/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.ide;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.form.core.MetaDataFactory;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.SysContext;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FormPermission {
    private static Log logger = LogFactory.getLog(FormPermission.class);
    public static final String EAS_FORM_IDE_USE = "eas_form_ide_use";
    public static final String EAS_FORM_IDE_ADMIN = "eas_form_ide_admin";
    public static final int FORM_PERMISSION_NOTES_MAX_LEN = 200;
    private static FormPermission formPermission = null;
    private HashMap cache = new HashMap();
    private HashMap form_notes_cache = new HashMap();
    private HashMap form_create_cache = new HashMap();
    private PersonInfo person = SysContext.getSysContext().getCurrentUserInfo().getPerson();

    public PersonInfo getPerson() {
        return this.person;
    }

    private HashMap getCache() {
        return this.cache;
    }

    private FormPermission() {
    }

    public void refresh(boolean force_refresh) {
        PersonInfo current_person = SysContext.getSysContext().getCurrentUserInfo().getPerson();
        if (force_refresh || current_person != this.person) {
            this.person = current_person;
            this.cache.clear();
            this.form_create_cache.clear();
            this.form_notes_cache.clear();
            this.cache.put("CurrentUserPermission", "");
            if (FormPermission.checkCurrentUserPermission(EAS_FORM_IDE_ADMIN)) {
                this.cache.put("CurrentUserPermission", EAS_FORM_IDE_ADMIN);
            } else if (FormPermission.checkCurrentUserPermission(EAS_FORM_IDE_USE)) {
                this.cache.put("CurrentUserPermission", EAS_FORM_IDE_USE);
            }
        }
    }

    public static FormPermission newInstance() {
        boolean isNeedNew = false;
        if (formPermission == null) {
            isNeedNew = true;
        } else {
            String curPerson = SysContext.getSysContext().getCurrentUserInfo().getPerson().getId().toString();
            if (curPerson != null && !curPerson.equals(formPermission.getPerson().getId().toString())) {
                isNeedNew = true;
            }
        }
        if (isNeedNew) {
            formPermission = new FormPermission();
            formPermission.refresh(true);
        }
        return formPermission;
    }

    public static boolean checkCurrentUserPermission(String permission_name) {
        ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
        ObjectUuidPK orgPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentOrgUnit().getId());
        try {
            IPermission ip = PermissionFactory.getRemoteInstance();
            ip.checkFunctionPermission((IObjectPK)userPK, OrgType.NONE, (IObjectPK)orgPK, permission_name);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public FormPermisoionType getCurrentUserFormPermission(String form_id) {
        if (this.cache.get("CurrentUserPermission").equals(EAS_FORM_IDE_ADMIN)) {
            return FormPermisoionType.NoLimit;
        }
        if (this.person != null) {
            String creator;
            String person_id = this.person.getId().toString();
            if (person_id.equals(creator = this.getFormPermissionCreator(form_id))) {
                return FormPermisoionType.NoLimit;
            }
            if (creator.equals("")) {
                return FormPermisoionType.Editable;
            }
            Map infos = this.getUserPermission(form_id);
            if (infos.containsKey(person_id)) {
                return FormPermisoionType.valueOf(Integer.parseInt(infos.get(person_id).toString()));
            }
        }
        return FormPermisoionType.Disable;
    }

    public String getFormPermissionCreator(String form_id) {
        String creator = "";
        if (this.form_create_cache.containsKey(form_id)) {
            creator = (String)this.form_create_cache.get(form_id);
        } else {
            try {
                creator = MetaDataFactory.getFormPermissionCreator(null, (String)form_id);
                if (creator != null && creator.length() > 0) {
                    ObjectUuidPK person_pk = new ObjectUuidPK(creator);
                    PersonInfo info = PersonFactory.getRemoteInstance().getPersonInfo((IObjectPK)person_pk);
                    if (info == null) {
                        creator = "";
                    }
                }
                this.form_create_cache.put(form_id, creator);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        return creator;
    }

    public boolean updateFormPermission(String form_id, String user_id, int permission_type, boolean is_create) {
        try {
            MetaDataFactory.updateFormPermission(null, (String)form_id, (String)user_id, (int)permission_type, (boolean)is_create);
            if (is_create) {
                this.form_create_cache.put(form_id, user_id);
            } else if (this.cache.containsKey(form_id)) {
                Map info = (Map)this.cache.get(form_id);
                info.put(user_id, new Integer(permission_type));
            }
            return true;
        }
        catch (BOSException e) {
            logger.error((Object)e);
            return false;
        }
    }

    public boolean updateFormPermission(String form_id, Map permission_info) {
        try {
            MetaDataFactory.updateFormPermission(null, (String)form_id, (Map)permission_info);
            this.cache.put(form_id, permission_info);
            return true;
        }
        catch (BOSException e) {
            logger.error((Object)e);
            return false;
        }
    }

    public Map getUserPermission(String form_id) {
        Object perm_info = this.cache.get(form_id);
        if (perm_info != null && perm_info instanceof Map) {
            return (Map)perm_info;
        }
        try {
            Map info = MetaDataFactory.getUserPermission(null, (String)form_id);
            this.cache.put(form_id, info);
            return info;
        }
        catch (BOSException e) {
            logger.error((Object)e);
            return null;
        }
    }

    public String getUserPermissionNotes(String form_id) {
        String notes = "";
        if (this.form_notes_cache.containsKey(form_id)) {
            notes = (String)this.form_notes_cache.get(form_id);
        } else {
            try {
                notes = MetaDataFactory.getUserPermissionNotes(null, (String)form_id);
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
            this.form_notes_cache.put(form_id, notes);
        }
        return notes;
    }

    public boolean updateUserPermissionNotes(String form_id, String notes) {
        try {
            MetaDataFactory.updateUserPermissionNotes(null, (String)form_id, (String)notes);
            this.form_notes_cache.put(form_id, notes);
            return true;
        }
        catch (BOSException e) {
            logger.error((Object)e);
            return false;
        }
    }

    public static class FormPermisoionType {
        public static final int DISABLE_TYPE = 0;
        public static final int READONLY_TYPE = 1;
        public static final int EDITABLE_TYPE = 2;
        public static final int DELETE_TYPE = 4;
        public static final int NOLIMIT_TYPE = 7;
        public static final FormPermisoionType Disable = new FormPermisoionType(0);
        public static final FormPermisoionType ReadOnly = new FormPermisoionType(1);
        public static final FormPermisoionType Editable = new FormPermisoionType(2);
        public static final FormPermisoionType Delete = new FormPermisoionType(4);
        public static final FormPermisoionType NoLimit = new FormPermisoionType(7);
        private int formPermisoionType = 0;

        public int getFormPermisoionType() {
            return this.formPermisoionType;
        }

        public static FormPermisoionType valueOf(int type) {
            return new FormPermisoionType(type);
        }

        public FormPermisoionType(int type) {
            this.formPermisoionType = type;
        }

        public boolean canEditable() {
            return (this.formPermisoionType & 2) == 2;
        }

        public boolean canRead() {
            return this.formPermisoionType != 0;
        }

        public boolean canDelete() {
            return (this.formPermisoionType & 4) == 4;
        }
    }
}

