/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.ide;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ctrl.swing.plaf.KingdeeLookAndFeel;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.form.ide.ContentWidgetViewport;
import com.kingdee.eas.base.form.ide.ExtMenuManager;
import com.kingdee.eas.base.form.ide.ExtStatusBarManager;
import com.kingdee.eas.base.form.ide.ExtToolbarManager;
import com.kingdee.eas.base.form.ide.IDEContext;
import com.kingdee.eas.base.form.ide.client.CreateNewUI;
import com.kingdee.eas.base.form.ide.client.SubSystemSelectUI;
import com.kingdee.eas.base.form.ide.view.DesignerView;
import com.kingdee.eas.base.form.ide.view.EntityView;
import com.kingdee.eas.base.form.ide.view.IDesignerView;
import com.kingdee.eas.base.form.ide.view.IPropertyView;
import com.kingdee.eas.base.form.ide.view.IToolBoxView;
import com.kingdee.eas.base.form.ide.view.PropertyView;
import com.kingdee.eas.base.form.ide.view.SolutionView;
import com.kingdee.eas.base.form.ide.view.ToolBoxView;
import com.kingdee.eas.base.form.ide.workbench.logic.TrimWidgetManager;
import com.kingdee.eas.base.form.ide.workbench.persist.WorkbenchPersistence;
import com.kingdee.eas.base.form.ide.workbench.ui.ITrimView;
import com.kingdee.eas.base.form.ide.workbench.ui.Perspective;
import com.kingdee.eas.base.form.ide.workbench.ui.TrimWidgetViewport;
import com.kingdee.eas.base.form.metadata.SubSystem;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.uiframe.EASLoginException;
import com.kingdee.eas.base.uiframe.client.LoginHelper;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ComponentUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Observer;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.log4j.Logger;

public class MainUI
extends CoreUIObject {
    private static final Logger logger = CoreUIObject.getLogger(MainUI.class);
    public static final String ELEMENTTYPES = "elementTypes";
    private Perspective perspective;
    private Locale locale;
    public static final String METADATA = "metadata";
    public static final String TAB_SET_TYPE = "tabSetType";
    private ExtToolbarManager toolbarManager;
    private IDesignerView mainBox;
    private IPropertyView propertyBox;
    private IToolBoxView toolBox;
    private SolutionView solutionBox;
    private EntityView entityView;

    public MainUI() {
        PersonInfo person = SysContext.getSysContext().getCurrentUserInfo().getPerson();
        if (person == null) {
            MsgBox.showError((Component)((Object)this), (String)"\u60a8\u4e0d\u662f\u804c\u5458\u7528\u6237\uff0c\u4e0d\u80fd\u4f7f\u7528\u52a8\u6001\u5355\u636e\u914d\u7f6e\u529f\u80fd\uff01");
            SysUtil.abort();
        }
        try {
            this.checkFunction();
        }
        catch (EASBizException e) {
            logger.error((Object)e);
            MsgBox.showError((Component)((Object)this), (String)e.getMessage());
            SysUtil.abort();
        }
        catch (BOSException e) {
            logger.error((Object)e);
            MsgBox.showError((Component)((Object)this), (String)e.getMessage());
            SysUtil.abort();
        }
        IDEContext.setCustomVer(true);
        this.initBars();
        this.initComps();
        this.initListeners();
        this.setLocale(Locale.SIMPLIFIED_CHINESE);
        this.showSubsytemUI();
    }

    private void checkFunction() throws BOSException, EASBizException {
        ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
        ObjectUuidPK orgPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentOrgUnit().getId());
        String permItemName = "eas_form_ide_use";
        IPermission ip = PermissionFactory.getRemoteInstance();
        ip.checkFunctionPermission((IObjectPK)userPK, OrgType.NONE, (IObjectPK)orgPK, permItemName);
    }

    public MainUI(Locale locale) {
        this();
        this.setLocale(locale);
    }

    private void initBars() {
        this.toolbarManager = new ExtToolbarManager(this);
        KDToolBar tb = this.toolbarManager.getToolBar();
        this.setUIToolBar(tb);
        ExtMenuManager _menuM = new ExtMenuManager(this);
        this.setUIMenuBar(_menuM.getMenuBar());
        ExtStatusBarManager statusBarM = new ExtStatusBarManager();
        this.setStatusBar(statusBarM.getStatusBar());
    }

    public Perspective getPerspective() {
        return this.perspective;
    }

    public ExtToolbarManager getExtToolbarManager() {
        return this.toolbarManager;
    }

    private void initListeners() {
    }

    public void close() {
        try {
            LoginHelper.logout();
        }
        catch (EASLoginException e) {
            logger.error((Object)e);
        }
        this.getUIWindow().close();
    }

    private void initComps() {
        this.setUITitle("EAS\u52a8\u6001\u754c\u9762\u8bbe\u8ba1\u5668");
        this.setSize(800, 600);
        this.dealAllPerspective();
        this.setLayout(new BorderLayout());
        this.add(this.perspective, "Center");
    }

    private void dealAllPerspective() {
        if (this.perspective == null) {
            this.perspective = new Perspective("EASDynamicUIDesigner", "1.0.0");
        }
        TrimWidgetManager manager = this.perspective.getTrimWidgetManager();
        WorkbenchPersistence wp = WorkbenchPersistence.getSharedInstance();
        this.toolBox = new ToolBoxView();
        TrimWidgetViewport wplBox = new TrimWidgetViewport("\u5de5\u5177\u7bb1", (ITrimView)((Object)this.toolBox));
        wplBox.setIconURL(ToolBoxView.class.getResource("find.gif"));
        wp.registerTrimWidget(wplBox);
        this.propertyBox = new PropertyView();
        this.entityView = new EntityView();
        TrimWidgetViewport wplEntity = new TrimWidgetViewport("\u5b9e\u4f53", this.entityView);
        wp.registerTrimWidget(wplEntity);
        this.solutionBox = new SolutionView();
        this.mainBox = new DesignerView(this.propertyBox, this.toolBox, this.toolbarManager, this.entityView, this.solutionBox);
        ContentWidgetViewport wplDesigner = new ContentWidgetViewport("\u8bbe\u8ba1\u4e3b\u7a97\u4f53", (ITrimView)((Object)this.mainBox));
        wplDesigner.setCloseable(false);
        wp.registerTrimWidget(wplDesigner);
        this.solutionBox.addObserver((Observer)((Object)this.mainBox));
        TrimWidgetViewport wplSolution = new TrimWidgetViewport("\u5b50\u7cfb\u7edf", this.solutionBox);
        TrimWidgetViewport wplProperty = new TrimWidgetViewport("\u5c5e\u6027", (ITrimView)((Object)this.propertyBox));
        wplBox.setCategory("aa");
        wplDesigner.setCategory("aa");
        wplSolution.setCategory("aa");
        wplProperty.setCategory("aa");
        wplEntity.setCategory("aa");
        wplSolution.setIconURL(ToolBoxView.class.getResource("flag.gif"));
        wplProperty.setIconURL(ToolBoxView.class.getResource("trush.gif"));
        wp.registerTrimWidget(wplSolution);
        wp.registerTrimWidget(wplProperty);
        manager.addTrim(3, wplDesigner);
        manager.addTrim(3, wplBox, wplDesigner);
        manager.addTrim(4, wplSolution, null);
        manager.addTrim(2, wplProperty, wplSolution, 0.5);
        manager.addTrim(2, wplEntity, wplBox, 0.5);
    }

    public static void main(String[] args) {
    }

    public ExtToolbarManager getToolbarManager() {
        return this.toolbarManager;
    }

    public IPropertyView getPropertyBox() {
        return this.propertyBox;
    }

    public IToolBoxView getToolBox() {
        return this.toolBox;
    }

    public SolutionView getSolutionView() {
        return this.solutionBox;
    }

    public IDesignerView getDesignerView() {
        return this.mainBox;
    }

    public void showCreateNewUI() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainUI.this.showNew();
            }
        });
    }

    public void showSubsytemUI() {
        UIContext uiContext = new UIContext((Object)ComponentUtil.getCurrentActiveWindow());
        IUIWindow uiWindow = null;
        try {
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(SubSystemSelectUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        }
        catch (UIException e) {
            logger.error((Object)e);
            MsgBox.showError((Component)((Object)this), (String)"\u51fa\u9519\u4e86\uff01");
            SysUtil.abort();
        }
        uiWindow.show();
        SubSystemSelectUI subSystemSelectUI = (SubSystemSelectUI)uiWindow.getUIObject();
        if (!subSystemSelectUI.isCanel()) {
            List subsysList = subSystemSelectUI.getSelectedSubsysList();
            this.solutionBox.refreshTree(subsysList);
        }
    }

    private void showNew() {
        try {
            KingdeeLookAndFeel.setCurrentTheme((int)0);
            UIManager.setLookAndFeel((LookAndFeel)new KingdeeLookAndFeel());
        }
        catch (Exception e) {
            logger.error((Object)e);
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception ex2) {
                logger.error((Object)ex2);
            }
        }
        CtrlSwingUtilities.resetAppDefaultFocusTraversalKeys();
        Locale.setDefault(this.getLocale());
        SubSystem subsys = this.solutionBox.getCurrentSubsys();
        if (subsys == null) {
            MsgBox.showError((Component)((Object)this), (String)"\u8bf7\u9009\u62e9\u5b50\u7cfb\u7edf\uff01");
            return;
        }
        CreateNewUI frame = new CreateNewUI(this, subsys);
        frame.setVisible(true);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public EntityView getEntityView() {
        return this.entityView;
    }
}

