/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.ide;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.jdbc.rowset.IRowSet;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class SQLScriptBuilder {
    private Map m_dctNoOutFields;
    private String m_strSQL;
    private String m_strDeleteSQL;
    private String m_Desc;
    private String m_Table;
    private BigDecimal ZERO = new BigDecimal(0.0);

    public SQLScriptBuilder(String strTableName, String strFilter, String strOder, String Desc) {
        this(strTableName, strFilter, strOder, Desc, "*", null);
    }

    public SQLScriptBuilder(String strTableName, String strFilter, String strOder, String Desc, String strFieldList, Map dctNoOutFields) {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT ").append(strFieldList).append(" FROM ");
        sb.append(strTableName).append(" ");
        sb.append(strFilter.length() > 0 ? " WHERE " + strFilter : "").append(" ");
        sb.append(strOder.length() > 0 ? "ORDER BY " + strOder : "");
        this.m_strSQL = sb.toString();
        sb = new StringBuffer();
        sb.append("DELETE ").append(strTableName);
        sb.append(strFilter.length() > 0 ? " WHERE " + strFilter : "");
        this.m_strDeleteSQL = sb.toString();
        this.m_Desc = Desc;
        this.m_Table = strTableName;
        this.m_dctNoOutFields = dctNoOutFields;
    }

    public String GenInsertScript(boolean bGenDeleteSQL) throws SQLException, BOSException {
        if (this.m_dctNoOutFields == null) {
            this.m_dctNoOutFields = new HashMap();
        }
        StringBuffer sbScript = new StringBuffer();
        sbScript.append("/****** Object:Data   " + this.m_Desc + "    Script Date: ");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/mm/dd HH:mm");
        sbScript.append(sdf.format(new Date())).append(" ******/");
        sbScript.append("");
        if (bGenDeleteSQL) {
            sbScript.append(this.m_strDeleteSQL);
            sbScript.append("\r\n");
        }
        StringBuffer sb = new StringBuffer();
        sb.append("INSERT INTO ").append(this.m_Table);
        ISQLExecutor sqlExecutor = SQLExecutorFactory.getRemoteInstance((String)this.m_strSQL);
        IRowSet rs = sqlExecutor.executeSQL();
        int colCounts = rs.getMetaData().getColumnCount();
        for (int j = 1; j <= colCounts; ++j) {
            String colName = rs.getMetaData().getColumnName(j);
            if (this.m_dctNoOutFields.containsKey(colName)) continue;
            sb.append(",").append(colName);
        }
        String strSQL = sb.toString();
        strSQL = strSQL.substring(0, strSQL.length() - 1) + ") ";
        while (rs.next()) {
            sbScript.append(strSQL);
            sb = new StringBuffer();
            sb.append("VALUES (");
            sb.append("\r\n");
            for (int j = 1; j <= colCounts; ++j) {
                String colName = rs.getMetaData().getColumnName(j);
                if (this.m_dctNoOutFields.containsKey(colName)) continue;
                sb.append(this.getStr(j, (ResultSet)rs)).append(",");
            }
            String strVal = sb.toString();
            strVal = strVal.substring(0, strVal.length() - 1) + ") ";
            sbScript.append(strVal);
            sbScript.append("\r\n");
        }
        return sbScript.toString();
    }

    private String getStr(int col, ResultSet rs) throws SQLException {
        boolean withMark;
        boolean isNull;
        String colType = rs.getMetaData().getColumnTypeName(col);
        int colType1 = rs.getMetaData().getColumnType(col);
        boolean bl = isNull = rs.getObject(col) == null;
        if (isNull) {
            return "null";
        }
        StringBuffer sb = new StringBuffer();
        if (colType.equalsIgnoreCase("NVARCHAR")) {
            sb.append("N");
        } else if (colType.equalsIgnoreCase("DATETIME")) {
            sb.append("CONVERT(DATETIME, ");
        }
        boolean bl2 = withMark = colType.equalsIgnoreCase("NVARCHAR") || colType.equalsIgnoreCase("VARCHAR") || colType.equalsIgnoreCase("NVARCHAR") || colType.equalsIgnoreCase("CHAR") || colType.equalsIgnoreCase("DATETIME");
        if (withMark) {
            sb.append("'");
        }
        if (colType.equalsIgnoreCase("DECIMAL") && rs.getBigDecimal(col).compareTo(this.ZERO) == 0) {
            sb.append("0.00");
        } else {
            String value = rs.getString(col).replaceAll("'", "''");
            if (value.length() == 0) {
                value = " ";
            }
            sb.append(value);
        }
        if (withMark) {
            sb.append("'");
        }
        if (colType.equalsIgnoreCase("DATETIME")) {
            sb.append(")");
        }
        return sb.toString();
    }

    public static void outputToFile(String insertFileName, String caption, String formid) throws FileNotFoundException, UnsupportedEncodingException, SQLException, BOSException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(insertFileName), "utf-8"));
        PrintWriter fw = new PrintWriter((Writer)writer, false);
        fw.println("/**Begin \u52a8\u6001Form\u5143\u6570\u636e\u811a\u672c\uff0c\u540d\u79f0 :" + caption + " **/");
        SQLScriptBuilder sb = new SQLScriptBuilder("T_BAS_Form", "FID='" + formid + "'", "", "T_BAS_Form", "*", null);
        sb.GenInsertScript(true);
        fw.println(sb.GenInsertScript(true));
        sb = new SQLScriptBuilder("T_BAS_FormEntity", "FFormID='" + formid + "'", "FSEQ", "T_BAS_FormEntity");
        sb.GenInsertScript(true);
        fw.println(sb.GenInsertScript(true));
        sb = new SQLScriptBuilder("T_BAS_FormField", "F='" + formid + "'", "", "T_BAS_FormField");
        sb.GenInsertScript(true);
        fw.println(sb.GenInsertScript(true));
        sb = new SQLScriptBuilder("T_BAS_FormLayout", "F='" + formid + "'", "", "T_BAS_FormLayout");
        sb.GenInsertScript(true);
        fw.println(sb.GenInsertScript(true));
        sb = new SQLScriptBuilder("T_BAS_FormLayoutEntity", "FLayoutID IN(SELECT FID FROM T_BAS_FormLayout WHERE F='" + formid + "')", "", "T_BAS_FormLayoutEntity");
        sb.GenInsertScript(true);
        fw.println(sb.GenInsertScript(true));
        sb = new SQLScriptBuilder("T_BAS_FormLayoutField", "FLayoutID IN(SELECT FID FROM T_BAS_FormLayout WHERE F='" + formid + "')", "", "T_BAS_FormLayoutField");
        sb.GenInsertScript(true);
        fw.println(sb.GenInsertScript(true));
        sb = new SQLScriptBuilder("T_BAS_FormLayoutCtrl", "FLayoutID IN(SELECT FID FROM T_BAS_FormLayout WHERE F='" + formid + "')", "", "T_BAS_FormLayoutCtrl");
        sb.GenInsertScript(true);
        fw.println(sb.GenInsertScript(true));
        sb = new SQLScriptBuilder("T_BAS_FormLayoutTabPage", "FLayoutID IN(SELECT FID FROM T_BAS_FormLayout WHERE F='" + formid + "')", "", "T_BAS_FormLayoutTabPage");
        sb.GenInsertScript(true);
        fw.println(sb.GenInsertScript(true));
        fw.close();
    }
}

