/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.ide.app;

import com.kingdee.bos.AbstractBOSObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.form.ide.ISQLScript;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class DefaultSQLScriptServer
extends AbstractBOSObject
implements ISQLScript {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.form.core.app.DefaultMetaDataServer");
    private BigDecimal ZERO = new BigDecimal(0.0);

    public DefaultSQLScriptServer(Context ctx) {
        super(ctx);
    }

    public DefaultSQLScriptServer() {
    }

    public ResultSet exeQuerySql(String sql) throws BOSException {
        Context ctx = this.getContext();
        Connection conn = null;
        Statement st = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            st = conn.createStatement();
            rs = st.executeQuery(sql);
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(st, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)st, (Connection)conn);
        return rs;
    }

    @Override
    public String getSQLScript(String strTableName, String strFilter, String strOder, String Desc, String strFieldList, Map dctNoOutFields) throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT ").append(strFieldList).append(" FROM ");
        sb.append(strTableName).append(" ");
        sb.append(strFilter.length() > 0 ? " WHERE " + strFilter : "").append(" ");
        sb.append(strOder.length() > 0 ? "ORDER BY " + strOder : "");
        String m_strSQL = sb.toString();
        sb = new StringBuffer();
        sb.append("DELETE ").append(strTableName);
        sb.append(strFilter.length() > 0 ? " WHERE " + strFilter : "");
        sb.append(";\r\n");
        String m_strDeleteSQL = sb.toString();
        String m_Desc = Desc;
        String m_Table = strTableName;
        Map m_dctNoOutFields = dctNoOutFields;
        try {
            return this.genInsertScript(true, m_Table, m_strSQL, m_strDeleteSQL, m_Desc, m_dctNoOutFields);
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    public String genInsertScript(boolean bGenDeleteSQL, String m_Table, String m_strSQL, String m_strDeleteSQL, String m_Desc, Map m_dctNoOutFields) throws SQLException, BOSException {
        if (m_dctNoOutFields == null) {
            m_dctNoOutFields = new HashMap();
        }
        StringBuffer sbScript = new StringBuffer();
        sbScript.append("/****** Object:Data   " + m_Desc + "    Script Date: ");
        Calendar c = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sbScript.append(sdf.format(c.getTime())).append(" ******/");
        sbScript.append("\r\n");
        if (bGenDeleteSQL) {
            sbScript.append(m_strDeleteSQL);
            sbScript.append("\r\n");
        }
        StringBuffer sb = new StringBuffer();
        sb.append("INSERT INTO ").append(m_Table).append("(");
        Context ctx = this.getContext();
        Connection conn = null;
        Statement st = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            st = conn.createStatement();
            rs = st.executeQuery(m_strSQL);
            int colCounts = rs.getMetaData().getColumnCount();
            for (int j = 1; j <= colCounts; ++j) {
                String colName = rs.getMetaData().getColumnName(j);
                if (m_dctNoOutFields.containsKey(colName)) continue;
                sb.append(colName).append(",");
            }
            String strSQL = sb.toString();
            strSQL = strSQL.substring(0, strSQL.length() - 1) + ") ";
            while (rs.next()) {
                sbScript.append(strSQL);
                sb = new StringBuffer();
                sb.append("VALUES (");
                sb.append("\r\n");
                for (int j = 1; j <= colCounts; ++j) {
                    String colName = rs.getMetaData().getColumnName(j);
                    if (m_dctNoOutFields.containsKey(colName)) continue;
                    sb.append(this.getStr(j, m_Table, rs)).append(",");
                }
                String strVal = sb.toString();
                strVal = strVal.substring(0, strVal.length() - 1) + ") ";
                sbScript.append(strVal);
                sbScript.append(";\r\n");
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)st, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)st, (Connection)conn);
        return sbScript.toString();
    }

    private String getStr(int col, String tableName, ResultSet rs) throws SQLException {
        boolean withMark;
        boolean isNull;
        String colType = rs.getMetaData().getColumnTypeName(col);
        String colName = rs.getMetaData().getColumnName(col);
        boolean bl = isNull = rs.getObject(col) == null;
        if (isNull) {
            return "null";
        }
        StringBuffer sb = new StringBuffer();
        if (!(tableName.equalsIgnoreCase("T_BAS_FormActionList") && colName.equalsIgnoreCase("FParaments") || tableName.equalsIgnoreCase("T_BAS_FCEntry") && (colName.equalsIgnoreCase("FCondition") || colName.equalsIgnoreCase("FSetting")) || tableName.equalsIgnoreCase("T_BAS_FilterCondition") && (colName.equalsIgnoreCase("FDataSource_L1") || colName.equalsIgnoreCase("FDataSource_L2") || colName.equalsIgnoreCase("FDataSource_L3")))) {
            if (colType.equalsIgnoreCase("NVARCHAR") || colType.equalsIgnoreCase("NVARCHAR2") || colType.equalsIgnoreCase("VARGRAPHIC")) {
                sb.append("N");
            } else if (colType.equalsIgnoreCase("DATETIME")) {
                sb.append("CONVERT(DATETIME, ");
            }
        }
        boolean bl2 = withMark = colType.equalsIgnoreCase("NVARCHAR") || colType.equalsIgnoreCase("VARGRAPHIC") || colType.equalsIgnoreCase("VARCHAR") || colType.equalsIgnoreCase("VARCHAR2") || colType.equalsIgnoreCase("NVARCHAR") || colType.equalsIgnoreCase("CHAR") || colType.equalsIgnoreCase("DATETIME");
        if (withMark) {
            sb.append("'");
        }
        if (colType.equalsIgnoreCase("DECIMAL") && rs.getBigDecimal(col).compareTo(this.ZERO) == 0) {
            sb.append("0.00");
        } else {
            String value = rs.getString(col).replaceAll("'", "''");
            if (value.length() == 0) {
                value = " ";
            }
            sb.append(value);
        }
        if (withMark) {
            sb.append("'");
        }
        if (colType.equalsIgnoreCase("DATETIME")) {
            sb.append(")");
        }
        return sb.toString();
    }

    public BOSObjectType getType() {
        return null;
    }

    @Override
    public void exeSqls(String[] sqls) throws BOSException {
        Context ctx = this.getContext();
        if (sqls == null || sqls.length == 0) {
            return;
        }
        Connection conn = null;
        Statement st = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            st = conn.createStatement();
            for (int i = 0; i < sqls.length; ++i) {
                st.execute(sqls[i]);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(st, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)st, (Connection)conn);
    }
}

