/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.ide.app;

import com.kingdee.bos.AbstractBOSObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.form.core.PropertyUtil;
import com.kingdee.eas.base.form.core.app.SqlParameter;
import com.kingdee.eas.base.form.ide.ISubsys;
import com.kingdee.eas.base.form.ide.exception.FormIdeException;
import com.kingdee.eas.base.form.metadata.IProp;
import com.kingdee.eas.base.form.metadata.SubSystem;
import com.kingdee.eas.base.form.metadata.TopSystem;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class DefaultSubsysServer
extends AbstractBOSObject
implements ISubsys {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.form.ide.app.DefaultSubsysServer");

    public DefaultSubsysServer(Context ctx) {
        super(ctx);
    }

    public DefaultSubsysServer() {
    }

    public BOSObjectType getType() {
        return null;
    }

    @Override
    public void dealSubsys(DefaultKingdeeTreeNode node) throws BOSException {
        for (int i = 0; i < node.getChildCount(); ++i) {
            DefaultKingdeeTreeNode childNode = (DefaultKingdeeTreeNode)node.getChildAt(i);
            TopSystem top = new TopSystem();
            top.setId(null);
            top.setName_L1(childNode.getText());
            top.setName_L2(childNode.getText());
            top.setName_L3(childNode.getText());
            top.setIndex(i + 1);
            top.setIsDefault(1);
            try {
                String id = this.updateObject(top, TopSystem.class.getName());
                for (int j = 0; j < childNode.getChildCount(); ++j) {
                    DefaultKingdeeTreeNode childNode1 = (DefaultKingdeeTreeNode)childNode.getChildAt(j);
                    if (childNode1.getChildCount() == 0) continue;
                    SubSystem sub = new SubSystem();
                    sub.setId(null);
                    sub.setTopId(id);
                    sub.setName_L1(childNode1.getText());
                    sub.setName_L2(childNode1.getText());
                    sub.setName_L3(childNode1.getText());
                    sub.setIndex(j + 1);
                    sub.setIsDefault(1);
                    this.updateObject(sub, SubSystem.class.getName());
                }
                continue;
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
    }

    @Override
    public List getSystemList() throws BOSException {
        ArrayList<TopSystem> result = new ArrayList<TopSystem>();
        Context ctx = this.getContext();
        Locale locale = ctx.getLocale();
        String sql = "select ftopclassid, ftopclassname_l1, ftopclassname_l2, ftopclassname_l3, fisdefault, findex  from t_bas_formtopclass where FVisible <> -1 or FVisible is null order by findex";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rs.next()) {
                TopSystem top = new TopSystem();
                this.setPropertys((IProp)top, rs);
                top.setName(rs.getString("ftopclassname_" + locale));
                result.add(top);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    private void setPropertys(IProp obj, IRowSet rs) throws BOSException, SQLException {
        List keyProps = obj.getKeyPropList();
        List keyFields = obj.getKeyFieldNames();
        for (int i = 0; i < keyProps.size(); ++i) {
            PropertyUtil.setPropertyValue((Object)obj, (String)keyProps.get(i).toString(), (Object)rs.getObject(keyFields.get(i).toString()));
        }
        List props = obj.getPropList();
        List fields = obj.getFieldList();
        for (int i = 0; i < props.size(); ++i) {
            PropertyUtil.setPropertyValue((Object)obj, (String)props.get(i).toString(), (Object)rs.getObject(fields.get(i).toString()));
        }
    }

    @Override
    public List getSubSystemList(String topId) throws BOSException {
        ArrayList<SubSystem> result = new ArrayList<SubSystem>();
        Context ctx = this.getContext();
        Locale locale = ctx.getLocale();
        String sql = " select fsubsysid, ftopclassId, fname_l1, fname_l2, fname_l3, fisdefault, findex, FPackages, FSimpleName, FPrintPath  from t_bas_formsubsystem where ftopclassid = ? order by findex ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{topId});
        try {
            while (rs.next()) {
                SubSystem subSystem = new SubSystem();
                this.setPropertys((IProp)subSystem, rs);
                subSystem.setName(rs.getString("fname_" + locale));
                result.add(subSystem);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    @Override
    public List getSubSystemList() throws BOSException {
        ArrayList<SubSystem> result = new ArrayList<SubSystem>();
        Context ctx = this.getContext();
        Locale locale = ctx.getLocale();
        String sql = "select fsubsysid, ftopclassId, fname_l1, fname_l2, fname_l3, fisdefault, findex, FPackages, FSimpleName, FPrintPath  from t_bas_formsubsystem order by ftopclassid, findex";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rs.next()) {
                SubSystem subSystem = new SubSystem();
                this.setPropertys((IProp)subSystem, rs);
                subSystem.setName(rs.getString("fname_" + locale));
                result.add(subSystem);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    @Override
    public String updateObject(Object obj, String propClassName) throws BOSException, SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        String result = null;
        IProp prop = (IProp)obj;
        String tableName = prop.getTableName();
        List propertyList = prop.getPropList();
        List fieldList = prop.getFieldList();
        List ids = prop.getKeyIdValues();
        List keyFieldName = prop.getKeyFieldNames();
        if (this.checkIdIsNull(ids)) {
            ArrayList<SqlParameter> pk = new ArrayList<SqlParameter>();
            for (int i = 0; i < ids.size(); ++i) {
                String tempid = BOSUuid.create((String)prop.getBosType()).toString();
                pk.add(new SqlParameter(keyFieldName.get(i).toString(), (Object)tempid));
                result = tempid;
            }
            this.insertRow(obj, propertyList, fieldList, tableName, pk);
        } else {
            ArrayList<SqlParameter> pk = new ArrayList<SqlParameter>();
            for (int i = 0; i < ids.size(); ++i) {
                pk.add(new SqlParameter(keyFieldName.get(i).toString(), ids.get(i)));
                result = ids.get(i).toString();
            }
            this.updateRow(obj, propertyList, fieldList, tableName, pk);
        }
        return result;
    }

    @Override
    public void deleteObject(IProp prop) throws BOSException, EASBizException {
        Context ctx = this.getContext();
        String dependedBySql = prop.getDependBySql();
        if (dependedBySql != null && dependedBySql.trim().length() > 0) {
            String id = prop.getKeyIdValues().get(0).toString();
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)dependedBySql, (Object[])new String[]{id});
            int count = 0;
            try {
                if (rs.next() && (count = rs.getInt(1)) > 0) {
                    FormIdeException e1 = new FormIdeException(FormIdeException.SIMPLETEXTEXP, new String[]{prop.getDeleteDependByHint()});
                    logger.error((Object)e1);
                    throw e1;
                }
            }
            catch (SQLException e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
        }
        String tableName = prop.getTableName();
        List idValues = prop.getKeyIdValues();
        List keyFieldName = prop.getKeyFieldNames();
        String sql = " delete from " + tableName + " where ";
        ArrayList param = new ArrayList();
        for (int i = 0; i < keyFieldName.size(); ++i) {
            sql = i == 0 ? sql + keyFieldName.get(i) + " = ? " : sql + " and " + keyFieldName.get(i) + " = ? ";
            param.add(idValues.get(i));
        }
        DbUtil.execute((Context)ctx, (String)sql, (Object[])param.toArray());
    }

    private boolean checkIdIsNull(List ids) throws BOSException {
        if (ids == null || ids.size() == 0) {
            throw new BOSException("id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        boolean isNull = true;
        for (int i = 0; i < ids.size(); ++i) {
            if (ids.get(i) == null || ids.get(i).toString().trim().length() <= 0) continue;
            isNull = false;
            break;
        }
        return isNull;
    }

    private void insertRow(Object elementObj, List props, List fieldList, String tableName, List pk) throws BOSException, SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Context ctx = this.getContext();
        String strSQL = " INSERT INTO " + tableName + "(";
        String strField = "";
        String strValue = "";
        ArrayList<Object> params = new ArrayList<Object>();
        for (SqlParameter parammeter : pk) {
            String sField = parammeter.getFieldName();
            strField = strField + sField + ",";
            strValue = strValue + " ? ,";
            Object value = parammeter.getFieldValue();
            params.add(value);
        }
        for (int i = 0; i < props.size(); ++i) {
            String propertyName = (String)props.get(i);
            Object value = null;
            try {
                value = this.getPropertyValue(elementObj, propertyName);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
            if (value == null) continue;
            strField = strField + fieldList.get(i) + ",";
            strValue = strValue + " ? ,";
            params.add(value);
        }
        if (strField.length() > 0) {
            strField = strField.substring(0, strField.length() - 1);
            strValue = strValue.substring(0, strValue.length() - 1);
            strSQL = strSQL + strField + ") values(" + strValue + ")";
            DbUtil.execute((Context)ctx, (String)strSQL, (Object[])params.toArray());
        }
    }

    private void updateRow(Object elementObj, List props, List fieldList, String tableName, List pk) throws SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, BOSException {
        Context ctx = this.getContext();
        Object result = null;
        String strSQL = " UPDATE " + tableName + " SET ";
        ArrayList<Object> params = new ArrayList<Object>();
        for (int i = 0; i < props.size(); ++i) {
            String propertyName = (String)props.get(i);
            Object value = null;
            try {
                value = this.getPropertyValue(elementObj, propertyName);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
            if (value == null) continue;
            params.add(value);
            strSQL = strSQL + fieldList.get(i) + " = ? ,";
        }
        if (strSQL.length() > 0 && params.size() > 0) {
            strSQL = strSQL.substring(0, strSQL.length() - 1);
            strSQL = strSQL + " WHERE ";
            for (SqlParameter parammeter : pk) {
                String sField = parammeter.getFieldName();
                strSQL = strSQL + sField + " = ? and ";
                Object value = parammeter.getFieldValue();
                params.add(value);
            }
            strSQL = strSQL.substring(0, strSQL.length() - 4);
            DbUtil.execute((Context)ctx, (String)strSQL, (Object[])params.toArray());
        }
    }

    private Object getPropertyValue(Object elementObj, String propertyName) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (elementObj != null) {
            Method mi = null;
            try {
                mi = elementObj.getClass().getMethod("get" + propertyName, null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (mi != null) {
                return mi.invoke(elementObj, new Object[0]);
            }
        }
        return null;
    }

    @Override
    public void updateSeq(String tableName, Map seqMap) throws BOSException, EASBizException {
        Context ctx = this.getContext();
        String sql = " UPDATE " + tableName + " SET fseq = ? where fid = ?";
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.prepareStatement(sql);
            for (Object id : seqMap.keySet()) {
                Object seq = seqMap.get(id);
                ps.setObject(1, seq);
                ps.setObject(2, id);
                ps.addBatch();
            }
            ps.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
    }

    @Override
    public SubSystem getSubSystem(String subsysid) throws BOSException {
        SubSystem result = null;
        Context ctx = this.getContext();
        Locale locale = ctx.getLocale();
        String sql = " select fsubsysid, ftopclassId, fname_l1, fname_l2, fname_l3, fisdefault, findex, FPackages, FSimpleName, FPrintPath  from t_bas_formsubsystem where fsubsysid = ? order by findex ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{subsysid});
        try {
            if (rs.next()) {
                SubSystem subSystem = new SubSystem();
                this.setPropertys((IProp)subSystem, rs);
                subSystem.setName(rs.getString("fname_" + locale));
                result = subSystem;
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return result;
    }
}

