/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.ide.designer;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.eas.base.form.designer.Designer;
import com.kingdee.eas.base.form.designer.command.ICommand;
import com.kingdee.eas.base.form.designer.listenner.PrepareAddControlEventArgs;
import com.kingdee.eas.base.form.designer.listenner.PrepareCreateItemOnGridArgs;
import com.kingdee.eas.base.form.designer.listenner.QueryAddedArgs;
import com.kingdee.eas.base.form.ide.designer.AddEntityFieldCommand;
import com.kingdee.eas.base.form.ide.designer.DynamicFormDesigner;
import com.kingdee.eas.base.form.ide.model.ElementPropertyAdpter;
import com.kingdee.eas.base.form.ide.model.MetaDataDesinerModel;
import com.kingdee.eas.base.form.ide.model.ObjectProperty;
import com.kingdee.eas.base.form.ide.view.EntityView;
import com.kingdee.eas.base.form.ide.view.IPropertyView;
import com.kingdee.eas.base.form.ide.view.IToolBoxView;
import com.kingdee.eas.base.form.ide.view.PropertyNodeObject;
import com.kingdee.eas.base.form.ide.view.SolutionView;
import com.kingdee.eas.base.form.metadata.Entity;
import com.kingdee.eas.base.form.metadata.EntityAppearance;
import com.kingdee.eas.base.form.metadata.Field;
import com.kingdee.eas.base.form.metadata.LayoutInfo;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;

public class BillDesigner
extends DynamicFormDesigner {
    private EntityView entityView;

    public BillDesigner(MetaDataDesinerModel model, IPropertyView propertyView, IToolBoxView toolBoxView, EntityView entityView, SolutionView solutionView) {
        super(model, propertyView, toolBoxView, solutionView);
        this.entityView = entityView;
    }

    @Override
    public List getElementGroupIDList() {
        ArrayList<Integer> groupIdList = new ArrayList<Integer>();
        groupIdList.add(new Integer(1));
        groupIdList.add(new Integer(2));
        groupIdList.add(new Integer(4));
        groupIdList.add(new Integer(10));
        return groupIdList;
    }

    @Override
    public void queryCanAdded(Designer sender, QueryAddedArgs e) {
        if (e.getCreateData() instanceof Field) {
            Field fld = (Field)e.getCreateData();
            LayoutInfo layout = this.formMetaData.getLayoutInfo(this.model.getLayoutKey());
            if (layout.getAppearance(fld.getKey()) != null) {
                e.setAllowAdded(false);
            }
            if (e.getParent() instanceof KDTable && !fld.getEntityKey().equalsIgnoreCase(e.getParent().getName())) {
                e.setAllowAdded(false);
            }
        } else if (e.getCreateData() instanceof Entity) {
            Entity entity = (Entity)e.getCreateData();
            LayoutInfo layout = this.formMetaData.getLayoutInfo(this.model.getLayoutKey());
            if (layout.getAppearance(entity.getKey()) != null) {
                e.setAllowAdded(false);
            }
            if (entity.getEntityType() == 0) {
                e.setAllowAdded(false);
            }
        } else if (e.getCreateData() instanceof PropertyNodeObject) {
            e.setAllowAdded(false);
        }
        super.queryCanAdded(sender, e);
    }

    @Override
    public void prepareAddControl(Designer sender, PrepareAddControlEventArgs e) {
        if (e.getCreateData() instanceof Field) {
            Field fld = (Field)e.getCreateData();
            String containerKey = this.getContainerKey(e.getParent());
            ElementPropertyAdpter el = null;
            Rectangle rect = e.getBounds();
            try {
                el = this.model.createField(fld, rect, containerKey);
            }
            catch (BOSException e1) {
                e1.printStackTrace();
            }
            if (el != null && el.getAppearance() != null) {
                Container parent = e.getParent();
                this.addControlToDesigner(el, parent);
            }
        } else {
            super.prepareAddControl(sender, e);
        }
    }

    @Override
    public void prepareCreateItemOnGrid(Designer sender, PrepareCreateItemOnGridArgs e) {
        if (e.getCreateData() instanceof Field) {
            Field fld = (Field)e.getCreateData();
            AddEntityFieldCommand cmd = new AddEntityFieldCommand(e.getGrid(), fld, e.getGrid().getName(), this.model, this.getUIBuilder(), (DynamicFormDesigner)this);
            try {
                cmd.execute();
            }
            catch (BOSException e1) {
                e1.printStackTrace();
            }
            sender.addCommand((ICommand)cmd);
        } else {
            super.prepareCreateItemOnGrid(sender, e);
        }
    }

    @Override
    public String getTitle() {
        return this.model.getTitle() + "-" + this.model.getLayoutKey();
    }

    @Override
    public String getKey() {
        return this.model.getLayoutKey();
    }

    @Override
    protected void resetContentMapKey() {
    }

    @Override
    public String getComponentBindinfo(Component component) {
        String key = component.getName();
        Field field = this.model.getBusinessInfo().getField(key);
        if (field != null && field.getPropertyName() != null && field.getPropertyName().length() > 0) {
            return field.getEntityKey() + "." + field.getPropertyName();
        }
        return super.getComponentBindinfo(component);
    }

    public void refreshEntityView() {
        this.entityView.refreshEntity();
    }

    @Override
    public void active() {
        super.active();
        this.entityView.refreshEntity(this.model.getBusinessInfo().getForm().getBosType());
        this.entityView.addCreateDataChangeListener(this);
        this.entityView.setCanEdit(this.canEdit());
    }

    @Override
    public void deActive() {
        super.deActive();
        this.entityView.removeCreateDataChangeListener(this);
    }

    @Override
    public void save() throws Exception {
        for (Object obj : this.model.getLayoutInfo().getControls()) {
            if (!(obj instanceof EntityAppearance)) continue;
            EntityAppearance enAppear = (EntityAppearance)obj;
            Entity entity = this.model.getBusinessInfo().getEntity(enAppear.getKey());
            if (enAppear.getControlType() != -1 || !entity.getFields().isEmpty() || !enAppear.getLayoutinfo().getControls().isEmpty() || enAppear.getKey().equalsIgnoreCase("fbillhead")) continue;
            this.model.getListDel().add(enAppear);
            this.model.getListDel().add(entity);
        }
        super.save();
    }

    @Override
    public void propertyChanged(ObjectProperty prop, Object newValue, Object oldValue) {
        super.propertyChanged(prop, newValue, oldValue);
        if (prop.getElementProperty().getType().getId() == 100 && prop.getElementProperty().getPropertyName().equalsIgnoreCase("BosType")) {
            this.entityView.refreshEntity(newValue == null ? "" : newValue.toString());
        }
    }
}

