/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.ide.designer;

import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.eas.base.form.client.UIBuilder;
import com.kingdee.eas.base.form.designer.command.ICommand;
import com.kingdee.eas.base.form.ide.designer.DynamicFormDesigner;
import com.kingdee.eas.base.form.ide.model.ElementPropertyAdpter;
import com.kingdee.eas.base.form.ide.model.MetaDataDesinerModel;
import com.kingdee.eas.base.form.metadata.FieldAppearance;
import java.util.ArrayList;
import java.util.Collections;

public class DeleteEntityFieldCommand
implements ICommand {
    private MetaDataDesinerModel model;
    private KDTable table;
    private ElementPropertyAdpter elAdp;
    private UIBuilder uibuilder;
    private DynamicFormDesigner dynamicFormdesigner;

    public DeleteEntityFieldCommand(KDTable oGrid, MetaDataDesinerModel metaDataObject, UIBuilder uibuilder, DynamicFormDesigner designer) {
        this.model = metaDataObject;
        this.table = oGrid;
        this.uibuilder = uibuilder;
        this.dynamicFormdesigner = designer;
    }

    public void execute() {
        if ((Integer)this.table.getClientProperty((Object)"EntryType") == 1) {
            this.deleteCol();
        } else {
            this.deleteRow();
        }
    }

    private void deleteCol() {
        ArrayList blockList = this.table.getSelectManager().getBlocks();
        ArrayList<Integer> colIndexList = new ArrayList<Integer>();
        for (int i = 0; i < blockList.size(); ++i) {
            KDTSelectBlock block = this.table.getSelectManager().get(i);
            for (int colIndex = block.getBeginCol(); colIndex <= block.getEndCol(); ++colIndex) {
                colIndexList.add(new Integer(colIndex));
            }
        }
        Collections.sort(colIndexList);
        IColumn column = null;
        for (int i = colIndexList.size() - 1; i >= 0; --i) {
            column = this.table.getColumn(((Integer)colIndexList.get(i)).intValue());
            ElementPropertyAdpter propAdp = this.model.getElementProperty(column.getKey());
            if (propAdp == null) continue;
            this.elAdp = propAdp;
            this.model.deleteElement(propAdp, true);
            this.table.removeColumn(((Integer)colIndexList.get(i)).intValue());
        }
        if (colIndexList.size() > 0) {
            KDTSelectBlock block;
            int colIndex;
            this.dynamicFormdesigner.refreshObjectList();
            blockList = this.table.getSelectManager().getBlocks();
            ElementPropertyAdpter propAdp = this.model.getElementProperty(this.table.getName());
            if (blockList != null && !blockList.isEmpty() && (colIndex = (block = this.table.getSelectManager().get(0)).getBeginCol()) >= 0) {
                String key = this.table.getColumnKey(colIndex);
                propAdp = this.model.getElementProperty(key);
            }
            this.dynamicFormdesigner.selectEntryField(propAdp);
        }
    }

    private void deleteRow() {
        ArrayList blockList = this.table.getSelectManager().getBlocks();
        ArrayList<Integer> rowIndexList = new ArrayList<Integer>();
        for (int i = 0; i < blockList.size(); ++i) {
            KDTSelectBlock block = this.table.getSelectManager().get(i);
            for (int rowIndex = block.getBeginRow(); rowIndex <= block.getEndRow(); ++rowIndex) {
                rowIndexList.add(new Integer(rowIndex));
            }
        }
        Collections.sort(rowIndexList);
        IRow row = null;
        for (int i = rowIndexList.size() - 1; i >= 0; --i) {
            row = this.table.getRow(((Integer)rowIndexList.get(i)).intValue());
            ElementPropertyAdpter propAdp = this.model.getElementProperty(row.getUserObject().toString());
            if (propAdp == null) continue;
            this.elAdp = propAdp;
            this.model.deleteElement(propAdp, true);
            this.table.removeRow(((Integer)rowIndexList.get(i)).intValue());
        }
        if (rowIndexList.size() > 0) {
            KDTSelectBlock block;
            int rowIndex;
            this.dynamicFormdesigner.refreshObjectList();
            blockList = this.table.getSelectManager().getBlocks();
            ElementPropertyAdpter propAdp = this.model.getElementProperty(this.table.getName());
            if (blockList != null && !blockList.isEmpty() && (rowIndex = (block = this.table.getSelectManager().get(0)).getBeginRow()) >= 0) {
                String key = this.table.getRow(rowIndex).getUserObject().toString();
                propAdp = this.model.getElementProperty(key);
            }
            this.dynamicFormdesigner.selectEntryField(propAdp);
        }
    }

    public String getDescription() {
        return null;
    }

    public void unExecute() {
        if (this.elAdp != null && this.model.getElementProperty(this.elAdp.getKey()) == null) {
            this.model.addElementToMetaData(this.elAdp);
            if ((Integer)this.table.getClientProperty((Object)"EntryType") == 1) {
                this.uibuilder.insertNewColumn(this.table, (FieldAppearance)this.elAdp.getAppearance());
            } else {
                this.uibuilder.insertNewRow(this.table, (FieldAppearance)this.elAdp.getAppearance());
            }
        }
    }
}

