/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.ide.designer;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTColumnMoveEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTColumnMoveListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTResizeEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTResizeListener;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDContainer;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.form.client.UIBuilder;
import com.kingdee.eas.base.form.client.ctrl.KDAccessoryPanel;
import com.kingdee.eas.base.form.client.ctrl.KDApproval;
import com.kingdee.eas.base.form.client.ctrl.KDExtLabel;
import com.kingdee.eas.base.form.client.ctrl.KDImgPanel;
import com.kingdee.eas.base.form.client.ctrl.KDRadioGroupPanel;
import com.kingdee.eas.base.form.client.layout.Table.Cell;
import com.kingdee.eas.base.form.client.layout.Table.ComponentContent;
import com.kingdee.eas.base.form.core.BOSEntityGenerator;
import com.kingdee.eas.base.form.core.BasImgHelper;
import com.kingdee.eas.base.form.core.BillTypeCollection;
import com.kingdee.eas.base.form.core.BillTypeFactory;
import com.kingdee.eas.base.form.core.MetaDataFactory;
import com.kingdee.eas.base.form.core.PropertyUtil;
import com.kingdee.eas.base.form.designer.AbstractFormDesigner;
import com.kingdee.eas.base.form.designer.Designer;
import com.kingdee.eas.base.form.designer.ToolBarOperation;
import com.kingdee.eas.base.form.designer.command.ICommand;
import com.kingdee.eas.base.form.designer.component.FormContainer;
import com.kingdee.eas.base.form.designer.component.FormDesignerPanel;
import com.kingdee.eas.base.form.designer.listenner.CommandAddArgs;
import com.kingdee.eas.base.form.designer.listenner.CommandRemoveArgs;
import com.kingdee.eas.base.form.designer.listenner.ComponentBeforeRemoveArgs;
import com.kingdee.eas.base.form.designer.listenner.ComponentPositionChangedArgs;
import com.kingdee.eas.base.form.designer.listenner.ComponentTabIndexChangedArgs;
import com.kingdee.eas.base.form.designer.listenner.GridActiveToDesignArgs;
import com.kingdee.eas.base.form.designer.listenner.ItemContainerLabelWidthChangedArgs;
import com.kingdee.eas.base.form.designer.listenner.PrepareAddControlEventArgs;
import com.kingdee.eas.base.form.designer.listenner.PrepareCopyControlEventArgs;
import com.kingdee.eas.base.form.designer.listenner.PrepareCreateItemOnGridArgs;
import com.kingdee.eas.base.form.designer.listenner.QueryAddedArgs;
import com.kingdee.eas.base.form.designer.listenner.RequestTypeDefaultSizeEventArgs;
import com.kingdee.eas.base.form.designer.listenner.SmartTagClickArg;
import com.kingdee.eas.base.form.designer.listenner.TableLayoutChangeArgs;
import com.kingdee.eas.base.form.designer.listenner.UndoRedoStateChangedEventArgs;
import com.kingdee.eas.base.form.ide.FormPermission;
import com.kingdee.eas.base.form.ide.client.util.IdeUtil;
import com.kingdee.eas.base.form.ide.designer.AddEntityFieldCommand;
import com.kingdee.eas.base.form.ide.designer.BillDesigner;
import com.kingdee.eas.base.form.ide.designer.CreateEntityDialog;
import com.kingdee.eas.base.form.ide.designer.DeleteEntityFieldCommand;
import com.kingdee.eas.base.form.ide.designer.OperationConstant;
import com.kingdee.eas.base.form.ide.designer.smarttag.AbstractSmartMenu;
import com.kingdee.eas.base.form.ide.designer.smarttag.ContainerSmarMenu;
import com.kingdee.eas.base.form.ide.designer.smarttag.ImgSmartMenu;
import com.kingdee.eas.base.form.ide.designer.smarttag.TabbedPaneSmartMenu;
import com.kingdee.eas.base.form.ide.designer.smarttag.TableSmartMenu;
import com.kingdee.eas.base.form.ide.model.ElementPropertyAdpter;
import com.kingdee.eas.base.form.ide.model.MetaDataDesinerModel;
import com.kingdee.eas.base.form.ide.model.ObjectProperty;
import com.kingdee.eas.base.form.ide.model.PropertyAdpterListner;
import com.kingdee.eas.base.form.ide.model.property.BindingDataProp;
import com.kingdee.eas.base.form.ide.utils.EntityObjectInfoHelp;
import com.kingdee.eas.base.form.ide.view.DesignerView;
import com.kingdee.eas.base.form.ide.view.ICreateDataChangeListener;
import com.kingdee.eas.base.form.ide.view.IDesignerContent;
import com.kingdee.eas.base.form.ide.view.IPropertyView;
import com.kingdee.eas.base.form.ide.view.IToolBoxView;
import com.kingdee.eas.base.form.ide.view.SolutionView;
import com.kingdee.eas.base.form.ide.view.ToolBoxView;
import com.kingdee.eas.base.form.metadata.Appearance;
import com.kingdee.eas.base.form.metadata.BusinessInfo;
import com.kingdee.eas.base.form.metadata.ControlAppearance;
import com.kingdee.eas.base.form.metadata.Element;
import com.kingdee.eas.base.form.metadata.ElementProperty;
import com.kingdee.eas.base.form.metadata.ElementType;
import com.kingdee.eas.base.form.metadata.Entity;
import com.kingdee.eas.base.form.metadata.EntityAppearance;
import com.kingdee.eas.base.form.metadata.Field;
import com.kingdee.eas.base.form.metadata.FieldAppearance;
import com.kingdee.eas.base.form.metadata.FormAppearance;
import com.kingdee.eas.base.form.metadata.FormMetaData;
import com.kingdee.eas.base.form.metadata.LayoutInfo;
import com.kingdee.eas.base.form.metadata.TabControlAppearance;
import com.kingdee.eas.base.form.metadata.TabPageAppearance;
import com.kingdee.eas.base.form.metadata.extcontrol.AccessoryPanelAppearance;
import com.kingdee.eas.base.form.metadata.layout.tablelayout.Style;
import com.kingdee.eas.base.form.metadata.layout.tablelayout.TableLayout;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.dynbusiness.util.StringUtil;
import com.kingdee.eas.framework.util.EntityUtility;
import com.kingdee.eas.util.client.ComponentUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public abstract class DynamicFormDesigner
extends AbstractFormDesigner
implements IDesignerContent,
ChangeListener,
KDTActiveCellListener,
KDTResizeListener,
KDTColumnMoveListener,
PropertyAdpterListner,
ICreateDataChangeListener {
    protected FormMetaData formMetaData;
    protected FormDesignerPanel designPanel;
    protected FormContainer designForm;
    protected UIBuilder uiBuilder;
    protected MetaDataDesinerModel model;
    protected IPropertyView propertyView;
    protected IToolBoxView toolBoxView;
    protected SolutionView solutionView;
    protected KDScrollPane sPane;
    private Map propMap = new HashMap();
    protected Map smartMenu = new HashMap();
    protected static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.form.ide.designer.DynamicFormDesigner");

    public DynamicFormDesigner(MetaDataDesinerModel model, IPropertyView propertyView, IToolBoxView toolBoxView, SolutionView solutionView) {
        this.propertyView = propertyView;
        this.toolBoxView = toolBoxView;
        this.solutionView = solutionView;
        this.model = model;
        this.initDesigner();
        this.bindEntryEvents();
        this.registeSmartMenu();
    }

    @Override
    public void bindEntryEvents() {
        LayoutInfo layoutInfo = this.model.getLayoutInfo();
        this.bindEntryEvents(layoutInfo);
    }

    private void bindEntryEvents(LayoutInfo layoutInfo) {
        ArrayList ctlList = layoutInfo.getControls();
        for (ControlAppearance ctlAppear : ctlList) {
            if (ctlAppear.getControlType() == 1007) {
                KDTable table = (KDTable)this.getUIBuilder().getControl(ctlAppear.getKey());
                this.bindEntryEvents(table, true);
                continue;
            }
            if (ctlAppear.getControlType() != -1) continue;
            this.bindEntryEvents(((EntityAppearance)ctlAppear).getLayoutinfo());
        }
    }

    public void registeSmartMenu() {
        this.smartMenu.put(KDTable.class, TableSmartMenu.class);
        this.smartMenu.put(KDPanel.class, ContainerSmarMenu.class);
        this.smartMenu.put(KDContainer.class, ContainerSmarMenu.class);
        this.smartMenu.put(KDTabbedPane.class, TabbedPaneSmartMenu.class);
        this.smartMenu.put(KDImgPanel.class, ImgSmartMenu.class);
    }

    public boolean canEdit() {
        if (!StringUtils.isEmpty((String)this.model.getFormID())) {
            return FormPermission.newInstance().getCurrentUserFormPermission(this.model.getFormID()).canEditable();
        }
        return false;
    }

    @Override
    public final void stateChanged(ChangeEvent e) {
        ElementPropertyAdpter elAdp = this.propertyView.getSelectObject();
        this.selectViewObject(elAdp);
    }

    protected void selectViewObject(ElementPropertyAdpter elAdp) {
        Component comp = this.getUIBuilder().getControl(elAdp.getKey());
        if (comp != null) {
            this.getDesigner().selectControl(comp);
            return;
        }
        IColumn col = this.getUIBuilder().getColumn(elAdp.getKey());
        if (col != null) {
            KDTable table = (KDTable)this.getUIBuilder().getControl(((Field)elAdp.getElement()).getEntityKey());
            table.getSelectManager().select(0, col.getColumnIndex(), 4);
            return;
        }
        IRow row = this.getUIBuilder().getRow(elAdp.getKey());
        if (row != null) {
            KDTable table = (KDTable)this.getUIBuilder().getControl(((Field)elAdp.getElement()).getEntityKey());
            table.getSelectManager().select(row.getRowIndex(), 0, 2);
            return;
        }
        this.getDesigner().getSelection().clear();
    }

    public Designer getDesigner() {
        return (Designer)this.designerMap.get(this.designForm.getContentPane());
    }

    public UIBuilder getUIBuilder() {
        return this.uiBuilder;
    }

    @Override
    public void initDesigner() {
        this.formMetaData = this.model.getFormMetaData();
        LayoutInfo layout = this.formMetaData.getLayoutInfo(this.model.getLayoutKey());
        BusinessInfo businessInfo = this.formMetaData.getBusinessInfo();
        this.designPanel = new FormDesignerPanel();
        this.designPanel.setLayout((LayoutManager)new KDLayout());
        this.designPanel.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, 800, 600));
        this.designForm = new FormContainer();
        KDPanel panel = new KDPanel();
        panel.setLayout((LayoutManager)new KDLayout());
        Appearance ap = layout.getAppearance("_Bill");
        this.designPanel.setSize(ap.getWidth() + 100, ap.getHeight() + 100);
        this.designForm.setBounds(ap.getBounds());
        this.designForm.setLocation(10, 10);
        ap.setCaption(ap.getCaption_L1());
        String locale = SysContext.getSysContext().getLocale().toString();
        if (locale.equalsIgnoreCase("l2")) {
            ap.setCaption(ap.getCaption_L2());
        } else if (locale.equalsIgnoreCase("l3")) {
            ap.setCaption(ap.getCaption_L3());
        }
        FormAppearance fap = layout.getFormAppearance();
        fap.setListCaption(fap.getListCaption_L1());
        if (locale.equalsIgnoreCase("l2")) {
            fap.setListCaption(fap.getListCaption_L2());
        } else if (locale.equalsIgnoreCase("l3")) {
            fap.setListCaption(fap.getListCaption_L3());
        }
        this.designForm.setTitle(ap.getCaption());
        this.designForm.setIconURL(ToolBoxView.class.getResource("find.gif"));
        this.designPanel.add((Component)this.designForm, (Object)new KDLayout.Constraints(0, this.designForm.getBounds()));
        panel.setBounds(ap.getBounds());
        panel.putClientProperty((Object)"OriginalBounds", (Object)ap.getBounds());
        this.designForm.setContentPane((Container)panel);
        this.designForm.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
                DynamicFormDesigner.this.setLayoutSize();
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }
        });
        this.initDesignerContent(layout, businessInfo);
    }

    protected void setLayoutSize() {
        if (this.designPanel.isSelected()) {
            ElementPropertyAdpter elAdpter = this.model.getElementProperty("_Bill");
            elAdpter.setBounds(this.designForm.getBounds());
            this.propertyView.selectObject(elAdpter);
        }
    }

    protected void initDesignerContent(LayoutInfo layout, BusinessInfo businessInfo) {
        this.uiBuilder = new UIBuilder(layout, this.designForm.getContentPane(), businessInfo);
        this.uiBuilder.setRuntime(false);
        this.uiBuilder.addControls();
        this.addDesignPanel((KDPanel)this.designForm.getContentPane());
    }

    public void prepareCopyControl(Designer sender, PrepareCopyControlEventArgs e) {
        ElementPropertyAdpter srcElAdpter = this.model.getElementProperty(e.getComponent().getName());
        ElementType elementType = srcElAdpter.elementType;
        String containerKey = this.getContainerKey(e.getParent());
        ElementPropertyAdpter el = null;
        try {
            switch (elementType.getType()) {
                case 4: {
                    el = this.model.copyField(srcElAdpter, e.getBounds(), containerKey);
                    break;
                }
                case 3: {
                    el = this.model.copyControl(srcElAdpter, e.getBounds(), containerKey);
                }
            }
        }
        catch (CloneNotSupportedException e1) {
            logger.error((Object)e1);
        }
        if (el != null && el.getAppearance() != null) {
            this.model.addElementToMetaData(el);
            this.refreshObjectList();
            JComponent comp = (JComponent)this.getUIBuilder().addControl((ControlAppearance)el.getAppearance());
            if (comp != null) {
                comp.putClientProperty("Tag", el);
                if (comp instanceof KDTable) {
                    this.bindEntryEvents((KDTable)comp, true);
                }
                this.getDesigner().add((Component)comp, e.getParent());
                e.setNewComp((Component)comp);
            }
        }
    }

    @Override
    public void createDataChanged(Object data) {
        if (data == null) {
            this.getDesigner().setCreateType(0);
        } else {
            this.getDesigner().setCreateType(1);
        }
        this.getDesigner().setCreateData(data);
    }

    public void prepareAddControl(Designer sender, PrepareAddControlEventArgs e) {
        try {
            ElementType elementType = (ElementType)e.getCreateData();
            if (elementType == null) {
                return;
            }
            String containerKey = this.getContainerKey(e.getParent());
            ElementPropertyAdpter el = null;
            String entityKey = this.formMetaData.getBusinessInfo().getEntity(0).getKey();
            Rectangle rect = e.getBounds();
            switch (elementType.getType()) {
                case 4: {
                    el = this.model.createField(elementType, rect, containerKey, entityKey);
                    break;
                }
                case 3: {
                    el = this.model.createControl(elementType, rect, entityKey, containerKey);
                    break;
                }
                case 2: {
                    Object[] captions;
                    String caption;
                    EntityObjectInfo new_entity = null;
                    CreateEntityDialog dialog = new CreateEntityDialog();
                    dialog.setBusinessInfo(this.model.getBusinessInfo());
                    String FLOW_MANAGER_SYS_ID = "Yds+n9qaSlCkwWcxiBqrqQfnBlk=";
                    if (this.model.getBusinessInfo().getForm().getSubsysId().equals(FLOW_MANAGER_SYS_ID)) {
                        dialog.showSelectBaseEntityNameItems(false);
                        String[] base_entity_names = new String[]{"com.kingdee.eas.framework.app.CoreBillEntryBase"};
                        dialog.selectBaseEntityNameItems(new String[]{"\u5206\u5f55\u57fa\u7c7b"}, base_entity_names);
                    } else {
                        BillTypeCollection items = BillTypeFactory.getRemoteInstance().getBillTypeCollection("select * order by index");
                        ArrayList<String> alias = new ArrayList<String>();
                        ArrayList<String> names = new ArrayList<String>();
                        for (int i = 0; i < items.size(); ++i) {
                            if (items.get(i).getType() != 1) continue;
                            alias.add(items.get(i).getName());
                            names.add(items.get(i).getFullEntityName());
                        }
                        if (alias.size() > 0) {
                            String[] alias_strings = new String[alias.size()];
                            String[] names_strings = new String[names.size()];
                            alias.toArray(alias_strings);
                            names.toArray(names_strings);
                            dialog.selectBaseEntityNameItems(alias_strings, names_strings);
                        }
                    }
                    dialog.show();
                    Entity entity = dialog.getReturn();
                    if (null == entity) {
                        return;
                    }
                    if (!StringUtil.isEmpty((String)entity.getName())) {
                        entity.setParentEntityKey("entries" + this.model.getBusinessInfo().getEntryCount());
                        BOSObjectType bostype = BOSObjectType.create((String)this.model.getBusinessInfo().getEntity(0).getBosType());
                        new_entity = BOSEntityGenerator.getInstance().createAEntry(null, entity, EntityUtility.getBOSEntity(null, (BOSObjectType)bostype));
                        ((BillDesigner)this).refreshEntityView();
                        if (new_entity != null) {
                            String ref_bostype = new_entity.getType().toString();
                            String old_bostype = this.model.getBusinessInfo().getForm().getRefBosTypes();
                            this.model.getBusinessInfo().getForm().setRefBosTypes(old_bostype + "," + ref_bostype);
                        }
                    }
                    if ((el = this.model.createEntity(elementType, rect, containerKey)) != null && IdeUtil.with_in_array((Object)(caption = el.getCaption()), (Object[])(captions = this.model.getCaptionOfEntries()))) {
                        String new_name = "";
                        int i = 1;
                        while (true) {
                            if (!IdeUtil.with_in_array((Object)(new_name = caption + i), (Object[])captions)) {
                                el.setCaption(new_name);
                                el.getAppearance().setCaption_L1(new_name);
                                el.getAppearance().setCaption_L3(new_name);
                                break;
                            }
                            ++i;
                        }
                    }
                    if (new_entity == null) break;
                    if (el != null && el.getAppearance() != null) {
                        Container parent = e.getParent();
                        this.addControlToDesigner(el, parent);
                    }
                    this.bindNewEntityAndEntry(el, new_entity);
                    return;
                }
            }
            if (el != null && el.getAppearance() != null) {
                Container parent = e.getParent();
                this.addControlToDesigner(el, parent);
            }
        }
        catch (BOSException e1) {
            logger.error((Object)e1);
        }
    }

    public void bindNewEntityAndEntry(ElementPropertyAdpter el, EntityObjectInfo new_entity) throws BOSException {
        if (this.model.getBusinessInfo().getEntity(0).getBosType().equals(new_entity.getType().toString())) {
            return;
        }
        el.getAppearance().setBosType(new_entity.getType().toString());
        PropertyUtil.setPropertyValue((Object)el.getElement(), (String)"BosType", (Object)new_entity.get("bosType").toString());
        PropertyUtil.setPropertyValue((Object)el.getElement(), (String)"TableName", (Object)new_entity.getTable().getName());
        PropertyUtil.setPropertyValue((Object)el.getElement(), (String)"PkFieldName", (Object)BindingDataProp.getPKFieldName(new_entity));
        PropertyUtil.setPropertyValue((Object)el.getElement(), (String)"EntryName", (Object)BindingDataProp.getClientEntryName(new_entity));
        PropertyUtil.setPropertyValue((Object)el.getElement(), (String)"EntryPkFieldName", (Object)new_entity.getPropertyByName(BindingDataProp.getSupplyEntryName(new_entity)).getMappingField().getName());
        ElementPropertyAdpter field = this.model.createField(this.model.getElementType(3), new Rectangle(0, 0, 200, 200), null, el.getKey());
        int visible = field.getAppearance().getVisible();
        int[] excepts = new int[]{1, 128, 64, 32, 2, 256, 512, 8192, 1024, 32768};
        for (int i = 0; i < excepts.length; ++i) {
            visible = FieldAppearance.getVisibleExcept((int)visible, (int)excepts[i]);
        }
        field.getAppearance().setVisible(visible);
        this.model.addElementToMetaData(field);
        PropertyInfo info = null;
        for (int i = 0; i < new_entity.getEntityProperties().size() && !(info = new_entity.getEntityProperties().get(i)).getName().equalsIgnoreCase("seq"); ++i) {
        }
        if (info != null) {
            ((Field)field.getElement()).setDynamic(0);
            field.getAppearance().setCaption(info.getAlias());
            field.getAppearance().setCaption_L1(info.getAlias(new Locale("en", "US")));
            field.getAppearance().setCaption_L2(info.getAlias(new Locale("zh", "CN")));
            field.getAppearance().setCaption_L3(info.getAlias(new Locale("zh", "TW")));
            PropertyUtil.setPropertyValue((Object)field.getElement(), (String)"BosType", (Object)new_entity.get("bosType").toString());
            PropertyUtil.setPropertyValue((Object)field.getElement(), (String)"PropertyName", (Object)info.getName());
            PropertyUtil.setPropertyValue((Object)field.getElement(), (String)"FieldName", (Object)info.getMappingField().getName());
            PropertyUtil.setPropertyValue((Object)field.getElement(), (String)"MustInput", (Object)new Integer(info.getMappingField().isNullable() ? 0 : 1));
            Object obj = info.get("isMultilingual");
            if (obj != null) {
                PropertyUtil.setPropertyValue((Object)field.getElement(), (String)"MulLanguage", (Object)new Integer(obj.toString().equals("true") ? 1 : 0));
            }
        }
        this.uiBuilder.createNewColumn((KDTable)this.getUIBuilder().getControl(el.getKey()), (FieldAppearance)field.getAppearance());
    }

    public void addControlToDesigner(ElementPropertyAdpter el, Container parent) {
        this.model.addElementToMetaData(el);
        this.refreshObjectList();
        JComponent comp = (JComponent)this.getUIBuilder().addControl((ControlAppearance)el.getAppearance());
        if (comp != null) {
            comp.putClientProperty("Tag", el);
            if (el.getAppearance().getControlType() == 1007) {
                this.bindEntryEvents((KDTable)comp, true);
            }
            this.getDesigner().add((Component)comp, parent);
        }
    }

    public void refreshObjectList() {
        this.propertyView.initObjectList(this.model.getElements());
    }

    public void componentPositionChanged(Component sender, ComponentPositionChangedArgs e) {
        ElementPropertyAdpter objProperty = this.model.getElementProperty(sender.getName());
        if (objProperty != null) {
            Container ctlParent = sender.getParent();
            String containerKey = this.getContainerKey(ctlParent);
            objProperty.setBounds(sender.getBounds());
            if (ctlParent != null) {
                try {
                    objProperty.setPropertyValue("Container", containerKey);
                }
                catch (BOSException e1) {
                    logger.error((Object)e1);
                }
            }
            this.propertyView.selectObject(objProperty);
        }
    }

    protected String getContainerKey(Container ctlParent) {
        String containerKey = ctlParent.getName();
        if (ctlParent.getLayout() instanceof com.kingdee.eas.base.form.client.layout.Table.TableLayout) {
            Cell c = (Cell)((JComponent)ctlParent).getClientProperty("Cell");
            containerKey = containerKey + "," + c.getCol() + "," + c.getRow();
        }
        return containerKey;
    }

    public void selectionChanged(Designer sender) {
        this.propertyView.commitCurrentPropEditing();
        this.getToolBarOperation().getCommandList().setToolbarLocateAction(sender.getSelection().getCount());
        int selectCount = sender.getSelection().getCount();
        if (selectCount == 0) {
            ElementPropertyAdpter elAdpter = this.model.getElementProperty("_Bill");
            this.propertyView.selectObject(elAdpter);
            this.propertyView.initObjectList(this.model.getElements());
            this.designPanel.setSelected(true);
        } else if (selectCount >= 1) {
            this.designPanel.setSelected(false);
            String key = sender.getSelection().getPrimaryControl().getName();
            ElementPropertyAdpter elAdpter = this.model.getElementProperty(key);
            this.createMuitleObjProperty(sender.getSelection().getSelectedControls());
            if (selectCount > 1) {
                this.propertyView.initObjectList(null);
            } else {
                this.propertyView.initObjectList(this.model.getElements());
            }
            this.propertyView.selectObject(elAdpter);
        }
    }

    protected void createMuitleObjProperty(List ctlList) {
        this.propMap.clear();
        if (ctlList.size() > 1) {
            ArrayList<ElementType> tmpList = new ArrayList<ElementType>();
            HashMap<Integer, Integer> mapTmp = new HashMap<Integer, Integer>();
            Iterator it = ctlList.iterator();
            while (it.hasNext()) {
                String key1 = ((Component)it.next()).getName();
                Appearance el = this.model.getLayoutInfo().getAppearance(key1);
                if (el == null) continue;
                int elementType = el.getElementType();
                if (!mapTmp.containsKey(new Integer(elementType))) {
                    tmpList.add(this.model.getElementType(elementType));
                    mapTmp.put(new Integer(elementType), new Integer(1));
                    continue;
                }
                mapTmp.put(new Integer(elementType), new Integer((Integer)mapTmp.get(new Integer(elementType)) + 1));
            }
            for (ElementType elementType : tmpList) {
                int base = (Integer)mapTmp.get(new Integer(elementType.getId()));
                for (ElementProperty prop : elementType.getAppearancePropertys()) {
                    if (prop.getBindingFlags() == 3) continue;
                    String propName = prop.getPropertyName();
                    if (this.propMap.containsKey(propName)) {
                        this.propMap.put(propName, new Integer((Integer)this.propMap.get(propName) + base));
                        continue;
                    }
                    this.propMap.put(propName, new Integer(base));
                }
            }
        }
    }

    public void commandAddExecute(Designer sender, CommandAddArgs e) {
        ElementPropertyAdpter el = (ElementPropertyAdpter)((JComponent)e.getControl()).getClientProperty("Tag");
        e.setBindData((Object)el);
        if (el != null && this.model.getElementProperty(el.getKey()) == null) {
            this.model.addElementToMetaData(el);
            if (el.getAppearance() instanceof TabPageAppearance) {
                TabPageAppearance tabPageAp = (TabPageAppearance)el.getAppearance();
                TabControlAppearance tabAp = (TabControlAppearance)this.model.getLayoutInfo().getAppearance(el.getAppearance().getContainer());
                tabAp.insert(tabPageAp.getTabindex(), tabPageAp);
            }
        }
        if (el != null) {
            sender.selectControl(e.getControl());
        }
        this.designPanel.setPreferredSize(this.getDesignerPreferredSize((Container)this.designPanel));
    }

    public void commandAddUnExecute(Designer sender, CommandAddArgs e) {
        Object obj = e.getBindData();
        if (obj instanceof ElementPropertyAdpter) {
            ElementPropertyAdpter el = (ElementPropertyAdpter)e.getBindData();
            this.model.deleteElement(el, false);
        }
    }

    public void commandRemoveExecute(Designer sender, CommandRemoveArgs e) {
        ElementPropertyAdpter el = this.model.getElementProperty(e.getControl().getName());
        this.DeleteFieldHandle(el.getElement());
        this.deleteControl((JComponent)e.getControl());
        e.setBindData((Object)el);
        if (el.getElement() != null) {
            this.refreshRefControlKey(el.getElement().getKey(), "");
        }
        this.refreshObjectList();
    }

    public void DeleteFieldHandle(Element del_ele) {
        if (del_ele != null && del_ele.getElementType() == 30) {
            List field_list = this.model.getBusinessInfo().getFieldList();
            Field fld = null;
            for (int i = 0; i < field_list.size(); ++i) {
                fld = (Field)field_list.get(i);
                if (fld == del_ele || fld.getElementType() != 30 || !del_ele.getKey().equals(fld.getControlFieldKey())) continue;
                fld.setControlFieldKey("");
            }
        }
    }

    private boolean deleteControl(JComponent ctl) {
        boolean bCancel = false;
        if (ctl == null) {
            return true;
        }
        ElementPropertyAdpter propAdp = this.model.getElementProperty(ctl.getName());
        if (propAdp != null) {
            this.model.deleteElement(propAdp, true);
        }
        return bCancel;
    }

    public void commandRemoveUnExecute(Designer sender, CommandRemoveArgs e) {
        ElementPropertyAdpter el = (ElementPropertyAdpter)e.getBindData();
        if (this.model.getElementProperty(el.getKey()) == null) {
            this.model.addElementToMetaData(el);
            if (el.getAppearance() instanceof TabPageAppearance) {
                TabPageAppearance tabPageAp = (TabPageAppearance)el.getAppearance();
                TabControlAppearance tabAp = (TabControlAppearance)this.model.getLayoutInfo().getAppearance(el.getAppearance().getContainer());
                tabAp.insert(tabPageAp.getTabindex(), tabPageAp);
            }
        }
        if (el != null) {
            e.getControl().setName(el.getKey());
            sender.selectControl(e.getControl());
        }
        this.designPanel.setPreferredSize(this.getDesignerPreferredSize((Container)this.designPanel));
    }

    public void componentBeforeRemove(Designer sender, ComponentBeforeRemoveArgs e) {
    }

    public void gridActiveToDesign(Designer sender, GridActiveToDesignArgs e) {
        KDTable table = e.getGrid();
        if (table instanceof KDApproval) {
            return;
        }
        String key = null;
        Integer entryType = (Integer)table.getClientProperty((Object)"EntryType");
        if (entryType != null && entryType == 0) {
            int rowIndex = table.getSelectManager().getActiveRowIndex();
            if (rowIndex < 0) {
                return;
            }
            key = table.getRow(rowIndex).getUserObject().toString();
        } else {
            int columnIndex = table.getSelectManager().getActiveColumnIndex();
            if (columnIndex < 0) {
                return;
            }
            key = table.getColumn(columnIndex).getKey();
        }
        this.propertyView.selectObject(this.model.getElementProperty(key));
    }

    public void itemContainerLabelWidthChanged(Designer sender, ItemContainerLabelWidthChangedArgs e) {
        ElementPropertyAdpter objProperty = this.model.getElementProperty(e.getItem().getName());
        if (objProperty != null) {
            try {
                objProperty.setPropertyValue("LabelWidth", new Integer(e.getLabelWidth()));
            }
            catch (BOSException bOSException) {
                // empty catch block
            }
            this.propertyView.selectObject(objProperty);
        }
    }

    public void prepareCreateItemOnGrid(Designer sender, PrepareCreateItemOnGridArgs e) {
        ElementType elementType = (ElementType)e.getCreateData();
        if (elementType != null && elementType.getType() == 4) {
            AddEntityFieldCommand cmd = new AddEntityFieldCommand(e.getGrid(), elementType, e.getGrid().getName(), this.model, this.getUIBuilder(), this);
            try {
                cmd.execute();
            }
            catch (BOSException e1) {
                logger.error((Object)e1);
            }
            sender.addCommand((ICommand)cmd);
        }
    }

    public String getComponentBindinfo(Component component) {
        return "";
    }

    public void queryCanAdded(Designer sender, QueryAddedArgs e) {
        FormPermission.FormPermisoionType type;
        if (e.getCreateData() == null) {
            e.setAllowAdded(false);
        } else if (!StringUtils.isEmpty((String)this.model.getFormID()) && !(type = FormPermission.newInstance().getCurrentUserFormPermission(this.model.getFormID())).canEditable()) {
            e.setAllowAdded(false);
        }
    }

    public void requestTypeDefaultSize(Designer sender, RequestTypeDefaultSizeEventArgs e) {
    }

    public void smartTagClicked(Component component, SmartTagClickArg e) {
        KDPopupMenu menu = this.createPopupMenu(component);
        if (menu != null) {
            menu.show((Component)e.getContainer(), e.getLocation().x, e.getLocation().y);
        }
    }

    private Class getSmartType(Component c) {
        Class<?> controlType = c.getClass();
        Class itemType = null;
        if (this.smartMenu.containsKey(controlType)) {
            itemType = (Class)this.smartMenu.get(controlType);
        }
        return itemType;
    }

    private AbstractSmartMenu createSmartMenu(Component c) {
        Class smartClass = this.getSmartType(c);
        AbstractSmartMenu smartMenu = null;
        if (smartClass != null) {
            try {
                Class[] partypes = new Class[]{Component.class, DynamicFormDesigner.class};
                Constructor ct = smartClass.getConstructor(partypes);
                Object[] arglist = new Object[]{c, this};
                smartMenu = (AbstractSmartMenu)ct.newInstance(arglist);
            }
            catch (Exception e) {
                return null;
            }
        }
        return smartMenu;
    }

    private KDPopupMenu createPopupMenu(Component component) {
        KDPopupMenu menu = null;
        AbstractSmartMenu smartMenu = this.createSmartMenu(component);
        if (smartMenu != null) {
            return smartMenu.createPopupMenu();
        }
        return menu;
    }

    public void deleteColumn(KDTable table) {
        DeleteEntityFieldCommand cmd = new DeleteEntityFieldCommand(table, this.model, this.getUIBuilder(), this);
        cmd.execute();
        this.getDesigner().addCommand((ICommand)cmd);
    }

    public void tableLayoutChanged(Container container, TableLayoutChangeArgs e) {
        ControlAppearance ctl = this.model.getLayoutInfo().getControlAppearance(container.getName());
        TableLayout tbInfo = (TableLayout)ctl.getLayout();
        ArrayList colStylesInfo = tbInfo.getColStyles();
        ArrayList rowStylesInfo = tbInfo.getRowStyles();
        com.kingdee.eas.base.form.client.layout.Table.TableLayout tb = e.getLayout();
        for (int i = 0; i < tb.getRowCount(); ++i) {
            ((Style)rowStylesInfo.get(i)).setOut(tb.getRowStyle(i).getHeight());
            for (int j = 0; j < tb.getColCount(); ++j) {
                ElementPropertyAdpter objProperty;
                ComponentContent content;
                Component comp;
                ((Style)colStylesInfo.get(j)).setOut(tb.getColStyle(j).getWidth());
                Cell c = e.getLayout().cell(i, j);
                if (c.getContent() == null || (comp = (content = (ComponentContent)c.getContent()).getComponent()) == null || (objProperty = this.model.getElementProperty(comp.getName())) == null) continue;
                objProperty.setBounds(comp.getBounds());
                if (comp instanceof KDLabelContainer) {
                    ((KDLabelContainer)comp).revalidate();
                    continue;
                }
                if (!(comp instanceof KDContainer)) continue;
                ((KDContainer)comp).doLayout();
            }
        }
    }

    public void queryCreateData(Designer sender) {
    }

    public void eelectEntryField(ElementPropertyAdpter elAdp) {
        this.propertyView.selectObject(elAdp);
    }

    public void undoRedoStateChanged(Designer sender, UndoRedoStateChangedEventArgs e) {
    }

    @Override
    public Component getDesignerComponent() {
        if (this.sPane == null) {
            this.sPane = new KDScrollPane((Component)this.designPanel, 20, 30);
            this.sPane.setUserObject((Object)this.getKey());
            this.designPanel.setAutoscrolls(true);
            Dimension di = this.designPanel.getSize();
            this.designPanel.setPreferredSize(di);
        }
        return this.sPane;
    }

    @Override
    public String getKey() {
        String formId = this.model.getFormMetaData().getFormId();
        String tmpKey = this.model.getTmpKey();
        if (formId == null || formId.trim().length() == 0) {
            return tmpKey;
        }
        return formId;
    }

    @Override
    public String getTitle() {
        return this.model.getTitle();
    }

    @Override
    public void active() {
        this.propertyView.setPropertyAdpterListner(this);
        this.refreshObjectList();
        this.propertyView.addSelectChangeListener(this);
        this.toolBoxView.addCreateDataChangeListener(this);
        this.selectionChanged(this.getDesigner());
    }

    @Override
    public void afterSave() throws Exception {
        this.resetContentMapKey();
        this.getUIBuilder().setBusinessInfo(this.model.getBusinessInfo());
        this.getUIBuilder().setLayoutInfo(this.model.getLayoutInfo());
    }

    @Override
    public void deActive() {
        this.propertyView.clearObjectList();
        this.propertyView.removeSelectChangeListener(this);
        this.toolBoxView.removeCreateDataChangeListener(this);
    }

    @Override
    public boolean queryUnLoad() {
        return true;
    }

    @Override
    public void save() throws Exception {
        this.model.save();
        this.solutionView.refreshTree();
        this.selectionChanged(this.getDesigner());
    }

    protected void resetContentMapKey() {
        KDScrollPane designerComponent = (KDScrollPane)this.getDesignerComponent();
        KDTabbedPane tabPane = (KDTabbedPane)designerComponent.getParent();
        DesignerView parentView = (DesignerView)((Object)tabPane.getParent());
        Map parentContentMap = parentView.getCacheContentMap();
        if (parentContentMap != null) {
            for (Object key : parentContentMap.keySet()) {
                IDesignerContent content = (IDesignerContent)parentContentMap.get(key);
                if (content.getKey().equals(key)) continue;
                parentContentMap.remove(key);
                parentContentMap.put(content.getKey(), content);
                designerComponent.setUserObject((Object)content.getKey());
                break;
            }
        }
    }

    protected void bindEntryEvents(KDTable table, boolean bAdd) {
        if (bAdd) {
            table.addKDTActiveCellListener((KDTActiveCellListener)this);
            table.addKDTResizeListener((KDTResizeListener)this);
            table.addKDTColumnMoveListener((KDTColumnMoveListener)this);
            Integer entryType = (Integer)table.getClientProperty((Object)"EntryType");
            if (entryType != null && entryType == 1) {
                table.addRow();
            }
        } else {
            table.removeKDTActiveCellListener((KDTActiveCellListener)this);
            table.removeKDTResizeListener((KDTResizeListener)this);
        }
    }

    public void activeCellChanged(KDTActiveCellEvent e) {
        KDTable table = (KDTable)e.getSource();
        String key = table.getName();
        Entity entity = this.model.getFormMetaData().getBusinessInfo().getEntity(key);
        ElementPropertyAdpter elAdp = null;
        if (entity.getEntityType() == 0) {
            int rowIndex = e.getRowIndex();
            if (rowIndex < 0) {
                return;
            }
            key = table.getRow(rowIndex).getUserObject().toString();
            elAdp = this.model.getElementProperty(key);
        } else {
            int colIndex = e.getColumnIndex();
            if (colIndex < 0) {
                return;
            }
            elAdp = this.model.getElementProperty(table.getColumn(e.getColumnIndex()).getKey());
        }
        this.propertyView.selectObject(elAdp);
    }

    public void tableColumnResize(KDTResizeEvent e) {
        String key = ((KDTable)e.getSource()).getColumn(e.getIndex()).getKey();
        ElementPropertyAdpter elAdp = this.model.getElementProperty(key);
        try {
            elAdp.setPropertyValue("Width", new Integer(e.getNewValue()));
        }
        catch (BOSException e1) {
            logger.error((Object)e1);
        }
    }

    public void tableRowResize(KDTResizeEvent e) {
    }

    public void columnMoved(KDTColumnMoveEvent e) {
        KDTable table = (KDTable)e.getSource();
        if (table != null) {
            for (int i = 0; i < table.getColumnCount(); ++i) {
                this.setColumnIndex(table.getColumn(i));
            }
        }
    }

    private void setColumnIndex(IColumn col) {
        String key = col.getKey();
        ElementPropertyAdpter elAdp = this.model.getElementProperty(key);
        elAdp.getAppearance().setTabindex(col.getColumnIndex());
    }

    public Dimension getDesignerPreferredSize(Container panel) {
        double x = -1.0;
        double y = -1.0;
        for (int i = 0; i < panel.getComponentCount(); ++i) {
            if (panel.getComponent(i).getBounds().getX() + panel.getComponent(i).getBounds().getWidth() > x) {
                x = panel.getComponent(i).getBounds().getX() + panel.getComponent(i).getBounds().getWidth();
            }
            if (!(panel.getComponent(i).getBounds().getY() + panel.getComponent(i).getBounds().getHeight() > y)) continue;
            y = panel.getComponent(i).getBounds().getY() + panel.getComponent(i).getBounds().getHeight();
        }
        Dimension di = new Dimension((int)x + 50, (int)y + 50);
        return di;
    }

    @Override
    public void filterProperty(ObjectProperty prop) {
        int selectCount = this.getDesigner().getSelection().getCount();
        if (selectCount > 1) {
            String name = prop.getElementProperty().getPropertyName();
            Integer count = (Integer)this.propMap.get(name);
            if (count != null && count == selectCount) {
                prop.setVisible(true);
            } else {
                prop.setVisible(false);
            }
        } else {
            if (prop.getPropertyAdpter().getAppearance() instanceof FieldAppearance) {
                FieldAppearance fieldAp = (FieldAppearance)prop.getPropertyAdpter().getAppearance();
                EntityAppearance entityAp = this.model.getLayoutInfo().getEntityAppearance(fieldAp.getEntityKey());
                Entity entity = this.model.getBusinessInfo().getEntity(fieldAp.getEntityKey());
                if (entityAp != null && entityAp.getControlType() == 1007 && prop.getElementProperty().getVisible() != 3) {
                    prop.setVisible(false);
                }
                if (entity != null && entity.getEntityType() == 0 && prop.getElementProperty().getPropertyName().equalsIgnoreCase("MulLines")) {
                    prop.setVisible(false);
                }
            }
            if (prop.getPropertyAdpter().getElement() instanceof Field) {
                Field field = (Field)prop.getPropertyAdpter().getElement();
                if (prop.getElementProperty().getPropertyName().equalsIgnoreCase("MulLanguage")) {
                    if (field.isDynamic()) {
                        prop.setEditable(true);
                    } else {
                        prop.setEditable(false);
                    }
                }
                if (prop.getElementProperty().getPropertyName().equalsIgnoreCase("Editlen") && (field.getElementType() == 1 || field.getElementType() == 6 || field.getElementType() == 12)) {
                    if (field.isDynamic()) {
                        prop.setEditable(true);
                    } else {
                        prop.setEditable(false);
                    }
                }
            }
            if (prop.getPropertyAdpter() != null && prop.getPropertyAdpter().getAppearance() instanceof AccessoryPanelAppearance) {
                AccessoryPanelAppearance control = (AccessoryPanelAppearance)prop.getPropertyAdpter().getAppearance();
                if (prop.getElementProperty().getPropertyName().equalsIgnoreCase("DisplayCreator") || prop.getElementProperty().getPropertyName().equalsIgnoreCase("DisplayCreateTime")) {
                    if (control.getSingleDisplay() == 1) {
                        prop.setEditable(true);
                    } else {
                        prop.setEditable(false);
                    }
                }
            }
        }
    }

    private void refreshRefControlKey(String old_key_name, String new_key_name) {
        List field_list = this.model.getBusinessInfo().getFieldList();
        Field fld = null;
        for (int i = 0; i < field_list.size(); ++i) {
            fld = (Field)field_list.get(i);
            String key = fld.getControlFieldKey();
            if (key == null || !key.equals(old_key_name)) continue;
            fld.setControlFieldKey(new_key_name);
        }
    }

    @Override
    public void propertyChanged(ObjectProperty prop, Object newValue, Object oldValue) {
        int bindingFlag;
        try {
            EntityObjectInfo new_entity;
            Entity entry;
            if (prop.getPropertyAdpter().getElementType() == 35 && (entry = (Entity)prop.getPropertyAdpter().getElement()).getFields().size() == 0 && (new_entity = EntityObjectInfoHelp.getEntity(BOSObjectType.create((String)entry.getBosType()))) != null) {
                ElementPropertyAdpter el = prop.getPropertyAdpter();
                this.bindNewEntityAndEntry(el, new_entity);
            }
        }
        catch (BOSException entry) {
            // empty catch block
        }
        if (prop.getElementProperty().getPropertyName().equalsIgnoreCase("Key")) {
            this.model.keyChanged(prop.getPropertyAdpter(), newValue, oldValue);
            this.getUIBuilder().setControlKey(newValue.toString(), oldValue.toString());
            this.refreshRefControlKey(oldValue.toString(), newValue.toString());
            Component ctrl = this.getUIBuilder().getControl((String)newValue);
            if (ctrl instanceof KDImgPanel) {
                KDImgPanel comp = (KDImgPanel)ctrl;
                comp.setImgPanelKey((String)newValue);
                BasImgHelper biHelper = new BasImgHelper();
                biHelper.setBosType(this.model.getBusinessInfo().getForm().getBosType());
                biHelper.setFieldKey((String)newValue);
                String imgFile = MetaDataFactory.getImgDataStream((BasImgHelper)biHelper, null);
                comp.setImagePath(imgFile);
                comp.repaint();
            }
        }
        if (prop.getElementProperty().getPropertyName().equalsIgnoreCase("PictureSrc")) {
            KDImgPanel comp = (KDImgPanel)this.getUIBuilder().getControl(prop.getPropertyAdpter().getKey());
            this.setNewImage((KDPanel)comp, newValue);
        }
        if ((bindingFlag = prop.getElementProperty().getBindingFlags()) == 1 || bindingFlag == 3 || prop.getName().equalsIgnoreCase("PropertyName") || prop.getName().equalsIgnoreCase("BosType")) {
            String primaryKey;
            this.updateView(prop.getPropertyAdpter());
            if (this.getDesigner().getSelection().getCount() > 1 && (primaryKey = this.getDesigner().getSelection().getPrimaryControl().getName()).equalsIgnoreCase(prop.getPropertyAdpter().getKey())) {
                List comps = this.getDesigner().getSelection().getSelectedControls();
                for (Component comp : comps) {
                    if (comp.getName().equalsIgnoreCase(primaryKey)) continue;
                    ElementPropertyAdpter elAdp = this.model.getElementProperty(comp.getName());
                    try {
                        elAdp.setPropertyValue(prop.getElementProperty().getPropertyName(), newValue);
                        this.updateView(elAdp);
                    }
                    catch (BOSException e) {
                        logger.error((Object)e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setNewImage(KDPanel comp, Object newValue) {
        String img_file_name = (String)newValue;
        String primaryKey = null;
        String formID = this.getModel().getFormID();
        String bosType = this.model.getBusinessInfo().getForm().getBosType();
        BasImgHelper biHelper = new BasImgHelper();
        if (this.getDesigner().getSelection().getCount() > 0) {
            primaryKey = this.getDesigner().getSelection().getPrimaryControl().getName();
        }
        if (img_file_name != null) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(new File(img_file_name));
                biHelper.setFormID(formID);
                biHelper.setBosType(bosType);
                biHelper.setFieldKey(primaryKey);
                String ret = biHelper.setTmpImg((InputStream)fis);
                if ("save_succ".equals(ret)) {
                    ((KDImgPanel)comp).setImagePath(biHelper.getImgString());
                    ((KDImgPanel)comp).setImgFile(biHelper.getImgString());
                    ((KDImgPanel)comp).setChanged(true);
                    comp.repaint();
                } else if ("file_too_big".equals(ret)) {
                    MsgBox.showInfo((Component)ComponentUtil.getCurrentActiveWindow(), (String)"\u6587\u4ef6\u8fc7\u5927\uff0c\u8bf7\u9009\u62e9\u5c0f\u4e8e6M\u56fe\u7247\u4e0a\u4f20");
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    @Override
    public void propertyChanging(ObjectProperty prop, Object newValue, Object oldValue) {
    }

    @Override
    public void doOperation(String commandStr) {
        try {
            if (commandStr.equals("OP_DELETE_ELEMENT")) {
                this.getDesigner().getToolbar().deleteSelect();
            } else if (commandStr.equals("OP_ALIGN_LEFT")) {
                this.getDesigner().getToolbar().alignLefts();
            } else if (commandStr.equals("OP_ALIGN_RIGHT")) {
                this.getDesigner().getToolbar().alignRights();
            } else if (commandStr.equals("OP_ALIGN_BOTTOM")) {
                this.getDesigner().getToolbar().alignBottoms();
            } else if (commandStr.equals("OP_ALIGN_TOP")) {
                this.getDesigner().getToolbar().alignTops();
            } else if (commandStr.equals("OP_ALIGN_CENTER")) {
                this.getDesigner().getToolbar().alignCenters();
            } else if (commandStr.equals("OP_ALIGN_MIDDLE")) {
                this.getDesigner().getToolbar().alignMiddles();
            } else if (commandStr.equals("OP_HORI_SAME_LENTH")) {
                this.getDesigner().getToolbar().makeHorizontalSpacingEqual();
            } else if (commandStr.equals("OP_ADD_HORI_LENTH")) {
                this.getDesigner().getToolbar().increaseHorizontalSpacing();
            } else if (commandStr.equals("OP_REDUCE_HORI_LENTH")) {
                this.getDesigner().getToolbar().decreaseHorizontalSpacing();
            } else if (commandStr.equals("OP_VERTI_SAME_LENTH")) {
                this.getDesigner().getToolbar().makeVerticalSpacingEqual();
            } else if (commandStr.equals("OP_ADD_VERTI_LENTH")) {
                this.getDesigner().getToolbar().increaseVerticalSpacing();
            } else if (commandStr.equals("OP_REDUCE_VERTI_LENTH")) {
                this.getDesigner().getToolbar().decreaseVerticalSpacing();
            } else if (commandStr.equals("OP_SAME_WIDTH")) {
                this.getDesigner().getToolbar().makeSameWidth();
            } else if (commandStr.equals("OP_SAME_HEIGHT")) {
                this.getDesigner().getToolbar().makeSameHeight();
            } else if (commandStr.equals("OP_SAME_WIDTH_AND_HEIGHT")) {
                this.getDesigner().getToolbar().makeSameSize();
            } else if (commandStr.equals("OP_SAME_LABLE_WIDTH")) {
                this.getDesigner().getToolbar().itemContainerSameLabelWidth();
            } else if (commandStr.equals("OP_UNDO")) {
                this.getDesigner().getToolbar().undo();
            } else if (commandStr.equals("OP_REDO")) {
                this.getDesigner().getToolbar().redo();
            } else if (commandStr.equals("OP_LAY_TOP")) {
                this.getDesigner().getToolbar().bringToFront();
            } else if (commandStr.equals("OP_LAY_BOTTOM")) {
                this.getDesigner().getToolbar().sendToBack();
            } else if (commandStr.equals("OP_LOCK")) {
                this.getDesigner().getToolbar().lock();
            } else if (commandStr.equals("OP_TAB_SEQ")) {
                this.getDesigner().setDesignTabIndexMode(!this.getDesigner().isDesignTabIndex());
            } else if (commandStr.equals(OperationConstant.OP_MAKE_GRID)) {
                this.getDesigner().getToolbar().makeGrid();
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
    }

    @Override
    public MetaDataDesinerModel getModel() {
        return this.model;
    }

    public void componentTextChanged(Component sender) {
        ElementPropertyAdpter el = this.model.getElementProperty(sender.getName());
        el.setCaption(((JComponent)sender).getClientProperty("Text").toString());
        this.propertyView.selectObject(el);
    }

    protected void updateView(ElementPropertyAdpter elAdp) {
        Component comp = this.getUIBuilder().getControl(elAdp.getKey());
        if (comp != null) {
            comp.setBounds(elAdp.getAppearance().getBounds());
            comp.setName(elAdp.getKey());
            ((JComponent)comp).putClientProperty("KDLayoutConstraints", new KDLayout.Constraints(0, comp.getBounds()));
            if (elAdp.getAppearance() instanceof TabPageAppearance) {
                KDTabbedPane tab = (KDTabbedPane)this.getUIBuilder().getControl(elAdp.getAppearance().getContainer());
                TabControlAppearance tabAp = (TabControlAppearance)this.model.getLayoutInfo().getAppearance(elAdp.getAppearance().getContainer());
                tab.setTitleAt(tabAp.getTabPages().indexOf(elAdp.getAppearance()), elAdp.getCaption());
                ((JComponent)comp).putClientProperty("Text", elAdp.getCaption());
            } else if (comp instanceof KDLabelContainer) {
                this.updateKDLabelContainer((KDLabelContainer)comp, elAdp);
            } else if (comp instanceof KDContainer) {
                this.updateKDContainer((KDContainer)comp, elAdp);
            } else if (comp instanceof KDWorkButton) {
                ((KDWorkButton)comp).setText(elAdp.getCaption());
            } else if (comp instanceof KDExtLabel) {
                this.updateKDExtLabel((KDExtLabel)comp, elAdp);
            } else if (comp instanceof KDCheckBox) {
                ((KDCheckBox)comp).setText(elAdp.getCaption());
            } else if (comp instanceof KDTextArea) {
                ((KDTextArea)comp).setText(elAdp.getCaption());
            } else if (comp instanceof KDAccessoryPanel) {
                ((KDAccessoryPanel)comp).setTitle(elAdp.getCaption());
            } else if (comp instanceof KDRadioButton) {
                ((KDRadioButton)comp).setText(elAdp.getCaption());
            } else if (comp instanceof KDRadioGroupPanel) {
                ((KDRadioGroupPanel)comp).setTitle(elAdp.getCaption());
            }
            this.getDesigner().repaint();
            return;
        }
        if (elAdp.getKey().equalsIgnoreCase("_Bill")) {
            this.designForm.setTitle(elAdp.getCaption());
            this.designPanel.setFormSize(elAdp.getAppearance().getBounds().getSize());
            return;
        }
        IColumn col = this.getUIBuilder().getColumn(elAdp.getKey());
        if (col != null) {
            KDTable table = (KDTable)this.getUIBuilder().getControl(((Field)elAdp.getElement()).getEntityKey());
            String caption = elAdp.getCaption();
            table.getHeadRow(0).getCell(col.getColumnIndex()).setValue((Object)caption);
            col.setKey(elAdp.getKey());
            return;
        }
        IRow row = this.getUIBuilder().getRow(elAdp.getKey());
        if (row != null) {
            KDTable table = (KDTable)this.getUIBuilder().getControl(((Field)elAdp.getElement()).getEntityKey());
            String caption = this.getAppearCaption(elAdp);
            table.getRow(row.getRowIndex()).getCell(0).setValue((Object)caption);
            table.getRow(row.getRowIndex()).setUserObject((Object)elAdp.getKey());
            return;
        }
    }

    private void updateKDExtLabel(KDExtLabel lbl, ElementPropertyAdpter elAdp) {
        lbl.setText(elAdp.getCaption());
        ControlAppearance ap = (ControlAppearance)elAdp.getAppearance();
        if (ap.getStyle() == 1) {
            lbl.setFrameLine(true);
        } else {
            lbl.setFrameLine(false);
        }
        if (ap.getTextAlign() == 2) {
            lbl.setHorizontalAlignment(0);
        } else if (ap.getTextAlign() == 3) {
            lbl.setHorizontalAlignment(4);
        } else {
            lbl.setHorizontalAlignment(2);
        }
    }

    private String getAppearCaption(ElementPropertyAdpter elAdp) {
        Locale l = SysContext.getSysContext().getLocale();
        String caption = null;
        try {
            caption = (String)elAdp.getPropertyValue("Caption_" + l.toString().toUpperCase());
        }
        catch (SecurityException e) {
            logger.error((Object)e);
        }
        catch (IllegalArgumentException e) {
            logger.error((Object)e);
        }
        catch (NoSuchMethodException e) {
            logger.error((Object)e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)e);
        }
        catch (InvocationTargetException e) {
            logger.error((Object)e);
        }
        return caption;
    }

    protected void updateKDLabelContainer(KDLabelContainer comp, ElementPropertyAdpter elAdp) {
        comp.setBoundLabelText(elAdp.getCaption());
        FieldAppearance ap = (FieldAppearance)elAdp.getAppearance();
        comp.setBoundLabelLength(ap.getLabelWidth());
        KDExtLabel lbl = (KDExtLabel)comp.getBoundLabel();
        if (ap.getStyle() == 6) {
            lbl.setFrameLine(true);
            comp.putClientProperty((Object)"autoHeight", (Object)new Boolean(false));
        } else {
            if (ap.getElementType() == 6) {
                comp.putClientProperty((Object)"autoHeight", (Object)new Boolean(false));
            } else {
                comp.putClientProperty((Object)"autoHeight", (Object)new Boolean(true));
                ap.setHeight(21);
                comp.setBounds(ap.getBounds());
            }
            lbl.setFrameLine(false);
        }
        if (ap.getTextAlign() == 2) {
            lbl.setHorizontalAlignment(0);
        } else if (ap.getTextAlign() == 3) {
            lbl.setHorizontalAlignment(4);
        } else {
            lbl.setHorizontalAlignment(2);
        }
        Field fld = (Field)elAdp.getElement();
        if (fld != null && fld.getPropertyName() != null && fld.getPropertyName().trim().length() > 0 && fld.getBosType() != null && fld.getBosType().trim().length() > 0) {
            lbl.setIcon((Icon)new ImageIcon(EASResource.getImage((String)"imgTbtn_entity")));
        } else {
            lbl.setIcon(null);
        }
    }

    protected void updateKDContainer(KDContainer comp, ElementPropertyAdpter elAdp) {
        comp.setTitle(elAdp.getCaption());
    }

    public void selectEntryField(ElementPropertyAdpter elAdp) {
        this.propertyView.selectObject(elAdp);
        this.selectViewObject(elAdp);
    }

    @Override
    public ToolBarOperation getToolBarOperation() {
        if (this.getDesigner() == null) {
            return null;
        }
        return this.getDesigner().getToolbar();
    }

    public void ComponentTabIndexChanged(Component sender, ComponentTabIndexChangedArgs e) {
        ElementPropertyAdpter el = this.model.getElementProperty(sender.getName());
        el.getAppearance().setTabindex(e.getNewIndex());
    }
}

