/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.ide.designer;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellEvent;
import com.kingdee.eas.base.form.designer.Designer;
import com.kingdee.eas.base.form.designer.command.ICommand;
import com.kingdee.eas.base.form.designer.entityrelation.Column;
import com.kingdee.eas.base.form.designer.entityrelation.ERDesigner;
import com.kingdee.eas.base.form.designer.entityrelation.EntityTable;
import com.kingdee.eas.base.form.designer.listenner.ComponentPositionChangedArgs;
import com.kingdee.eas.base.form.designer.listenner.IDesignerListener;
import com.kingdee.eas.base.form.designer.listenner.PrepareCreateItemOnGridArgs;
import com.kingdee.eas.base.form.designer.listenner.QueryAddedArgs;
import com.kingdee.eas.base.form.ide.designer.AddEntityColumnCommand;
import com.kingdee.eas.base.form.ide.designer.DynamicFormDesigner;
import com.kingdee.eas.base.form.ide.designer.smarttag.EntityTabelMenu;
import com.kingdee.eas.base.form.ide.model.ElementPropertyAdpter;
import com.kingdee.eas.base.form.ide.model.MetaDataDesinerModel;
import com.kingdee.eas.base.form.ide.model.ObjectProperty;
import com.kingdee.eas.base.form.ide.view.EntityView;
import com.kingdee.eas.base.form.ide.view.IPropertyView;
import com.kingdee.eas.base.form.ide.view.IToolBoxView;
import com.kingdee.eas.base.form.ide.view.SolutionView;
import com.kingdee.eas.base.form.metadata.BusinessInfo;
import com.kingdee.eas.base.form.metadata.ElementType;
import com.kingdee.eas.base.form.metadata.Entity;
import com.kingdee.eas.base.form.metadata.Field;
import com.kingdee.eas.base.form.metadata.LayoutInfo;
import com.kingdee.eas.common.client.SysContext;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class EntityDesigner
extends DynamicFormDesigner {
    private EntityView entityView;
    private ERDesigner erDesigner;

    public EntityDesigner(MetaDataDesinerModel model, IPropertyView propertyView, IToolBoxView toolBoxView, EntityView entityView, SolutionView solutionView) {
        super(model, propertyView, toolBoxView, solutionView);
        this.entityView = entityView;
    }

    @Override
    public String getKey() {
        return "Entity" + this.model.getFormID();
    }

    @Override
    protected void updateView(ElementPropertyAdpter elAdp) {
    }

    @Override
    public void filterProperty(ObjectProperty prop) {
        if (prop.getElementProperty().getBindingFlags() == 1) {
            prop.setVisible(false);
        }
        if (prop.getElementProperty().getPropertyName().equalsIgnoreCase("FieldName") && prop.getPropertyAdpter().getElement().isCustom()) {
            prop.setEditable(true);
        }
    }

    @Override
    public void selectionChanged(Designer sender) {
        this.propertyView.commitCurrentPropEditing();
        this.getToolBarOperation().getCommandList().setToolbarLocateAction(sender.getSelection().getCount());
        int selectCount = sender.getSelection().getCount();
        if (selectCount == 0) {
            ElementPropertyAdpter elAdpter = this.model.getElementProperty("_Bill");
            this.propertyView.selectObject(elAdpter);
            this.designPanel.setSelected(true);
        } else if (selectCount >= 1) {
            this.designPanel.setSelected(false);
            String key = sender.getSelection().getPrimaryControl().getName();
            if (key == null) {
                return;
            }
            ElementPropertyAdpter elAdpter = this.model.getElementProperty(key);
            this.createMuitleObjProperty(sender.getSelection().getSelectedControls());
            if (selectCount > 1) {
                this.propertyView.initObjectList(null);
            } else {
                this.refreshObjectList();
            }
            this.propertyView.selectObject(elAdpter);
        }
    }

    @Override
    public void registeSmartMenu() {
        super.registeSmartMenu();
        this.smartMenu.put(EntityTable.class, EntityTabelMenu.class);
    }

    @Override
    protected void initDesignerContent(LayoutInfo layout, BusinessInfo businessInfo) {
        this.erDesigner = new ERDesigner();
        this.designForm.setContentPane((Container)this.erDesigner.getDesignerPanel());
        this.designForm.getContentPane().setBackground(Color.WHITE);
        this.designForm.getContentPane().setOpaque(true);
        this.erDesigner.addDesignerListener((IDesignerListener)this);
        this.designerMap.put(this.designForm.getContentPane(), this.erDesigner);
    }

    private void refreshEntity() {
        this.erDesigner = new ERDesigner();
        BusinessInfo businessInfo = this.formMetaData.getBusinessInfo();
        List entitys = businessInfo.getEntrys();
        Entity entity = businessInfo.getEntity(0);
        EntityTable mastTable = this.erDesigner.addEntityTable(entity.getTableName(), entity.getKey(), entity.getTableName(), new Rectangle(10, 10, 200, 400));
        Column col = new Column();
        col.setKey("PK");
        col.setName(entity.getPkFieldName());
        col.setAliasName("\u5355\u636e\u5185\u7801");
        mastTable.getPKs().add(col);
        this.createColumns(mastTable, entity);
        int left = 230;
        for (int i = 1; i < entitys.size(); ++i) {
            entity = (Entity)entitys.get(i);
            EntityTable childTable = this.erDesigner.addEntityTable(entity.getTableName(), entity.getKey(), entity.getTableName(), new Rectangle(left, 10, 200, 400));
            col = new Column();
            col.setKey("PK");
            col.setName(entity.getPkFieldName());
            col.setAliasName("\u5355\u636e\u5185\u7801");
            childTable.getPKs().add(col);
            col = new Column();
            col.setKey("EntryPK");
            col.setName(entity.getEntryPkFieldName());
            col.setAliasName("\u5206\u5f55\u5185\u7801");
            childTable.getPKs().add(col);
            this.createColumns(childTable, entity);
            this.erDesigner.addArrow(mastTable, 0, childTable, 0);
            left += 230;
        }
        this.designForm.setContentPane((Container)this.erDesigner.getDesignerPanel());
        this.designForm.getContentPane().setBackground(Color.WHITE);
        this.designForm.getContentPane().setOpaque(true);
        this.erDesigner.addDesignerListener((IDesignerListener)this);
        this.designerMap.put(this.designForm.getContentPane(), this.erDesigner);
    }

    @Override
    public void refreshObjectList() {
        this.propertyView.initObjectList(this.model.getEntityElements());
    }

    @Override
    public void active() {
        super.active();
        this.entityView.refreshEntity(this.getKey(), this.model.getBusinessInfo(), this.model.getLayoutInfo());
        this.refreshEntity();
    }

    @Override
    protected void selectViewObject(ElementPropertyAdpter elAdp) {
    }

    private void createColumns(EntityTable entityTable, Entity entity) {
        Vector list = entity.getFields();
        for (int i = 0; i < list.size(); ++i) {
            Field fld = (Field)list.get(i);
            if (fld.getElementType() == 14) continue;
            this.createColumn(entityTable, fld);
        }
        this.bindEntryEvents(entityTable.getTable(), true);
    }

    public Column createColumn(EntityTable entityTable, Field fld) {
        Column col = new Column();
        col.setKey(fld.getKey());
        col.setName(fld.getKey());
        col.setAliasName(fld.getName(SysContext.getSysContext().getLocale()));
        entityTable.getColumns().add(col);
        return col;
    }

    @Override
    public void bindEntryEvents() {
    }

    @Override
    public void activeCellChanged(KDTActiveCellEvent e) {
        KDTable table = (KDTable)e.getSource();
        ElementPropertyAdpter elAdp = null;
        int rowIndex = e.getRowIndex();
        if (rowIndex < 0) {
            return;
        }
        Object o = table.getRow(rowIndex).getUserObject();
        if (o != null) {
            String key = o.toString();
            elAdp = this.model.getElementProperty(key);
            this.propertyView.selectObject(elAdp);
        }
    }

    @Override
    public void componentPositionChanged(Component sender, ComponentPositionChangedArgs e) {
    }

    @Override
    public void queryCanAdded(Designer sender, QueryAddedArgs e) {
        if (!(e.getCreateData() instanceof ElementType)) {
            e.setAllowAdded(false);
            return;
        }
        if (((ElementType)e.getCreateData()).getType() != 4) {
            e.setAllowAdded(false);
            return;
        }
        if (e.getParent() instanceof EntityTable) {
            e.setAllowAdded(true);
        } else {
            e.setAllowAdded(false);
        }
    }

    @Override
    public void prepareCreateItemOnGrid(Designer sender, PrepareCreateItemOnGridArgs e) {
        ElementType elementType = (ElementType)e.getCreateData();
        if (elementType.getType() == 4) {
            AddEntityColumnCommand cmd = new AddEntityColumnCommand((EntityTable)e.getGrid().getParent(), elementType, this.model, this);
            try {
                cmd.execute();
            }
            catch (BOSException e1) {
                e1.printStackTrace();
            }
            sender.addCommand((ICommand)cmd);
        }
    }

    @Override
    public List getElementGroupIDList() {
        ArrayList<Integer> groupIdList = new ArrayList<Integer>();
        groupIdList.add(new Integer(1));
        return groupIdList;
    }

    @Override
    public void afterSave() throws Exception {
    }
}

