/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.ide.designer;

import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.eas.base.form.designer.ToolBarOperation;
import com.kingdee.eas.base.form.ide.ExtToolbarManager;
import com.kingdee.eas.base.form.ide.designer.BillDesigner;
import com.kingdee.eas.base.form.ide.designer.CombinUIDesigner;
import com.kingdee.eas.base.form.ide.designer.DynamicFormDesigner;
import com.kingdee.eas.base.form.ide.designer.EntityDesigner;
import com.kingdee.eas.base.form.ide.designer.FilterDesigner;
import com.kingdee.eas.base.form.ide.model.MetaDataDesinerModel;
import com.kingdee.eas.base.form.ide.view.DesignerView;
import com.kingdee.eas.base.form.ide.view.EntityView;
import com.kingdee.eas.base.form.ide.view.IDesignerContent;
import com.kingdee.eas.base.form.ide.view.IPropertyView;
import com.kingdee.eas.base.form.ide.view.IToolBoxView;
import com.kingdee.eas.base.form.ide.view.SolutionView;
import com.kingdee.eas.base.form.metadata.LayoutInfo;
import java.awt.Component;
import java.util.List;
import java.util.Map;
import java.util.Observable;

public class SubDesignerView
extends DesignerView
implements IDesignerContent {
    private static final long serialVersionUID = 1L;
    protected MetaDataDesinerModel designerModel;
    protected IDesignerContent entityDesigner;

    public SubDesignerView(MetaDataDesinerModel model, IPropertyView propertyView, IToolBoxView toolBoxView, Map dataMap, ExtToolbarManager toolbarManager, EntityView entityView, SolutionView solutionView) throws Exception {
        this.propertyView = propertyView;
        this.toolBoxView = toolBoxView;
        this.designerModel = model;
        this.toolbarManager = toolbarManager;
        this.entityView = entityView;
        this.solutionView = solutionView;
        this.showPanel(dataMap);
    }

    @Override
    public void update(Observable o, Object arg) {
        if (this.currentContent == this.entityDesigner) {
            return;
        }
        Map dataMap = (Map)arg;
        String key = (String)dataMap.get("EntityDesignerKey");
        if (this.cacheContentMap.containsKey(key)) {
            IDesignerContent comp;
            this.currentContent = comp = (IDesignerContent)this.cacheContentMap.get(key);
            this.tab.setSelectedComponent(comp.getDesignerComponent());
        } else {
            this.entityDesigner = new EntityDesigner(this.designerModel, this.propertyView, this.toolBoxView, this.entityView, this.solutionView);
            this.showDesignContent(this.entityDesigner);
            this.currentContent = this.entityDesigner;
        }
    }

    public void showPanel(Map dataMap) throws Exception {
        int createType;
        String layoutKey = (String)dataMap.get("layout_key");
        int n = createType = dataMap.get("operation_type") == null ? 0 : (Integer)dataMap.get("operation_type");
        if (createType == 2) {
            this.showLayout(dataMap);
        } else if (this.cacheContentMap.containsKey(layoutKey)) {
            IDesignerContent comp;
            this.currentContent = comp = (IDesignerContent)this.cacheContentMap.get(layoutKey);
            this.tab.setSelectedComponent(comp.getDesignerComponent());
        } else {
            this.showLayout(dataMap);
        }
    }

    private void showLayout(Map dataMap) throws Exception {
        DynamicFormDesigner d = null;
        this.designerModel = new MetaDataDesinerModel(this.designerModel.getFormMetaData(), this.designerModel.getElementTypes(), dataMap);
        switch (this.designerModel.getElementTypeId()) {
            case 100: {
                d = new BillDesigner(this.designerModel, this.propertyView, this.toolBoxView, this.entityView, this.solutionView);
                break;
            }
            case 210: {
                d = new CombinUIDesigner(this.designerModel, this.propertyView, this.toolBoxView, this.solutionView);
                break;
            }
            case 200: {
                d = new FilterDesigner(this.designerModel, this.propertyView, this.toolBoxView, this.toolbarManager, this.solutionView);
            }
        }
        this.designerModel.dealCreateData(dataMap);
        if (dataMap.containsKey("CREATEDATA") && d != null) {
            d.initDesigner();
            d.bindEntryEvents();
        }
        this.currentContent = d;
        this.showDesignContent(d);
    }

    public void showAllPanel() throws Exception {
        DynamicFormDesigner d = null;
        if (this.designerModel.getFormMetaData().getLayoutInfos().size() > 0) {
            for (int i = 0; i < this.designerModel.getFormMetaData().getLayoutInfos().size(); ++i) {
                String layoutKey = ((LayoutInfo)this.designerModel.getFormMetaData().getLayoutInfos().get(i)).getKey();
                this.designerModel = new MetaDataDesinerModel(this.designerModel.getFormMetaData(), this.designerModel.getElementTypes(), layoutKey);
                switch (this.designerModel.getElementTypeId()) {
                    case 100: {
                        d = new BillDesigner(this.designerModel, this.propertyView, this.toolBoxView, this.entityView, this.solutionView);
                        break;
                    }
                    case 210: {
                        d = new CombinUIDesigner(this.designerModel, this.propertyView, this.toolBoxView, this.solutionView);
                        break;
                    }
                    case 200: {
                        d = new FilterDesigner(this.designerModel, this.propertyView, this.toolBoxView, this.toolbarManager, this.solutionView);
                    }
                }
                this.currentContent = d;
                this.showDesignContent(d);
                this.updateUI();
            }
        }
    }

    @Override
    protected void setTab() {
        this.tab.setTabPlacement(3);
    }

    @Override
    public void active() {
        this.currentContent.active();
        this.entityView.addObserver(this);
    }

    @Override
    public void deActive() {
        this.currentContent.deActive();
        String bosType = this.designerModel.getBusinessInfo().getForm().getBosType();
        this.entityView.refreshEntity(bosType);
        this.entityView.removeObserver(this);
    }

    @Override
    public Component getDesignerComponent() {
        return this;
    }

    @Override
    public List getElementGroupIDList() {
        return this.currentContent.getElementGroupIDList();
    }

    @Override
    public String getKey() {
        String formId = this.designerModel.getFormMetaData().getFormId();
        String tmpKey = this.designerModel.getTmpKey();
        if (formId == null || formId.trim().length() == 0) {
            return tmpKey;
        }
        return formId;
    }

    @Override
    public String getTitle() {
        return this.designerModel.getTitle();
    }

    @Override
    public boolean queryUnLoad() {
        return true;
    }

    @Override
    public void save() throws Exception {
        IDesignerContent d = this.currentContent;
        if (d != null) {
            d.save();
            this.resetContentMapKey();
        }
        for (Object key : this.cacheContentMap.keySet()) {
            IDesignerContent content = (IDesignerContent)this.cacheContentMap.get(key);
            content.afterSave();
        }
        this.solutionView.refreshTree();
        this.entityView.refreshEntity();
    }

    protected void resetContentMapKey() {
        KDTabbedPane tabPane = (KDTabbedPane)this.getParent();
        DesignerView parentView = (DesignerView)((Object)tabPane.getParent());
        Map parentContentMap = parentView.getCacheContentMap();
        if (parentContentMap != null) {
            for (Object key : parentContentMap.keySet()) {
                IDesignerContent content = (IDesignerContent)parentContentMap.get(key);
                if (content.getKey().equals(key)) continue;
                parentContentMap.remove(key);
                parentContentMap.put(content.getKey(), content);
                break;
            }
        }
    }

    @Override
    public void closeCurrentPanel() {
        super.closeCurrentPanel();
        KDTabbedPane tabPane = (KDTabbedPane)this.getParent();
        DesignerView parentView = (DesignerView)((Object)tabPane.getParent());
        if (this.tab.getTabCount() <= 0) {
            parentView.closePanel(this.designerModel.getFormID(), null);
        }
    }

    @Override
    public void closePanel(String formkey, String layoutKey) {
        super.closePanel(formkey, layoutKey);
        KDTabbedPane tabPane = (KDTabbedPane)this.getParent();
        DesignerView parentView = (DesignerView)((Object)tabPane.getParent());
        if (this.tab.getTabCount() <= 0) {
            parentView.closePanel(formkey, layoutKey);
        }
    }

    @Override
    public void closeAllTabs() {
        super.closeAllTabs();
        KDTabbedPane tabPane = (KDTabbedPane)this.getParent();
        DesignerView parentView = (DesignerView)((Object)tabPane.getParent());
        if (this.tab.getTabCount() <= 0) {
            String id = parentView.getContent().getKey();
            parentView.closePanel(id, null);
        }
    }

    public void removeLayout(String layoutKey) {
        this.designerModel.getFormMetaData().removeLayoutInfo(layoutKey);
    }

    public void closeLayoutPanel(String key) {
    }

    @Override
    public MetaDataDesinerModel getModel() {
        return this.currentContent.getModel();
    }

    @Override
    public void doOperation(String commandStr) {
        this.currentContent.doOperation(commandStr);
    }

    @Override
    public ToolBarOperation getToolBarOperation() {
        return this.currentContent.getToolBarOperation();
    }

    @Override
    public void afterSave() throws Exception {
        this.currentContent.afterSave();
    }

    @Override
    public void initDesigner() {
        this.currentContent.initDesigner();
    }

    @Override
    public void bindEntryEvents() {
        this.currentContent.bindEntryEvents();
    }
}

