/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.ide.designer.action;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.service.formula.api.FormulaGrammarVerifier;
import com.kingdee.bos.service.formula.api.FormulaVarInfoParser;
import com.kingdee.bos.service.formula.api.IVarInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.form.core.MetaDataFactory;
import com.kingdee.eas.base.form.ide.designer.action.IActionDesign;
import com.kingdee.eas.base.form.ide.designer.action.formula.builder.FormulaBuilderPanelBean;
import com.kingdee.eas.base.form.ide.designer.action.formula.builder.TableVarInfo;
import com.kingdee.eas.base.form.ide.model.MetaDataDesinerModel;
import com.kingdee.eas.base.form.json.JSONArray;
import com.kingdee.eas.base.form.metadata.AbstractElement;
import com.kingdee.eas.base.form.metadata.Action;
import com.kingdee.eas.base.form.metadata.BusinessInfo;
import com.kingdee.eas.base.form.metadata.Entity;
import com.kingdee.eas.base.form.metadata.Field;
import com.kingdee.eas.base.form.metadata.FieldAppearance;
import com.kingdee.eas.base.form.metadata.Form;
import com.kingdee.eas.base.form.metadata.FormFunction;
import com.kingdee.eas.base.form.metadata.LayoutInfo;
import com.kingdee.eas.dynbusiness.util.BusinessProcessUtil;
import com.kingdee.eas.dynbusiness.util.ExpressionParser;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class FormulaDesignerUI
extends CoreUI
implements IActionDesign {
    private FormulaBuilderPanelBean panel;
    private String actionType;
    private Action action;
    private MetaDataDesinerModel metaData;
    private AbstractElement el;
    private Field sourceField = null;
    private ExpressionParser expParser = null;
    private boolean isNewStatus = false;
    private KDPanel kDPanel_ToUpdate;
    private KDLabelContainer lblToUpdate;
    private KDComboBox cbToUpdate;

    @Override
    public void load() throws Exception {
        this.initLayout();
        if (this.metaData == null) {
            MsgBox.showWarning((Component)((Object)this), (String)"\u8bf7\u8bbe\u7f6e\u5355\u636e\u64cd\u4f5c\u5217\u8868\uff01");
            SysUtil.abort();
        }
        this.panel.setMetaData(this.metaData);
        this.isNewStatus = this.action.getParameters().length == 0;
        this.expParser = ExpressionParser.getInstance();
        this.initToUpdate();
        this.initFormulaMetaDataObjs();
        this.initData();
    }

    private void initToUpdate() {
        BusinessInfo businessInfo = this.metaData.getBusinessInfo();
        LayoutInfo layoutInfo = this.metaData.getLayoutInfo();
        for (Entity entity : businessInfo.getEntrys()) {
            for (Field field : entity.getFields()) {
                FieldAppearance fieldAppearance = layoutInfo.getFieldAppearance(field.getKey());
                if (fieldAppearance.getElementType() == 14) continue;
                this.cbToUpdate.addItem((Object)new UserData(field.getKey(), field.getPropertyName(), fieldAppearance.getCaption() + "(" + field.getKey() + ")", field));
            }
        }
    }

    private void initLocalVar() {
        try {
            List formFuncList = MetaDataFactory.getFormFunction(null);
            ArrayList<TableVarInfo> varInfos = new ArrayList<TableVarInfo>();
            for (int i = 0; i < formFuncList.size(); ++i) {
                FormFunction function = (FormFunction)formFuncList.get(i);
                TableVarInfo var = new TableVarInfo(function.getName(), this.transVarDesc(function.getDesc()), function.getDateType(), this.getFunctionSetName(function), "local", function.getDesc(), 3);
                varInfos.add(var);
            }
            this.panel.addVarInfos(varInfos);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    private String transVarDesc(String desc) {
        String newDesc = desc;
        if (newDesc.indexOf("(") >= 0) {
            newDesc = newDesc.replaceAll("\\(", "\uff08");
        }
        if (newDesc.indexOf(")") >= 0) {
            newDesc = newDesc.replaceAll("\\)", "\uff09");
        }
        return newDesc;
    }

    private String getFunctionSetName(FormFunction function) {
        String funcName = function.getName();
        String[] params = function.getParams();
        String functionStr = "";
        if (params != null && params.length > 1) {
            functionStr = funcName + "(";
            for (int i = 0; i < params.length; ++i) {
                functionStr = functionStr + params[i] + ",";
            }
            functionStr = functionStr.substring(0, functionStr.length() - 1) + ")";
        } else {
            functionStr = funcName + "()";
        }
        functionStr = "\"" + functionStr + "\"";
        return functionStr;
    }

    private void initFormulaMetaDataObjs() {
        String bosType = this.metaData.getBusinessInfo().getForm().getBosType();
        EntityObjectInfo mainEntity = BusinessProcessUtil.getEntityInfo(null, (BOSObjectType)BOSObjectType.create((String)bosType));
        if (mainEntity == null) {
            return;
        }
        BusinessObjectInfo[] boi = new BusinessObjectInfo[]{mainEntity};
        this.panel.setDisplayObjMethods(false);
        this.panel.setMetaDataObjs(boi);
    }

    private void initData() {
        String[] param = this.action.getParameters();
        if (param == null || param.length < 1) {
            return;
        }
        if (param.length != 1) {
            MsgBox.showWarning((Component)((Object)this), (String)"\u53c2\u6570\u6570\u76ee\u9519\u8bef\uff01");
            return;
        }
        String toUpdate = this.parseParam(param[0])[0];
        for (int i = 0; i < this.cbToUpdate.getItemCount(); ++i) {
            UserData item = (UserData)this.cbToUpdate.getItemAt(i);
            if (item == null || !item.getKey().equalsIgnoreCase(toUpdate)) continue;
            this.cbToUpdate.setSelectedItem((Object)item);
        }
        String formula = this.action.getParamExtendData();
        this.panel.setFormulaStr(formula);
    }

    private String[] parseParam(String param) {
        String[] ret = new String[2];
        int pos = param.indexOf("=");
        if (pos > 0) {
            ret = param.split("=", 2);
        } else {
            ret[0] = param;
            ret[1] = param;
        }
        return ret;
    }

    public void initUIContentLayout() {
        this.setBounds(new Rectangle(0, 0, 772, 400));
        this.setLayout((LayoutManager)new KDLayout());
        this.putClientProperty("OriginalBounds", new Rectangle(0, 0, 772, 400));
        this.cbToUpdate = new KDComboBox();
        this.lblToUpdate = new KDLabelContainer();
        this.lblToUpdate.setBoundLabelText("\u9009\u62e9\u8981\u66f4\u65b0\u7684\u5b57\u6bb5\uff1a");
        this.lblToUpdate.setBoundLabelLength(130);
        this.lblToUpdate.setBounds(new Rectangle(8, 0, 446, 19));
        this.lblToUpdate.setBoundEditor((JComponent)this.cbToUpdate);
        this.panel = new FormulaBuilderPanelBean(false, false);
        this.panel.setAlwaysRefOldVar(true);
        KDPanel dialogPanel = new KDPanel();
        dialogPanel.setLayout((LayoutManager)new KDLayout());
        dialogPanel.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, 772, 400));
        dialogPanel.add((Component)this.lblToUpdate, (Object)new KDLayout.Constraints(8, 0, 446, 19, 5));
        dialogPanel.add((Component)((Object)this.panel), (Object)new KDLayout.Constraints(10, 25, 772, 360, 15));
        this.add((Component)dialogPanel, new KDLayout.Constraints(0, 0, 772, 400, 0));
    }

    protected void dialogInit() {
    }

    public void show() {
        super.show();
    }

    public String getFormula() {
        return this.panel.getFormulaStr();
    }

    public String getFormulaAlias() {
        return this.panel.getFormulaAliasStr();
    }

    public String getFormulaAliasNoResultStr() {
        return this.getMsgInfoAlias(this.panel.getFormulaAliasStr());
    }

    public IVarInfo[] getVarInfos(String script) {
        return new FormulaVarInfoParser().getFormulaVars(script);
    }

    public void setFormula(String formula) {
        this.panel.setFormulaStr(formula);
    }

    public void setMetaDataObjs(BusinessObjectInfo[] metaObjs) {
        IMetaDataLoader dataLoader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        this.panel.setMetaDataObjs(metaObjs, dataLoader);
    }

    protected KDTable getTable() {
        return (KDTable)this.panel.getVarTableComponents()[0];
    }

    protected JButton getAddButton() {
        return (JButton)this.panel.getVarTableComponents()[1];
    }

    protected JButton getDelButton() {
        return (JButton)this.panel.getVarTableComponents()[2];
    }

    private boolean hasReturn(String script) {
        FormulaGrammarVerifier verifier = new FormulaGrammarVerifier();
        if (!verifier.hasSetFormulaResult(script)) {
            MsgBox.showWarning((Component)((Object)this), (String)"\u8868\u8fbe\u5f0f\u5fc5\u987b\u8fd4\u56de\u201c\u516c\u5f0f\u7ed3\u679c\u201d!");
            return false;
        }
        return true;
    }

    private boolean checkExpression(String script) {
        FormulaGrammarVerifier verifier = new FormulaGrammarVerifier();
        boolean flag = verifier.isCompatibleWithBOSFormula(script);
        if (!flag) {
            MsgBox.showWarning((Component)((Object)this), (String)"\u516c\u5f0f\u4e0d\u5408\u6cd5,\u8bf7\u68c0\u67e5!");
            return false;
        }
        return flag;
    }

    private boolean checkSameVarAlias(IVarInfo[] varInfos) {
        if (varInfos != null) {
            int size = varInfos.length;
            HashSet<String> setAlias = new HashSet<String>();
            for (int i = 0; i < size; ++i) {
                String varAlias = varInfos[i].getVarAlias();
                if (setAlias.contains(varAlias)) {
                    MsgBox.showWarning((Component)((Object)this), (String)"\u53d8\u91cf\u522b\u540d\u4e0d\u80fd\u91cd\u590d!");
                    return true;
                }
                setAlias.add(varAlias);
            }
        }
        return false;
    }

    protected String getMsgInfoAlias(String alias) {
        String formulaResult = "\u516c\u5f0f\u7ed3\u679c =";
        int index = alias.indexOf(formulaResult);
        if (index == 0) {
            int length = formulaResult.length();
            alias = alias.substring(length);
        }
        return alias;
    }

    @Override
    public void commit() throws Exception {
        if (this.cbToUpdate.getSelectedIndex() < 0) {
            MsgBox.showError((Component)((Object)this), (String)"\u8bf7\u9009\u62e9\u8981\u66f4\u65b0\u7684\u5b57\u6bb5\uff01");
            SysUtil.abort();
        }
        String scriptEx = this.panel.getFormulaStr_Ex();
        String script = this.panel.getFormulaStr();
        IVarInfo[] varInfoList = this.getVarInfos(script);
        scriptEx = this.TransVar(scriptEx, varInfoList);
        if (this.checkExpression(script)) {
            UserData data = (UserData)this.cbToUpdate.getItemAt(this.cbToUpdate.getSelectedIndex());
            String paramStr = data.getKey() + "=" + scriptEx;
            JSONArray array = new JSONArray();
            array.put((Object)paramStr);
            this.action.setParameters(array.toString());
            this.action.setParamExtendData(script);
        } else {
            SysUtil.abort();
        }
    }

    private String[] getReplaceInfo(String formula) {
        String[] ret = new String[]{"Func" + String.valueOf(Math.abs(new SecureRandom().nextInt())), formula};
        return ret;
    }

    private String TransVar(String FormulaEx, IVarInfo[] varInfoList) {
        String newFormula = FormulaEx;
        newFormula = newFormula.replaceAll("\"", "");
        return newFormula;
    }

    private String TransFormula(String FormulaEx, String Formula) {
        String fm = Formula;
        IVarInfo[] varInfos = this.getVarInfos(Formula);
        if (varInfos != null) {
            int size = varInfos.length;
            for (int i = 0; i < size; ++i) {
                String dataType;
                String varScope = varInfos[i].getVarScope();
                String varName = varInfos[i].getVarName();
                if (varScope.toLowerCase().equalsIgnoreCase("in") && (dataType = varInfos[i].getVarType()).startsWith("com.kingdee") && !dataType.endsWith("Info")) continue;
            }
        }
        return Formula;
    }

    @Override
    public Action getAction() {
        return this.action;
    }

    @Override
    public JPanel getDesignerPanel() {
        return this;
    }

    @Override
    public void setAction(Action action) {
        this.action = action;
    }

    @Override
    public void setActionType(String type) {
        this.actionType = this.actionType;
    }

    @Override
    public void setMetaData(MetaDataDesinerModel meteData) {
        this.metaData = meteData;
    }

    @Override
    public void setSourceElement(AbstractElement el) {
        this.el = el;
        if (el != null && el instanceof Field) {
            this.sourceField = (Field)el;
        } else if (el != null && el instanceof FieldAppearance) {
            FieldAppearance fieldAppearance = (FieldAppearance)el;
            this.sourceField = fieldAppearance.getField();
        } else if (el != null && el instanceof Form) {
            this.sourceField = null;
        }
    }

    @Override
    public void setExtendData(Map extendData) {
    }

    private class UserData {
        private String key = null;
        private String propertyName = null;
        private String displayName = null;
        private Field field = null;

        public UserData(String key, String propertyName, String displayName) {
            this.propertyName = propertyName;
            this.displayName = displayName;
            this.key = key;
        }

        public UserData(String key, String propertyName, String displayName, Field field) {
            this(key, propertyName, displayName);
            this.field = field;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String toString() {
            return this.displayName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public void setPropertyName(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public Field getField() {
            return this.field;
        }

        public void setField(Field field) {
            this.field = field;
        }
    }
}

