/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.ide.designer.action;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.form.core.MetaDataFactory;
import com.kingdee.eas.base.form.ide.DataObjectEx;
import com.kingdee.eas.base.form.ide.designer.action.AbstractTakeBaseDataDesignerUI;
import com.kingdee.eas.base.form.ide.designer.action.IActionDesign;
import com.kingdee.eas.base.form.ide.designer.action.TakeBaseDataEntityTreeDialog;
import com.kingdee.eas.base.form.ide.model.MetaDataDesinerModel;
import com.kingdee.eas.base.form.ide.utils.EntityObjectInfoHelp;
import com.kingdee.eas.base.form.metadata.AbstractElement;
import com.kingdee.eas.base.form.metadata.Action;
import com.kingdee.eas.base.form.metadata.BusinessInfo;
import com.kingdee.eas.base.form.metadata.Entity;
import com.kingdee.eas.base.form.metadata.Field;
import com.kingdee.eas.base.form.metadata.FieldAppearance;
import com.kingdee.eas.base.form.metadata.Form;
import com.kingdee.eas.base.form.metadata.LayoutInfo;
import com.kingdee.eas.base.form.metadata.LookUpObject;
import com.kingdee.eas.base.form.util.DataMappingUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ComponentUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class TakeBaseDataDesignerUI
extends AbstractTakeBaseDataDesignerUI
implements IActionDesign {
    private static final Logger logger = CoreUIObject.getLogger(TakeBaseDataDesignerUI.class);
    private String actionType;
    private Action action;
    private MetaDataDesinerModel metaData;
    private AbstractElement el;
    private Field sourceField = null;
    private static final int TableColumn_Target = 0;
    private static final int TableColumn_Source = 1;
    private boolean isNewStatus = false;
    private ArrayList DataObjectList;

    public void onLoad() throws Exception {
        super.onLoad();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void btnDelete_actionPerformed(ActionEvent e) throws Exception {
        super.btnDelete_actionPerformed(e);
        if (this.kDTable.getSelectManager().getActiveRowIndex() < 0) {
            MsgBox.showError((Component)((Object)this), (String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u884c\uff01");
            SysUtil.abort();
        }
        IRow row = this.kDTable.getRow(this.kDTable.getSelectManager().getActiveRowIndex());
        if (this.action.getActionId() == 22) {
            UserData target = (UserData)row.getCell(0).getUserObject();
            UserData source = (UserData)row.getCell(1).getUserObject();
            if (target.getPropertyName() != null && target.getPropertyName().equalsIgnoreCase(source.getPropertyName())) {
                Field fld = target.getField();
                fld.setPropertyName("");
            }
        }
        this.kDTable.removeRow(this.kDTable.getSelectManager().getActiveRowIndex());
        this.displayHint();
    }

    @Override
    protected void btnAdd_actionPerformed(ActionEvent e) throws Exception {
        DataObjectEx data;
        super.btnAdd_actionPerformed(e);
        if (this.cbTarget.getSelectedIndex() == -1) {
            MsgBox.showError((Component)((Object)this), (String)"\u8bf7\u9009\u62e9\u76ee\u6807\u5b57\u6bb5\uff01");
            SysUtil.abort();
        }
        if ((data = (DataObjectEx)((Object)this.kDBizPromptBox_Source.getData())) == null) {
            MsgBox.showError((Component)((Object)this), (String)"\u8bf7\u9009\u62e9\u6e90\u5b57\u6bb5\uff01");
            SysUtil.abort();
        }
        IRow row = this.kDTable.addRow();
        UserData target = (UserData)this.cbTarget.getSelectedItem();
        UserData source = new UserData(data.getValue(), data.getValue(), data.getName(), data);
        row.getCell(0).setValue((Object)target.toString());
        row.getCell(0).setUserObject((Object)target);
        row.getCell(1).setValue((Object)source.toString());
        row.getCell(1).setUserObject((Object)source);
        this.displayHint();
    }

    @Override
    protected void cbTarget_itemStateChanged(ItemEvent e) throws Exception {
        super.cbTarget_itemStateChanged(e);
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    public void actionCalculator_actionPerformed(ActionEvent e) throws Exception {
        super.actionCalculator_actionPerformed(e);
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        super.actionExport_actionPerformed(e);
    }

    public void actionExportSelected_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelected_actionPerformed(e);
    }

    public void actionRegProduct_actionPerformed(ActionEvent e) throws Exception {
        super.actionRegProduct_actionPerformed(e);
    }

    public void actionPersonalSite_actionPerformed(ActionEvent e) throws Exception {
        super.actionPersonalSite_actionPerformed(e);
    }

    public void actionProcductVal_actionPerformed(ActionEvent e) throws Exception {
        super.actionProcductVal_actionPerformed(e);
    }

    @Override
    public void commit() throws Exception {
        HashMap<String, String> oldParamMap = new HashMap<String, String>();
        if (!this.isNewStatus) {
            String[] param = this.action.getParameters();
            for (int j = 0; param != null && j < param.length; ++j) {
                String[] pr = this.parseParam(param[j]);
                oldParamMap.put(pr[0], pr[1]);
            }
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        for (int i = 0; i < this.kDTable.getRowCount(); ++i) {
            IRow row = this.kDTable.getRow(i);
            UserData target = (UserData)row.getCell(0).getUserObject();
            UserData source = (UserData)row.getCell(1).getUserObject();
            if (this.action.getActionId() == 22) {
                if (paramMap.containsKey(target.getPropertyName())) {
                    MsgBox.showError((Component)((Object)this), (String)MessageFormat.format("\u76ee\u6807\u5b57\u6bb5\u201c{0}\u201d\u91cd\u590d\u6307\u5b9a,\u4e0d\u80fd\u4fdd\u5b58\uff01", target.getDisplayName()));
                    SysUtil.abort();
                }
                if (paramMap.containsKey(source.getPropertyName())) {
                    MsgBox.showError((Component)((Object)this), (String)MessageFormat.format("\u6e90\u5b57\u6bb5\u201c{0}\u201d\u91cd\u590d\u6307\u5b9a,\u4e0d\u80fd\u4fdd\u5b58\uff01", source.getDisplayName()));
                    SysUtil.abort();
                }
                Field fld = target.getField();
                String propName = source.getPropertyName();
                if (this.sourceField != null) {
                    propName = this.sourceField.getPropertyName() + "." + propName;
                }
                fld.setPropertyName(propName);
                int colType = DataMappingUtil.getColTypeFromDataType((DataType)source.getExtendData().getDataType());
                fld.setFieldColType(colType);
                String[] pr = this.parseParam(target.getKey());
                paramMap.put(pr[0], pr[1]);
            } else if (this.action.getActionId() == 1) {
                String src = source.getPropertyName();
                if (this.sourceField != null) {
                    src = this.sourceField.getKey() + "." + src;
                }
                paramMap.put(target.getKey(), src);
            }
            if (this.sourceField == null) continue;
            String refPropertyName = this.sourceField.getRefPropertyName();
            String propertyName = source.getPropertyName();
            if (source.getExtendData().isLinkProperty()) {
                propertyName = propertyName + ".id, " + propertyName + ".number, " + propertyName + ".name ";
            }
            if (refPropertyName == null || refPropertyName.trim().length() == 0) {
                refPropertyName = propertyName;
            } else if (refPropertyName.indexOf(propertyName) == -1) {
                refPropertyName = refPropertyName + "," + propertyName;
            }
            this.sourceField.setRefPropertyName(refPropertyName);
        }
        String paramStr = "";
        paramStr = "[";
        Iterator i = paramMap.keySet().iterator();
        for (String key : paramMap.keySet()) {
            String val = (String)paramMap.get(key);
            if (this.action.getActionId() == 22) {
                paramStr = paramStr + key + ",";
                continue;
            }
            if (this.action.getActionId() != 1) continue;
            paramStr = paramStr + key + "=" + val + ",";
        }
        paramStr = paramStr.length() <= 1 ? "" : paramStr.substring(0, paramStr.length() - 1) + "]";
        this.action.setParameters(paramStr);
        if (this.sourceField != null && (this.action.getObjectKey() == null || this.action.getObjectKey().length() == 0)) {
            this.action.setObjectKey(this.sourceField.getKey());
        }
    }

    private String[] parseParam(String param) {
        String[] ret = new String[2];
        int pos = param.indexOf("=");
        if (pos > 0) {
            ret = param.split("=", 2);
        } else {
            ret[0] = param;
            ret[1] = param;
        }
        return ret;
    }

    @Override
    public Action getAction() {
        return this.action;
    }

    @Override
    public JPanel getDesignerPanel() {
        return this;
    }

    @Override
    public void load() throws Exception {
        this.initLayout();
        if (this.metaData == null) {
            MsgBox.showWarning((Component)((Object)this), (String)"\u8bf7\u8bbe\u7f6e\u5355\u636e\u64cd\u4f5c\u5217\u8868\uff01");
            SysUtil.abort();
        }
        this.initTargetCombox();
        this.initSourceF7();
        this.initData();
        this.isNewStatus = this.action.getParameters().length == 0;
        this.displayHint();
    }

    private void initData() {
        String[] param = this.action.getParameters();
        if (param == null || param.length < 1) {
            return;
        }
        this.kDTable.checkParsed();
        this.kDTable.getSelectManager().setSelectMode(2);
        for (int j = 0; j < param.length; ++j) {
            String srcProperty;
            String[] pr = this.parseParam(param[j]);
            UserData target = this.getTargetUserData(pr[0]);
            UserData source = null;
            if (target == null) continue;
            if (this.action.getActionId() == 22) {
                srcProperty = target.getPropertyName();
                if (srcProperty.indexOf(".") > 0) {
                    srcProperty = srcProperty.substring(srcProperty.indexOf(".") + 1);
                }
                source = this.getSourceUserData(srcProperty);
            } else if (this.action.getActionId() == 1) {
                srcProperty = pr[1];
                if (srcProperty.indexOf(".") > 0) {
                    srcProperty = srcProperty.substring(srcProperty.indexOf(".") + 1);
                }
                source = this.getSourceUserData(srcProperty);
            }
            if (source == null) continue;
            IRow row = this.kDTable.addRow();
            row.getCell(0).setValue((Object)target.toString());
            row.getCell(0).setUserObject((Object)target);
            row.getCell(1).setValue((Object)source.toString());
            row.getCell(1).setUserObject((Object)source);
        }
    }

    private UserData getTargetUserData(String propertyName) {
        UserData data = null;
        for (int i = 0; i < this.cbTarget.getItemCount(); ++i) {
            UserData item = (UserData)this.cbTarget.getItemAt(i);
            if (this.action.getActionId() == 22 && propertyName.equalsIgnoreCase(item.getKey())) {
                data = (UserData)this.cbTarget.getItemAt(i);
                break;
            }
            if (this.action.getActionId() != 1 || !propertyName.equalsIgnoreCase(item.getKey())) continue;
            data = (UserData)this.cbTarget.getItemAt(i);
            break;
        }
        return data;
    }

    private UserData getSourceUserData(String propertyName) {
        UserData data = null;
        if (this.DataObjectList == null) {
            return null;
        }
        for (int i = 0; i < this.DataObjectList.size(); ++i) {
            DataObjectEx dataObject = (DataObjectEx)((Object)this.DataObjectList.get(i));
            if (dataObject.getValue() == null || !dataObject.getValue().equalsIgnoreCase(propertyName)) continue;
            data = new UserData(dataObject.getValue(), dataObject.getValue(), dataObject.getName(), dataObject);
            break;
        }
        return data;
    }

    private void initTargetCombox() {
        BusinessInfo businessInfo = this.metaData.getBusinessInfo();
        LayoutInfo layoutInfo = this.metaData.getLayoutInfo();
        for (Entity entity : businessInfo.getEntrys()) {
            for (Field field : entity.getFields()) {
                FieldAppearance fieldAppearance = layoutInfo.getFieldAppearance(field.getKey());
                if (this.action.getActionId() == 22 && fieldAppearance.getElementType() == 14 && this.sourceField != null && this.sourceField.getKey().equalsIgnoreCase(field.getControlFieldKey())) {
                    this.cbTarget.addItem((Object)new UserData(field.getKey(), field.getPropertyName(), fieldAppearance.getCaption() + "(" + field.getKey() + ")", field));
                    continue;
                }
                if (this.action.getActionId() != 1) continue;
                this.cbTarget.addItem((Object)new UserData(field.getKey(), field.getPropertyName(), fieldAppearance.getCaption() + "(" + field.getKey() + ")", field));
            }
        }
    }

    private void initSourceF7() {
        Window window = ComponentUtil.getOwnerWindow((Component)this.kDBizPromptBox_Source);
        EntityObjectInfo entityData = null;
        Object bos_type = this.getBosType();
        if (bos_type != null) {
            entityData = EntityObjectInfoHelp.getEntity(BOSObjectType.create((String)bos_type.toString()));
        }
        if (entityData == null) {
            this.kDBizPromptBox_Source.setEnabled(false);
            this.btnAdd.setEnabled(false);
            this.btnDelete.setEnabled(false);
            return;
        }
        Map filterClassType = this.initFilterClassType(14);
        TakeBaseDataEntityTreeDialog entityTreePromptDialog = null;
        entityTreePromptDialog = window instanceof Frame ? new TakeBaseDataEntityTreeDialog((Frame)window, entityData, filterClassType, false, -1) : (window instanceof Dialog ? new TakeBaseDataEntityTreeDialog((Dialog)window, entityData, filterClassType, false, -1, this.getSourceProperties()) : new TakeBaseDataEntityTreeDialog((Frame)null, entityData, filterClassType, false, -1));
        entityTreePromptDialog.setTitle("\u9009\u62e9\u5c5e\u6027");
        this.kDBizPromptBox_Source.setSelector((KDPromptSelector)entityTreePromptDialog);
        this.DataObjectList = entityTreePromptDialog.getDataList();
    }

    private int getMaxLevel() {
        String[] param = this.action.getParameters();
        if (param == null || param.length < 1) {
            return 1;
        }
        int maxLevel = 1;
        for (int j = 0; j < param.length; ++j) {
            String[] str;
            String[] pr = this.parseParam(param[j]);
            UserData target = null;
            String srcProperty = null;
            if (this.action.getActionId() == 22) {
                target = this.getTargetUserData(pr[0]);
                srcProperty = target.getPropertyName();
                if (srcProperty.indexOf(".") > 0) {
                    srcProperty = srcProperty.substring(srcProperty.indexOf(".") + 1);
                }
            } else if (this.action.getActionId() == 1) {
                srcProperty = pr[1];
            }
            if (srcProperty == null || (str = srcProperty.split("\\.")).length <= maxLevel) continue;
            maxLevel = str.length;
        }
        return maxLevel;
    }

    private String[] getSourceProperties() {
        String[] param = this.action.getParameters();
        if (param == null || param.length < 1) {
            return new String[0];
        }
        String[] ret = new String[param.length];
        for (int j = 0; j < param.length; ++j) {
            String[] pr = this.parseParam(param[j]);
            UserData target = null;
            String srcProperty = null;
            if (this.action.getActionId() == 22) {
                target = this.getTargetUserData(pr[0]);
                if (target != null && (srcProperty = target.getPropertyName()).indexOf(".") > 0) {
                    srcProperty = srcProperty.substring(srcProperty.indexOf(".") + 1);
                }
            } else if (this.action.getActionId() == 1 && (srcProperty = pr[1]).indexOf(".") > 0) {
                srcProperty = srcProperty.substring(srcProperty.indexOf(".") + 1);
            }
            if (srcProperty == null) continue;
            ret[j] = srcProperty;
        }
        return ret;
    }

    private Map initFilterClassType(int elementType) {
        HashMap map = new HashMap();
        switch (elementType) {
            case 1: 
            case 6: 
            case 12: 
            case 24: {
                map.clear();
                map.put("java.lang.String", null);
                break;
            }
            case 2: {
                map.clear();
                map.put("java.math.BigDecimal", null);
                break;
            }
            case 3: {
                map.clear();
                map.put("java.lang.Integer", null);
                break;
            }
            case 4: 
            case 5: {
                map.clear();
                map.put("java.util.Date", null);
                break;
            }
            case 7: 
            case 13: 
            case 30: 
            case 31: {
                map.clear();
                map.put("ONLY_SELECT_LINK", null);
                break;
            }
            case 14: {
                map.clear();
                map.put("SELECT_ALL", null);
                break;
            }
            case 8: {
                map.clear();
                map.put("java.lang.Boolean", null);
                break;
            }
            case 9: 
            case 29: {
                map.clear();
                map.put("java.lang.Integer", null);
                map.put("java.lang.String", null);
                break;
            }
        }
        return map;
    }

    @Override
    public void setAction(Action action) {
        this.action = action;
    }

    @Override
    public void setActionType(String type) {
        this.actionType = this.actionType;
    }

    @Override
    public void setMetaData(MetaDataDesinerModel meteData) {
        this.metaData = meteData;
    }

    @Override
    public void setSourceElement(AbstractElement el) {
        this.el = el;
        if (el != null && el instanceof Field) {
            this.sourceField = (Field)el;
        } else if (el != null && el instanceof FieldAppearance) {
            FieldAppearance fieldAppearance = (FieldAppearance)el;
            this.sourceField = fieldAppearance.getField();
        } else if (el != null && el instanceof Form) {
            this.sourceField = null;
        }
    }

    public Object getBosType() {
        Object bosType = null;
        if (this.sourceField == null || this.sourceField.getBosType() == null || this.sourceField.getBosType().toCharArray().length == 0) {
            return null;
        }
        try {
            PropertyInfo proper;
            EntityObjectInfo entity;
            int lookupid = this.sourceField.getLookUpObjectID();
            if (lookupid != -1) {
                LookUpObject lookobj = this.metaData.getBusinessInfo().getLookUpObject(lookupid);
                if (lookobj == null) {
                    lookobj = MetaDataFactory.getLoopUpObject(null, (int)lookupid);
                }
                if (lookobj != null) {
                    this.metaData.getBusinessInfo().getLookUpObjects().put(String.valueOf(lookupid), lookobj);
                    bosType = lookobj.getBosType();
                    return bosType;
                }
            }
            if ((entity = MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity(BOSObjectType.create((String)this.sourceField.getBosType().toString()))) != null && (proper = entity.getPropertyByName(this.sourceField.getPropertyName())) != null && proper instanceof LinkPropertyInfo) {
                bosType = ((LinkPropertyInfo)proper).getRelationship().getSupplierObject().get("bosType");
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return bosType;
    }

    private void displayHint() {
        String hintStr = "";
        if (this.action.getActionId() == 22) {
            hintStr = "TakeBaseData(";
        } else if (this.action.getActionId() == 1) {
            hintStr = "UpdateBaseProperty(";
        }
        for (int i = 0; i < this.kDTable.getRowCount(); ++i) {
            IRow row = this.kDTable.getRow(i);
            UserData target = (UserData)row.getCell(0).getUserObject();
            UserData source = (UserData)row.getCell(1).getUserObject();
            if (this.action.getActionId() == 22) {
                hintStr = hintStr + source.getPropertyName() + ",";
                continue;
            }
            if (this.action.getActionId() != 1) continue;
            hintStr = hintStr + target.getPropertyName() + "=" + source.getPropertyName() + ",";
        }
        hintStr = hintStr.endsWith(",") ? hintStr.substring(0, hintStr.length() - 1) + ")" : hintStr + ")";
        this.txtAction.setText(hintStr);
    }

    @Override
    protected void kDBizPromptBox1_dataChanged(DataChangeEvent e) throws Exception {
        super.kDBizPromptBox1_dataChanged(e);
    }

    @Override
    public void setExtendData(Map extendData) {
    }

    public class UserData {
        private String key = null;
        private String propertyName = null;
        private String displayName = null;
        private Field field = null;
        private DataObjectEx extendData = null;

        public UserData(String key, String propertyName, String displayName) {
            this.propertyName = propertyName;
            this.displayName = displayName;
            this.key = key;
        }

        public UserData(String key, String propertyName, String displayName, Field field) {
            this(key, propertyName, displayName);
            this.field = field;
        }

        public UserData(String key, String propertyName, String displayName, DataObjectEx extendData) {
            this.propertyName = propertyName;
            this.displayName = displayName;
            this.key = key;
            this.extendData = extendData;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String toString() {
            return this.displayName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public void setPropertyName(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public Field getField() {
            return this.field;
        }

        public void setField(Field field) {
            this.field = field;
        }

        public DataObjectEx getExtendData() {
            return this.extendData;
        }

        public void setExtendData(DataObjectEx extendData) {
            this.extendData = extendData;
        }
    }
}

