/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.ide.designer.action;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDContainer;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDMultiLangBox;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.filter.client.FilterPanel;
import com.kingdee.eas.base.filter.commonfiltermodel.FilterMetaData;
import com.kingdee.eas.base.filter.commonfiltermodel.FilterObject;
import com.kingdee.eas.base.form.ide.client.FormConditionHelper;
import com.kingdee.eas.base.form.ide.designer.action.IActionDesign;
import com.kingdee.eas.base.form.ide.model.MetaDataDesinerModel;
import com.kingdee.eas.base.form.json.JSONArray;
import com.kingdee.eas.base.form.metadata.AbstractElement;
import com.kingdee.eas.base.form.metadata.Action;
import com.kingdee.eas.base.form.metadata.BusinessInfo;
import com.kingdee.eas.base.form.metadata.Field;
import com.kingdee.eas.base.form.metadata.FieldAppearance;
import com.kingdee.eas.base.form.metadata.Form;
import com.kingdee.eas.base.form.metadata.LayoutInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.security.SecureRandom;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class VertifyDesignerUI
extends CoreUI
implements IActionDesign {
    private static final Logger logger = CoreUIObject.getLogger(VertifyDesignerUI.class);
    private KDContainer paneExpression = new KDContainer();
    private FilterPanel filterPanel;
    private FilterMetaData filterMetaData = new FilterMetaData();
    private FilterObject filterObject = new FilterObject();
    private KDContainer paneHint = new KDContainer();
    private KDMultiLangBox multiHint;
    private Locale _locale;
    private String actionType;
    private Action action;
    private MetaDataDesinerModel metaData;
    private AbstractElement el;
    private Field sourceField = null;

    public void initUIContentLayout() {
        this.setBounds(new Rectangle(10, 10, 630, 230));
        this.setLayout((LayoutManager)new KDLayout());
        this.putClientProperty("OriginalBounds", new Rectangle(10, 10, 630, 230));
        this.paneExpression.setTitle("\u5408\u6cd5\u6027\u6821\u9a8c\u8868\u8fbe\u5f0f");
        this.paneExpression.setPreferredSize(new Dimension(630, 160));
        this.paneExpression.getContentPane().setLayout(null);
        this.paneExpression.setBounds(new Rectangle(0, 0, 630, 160));
        this.add((Component)this.paneExpression, new KDLayout.Constraints(0, 0, 630, 160, 0));
        this.filterPanel = new FilterPanel();
        this.filterPanel.setSize(new Dimension(630, 150));
        Dimension di = this.filterPanel.getSize();
        this.filterPanel.setPreferredSize(di);
        this.paneExpression.getContentPane().add((Component)this.filterPanel, null);
        this.paneHint.setTitle("\u8868\u8fbe\u5f0f\u4e3a\u5047\u65f6\u63d0\u793a\u4fe1\u606f");
        this.paneHint.setPreferredSize(new Dimension(630, 60));
        this.paneHint.getContentPane().setLayout(null);
        this.paneHint.setBounds(new Rectangle(0, 165, 630, 60));
        this.add((Component)this.paneHint, new KDLayout.Constraints(0, 165, 630, 60, 0));
        this._locale = SysContext.getSysContext().getLocale();
        this.multiHint = this.newKDMultiLangBox(this._locale);
        this.multiHint.setBounds(5, 2, 620, 25);
        this.paneHint.getContentPane().add((Component)this.multiHint, null);
    }

    private KDMultiLangBox newKDMultiLangBox(Locale defaultLocale) {
        KDMultiLangBox mlb = new KDMultiLangBox();
        mlb.addItem(new LanguageInfo(LocaleUtils.getLocale((String)"l1")), (Object)"");
        mlb.addItem(new LanguageInfo(LocaleUtils.getLocale((String)"l2")), (Object)"");
        mlb.addItem(new LanguageInfo(LocaleUtils.getLocale((String)"l3")), (Object)"");
        mlb.setSelectedLanguage(new LanguageInfo(defaultLocale));
        return mlb;
    }

    @Override
    public void commit() throws Exception {
        String hint_locale;
        String hint_l3;
        String hint_l1;
        String hint_l2;
        String expression = null;
        try {
            expression = this.filterObject.getFilterString();
        }
        catch (BOSException e1) {
            MsgBox.showError((Component)((Object)this), (String)e1.getMessage());
            SysUtil.abort();
        }
        if (expression == null || expression.length() == 0) {
            MsgBox.showError((Component)((Object)this), (String)"\u8bf7\u9009\u62e9\u5355\u636e\u5408\u6cd5\u6027\u6821\u9a8c\u8868\u8fbe\u5f0f\uff01");
            SysUtil.abort();
        }
        if ((hint_l2 = (String)this.multiHint.getItemDataByLang(new LanguageInfo(LocaleUtils.getLocale((String)"l2")))) == null) {
            hint_l2 = "";
        }
        if ((hint_l1 = (String)this.multiHint.getItemDataByLang(new LanguageInfo(LocaleUtils.getLocale((String)"l1")))) == null) {
            hint_l1 = "";
        }
        if ((hint_l3 = (String)this.multiHint.getItemDataByLang(new LanguageInfo(LocaleUtils.getLocale((String)"l3")))) == null) {
            hint_l3 = "";
        }
        if ((hint_locale = (String)this.multiHint.getItemDataByLang(new LanguageInfo(this._locale))) == null || hint_locale.length() == 0) {
            MsgBox.showError((Component)((Object)this), (String)"\u8bf7\u8f93\u5165\u8868\u8fbe\u5f0f\u4e3a\u5047\u65f6\u63d0\u793a\u4fe1\u606f\uff01");
            SysUtil.abort();
        }
        String hint = "''L1'':''{0}'',''L2'':''{1}'',''L3'':''{2}''";
        hint = MessageFormat.format(hint, hint_l1, hint_l2, hint_l3);
        String setting = this.filterObject.getSetting();
        JSONArray array = new JSONArray();
        array.put((Object)expression);
        array.put((Object)("{" + hint + "}"));
        this.action.setParameters(array.toString());
        this.action.setParamExtendData(setting);
    }

    private String[] getReplaceInfo(String formula) {
        String[] ret = new String[]{"Func" + String.valueOf(Math.abs(new SecureRandom().nextInt())), formula};
        return ret;
    }

    @Override
    public Action getAction() {
        return this.action;
    }

    @Override
    public JPanel getDesignerPanel() {
        return this;
    }

    @Override
    public void load() throws Exception {
        this.initLayout();
        if (this.metaData == null) {
            MsgBox.showWarning((Component)((Object)this), (String)"\u8bf7\u8bbe\u7f6e\u5355\u636e\u64cd\u4f5c\u5217\u8868\uff01");
            SysUtil.abort();
        }
        this.initData();
    }

    private void initData() {
        try {
            Object[] objs = FormConditionHelper.initFilterPanelData((FilterMetaData)this.filterMetaData, (FilterObject)this.filterObject, (BusinessInfo)this.metaData.getBusinessInfo(), (LayoutInfo)this.metaData.getLayoutInfo());
            this.filterMetaData = (FilterMetaData)objs[0];
            this.filterObject = (FilterObject)objs[1];
            if (this.action != null && !StringUtils.isEmpty((String)this.action.getParamExtendData())) {
                this.filterObject.setSetting(this.action.getParamExtendData().trim());
            }
            String[] params = this.action.getParameters();
            String hint = null;
            if (params != null && params.length > 0 && params[0].length() > 0) {
                hint = params[1].substring(params[1].indexOf(",") + 2, params[1].length() - 2);
            }
            if (hint != null) {
                String[] lstr = hint.split(",");
                for (int i = 0; i < lstr.length; ++i) {
                    String[] item = lstr[i].split(":");
                    this.multiHint.setItemData(new LanguageInfo(LocaleUtils.getLocale((String)this.RemoveSingleQuote(item[0]))), (Object)this.RemoveSingleQuote(item[1]));
                }
            }
            this.filterPanel.loadFilter(this.filterMetaData, this.filterObject);
            this.filterPanel.refreshFilterRow();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String RemoveSingleQuote(String str) {
        String newStr = str.trim();
        if (newStr.startsWith("'")) {
            newStr = newStr.substring(1);
        }
        if (newStr.endsWith("'")) {
            newStr = newStr.substring(0, newStr.length() - 1);
        }
        return newStr;
    }

    @Override
    public void setAction(Action action) {
        this.action = action;
    }

    @Override
    public void setActionType(String type) {
        this.actionType = this.actionType;
    }

    @Override
    public void setMetaData(MetaDataDesinerModel meteData) {
        this.metaData = meteData;
    }

    @Override
    public void setSourceElement(AbstractElement el) {
        this.el = el;
        if (el != null && el instanceof Field) {
            this.sourceField = (Field)el;
        } else if (el != null && el instanceof FieldAppearance) {
            FieldAppearance fieldAppearance = (FieldAppearance)el;
            this.sourceField = fieldAppearance.getField();
        } else if (el != null && el instanceof Form) {
            this.sourceField = null;
        }
    }

    @Override
    public void setExtendData(Map extendData) {
    }
}

