/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.ide.designer.action.formula.api;

import com.kingdee.bos.kscript.KScriptException;
import com.kingdee.bos.kscript.runtime.Interpreter;
import com.kingdee.eas.base.form.ide.designer.action.formula.api.FuncInfo;
import com.kingdee.eas.base.form.ide.designer.action.formula.api.IParaInputFormulaFunctions;
import com.kingdee.eas.base.form.ide.designer.action.formula.api.InvokeFunctionException;
import com.kingdee.eas.base.form.ide.designer.action.formula.api.funcpara.IFuncParaInputProvider;
import java.math.BigDecimal;
import java.security.SecureRandom;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Vector;

public class BaseFormulaFunctions
implements IParaInputFormulaFunctions {
    private Vector funcInfos = new Vector();

    public BaseFormulaFunctions() {
        this.funcInfos.add(new FuncInfo("round", "\u6570\u5b66\u51fd\u6570", "\u8fd4\u56de\u56db\u820d\u4e94\u5165\u540e\u7684\u6570\u503c  1:\u9700\u8981\u56db\u820d\u4e94\u5165\u7684\u6570\u503c 2:\u5c0f\u6570\u70b9\u540e\u4fdd\u7559\u51e0\u4f4d(\u4ecb\u4e8e\u96f6\u4e0e\u5f53\u524d\u7cbe\u5ea6\u4e4b\u95f4)"));
        this.funcInfos.add(new FuncInfo("sqrt", "\u6570\u5b66\u51fd\u6570", "\u8fd4\u56de\u5e73\u65b9\u6839\u3002"));
        this.funcInfos.add(new FuncInfo("int", "\u6570\u5b66\u51fd\u6570", "\u8fd4\u56de\u6574\u6570\u90e8\u5206\u3002"));
        this.funcInfos.add(new FuncInfo("ln", "\u6570\u5b66\u51fd\u6570", "\u8fd4\u56de\u4ee5e\u4e3a\u5e95\u7684\u5bf9\u6570\u3002"));
        this.funcInfos.add(new FuncInfo("log", "\u6570\u5b66\u51fd\u6570", "\u8fd4\u56de\u5bf9\u6570\u3002\n\u53c2\u65701\uff1a\u5e95\u6570\n\u53c2\u65702\uff1a\u64cd\u4f5c\u6570"));
        this.funcInfos.add(new FuncInfo("log10", "\u6570\u5b66\u51fd\u6570", "\u8fd4\u56de\u4ee510\u4e3a\u5e95\u7684\u5bf9\u6570\u3002"));
        this.funcInfos.add(new FuncInfo("exp", "\u6570\u5b66\u51fd\u6570", "\u8fd4\u56de10\u7684\u5e42\u503c\u3002\n\u53c2\u65701\uff1a\u6307\u6570"));
        this.funcInfos.add(new FuncInfo("power", "\u6570\u5b66\u51fd\u6570", "\u8fd4\u56de\u5e42\u503c\u3002\n\u53c2\u65701\uff1a\u64cd\u4f5c\u6570\n\u53c2\u65702\uff1a\u6307\u6570"));
        this.funcInfos.add(new FuncInfo("mod", "\u6570\u5b66\u51fd\u6570", "\u8fd4\u56de\u4f59\u6570\u3002\n\u53c2\u65701\uff1a\u5de6\u64cd\u4f5c\u6570\n\u53c2\u65702\uff1a\u53f3\u64cd\u4f5c\u6570"));
        this.funcInfos.add(new FuncInfo("pi", "\u6570\u5b66\u51fd\u6570", "\u8fd4\u56de\u5706\u5468\u7387\u3002"));
        this.funcInfos.add(new FuncInfo("rand", "\u6570\u5b66\u51fd\u6570", "\u8fd4\u56de\u968f\u673a\u6570\u3002"));
        this.funcInfos.add(new FuncInfo("degrees", "\u6570\u5b66\u51fd\u6570", "\u8fd4\u56de\u89d2\u5ea6\u503c\u3002\n\u53c2\u65701\uff1a\u5f27\u5ea6\u503c"));
        this.funcInfos.add(new FuncInfo("radians", "\u6570\u5b66\u51fd\u6570", "\u8fd4\u56de\u5f27\u5ea6\u503c\u3002\n\u53c2\u65701\uff1a\u89d2\u5ea6\u503c"));
        this.funcInfos.add(new FuncInfo("sin", "\u6570\u5b66\u51fd\u6570", "\u8fd4\u56de\u53c2\u6570\u7684\u6b63\u5f26\u503c\u3002\n\u53c2\u65701\uff1a\u6570\u503c"));
        this.funcInfos.add(new FuncInfo("asin", "\u6570\u5b66\u51fd\u6570", "\u8fd4\u56de\u53c2\u6570\u7684\u53cd\u6b63\u5f26\u503c\u3002\n\u53c2\u65701\uff1a\u6570\u503c"));
        this.funcInfos.add(new FuncInfo("cos", "\u6570\u5b66\u51fd\u6570", "\u8fd4\u56de\u53c2\u6570\u7684\u4f59\u5f26\u503c\u3002\n\u53c2\u65701\uff1a\u6570\u503c"));
        this.funcInfos.add(new FuncInfo("acos", "\u6570\u5b66\u51fd\u6570", "\u8fd4\u56de\u53c2\u6570\u7684\u53cd\u4f59\u5f26\u503c\u3002\n\u53c2\u65701\uff1a\u6570\u503c"));
        this.funcInfos.add(new FuncInfo("tan", "\u6570\u5b66\u51fd\u6570", "\u8fd4\u56de\u53c2\u6570\u7684\u6b63\u5207\u503c\u3002\n\u53c2\u65701\uff1a\u6570\u503c"));
        this.funcInfos.add(new FuncInfo("atan", "\u6570\u5b66\u51fd\u6570", "\u8fd4\u56de\u53c2\u6570\u7684\u53cd\u6b63\u5207\u503c\u3002\n\u53c2\u65701\uff1a\u6570\u503c"));
        this.funcInfos.add(new FuncInfo("convertBigDecimal", "\u6570\u5b66\u51fd\u6570", "\u8f6c\u5316BigDecmial\u4e3a\u6574\u578b\u6570\u3002\n\u53c2\u65701\uff1ajava.math.BigDecimal"));
        this.funcInfos.add(new FuncInfo("trim", "\u5b57\u7b26\u4e32\u51fd\u6570", "\u8fd4\u56de\u53bb\u9664\u4e24\u8fb9\u7a7a\u767d\u5b57\u7b26\u540e\u7684\u5b57\u7b26\u4e32\u3002\n\u53c2\u65701\uff1a\u5b57\u7b26\u4e32"));
        this.funcInfos.add(new FuncInfo("left", "\u5b57\u7b26\u4e32\u51fd\u6570", "\u8fd4\u56de\u4ece\u5de6\u5f00\u59cb\u6307\u5b9a\u957f\u5ea6\u7684\u5b57\u7b26\u4e32\u3002\n\u53c2\u65701\uff1a\u5b57\u7b26\u4e32\n\u53c2\u65702\uff1a\u957f\u5ea6"));
        this.funcInfos.add(new FuncInfo("right", "\u5b57\u7b26\u4e32\u51fd\u6570", "\u8fd4\u56de\u4ece\u53f3\u5f00\u59cb\u6307\u5b9a\u957f\u5ea6\u7684\u5b57\u7b26\u4e32\u3002\n\u53c2\u65701\uff1a\u5b57\u7b26\u4e32\n\u53c2\u65702\uff1a\u957f\u5ea6"));
        this.funcInfos.add(new FuncInfo("rept", "\u5b57\u7b26\u4e32\u51fd\u6570", "\u8fd4\u56de\u91cd\u590d\u5b57\u7b26\u4e32\u3002\n\u53c2\u65701\uff1a\u8981\u91cd\u590d\u7684\u5b57\u7b26\u4e32\n\u53c2\u65702\uff1a\u91cd\u590d\u6b21\u6570"));
        this.funcInfos.add(new FuncInfo("now", "\u65f6\u95f4\u65e5\u671f\u51fd\u6570", "\u8fd4\u56de\u5f53\u524d\u65e5\u671f\u65f6\u95f4\u5b57\u7b26\u4e32\u3002\n\u683c\u5f0f\uff1a\"2004-4-17 14:43:05\""));
        this.funcInfos.add(new FuncInfo("convertJavaDate", "\u65f6\u95f4\u65e5\u671f\u51fd\u6570", "\u5c06java.util.Date\u8f6c\u5316\u4e3a\u65e5\u671f\u65f6\u95f4\u5b57\u7b26\u4e32\u3002\n\u53c2\u65701\uff1ajava.util.Date\u5bf9\u8c61"));
        this.funcInfos.add(new FuncInfo("year", "\u65f6\u95f4\u65e5\u671f\u51fd\u6570", "\u8fd4\u56de\u53c2\u6570\u65e5\u671f\u7684\u5e74\u4efd\u90e8\u5206\u3002\n\u53c2\u65701\uff1a\u65f6\u95f4\u65e5\u671f\u5b57\u7b26\u4e32"));
        this.funcInfos.add(new FuncInfo("month", "\u65f6\u95f4\u65e5\u671f\u51fd\u6570", "\u8fd4\u56de\u53c2\u6570\u65e5\u671f\u7684\u6708\u4efd\u90e8\u5206\u3002\n\u53c2\u65701\uff1a\u65f6\u95f4\u65e5\u671f\u5b57\u7b26\u4e32"));
        this.funcInfos.add(new FuncInfo("date", "\u65f6\u95f4\u65e5\u671f\u51fd\u6570", "\u8fd4\u56de\u53c2\u6570\u65e5\u671f\u7684\u65e5\u90e8\u5206\u3002\n\u53c2\u65701\uff1a\u65f6\u95f4\u65e5\u671f\u5b57\u7b26\u4e32"));
        this.funcInfos.add(new FuncInfo("hour", "\u65f6\u95f4\u65e5\u671f\u51fd\u6570", "\u8fd4\u56de\u53c2\u6570\u65f6\u95f4\u7684\u5c0f\u65f6\u90e8\u5206\u3002\n\u53c2\u65701\uff1a\u65f6\u95f4\u65e5\u671f\u5b57\u7b26\u4e32"));
        this.funcInfos.add(new FuncInfo("minute", "\u65f6\u95f4\u65e5\u671f\u51fd\u6570", "\u8fd4\u56de\u53c2\u6570\u65f6\u95f4\u7684\u5206\u949f\u90e8\u5206\u3002\n\u53c2\u65701\uff1a\u65f6\u95f4\u65e5\u671f\u5b57\u7b26\u4e32"));
        this.funcInfos.add(new FuncInfo("second", "\u65f6\u95f4\u65e5\u671f\u51fd\u6570", "\u8fd4\u56de\u53c2\u6570\u65f6\u95f4\u7684\u79d2\u90e8\u5206\u3002\n\u53c2\u65701\uff1a\u65f6\u95f4\u65e5\u671f\u5b57\u7b26\u4e32"));
        this.funcInfos.add(new FuncInfo("yearday", "\u65f6\u95f4\u65e5\u671f\u51fd\u6570", "\u8fd4\u56de\u5f53\u524d\u65e5\u671f\u662f\u4e00\u5e74\u7684\u7b2c\u51e0\u5929\n\u53c2\u65701\uff1a\u65f6\u95f4\u65e5\u671f\u5b57\u7b26\u4e32"));
        this.funcInfos.add(new FuncInfo("weekday", "\u65f6\u95f4\u65e5\u671f\u51fd\u6570", "\u8fd4\u56de\u5f53\u524d\u65e5\u671f\u662f\u4e00\u5468\u7684\u7b2c\u51e0\u5929\u3002\n\u53c2\u65701\uff1a\u65f6\u95f4\u65e5\u671f\u5b57\u7b26\u4e32"));
        this.funcInfos.add(new FuncInfo("datevalue", "\u65f6\u95f4\u65e5\u671f\u51fd\u6570", "\u8fd4\u56de\u5f53\u524d\u65e5\u671f\u7684LONG\u503c\u8868\u793a\u3002\n\u53c2\u65701\uff1a\u65f6\u95f4\u65e5\u671f\u5b57\u7b26\u4e32"));
        this.funcInfos.add(new FuncInfo("days", "\u65f6\u95f4\u65e5\u671f\u51fd\u6570", "\u5c06LONG\u503c\u8f6c\u4e3a\u7b49\u4ef7\u6574\u6570\u8868\u793a\u5929\u6570\u3002\n\u53c2\u65701\uff1a\u6570\u503c\u7c7b\u578b"));
        this.funcInfos.add(new FuncInfo("hours", "\u65f6\u95f4\u65e5\u671f\u51fd\u6570", "\u5c06LONG\u503c\u8f6c\u4e3a\u7b49\u4ef7\u6574\u6570\u8868\u793a\u5c0f\u65f6\u6570\u3002\n\u53c2\u65701\uff1a\u6570\u503c\u7c7b\u578b"));
        this.funcInfos.add(new FuncInfo("milliseconds", "\u65f6\u95f4\u65e5\u671f\u51fd\u6570", "\u5c06LONG\u503c\u8f6c\u4e3a\u7b49\u4ef7\u6574\u6570\u8868\u793a\u6beb\u79d2\u6570\u3002\n\u53c2\u65701\uff1a\u6570\u503c\u7c7b\u578b"));
        this.funcInfos.add(new FuncInfo("minutes", "\u65f6\u95f4\u65e5\u671f\u51fd\u6570", "\u5c06LONG\u503c\u8f6c\u4e3a\u7b49\u4ef7\u6574\u6570\u8868\u793a\u5206\u949f\u6570\u3002\n\u53c2\u65701\uff1a\u6570\u503c\u7c7b\u578b"));
        this.funcInfos.add(new FuncInfo("seconds", "\u65f6\u95f4\u65e5\u671f\u51fd\u6570", "\u5c06LONG\u503c\u8f6c\u4e3a\u7b49\u4ef7\u6574\u6570\u8868\u793a\u79d2\u6570\u3002\n\u53c2\u65701\uff1a\u6570\u503c\u7c7b\u578b"));
        this.funcInfos.add(new FuncInfo("ticks", "\u65f6\u95f4\u65e5\u671f\u51fd\u6570", "\u5c06LONG\u503c\u8f6c\u4e3a\u7b49\u4ef7\u6574\u6570\u8868\u793a\u65f6\u949f\u6570\u3002\n\u53c2\u65701\uff1a\u6570\u503c\u7c7b\u578b"));
        this.funcInfos.add(new FuncInfo("totaldays", "\u65f6\u95f4\u65e5\u671f\u51fd\u6570", "\u5c06LONG\u503c\u8f6c\u4e3a\u7b49\u4ef7\u6d6e\u70b9\u8868\u793a\u5929\u6570\u3002\n\u53c2\u65701\uff1a\u6570\u503c\u7c7b\u578b"));
        this.funcInfos.add(new FuncInfo("totalhours", "\u65f6\u95f4\u65e5\u671f\u51fd\u6570", "\u5c06LONG\u503c\u8f6c\u4e3a\u7b49\u4ef7\u6d6e\u70b9\u8868\u793a\u5c0f\u65f6\u6570\u3002\n\u53c2\u65701\uff1a\u6570\u503c\u7c7b\u578b"));
        this.funcInfos.add(new FuncInfo("totalmilliseconds", "\u65f6\u95f4\u65e5\u671f\u51fd\u6570", "\u5c06LONG\u503c\u8f6c\u4e3a\u7b49\u4ef7\u6d6e\u70b9\u8868\u793a\u6beb\u79d2\u6570\u3002\n\u53c2\u65701\uff1a\u6570\u503c\u7c7b\u578b"));
        this.funcInfos.add(new FuncInfo("totalminutes", "\u65f6\u95f4\u65e5\u671f\u51fd\u6570", "\u5c06LONG\u503c\u8f6c\u4e3a\u7b49\u4ef7\u6d6e\u70b9\u8868\u793a\u5206\u949f\u6570\u3002\n\u53c2\u65701\uff1a\u6570\u503c\u7c7b\u578b"));
        this.funcInfos.add(new FuncInfo("totalseconds", "\u65f6\u95f4\u65e5\u671f\u51fd\u6570", "\u5c06LONG\u503c\u8f6c\u4e3a\u7b49\u4ef7\u6d6e\u70b9\u8868\u793a\u79d2\u6570\u3002\n\u53c2\u65701\uff1a\u6570\u503c\u7c7b\u578b"));
        this.funcInfos.add(new FuncInfo("dateDiff", "\u65f6\u95f4\u65e5\u671f\u51fd\u6570", "\u8fd4\u56de\u53c2\u65701\u548c\u53c2\u65702\u95f4\u76f8\u5dee\u591a\u5c11\u5929\u3002\n\u53c2\u65701\uff1a\u65f6\u95f4\u65e5\u671f\u5b57\u7b26\u4e32\n\u53c2\u65702\uff1a\u65f6\u95f4\u65e5\u671f\u5b57\u7b26\u4e32"));
        this.funcInfos.add(new FuncInfo("dateAdd", "\u65f6\u95f4\u65e5\u671f\u51fd\u6570", "\u8fd4\u56de\u53c2\u65701\u52a0\u4e0a\u53c2\u65702\u7684\u5929\u6570\u3002\n\u53c2\u65701\uff1a\u65f6\u95f4\u65e5\u671f\u5b57\u7b26\u4e32\n\u53c2\u65702\uff1a\u6570\u503c\u7c7b\u578b"));
        this.funcInfos.add(new FuncInfo("abs", "\u6570\u5b66\u51fd\u6570", ""));
        this.funcInfos.add(new FuncInfo("parseInt", "\u6570\u5b66\u51fd\u6570", ""));
        this.funcInfos.add(new FuncInfo("parseFloat", "\u6570\u5b66\u51fd\u6570", ""));
        this.funcInfos.add(new FuncInfo("len", "\u5b57\u7b26\u4e32\u51fd\u6570", ""));
        this.funcInfos.add(new FuncInfo("avg", "\u805a\u5408\u51fd\u6570", ""));
        this.funcInfos.add(new FuncInfo("count", "\u805a\u5408\u51fd\u6570", ""));
        this.funcInfos.add(new FuncInfo("max", "\u805a\u5408\u51fd\u6570", ""));
        this.funcInfos.add(new FuncInfo("min", "\u805a\u5408\u51fd\u6570", ""));
        this.funcInfos.add(new FuncInfo("sum", "\u805a\u5408\u51fd\u6570", ""));
        this.funcInfos.add(new FuncInfo("print", "I/O\u51fd\u6570", ""));
        this.funcInfos.add(new FuncInfo("println", "I/O\u51fd\u6570", ""));
        this.funcInfos.add(new FuncInfo("eval", "\u5176\u5b83\u51fd\u6570", ""));
        this.funcInfos.add(new FuncInfo("newid", "\u5176\u5b83\u51fd\u6570", ""));
        this.funcInfos.add(new FuncInfo("ignoreNullString", "\u7a7a\u5904\u7406\u51fd\u6570", "\u5982\u679c\u5b57\u7b26\u4e32\u7684\u503c\u4e3anull\uff0c\u5c06\u4ee5\u7a7a\u5b57\u7b26\u4e32\u53d6\u4ee3\u5b83\u3002\n\u53c2\u65701\uff1a\u5b57\u7b26\u4e32"));
        this.funcInfos.add(new FuncInfo("ignoreNullNumber", "\u7a7a\u5904\u7406\u51fd\u6570", "\u5982\u679c\u6570\u503c\u7684\u503c\u4e3anull\uff0c\u5c06\u4ee50\u53d6\u4ee3\u5b83\u3002\n\u53c2\u65701\uff1a\u6570\u503c\u7c7b\u578b"));
    }

    @Override
    public boolean existFunction(String funcName) {
        if (funcName == null) {
            return false;
        }
        for (int i = 0; i < this.funcInfos.size(); ++i) {
            if (!funcName.equals(((FuncInfo)this.funcInfos.get((int)i)).funcName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String[] getAllFuncNames() {
        String[] funcNames = new String[this.funcInfos.size()];
        for (int i = 0; i < this.funcInfos.size(); ++i) {
            funcNames[i] = ((FuncInfo)this.funcInfos.get((int)i)).funcName;
        }
        return funcNames;
    }

    @Override
    public String getFuncCategory(String funcName) {
        if (funcName == null) {
            return null;
        }
        for (int i = 0; i < this.funcInfos.size(); ++i) {
            if (!funcName.equals(((FuncInfo)this.funcInfos.get((int)i)).funcName)) continue;
            return ((FuncInfo)this.funcInfos.get((int)i)).funcCategory;
        }
        return null;
    }

    @Override
    public String getFuncDesc(String funcName) {
        if (funcName == null) {
            return null;
        }
        for (int i = 0; i < this.funcInfos.size(); ++i) {
            if (!funcName.equals(((FuncInfo)this.funcInfos.get((int)i)).funcName)) continue;
            return ((FuncInfo)this.funcInfos.get((int)i)).funcDesc;
        }
        return null;
    }

    private Object now(List paramList) throws InvokeFunctionException {
        if (paramList != null && paramList.size() > 0) {
            throw new InvokeFunctionException("now", 1);
        }
        String pattern = "yyyy-MM-dd HH:mm:ss";
        SimpleDateFormat nowDateFormat = (SimpleDateFormat)SimpleDateFormat.getDateTimeInstance();
        nowDateFormat.applyPattern(pattern);
        return nowDateFormat.format(new Date());
    }

    private Object convertJavaDate(List paramList) throws InvokeFunctionException {
        if (paramList == null) {
            throw new InvokeFunctionException("convertJavaDate", 2);
        }
        if (paramList.size() < 1) {
            throw new InvokeFunctionException("convertJavaDate", 2);
        }
        if (paramList.size() > 1) {
            throw new InvokeFunctionException("convertJavaDate", 1);
        }
        if (paramList.get(0) == null) {
            return null;
        }
        if (!(paramList.get(0) instanceof Date)) {
            throw new InvokeFunctionException("convertJavaDate", 3);
        }
        Locale locale = null;
        DateFormat dateFormat = null;
        locale = new Locale(Locale.SIMPLIFIED_CHINESE.getLanguage(), Locale.CHINA.getCountry());
        dateFormat = DateFormat.getDateTimeInstance(2, 2, locale);
        return dateFormat.format((Date)paramList.get(0));
    }

    private Object timeFuncSetString(List paramList, String funcName) throws InvokeFunctionException {
        if (paramList == null) {
            throw new InvokeFunctionException(funcName, 2);
        }
        if (paramList.size() < 1) {
            throw new InvokeFunctionException(funcName, 2);
        }
        if (paramList.size() > 1) {
            throw new InvokeFunctionException(funcName, 1);
        }
        if (paramList.get(0) == null) {
            return null;
        }
        if (!(paramList.get(0) instanceof String)) {
            throw new InvokeFunctionException(funcName, 3);
        }
        Locale locale = null;
        DateFormat dateFormat = null;
        locale = new Locale(Locale.SIMPLIFIED_CHINESE.getLanguage(), Locale.CHINA.getCountry());
        dateFormat = DateFormat.getDateTimeInstance(2, 2, locale);
        try {
            if ("year".equals(funcName)) {
                int year = dateFormat.parse((String)paramList.get(0)).getYear() + 1900;
                return new Integer(year);
            }
            if ("month".equals(funcName)) {
                int month = dateFormat.parse((String)paramList.get(0)).getMonth() + 1;
                return new Integer(month);
            }
            if ("date".equals(funcName)) {
                int date = dateFormat.parse((String)paramList.get(0)).getDate();
                return new Integer(date);
            }
            if ("hour".equals(funcName)) {
                int hour = dateFormat.parse((String)paramList.get(0)).getHours();
                return new Integer(hour);
            }
            if ("minute".equals(funcName)) {
                int minute = dateFormat.parse((String)paramList.get(0)).getMinutes();
                return new Integer(minute);
            }
            if ("second".equals(funcName)) {
                int year = dateFormat.parse((String)paramList.get(0)).getSeconds();
                return new Integer(year);
            }
            if ("yearday".equals(funcName)) {
                Date date = dateFormat.parse((String)paramList.get(0));
                Calendar calendar = Calendar.getInstance();
                calendar.set(date.getYear(), date.getMonth(), date.getDate());
                return new Integer(calendar.get(6));
            }
            if ("weekday".equals(funcName)) {
                int weekday = dateFormat.parse((String)paramList.get(0)).getDay();
                return new Integer(weekday);
            }
            if ("datevalue".equals(funcName)) {
                long time = dateFormat.parse((String)paramList.get(0)).getTime();
                return new Long(time);
            }
            return null;
        }
        catch (ParseException e) {
            throw new InvokeFunctionException(funcName, e);
        }
    }

    private Object timeFuncDateDiff(List paramList) throws InvokeFunctionException {
        String funcName = "dateDiff";
        if (paramList == null) {
            throw new InvokeFunctionException(funcName, 2);
        }
        if (paramList.size() < 2) {
            throw new InvokeFunctionException(funcName, 2);
        }
        if (paramList.size() > 2) {
            throw new InvokeFunctionException(funcName, 1);
        }
        if (paramList.get(0) == null || paramList.get(1) == null) {
            return null;
        }
        if (!(paramList.get(0) instanceof String) && !(paramList.get(0) instanceof Date) || !(paramList.get(1) instanceof String) && !(paramList.get(1) instanceof Date)) {
            throw new InvokeFunctionException(funcName, 3);
        }
        Locale locale = null;
        DateFormat dateFormat = null;
        locale = new Locale(Locale.SIMPLIFIED_CHINESE.getLanguage(), Locale.CHINA.getCountry());
        dateFormat = DateFormat.getDateTimeInstance(2, 2, locale);
        GregorianCalendar leapYearCalendar = null;
        leapYearCalendar = new GregorianCalendar();
        try {
            int currMonth;
            Date date1 = dateFormat.parse((String)paramList.get(0));
            Date date2 = dateFormat.parse((String)paramList.get(1));
            boolean isMinus = false;
            if (date2.after(date1)) {
                Date tmpDate = date1;
                date1 = date2;
                date2 = tmpDate;
                isMinus = true;
            }
            int year1 = date1.getYear() + 1900;
            int year2 = date2.getYear() + 1900;
            int month1 = date1.getMonth() + 1;
            int month2 = date2.getMonth() + 1;
            int d1 = date1.getDate();
            int d2 = date2.getDate();
            if (year1 == year2 && month1 == month2) {
                if (!isMinus) {
                    return new Integer(d1 - d2);
                }
                return new Integer(d2 - d1);
            }
            int yearDates = 0;
            if (year1 - year2 >= 2) {
                for (int currYear = year2 + 1; currYear < year1; ++currYear) {
                    if (leapYearCalendar.isLeapYear(currYear)) {
                        yearDates += 366;
                        continue;
                    }
                    yearDates += 365;
                }
            }
            int year2dates = 0;
            int year1dates = 0;
            if (year1 == year2) {
                for (currMonth = month2 + 1; currMonth <= month1 - 1; ++currMonth) {
                    year1dates += this.monthDates(year1, currMonth);
                }
            } else {
                for (currMonth = month2 + 1; currMonth <= 12; ++currMonth) {
                    year2dates += this.monthDates(year2, currMonth);
                }
                for (currMonth = 1; currMonth <= month1 - 1; ++currMonth) {
                    year1dates += this.monthDates(year1, currMonth);
                }
            }
            int month2dates = this.monthDates(year2, month2) - d2;
            int month1dates = d1;
            int totalDates = yearDates + year2dates + year1dates + month2dates + month1dates;
            if (isMinus) {
                totalDates = -totalDates;
            }
            return new Integer(totalDates);
        }
        catch (ParseException e) {
            throw new InvokeFunctionException(funcName, e);
        }
    }

    private Object timeFuncDateAdd(List paramList) throws InvokeFunctionException {
        String funcName = "dateDiff";
        if (paramList == null) {
            throw new InvokeFunctionException(funcName, 2);
        }
        if (paramList.size() < 2) {
            throw new InvokeFunctionException(funcName, 2);
        }
        if (paramList.size() > 2) {
            throw new InvokeFunctionException(funcName, 1);
        }
        if (paramList.get(0) == null || paramList.get(1) == null) {
            return null;
        }
        if (!(paramList.get(0) instanceof String) && !(paramList.get(0) instanceof Date) || !(paramList.get(1) instanceof String) && !(paramList.get(1) instanceof Integer)) {
            throw new InvokeFunctionException(funcName, 3);
        }
        Locale locale = null;
        DateFormat dateFormat = null;
        locale = new Locale(Locale.SIMPLIFIED_CHINESE.getLanguage(), Locale.CHINA.getCountry());
        dateFormat = DateFormat.getDateTimeInstance(2, 2, locale);
        try {
            Date date1 = dateFormat.parse((String)paramList.get(0));
            int offset = 0;
            offset = paramList.get(1) instanceof String ? Integer.valueOf((String)paramList.get(1)).intValue() : ((Integer)paramList.get(1)).intValue();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date1);
            calendar.set(6, calendar.get(6) + offset);
            String pattern = "yyyy-MM-dd HH:mm:ss";
            SimpleDateFormat nowDateFormat = (SimpleDateFormat)SimpleDateFormat.getDateTimeInstance();
            nowDateFormat.applyPattern(pattern);
            return nowDateFormat.format(calendar.getTime());
        }
        catch (ParseException e) {
            throw new InvokeFunctionException(funcName, e);
        }
    }

    private int monthDates(int year, int month) {
        GregorianCalendar leapYearCalendar = null;
        leapYearCalendar = new GregorianCalendar();
        if (month < 1 || month > 12) {
            return 0;
        }
        if (month == 1 || month == 3 || month == 5 || month == 7 || month == 8 || month == 10 || month == 12) {
            return 31;
        }
        if (month == 2) {
            if (leapYearCalendar.isLeapYear(year)) {
                return 29;
            }
            return 28;
        }
        return 30;
    }

    private Object timeFuncSetInt(List paramList, String funcName) throws InvokeFunctionException {
        if (paramList == null) {
            throw new InvokeFunctionException(funcName, 2);
        }
        if (paramList.size() < 1) {
            throw new InvokeFunctionException(funcName, 2);
        }
        if (paramList.size() > 1) {
            throw new InvokeFunctionException(funcName, 1);
        }
        if (paramList.get(0) == null) {
            return null;
        }
        if (!(paramList.get(0) instanceof Long) && !(paramList.get(0) instanceof Integer)) {
            throw new InvokeFunctionException(funcName, 3);
        }
        long time = 0L;
        if (paramList.get(0) instanceof Long) {
            time = (Long)paramList.get(0);
        } else if (paramList.get(0) instanceof Integer) {
            time = ((Integer)paramList.get(0)).intValue();
        }
        if ("days".equals(funcName)) {
            return new Integer((int)(time / 86400000L));
        }
        if ("hours".equals(funcName)) {
            return new Integer((int)(time / 3600000L));
        }
        if ("milliseconds".equals(funcName)) {
            return new Integer((int)time);
        }
        if ("minutes".equals(funcName)) {
            return new Integer((int)(time / 60000L));
        }
        if ("seconds".equals(funcName)) {
            return new Integer((int)(time / 1000L));
        }
        if ("ticks".equals(funcName)) {
            return new Integer((int)(time / 3600000L));
        }
        if ("totaldays".equals(funcName)) {
            return new Double((double)time / 8.64E7);
        }
        if ("totalhours".equals(funcName)) {
            return new Double((double)time / 3600000.0);
        }
        if ("totalmilliseconds".equals(funcName)) {
            return new Double(time);
        }
        if ("totalminutes".equals(funcName)) {
            return new Double((double)time / 60000.0);
        }
        if ("totalseconds".equals(funcName)) {
            return new Double((double)time / 1000.0);
        }
        return null;
    }

    private Object trim(List paramList) throws InvokeFunctionException {
        String funcName = "trim";
        if (paramList == null) {
            throw new InvokeFunctionException(funcName, 2);
        }
        if (paramList.size() < 1) {
            throw new InvokeFunctionException(funcName, 2);
        }
        if (paramList.size() > 1) {
            throw new InvokeFunctionException(funcName, 1);
        }
        if (paramList.get(0) == null) {
            return null;
        }
        if (!(paramList.get(0) instanceof String)) {
            throw new InvokeFunctionException(funcName, 3);
        }
        return ((String)paramList.get(0)).trim();
    }

    private Object stringFuncSet(List paramList, String funcName) throws InvokeFunctionException {
        if (paramList == null) {
            throw new InvokeFunctionException(funcName, 2);
        }
        if (paramList.size() < 2) {
            throw new InvokeFunctionException(funcName, 2);
        }
        if (paramList.size() > 2) {
            throw new InvokeFunctionException(funcName, 1);
        }
        if (paramList.get(0) == null || paramList.get(0) == null) {
            return null;
        }
        if (!(paramList.get(0) instanceof String) || !(paramList.get(1) instanceof Integer)) {
            throw new InvokeFunctionException(funcName, 3);
        }
        String inputStr = (String)paramList.get(0);
        int cnt = (Integer)paramList.get(1);
        if (cnt < 0) {
            throw new InvokeFunctionException(funcName, "parameter 2 must be greater than 0!");
        }
        if ("left".equals(funcName)) {
            if (inputStr.length() < cnt) {
                throw new InvokeFunctionException(funcName, "the string is not long enough!");
            }
            return inputStr.substring(0, cnt);
        }
        if ("right".equals(funcName)) {
            if (inputStr.length() < cnt) {
                throw new InvokeFunctionException(funcName, "the string is not long enough!");
            }
            return inputStr.substring(inputStr.length() - cnt, cnt);
        }
        if ("rept".equals(funcName)) {
            String retStr = "";
            for (int i = 0; i < cnt; ++i) {
                retStr = retStr + inputStr;
            }
            return retStr;
        }
        return null;
    }

    private Object mathFuncSet0(List paramList, String funcName) throws InvokeFunctionException {
        if (paramList != null && paramList.size() > 0) {
            throw new InvokeFunctionException(funcName, 1);
        }
        if ("pi".equals(funcName)) {
            return new Double(Math.PI);
        }
        if ("rand".equals(funcName)) {
            return new Double(new SecureRandom().nextDouble());
        }
        return null;
    }

    private Object mathFuncSet1(List paramList, String funcName) throws InvokeFunctionException {
        if (paramList == null) {
            throw new InvokeFunctionException(funcName, 2);
        }
        if (paramList.size() < 1) {
            throw new InvokeFunctionException(funcName, 2);
        }
        if (paramList.size() > 1) {
            throw new InvokeFunctionException(funcName, 1);
        }
        if (paramList.get(0) == null) {
            return null;
        }
        if (!(paramList.get(0) instanceof Number)) {
            throw new InvokeFunctionException(funcName, 3);
        }
        double param1 = Double.valueOf(paramList.get(0).toString());
        if ("sqrt".equals(funcName)) {
            return new Double(Math.sqrt(param1));
        }
        if ("int".equals(funcName)) {
            return new Integer((int)param1);
        }
        if ("ln".equals(funcName)) {
            return new Double(Math.log(param1));
        }
        if ("log10".equals(funcName)) {
            return new Double(Math.log(param1) / Math.log(10.0));
        }
        if ("exp".equals(funcName)) {
            return new Double(Math.pow(10.0, param1));
        }
        if ("degrees".equals(funcName)) {
            return new Double(Math.toDegrees(param1));
        }
        if ("radians".equals(funcName)) {
            return new Double(Math.toRadians(param1));
        }
        if ("sin".equals(funcName)) {
            return new Double(Math.sin(param1));
        }
        if ("asin".equals(funcName)) {
            return new Double(Math.asin(param1));
        }
        if ("cos".equals(funcName)) {
            return new Double(Math.cos(param1));
        }
        if ("acos".equals(funcName)) {
            return new Double(Math.acos(param1));
        }
        if ("tan".equals(funcName)) {
            return new Double(Math.tan(param1));
        }
        if ("atan".equals(funcName)) {
            return new Double(Math.atan(param1));
        }
        return null;
    }

    private Object mathFuncSet2(List paramList, String funcName) throws InvokeFunctionException {
        if (paramList == null) {
            throw new InvokeFunctionException(funcName, 2);
        }
        if (paramList.size() < 2) {
            throw new InvokeFunctionException(funcName, 2);
        }
        if (paramList.size() > 2) {
            throw new InvokeFunctionException(funcName, 1);
        }
        if (paramList.get(0) == null || paramList.get(0) == null) {
            return null;
        }
        if (!(paramList.get(0) instanceof Number) || !(paramList.get(1) instanceof Number)) {
            throw new InvokeFunctionException(funcName, 3);
        }
        double param1 = Double.valueOf(paramList.get(0).toString());
        double param2 = Double.valueOf(paramList.get(1).toString());
        if ("log".equals(funcName)) {
            return new Double(Math.log(param2) / Math.log(param1));
        }
        if ("power".equals(funcName)) {
            return new Double(Math.pow(param1, param2));
        }
        if ("mod".equals(funcName)) {
            return new Double(param1 % param2);
        }
        return null;
    }

    private Object convertBigDecimal(List paramList) throws InvokeFunctionException {
        String funcName = "convertBigDecimal";
        if (paramList == null) {
            return new Integer(0);
        }
        if (paramList.size() < 1) {
            throw new InvokeFunctionException(funcName, 2);
        }
        if (paramList.size() > 1) {
            throw new InvokeFunctionException(funcName, 1);
        }
        if (paramList.get(0) == null) {
            return null;
        }
        if (!(paramList.get(0) instanceof BigDecimal)) {
            throw new InvokeFunctionException(funcName, 3);
        }
        return new Integer(((BigDecimal)paramList.get(0)).intValue());
    }

    private Object ignoreNull(String funcName, List paramList) throws InvokeFunctionException {
        if (paramList == null) {
            return null;
        }
        if (paramList.size() < 1) {
            throw new InvokeFunctionException(funcName, 2);
        }
        if (paramList.size() > 1) {
            throw new InvokeFunctionException(funcName, 1);
        }
        if (paramList.get(0) == null) {
            if ("ignoreNullString".equals(funcName)) {
                return "";
            }
            if ("ignoreNullNumber".equals(funcName)) {
                return new Integer(0);
            }
        }
        return paramList.get(0);
    }

    private BigDecimal round(String funcName, List paramList) throws InvokeFunctionException {
        if (paramList == null) {
            throw new InvokeFunctionException(funcName, 2);
        }
        if (paramList.size() < 2) {
            throw new InvokeFunctionException(funcName, 2);
        }
        if (paramList.size() > 2) {
            throw new InvokeFunctionException(funcName, 1);
        }
        if (paramList.get(0) == null || paramList.get(1) == null) {
            return null;
        }
        if (!(paramList.get(0) instanceof Number) || !(paramList.get(1) instanceof Number)) {
            throw new InvokeFunctionException(funcName, 3);
        }
        BigDecimal dSource = new BigDecimal(paramList.get(0).toString());
        int oldScale = dSource.scale();
        int scale = Integer.parseInt(paramList.get(1).toString());
        if (scale < 0) {
            throw new InvokeFunctionException(funcName, "The scale must be a positive integer or zero");
        }
        if (scale > oldScale) {
            scale = oldScale;
        }
        BigDecimal one = new BigDecimal("1");
        BigDecimal rev = dSource.divide(one, scale, 4);
        return rev;
    }

    @Override
    public Object evalFunction(String funcName, List paramList) throws KScriptException {
        if (funcName == null) {
            return null;
        }
        try {
            if ("round".equals(funcName)) {
                return this.round(funcName, paramList);
            }
            if ("now".equals(funcName)) {
                return this.now(paramList);
            }
            if ("convertJavaDate".equals(funcName)) {
                return this.convertJavaDate(paramList);
            }
            if ("year".equals(funcName) || "month".equals(funcName) || "date".equals(funcName) || "hour".equals(funcName) || "minute".equals(funcName) || "second".equals(funcName) || "yearday".equals(funcName) || "weekday".equals(funcName) || "datevalue".equals(funcName)) {
                return this.timeFuncSetString(paramList, funcName);
            }
            if ("dateDiff".equals(funcName)) {
                return this.timeFuncDateDiff(paramList);
            }
            if ("dateAdd".equals(funcName)) {
                return this.timeFuncDateAdd(paramList);
            }
            if ("days".equals(funcName) || "hours".equals(funcName) || "milliseconds".equals(funcName) || "minutes".equals(funcName) || "seconds".equals(funcName) || "ticks".equals(funcName) || "totaldays".equals(funcName) || "totalhours".equals(funcName) || "totalmilliseconds".equals(funcName) || "totalminutes".equals(funcName) || "totalseconds".equals(funcName)) {
                return this.timeFuncSetInt(paramList, funcName);
            }
            if ("trim".equals(funcName)) {
                return this.trim(paramList);
            }
            if ("left".equals(funcName) || "right".equals(funcName) || "rept".equals(funcName)) {
                return this.stringFuncSet(paramList, funcName);
            }
            if ("pi".equals(funcName) || "rand".equals(funcName)) {
                return this.mathFuncSet0(paramList, funcName);
            }
            if ("sqrt".equals(funcName) || "int".equals(funcName) || "ln".equals(funcName) || "log10".equals(funcName) || "exp".equals(funcName) || "degrees".equals(funcName) || "radians".equals(funcName) || "sin".equals(funcName) || "asin".equals(funcName) || "cos".equals(funcName) || "acos".equals(funcName) || "tan".equals(funcName) || "atan".equals(funcName)) {
                return this.mathFuncSet1(paramList, funcName);
            }
            if ("convertBigDecimal".equals(funcName)) {
                return this.convertBigDecimal(paramList);
            }
            if ("log".equals(funcName) || "power".equals(funcName) || "mod".equals(funcName)) {
                return this.mathFuncSet2(paramList, funcName);
            }
            if ("ignoreNullString".equals(funcName) || "ignoreNullNumber".equals(funcName)) {
                return this.ignoreNull(funcName, paramList);
            }
        }
        catch (InvokeFunctionException e) {
            throw new KScriptException(e.toString(), (Throwable)e);
        }
        return null;
    }

    @Override
    public IFuncParaInputProvider getFuncParaInputProvider(String funcName) {
        if (funcName == null) {
            return null;
        }
        for (int i = 0; i < this.funcInfos.size(); ++i) {
            if (!funcName.equals(((FuncInfo)this.funcInfos.get((int)i)).funcName)) continue;
            return ((FuncInfo)this.funcInfos.get((int)i)).input;
        }
        return null;
    }

    public static void main(String[] args) throws Exception {
        Interpreter.publicFuncProviderList.add(new BaseFormulaFunctions());
        for (int i = 0; i < 1000; ++i) {
            Thread t = new Thread("Thead" + i){

                @Override
                public void run() {
                    while (true) {
                        try {
                            String text = "var formula_result;formula_result=month(now());return formula_result;";
                            HashMap context = new HashMap();
                            Interpreter interpreter = new Interpreter();
                            Object rtnValue = interpreter.eval(text, context);
                            System.out.println("formula_result:" + rtnValue);
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                        }
                        try {
                            Thread.currentThread();
                            Thread.sleep(100L);
                            continue;
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                            continue;
                        }
                        break;
                    }
                }
            };
            t.start();
            System.out.println(t.getName() + ":Start");
        }
    }
}

