/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.ide.designer.action.formula.api;

import com.kingdee.bos.kscript.ParserException;
import com.kingdee.bos.kscript.dom.expr.BinaryOpExpr;
import com.kingdee.bos.kscript.dom.expr.BoolExpr;
import com.kingdee.bos.kscript.dom.expr.CodeExpr;
import com.kingdee.bos.kscript.dom.expr.DoubleExpr;
import com.kingdee.bos.kscript.dom.expr.FloatExpr;
import com.kingdee.bos.kscript.dom.expr.IdentifierExpr;
import com.kingdee.bos.kscript.dom.expr.IntExpr;
import com.kingdee.bos.kscript.dom.expr.LongExpr;
import com.kingdee.bos.kscript.dom.expr.MethodInvokeExpr;
import com.kingdee.bos.kscript.dom.expr.NullExpr;
import com.kingdee.bos.kscript.dom.expr.PropertyExpr;
import com.kingdee.bos.kscript.dom.expr.StringExpr;
import com.kingdee.bos.kscript.dom.stmt.BlockStmt;
import com.kingdee.bos.kscript.dom.stmt.CodeStmt;
import com.kingdee.bos.kscript.dom.stmt.ElseIfItem;
import com.kingdee.bos.kscript.dom.stmt.ExprStmt;
import com.kingdee.bos.kscript.dom.stmt.IfStmt;
import com.kingdee.bos.kscript.dom.stmt.ReturnStmt;
import com.kingdee.bos.kscript.dom.stmt.VarDeclStmt;
import com.kingdee.bos.kscript.parser.KScriptParser;
import com.kingdee.eas.base.form.ide.designer.action.formula.api.IFormulaGrammarVerifier;
import com.kingdee.eas.base.form.ide.designer.action.formula.api.KScriptFormulaParser;
import java.util.List;

public class FormulaGrammarVerifier
implements IFormulaGrammarVerifier {
    @Override
    public boolean isCompatibleWithKScript(String formulaStr) {
        if (formulaStr == null) {
            return false;
        }
        try {
            KScriptFormulaParser.parseFormulaStr(formulaStr);
            return true;
        }
        catch (ParserException e) {
            return false;
        }
        catch (Exception ee) {
            return false;
        }
    }

    @Override
    public boolean isCompatibleWithBOSFormula(String formulaStr) {
        if (formulaStr == null) {
            return false;
        }
        try {
            KScriptParser parser = KScriptFormulaParser.parseFormulaStr(formulaStr);
            List stmtList = parser.stmtList;
            for (int i = 0; i < stmtList.size(); ++i) {
                CodeStmt codeStmt = (CodeStmt)stmtList.get(i);
                if (!this.isStmtInvalid(codeStmt)) continue;
                return false;
            }
            return true;
        }
        catch (ParserException e) {
            return false;
        }
    }

    @Override
    public boolean hasSetFormulaResult(String formulaStr) {
        if (formulaStr == null) {
            return false;
        }
        try {
            KScriptParser parser = KScriptFormulaParser.parseFormulaStr(formulaStr);
            if (parser == null) {
                return false;
            }
            List stmtList = parser.stmtList;
            return this.isStmtListSetResult(stmtList);
        }
        catch (ParserException e) {
            return false;
        }
    }

    private boolean isStmtListSetResult(List stmtList) {
        if (stmtList == null) {
            return false;
        }
        for (int i = 0; i < stmtList.size(); ++i) {
            CodeStmt codeStmt = (CodeStmt)stmtList.get(i);
            if (!(codeStmt instanceof ExprStmt ? this.isExprSetResult(((ExprStmt)codeStmt).expr) : (codeStmt instanceof IfStmt ? this.isIfStmtSetResult((IfStmt)codeStmt) : codeStmt instanceof BlockStmt && this.isStmtListSetResult(((BlockStmt)codeStmt).stmtList)))) continue;
            return true;
        }
        return false;
    }

    private boolean isIfStmtSetResult(IfStmt ifStmt) {
        List elseStmtList = ifStmt.elseStmtList;
        List trueStmtList = ifStmt.trueStmtList;
        List elseIfList = ifStmt.elseIfList;
        if (this.isStmtListSetResult(trueStmtList)) {
            return true;
        }
        if (this.isStmtListSetResult(elseStmtList)) {
            return true;
        }
        for (int i = 0; i < elseIfList.size(); ++i) {
            ElseIfItem elseIfItem = (ElseIfItem)elseIfList.get(i);
            if (!this.isStmtListSetResult(elseIfItem.stmtList)) continue;
            return true;
        }
        return false;
    }

    private boolean isExprSetResult(CodeExpr codeExpr) {
        if (codeExpr == null) {
            return false;
        }
        if (codeExpr instanceof BinaryOpExpr) {
            IdentifierExpr idExpr;
            BinaryOpExpr bopExpr = (BinaryOpExpr)codeExpr;
            CodeExpr lExpr = bopExpr.left;
            CodeExpr rExpr = bopExpr.right;
            if (lExpr != null && rExpr != null && bopExpr.operator == 2 && lExpr instanceof IdentifierExpr && "formula_result".equals((idExpr = (IdentifierExpr)lExpr).toString())) {
                return true;
            }
        }
        return false;
    }

    private boolean isStmtInvalid(CodeStmt codeStmt) {
        if (!(codeStmt instanceof VarDeclStmt)) {
            if (codeStmt instanceof ExprStmt) {
                ExprStmt exprStmt = (ExprStmt)codeStmt;
                return this.isExprInvalid(exprStmt.expr);
            }
            if (codeStmt instanceof IfStmt) {
                int i;
                IfStmt ifStmt = (IfStmt)codeStmt;
                CodeExpr testExpr = ifStmt.testExpr;
                List elseStmtList = ifStmt.elseStmtList;
                List trueStmtList = ifStmt.trueStmtList;
                List elseIfList = ifStmt.elseIfList;
                if (this.isExprInvalid(testExpr)) {
                    return true;
                }
                for (i = 0; i < trueStmtList.size(); ++i) {
                    CodeStmt trueStmt = (CodeStmt)trueStmtList.get(i);
                    if (!this.isStmtInvalid(trueStmt)) continue;
                    return true;
                }
                for (i = 0; i < elseIfList.size(); ++i) {
                    ElseIfItem elseIfItem = (ElseIfItem)elseIfList.get(i);
                    if (this.isExprInvalid(elseIfItem.testExpr)) {
                        return true;
                    }
                    for (int k = 0; k < elseIfItem.stmtList.size(); ++k) {
                        CodeStmt elseIfStmt = (CodeStmt)elseIfItem.stmtList.get(k);
                        if (!this.isStmtInvalid(elseIfStmt)) continue;
                        return true;
                    }
                }
                for (i = 0; i < elseStmtList.size(); ++i) {
                    CodeStmt elseStmt = (CodeStmt)elseStmtList.get(i);
                    if (!this.isStmtInvalid(elseStmt)) continue;
                    return true;
                }
            } else {
                if (codeStmt instanceof ReturnStmt) {
                    ReturnStmt returnStmt = (ReturnStmt)codeStmt;
                    return this.isExprInvalid(returnStmt.expr);
                }
                if (codeStmt instanceof BlockStmt) {
                    List stmtList = ((BlockStmt)codeStmt).stmtList;
                    if (stmtList != null) {
                        for (int i = 0; i < stmtList.size(); ++i) {
                            CodeStmt currStmt = (CodeStmt)stmtList.get(i);
                            if (!this.isStmtInvalid(currStmt)) continue;
                            return true;
                        }
                    }
                } else {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isExprInvalid(CodeExpr codeExpr) {
        if (codeExpr instanceof BinaryOpExpr) {
            BinaryOpExpr bopExpr = (BinaryOpExpr)codeExpr;
            CodeExpr lExpr = bopExpr.left;
            CodeExpr rExpr = bopExpr.right;
            if (lExpr != null && this.isExprInvalid(lExpr)) {
                return true;
            }
            if (rExpr != null && this.isExprInvalid(rExpr)) {
                return true;
            }
        } else if (!(codeExpr instanceof PropertyExpr)) {
            if (codeExpr instanceof MethodInvokeExpr) {
                MethodInvokeExpr mthdExpr = (MethodInvokeExpr)codeExpr;
                for (int i = 0; i < mthdExpr.paramList.size(); ++i) {
                    CodeExpr paramExpr = (CodeExpr)mthdExpr.paramList.get(i);
                    if (!this.isExprInvalid(paramExpr)) continue;
                    return true;
                }
            } else if (!(codeExpr instanceof IdentifierExpr || codeExpr instanceof IntExpr || codeExpr instanceof DoubleExpr || codeExpr instanceof LongExpr || codeExpr instanceof FloatExpr || codeExpr instanceof StringExpr || codeExpr instanceof NullExpr || codeExpr instanceof BoolExpr)) {
                return true;
            }
        }
        return false;
    }

    public static void main(String[] args) {
    }
}

