/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.ide.designer.action.formula.api;

import com.kingdee.bos.kscript.ParserException;
import com.kingdee.bos.kscript.dom.expr.BoolExpr;
import com.kingdee.bos.kscript.dom.expr.CodeExpr;
import com.kingdee.bos.kscript.dom.expr.DoubleExpr;
import com.kingdee.bos.kscript.dom.expr.FloatExpr;
import com.kingdee.bos.kscript.dom.expr.IntExpr;
import com.kingdee.bos.kscript.dom.expr.LongExpr;
import com.kingdee.bos.kscript.dom.expr.NullExpr;
import com.kingdee.bos.kscript.dom.expr.StringExpr;
import com.kingdee.bos.kscript.parser.KScriptParser;
import com.kingdee.bos.kscript.parser.Lexer;
import com.kingdee.bos.kscript.parser.TokenList;
import java.util.Hashtable;
import org.apache.log4j.Logger;

public class KScriptFormulaParser {
    private static Hashtable parsedFormula = new Hashtable();
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.form.ide.designer.action.formula.api.KScriptFormulaParser");

    public static KScriptParser parseFormulaStr(String formulaStr) throws ParserException {
        if (formulaStr == null) {
            return null;
        }
        Object oldParser = parsedFormula.get(formulaStr);
        if (oldParser != null) {
            return (KScriptParser)oldParser;
        }
        Lexer lexer = new Lexer(formulaStr);
        TokenList tokList = new TokenList(lexer);
        KScriptParser parser = new KScriptParser(tokList);
        try {
            parser.parse();
        }
        catch (Exception e) {
            logger.error((Object)"Script is illegal!", (Throwable)e);
            throw new ParserException("0", formulaStr, "\u516c\u5f0f \u4e0d\u5408\u6cd5", (Throwable)e);
        }
        parsedFormula.put(formulaStr, parser);
        return parser;
    }

    public static String getConstantExprStr(CodeExpr codeExpr) {
        String retStr = "";
        if (codeExpr instanceof IntExpr) {
            IntExpr intExpr = (IntExpr)codeExpr;
            retStr = retStr + intExpr.intValue();
        } else if (codeExpr instanceof DoubleExpr) {
            DoubleExpr dblExpr = (DoubleExpr)codeExpr;
            retStr = retStr + dblExpr.doubleValue();
        } else if (codeExpr instanceof LongExpr) {
            LongExpr longExpr = (LongExpr)codeExpr;
            retStr = retStr + longExpr.longValue();
        } else if (codeExpr instanceof FloatExpr) {
            FloatExpr floatExpr = (FloatExpr)codeExpr;
            retStr = retStr + floatExpr.floatValue();
        } else if (codeExpr instanceof StringExpr) {
            String originStr;
            StringExpr strExpr = (StringExpr)codeExpr;
            String jsStr = originStr = strExpr.text;
            if (originStr != null) {
                jsStr = "";
                for (int i = 0; i < originStr.length(); ++i) {
                    char currChar = originStr.charAt(i);
                    jsStr = currChar == '\n' ? jsStr + "\\n" : (currChar == '\r' ? jsStr + "\\r" : (currChar == '\f' ? jsStr + "\\f" : (currChar == '\b' ? jsStr + "\\b" : (currChar == '\t' ? jsStr + "\\t" : (currChar == '\"' ? jsStr + "\\\"" : (currChar == '\'' ? jsStr + "\\'" : (currChar == '\\' ? jsStr + "\\\\" : jsStr + currChar)))))));
                }
            }
            retStr = retStr + "\"" + jsStr + "\"";
        } else if (codeExpr instanceof NullExpr) {
            NullExpr nullExpr = (NullExpr)codeExpr;
            retStr = retStr + nullExpr.toString();
        } else if (codeExpr instanceof BoolExpr) {
            BoolExpr boolExpr = (BoolExpr)codeExpr;
            retStr = retStr + boolExpr.toString();
        }
        return retStr;
    }
}

