/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.ide.designer.action.formula.builder;

import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.eas.base.form.ide.designer.action.formula.api.BuilderResourceUtil;
import com.kingdee.eas.base.form.ide.designer.action.formula.builder.FormulaBuilderPanelBean;
import com.kingdee.eas.base.form.ide.designer.action.formula.builder.FormulaBuilderUtil;
import com.kingdee.eas.base.form.ide.designer.action.formula.builder.FormulaEleComponent;
import com.kingdee.eas.base.form.ide.designer.action.formula.builder.FormulaEleInfo;
import com.kingdee.eas.base.form.ide.designer.action.formula.builder.FormulaLineGapPanel;
import com.kingdee.eas.base.form.ide.designer.action.formula.builder.FormulaLinePanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;

class FormulaPanel
extends KDPanel {
    Vector formulaLinePanes = new Vector();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    KDPanel fillinPane = new KDPanel();
    public static final Color MARGIN_COLOR = Color.lightGray;
    public static final Color CENTER_BGCOLOR = Color.white;
    public static final Color LINEGAP_COLOR = new Color(240, 240, 240, 128);
    public static Color TRANSPARENT = new Color(0, 0, 0, 0);

    public FormulaPanel() {
        this.init();
    }

    public void init() {
        this.setBorder(null);
        this.setLayout(this.gridBagLayout1);
        this.setBackground(CENTER_BGCOLOR);
        this.fillinPane.setBackground(MARGIN_COLOR);
        this.addLine(0, new FormulaLinePanel(this, 0), true);
        this.add((Component)this.fillinPane, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public boolean addLine(int idx, FormulaLinePanel flp, boolean needReDisp) {
        if (flp != null) {
            if (idx == -1) {
                idx = this.formulaLinePanes.size();
            }
        } else {
            return false;
        }
        this.formulaLinePanes.add(idx, flp);
        flp.setIndex(idx);
        if (needReDisp) {
            this.reDisp();
        }
        return true;
    }

    public void reDisp() {
        int i;
        this.removeAll();
        this.repaint();
        int idx = -1;
        int componentIdx = 2 * idx + 2;
        FormulaLineGapPanel lineGapPanel = new FormulaLineGapPanel(this, idx + 1);
        this.add((Component)((Object)lineGapPanel), new GridBagConstraints(0, componentIdx, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        ++idx;
        for (i = 0; i < this.formulaLinePanes.size(); ++i) {
            componentIdx = 2 * idx + 1;
            FormulaLinePanel currLine = (FormulaLinePanel)((Object)this.formulaLinePanes.get(i));
            currLine.setIndex(i);
            this.add((Component)((Object)currLine), new GridBagConstraints(0, componentIdx, 1, 1, 1.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
            componentIdx = 2 * idx + 2;
            lineGapPanel = new FormulaLineGapPanel(this, idx + 1);
            this.add((Component)((Object)lineGapPanel), new GridBagConstraints(0, componentIdx, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
            ++idx;
        }
        this.add((Component)this.fillinPane, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.revalidate();
        for (i = 0; i < this.formulaLinePanes.size(); ++i) {
            ((FormulaLinePanel)((Object)this.formulaLinePanes.get(i))).reDisp();
        }
    }

    public void reIndentLines() {
        for (int i = 0; i < this.formulaLinePanes.size(); ++i) {
            FormulaLinePanel currLine = (FormulaLinePanel)((Object)this.formulaLinePanes.get(i));
            currLine.setIndentCnt(this.calcIndent(i));
        }
    }

    public boolean delLine(int idx) {
        this.formulaLinePanes.remove(idx);
        this.reDisp();
        return true;
    }

    public void changeAliasDisp() {
        for (int i = 0; i < this.formulaLinePanes.size(); ++i) {
            ((FormulaLinePanel)((Object)this.formulaLinePanes.get(i))).changeAliasDisp();
        }
    }

    public String genFormulaStr() {
        String expLines = "";
        for (int i = 0; i < this.formulaLinePanes.size(); ++i) {
            String expLine = ((FormulaLinePanel)((Object)this.formulaLinePanes.get(i))).genFormulaStr();
            if (expLine == null) continue;
            for (int indent = this.calcIndent(i); indent > 0; --indent) {
                expLine = "    " + expLine;
            }
            expLines = expLines + expLine + "\n";
        }
        return expLines;
    }

    public String genFormulaAliasStr() {
        String expLines = "";
        for (int i = 0; i < this.formulaLinePanes.size(); ++i) {
            String expLine = ((FormulaLinePanel)((Object)this.formulaLinePanes.get(i))).genFormulaAliasStr();
            if (expLine == null) continue;
            for (int indent = this.calcIndent(i); indent > 0; --indent) {
                expLine = "    " + expLine;
            }
            expLines = expLines + expLine + "\n";
        }
        return expLines;
    }

    public void removeAllFormulaLines() {
        this.formulaLinePanes.removeAllElements();
        this.reDisp();
    }

    public FormulaLinePanel getLinePane(int idx) {
        if (idx < 0 || idx > this.formulaLinePanes.size() - 1) {
            return null;
        }
        return (FormulaLinePanel)((Object)this.formulaLinePanes.get(idx));
    }

    public Vector getAllFormulaLines() {
        return this.formulaLinePanes;
    }

    protected int calcIndent(int idx) {
        if (idx < 0 || idx > this.formulaLinePanes.size() - 1) {
            return -1;
        }
        Vector<IndentNode> statesStack = new Vector<IndentNode>();
        block0: for (int i = 0; i <= idx; ++i) {
            FormulaLinePanel linePane = (FormulaLinePanel)((Object)this.formulaLinePanes.get(i));
            Vector eleComponents = linePane.getAllEleComponents();
            if (eleComponents.size() == 0) {
                statesStack.add(new IndentNode("no"));
                continue;
            }
            for (int k = 0; k < eleComponents.size(); ++k) {
                FormulaEleComponent eleComponent = (FormulaEleComponent)eleComponents.get(k);
                if (eleComponent.getEleInfo().getEleType() == 14) {
                    statesStack.add(new IndentNode("if"));
                    continue block0;
                }
                if (eleComponent.getEleInfo().getEleType() == 17) {
                    if (FormulaEleInfo.BAS_BBRACKET_TYPES_STRS.get(0).equals(eleComponent.getEleInfo().getSimpleStr())) {
                        statesStack.add(new IndentNode("lb"));
                        continue block0;
                    }
                    statesStack.add(new IndentNode("rb"));
                    continue block0;
                }
                if (k != eleComponents.size() - 1) continue;
                statesStack.add(new IndentNode("no"));
            }
        }
        if (statesStack.size() < 2) {
            return 0;
        }
        IndentNode lastNode = (IndentNode)statesStack.get(0);
        for (int i = 1; i < statesStack.size(); ++i) {
            IndentNode currNode = (IndentNode)statesStack.get(i);
            if (lastNode.type.equals("if")) {
                currNode.parent = lastNode;
            } else if (lastNode.type.equals("lb")) {
                currNode.parent = !currNode.type.equals("rb") ? lastNode : lastNode.parent;
            } else if (lastNode.type.equals("no") || lastNode.type.equals("rb")) {
                if (lastNode.parent != null) {
                    if (lastNode.parent.type.equals("lb")) {
                        currNode.parent = currNode.type.equals("rb") ? lastNode.parent.parent : lastNode.parent;
                    } else if (lastNode.parent.type.equals("if")) {
                        IndentNode tmpNode = lastNode;
                        while (tmpNode.parent != null && tmpNode.parent.type.equals("if")) {
                            tmpNode = tmpNode.parent;
                        }
                        currNode.parent = tmpNode.parent;
                    }
                } else {
                    currNode.parent = null;
                }
            }
            lastNode = currNode;
        }
        int indent = 0;
        while (lastNode.parent != null) {
            lastNode = lastNode.parent;
            ++indent;
        }
        return indent;
    }

    public FormulaLinePanel getLastFormulaLine() {
        if (this.formulaLinePanes.size() == 0) {
            int result = FormulaBuilderUtil.showConfirmDialog((Component)((Object)FormulaBuilderPanelBean.This), BuilderResourceUtil.getString("addLineOrNot"));
            if (result == 0) {
                FormulaLinePanel newLine = new FormulaLinePanel(this, 0);
                this.addLine(0, newLine, true);
                return newLine;
            }
        } else if (this.formulaLinePanes.size() > 0) {
            for (int i = this.formulaLinePanes.size() - 1; i >= 0; --i) {
                FormulaLinePanel currLine = this.getLinePane(i);
                if (currLine.isEmpty()) {
                    if (i != 0) continue;
                    return currLine;
                }
                return currLine;
            }
        }
        return null;
    }

    private class IndentNode {
        String type;
        IndentNode parent = null;

        public IndentNode(String type) {
            this.type = type;
        }
    }
}

