/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.ide.designer.action.formula.engine;

import com.kingdee.bos.kscript.ParserException;
import com.kingdee.bos.kscript.parser.KScriptParser;
import com.kingdee.bos.kscript.parser.Lexer;
import com.kingdee.bos.kscript.parser.TokenList;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.eas.base.form.ide.designer.action.formula.builder.FormulaUtils;
import com.kingdee.eas.base.form.ide.designer.action.formula.engine.BOSObjectTransformer;
import com.kingdee.eas.base.form.ide.designer.action.formula.engine.EnumTransformer;
import com.kingdee.eas.base.form.ide.designer.action.formula.engine.IfThenTransformer;
import com.kingdee.eas.base.form.ide.designer.action.formula.engine.KeyWordTransformer;
import com.kingdee.eas.base.form.ide.designer.action.formula.engine.ValidateResult;
import java.util.Locale;
import java.util.Vector;
import org.apache.log4j.Logger;

public class FormulaTransformer {
    private static final Logger logger = Logger.getLogger(FormulaTransformer.class);
    KeyWordTransformer keyWordTransformer = new KeyWordTransformer();
    IfThenTransformer ifThenTransformer = new IfThenTransformer();
    BOSObjectTransformer bosObjectTransformer;
    EnumTransformer enumTransformer;

    public FormulaTransformer(Vector varList, Vector enumList) {
        this.bosObjectTransformer = new BOSObjectTransformer(varList, enumList);
        this.enumTransformer = new EnumTransformer(varList);
    }

    public void setLocale(String locale) {
        this.setLocale(new Locale(locale));
    }

    public void setLocale(Locale locale) {
        KeyWordTransformer.setLocale(locale);
    }

    public FormulaTransformer() {
        this(null, null);
    }

    public void addBOSObjects(BusinessObjectInfo[] bosobjs) {
        this.bosObjectTransformer.addBOSObjects(bosobjs);
        this.enumTransformer.addBOSObjects(bosobjs);
    }

    public void addBOSObjects(Vector bosobjs) {
        this.bosObjectTransformer.addBOSObjects(bosobjs);
        this.enumTransformer.addBOSObjects(bosobjs);
    }

    public TokenList transformeToken(String formulaString, boolean isExtend) throws ParserException {
        Lexer lexer = new Lexer(formulaString);
        TokenList _tokenList = new TokenList(lexer);
        _tokenList = this.keyWordTransformer.transform(_tokenList);
        _tokenList = this.ifThenTransformer.transform(_tokenList);
        this.bosObjectTransformer.setExtend(isExtend);
        _tokenList = this.bosObjectTransformer.transform(_tokenList);
        _tokenList = this.enumTransformer.transform(_tokenList);
        return _tokenList;
    }

    public String reverseTransform(String script) throws ParserException {
        Lexer lexer = new Lexer(script);
        TokenList _tokenList = new TokenList(lexer);
        this.keyWordTransformer.fixSpace(_tokenList);
        _tokenList = this.enumTransformer.reverseTransform(_tokenList);
        this.keyWordTransformer.fixSpace(_tokenList);
        _tokenList = this.bosObjectTransformer.reverseTransform(_tokenList);
        this.keyWordTransformer.fixSpace(_tokenList);
        _tokenList = this.keyWordTransformer.reverseTransform(_tokenList);
        this.keyWordTransformer.fixSpace(_tokenList);
        return FormulaUtils.printTokenList(_tokenList);
    }

    public String transforme(String formulaString) throws ParserException {
        return FormulaUtils.printTokenList(this.transformeToken(formulaString, false));
    }

    public String transforme_Ex(String formulaString) throws ParserException {
        return FormulaUtils.printTokenList(this.transformeToken(formulaString, true));
    }

    public ValidateResult validate(String formulaString) {
        ValidateResult re = new ValidateResult();
        try {
            String script = this.transforme(formulaString);
            KScriptParser parser = new KScriptParser(script);
            parser.parse();
            return re;
        }
        catch (ParserException e) {
            re.success = false;
            re.errorMsg = e.getMessage();
            return re;
        }
    }

    public boolean scriptIsFormula(String script, String formulaString) throws ParserException {
        Lexer lexer = new Lexer(script);
        TokenList _scriptTokenList = new TokenList(lexer);
        TokenList _scriptTokenList1 = this.transformeToken(formulaString, false);
        return FormulaUtils.tokenListEquals(_scriptTokenList, _scriptTokenList1);
    }
}

