/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.ide.designer.smarttag;

import com.kingdee.bos.ctrl.swing.KDContainer;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDRadioButtonMenuItem;
import com.kingdee.eas.base.form.designer.Designer;
import com.kingdee.eas.base.form.ide.designer.DynamicFormDesigner;
import com.kingdee.eas.base.form.ide.designer.smarttag.AbstractSmartMenu;
import com.kingdee.eas.base.form.ide.model.ElementPropertyAdpter;
import com.kingdee.eas.base.form.metadata.ControlAppearance;
import com.kingdee.eas.base.form.metadata.layout.AbstractLayout;
import com.kingdee.eas.base.form.metadata.layout.tablelayout.Style;
import com.kingdee.eas.base.form.metadata.layout.tablelayout.TableLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.JMenuItem;

public class ContainerSmarMenu
extends AbstractSmartMenu {
    private Container container;

    public ContainerSmarMenu(Component component, DynamicFormDesigner formDesiger) {
        super(component, formDesiger);
        this.container = component instanceof KDContainer ? ((KDContainer)component).getContentPane() : (Container)component;
    }

    @Override
    protected void builderMenuItem() {
        ElementPropertyAdpter el = this.formDesiger.getModel().getElementProperty(this.component.getName());
        KDRadioButtonMenuItem absItem = new KDRadioButtonMenuItem();
        absItem.addActionListener((ActionListener)new AbsolutionLayoutListener(this.container, el));
        absItem.setName("absolutionLayout");
        absItem.setActionCommand("tableLayout");
        absItem.setText("\u7edd\u5bf9\u5b9a\u4f4d\u5e03\u5c40");
        absItem.setSelected(this.container.getLayout() instanceof KDLayout);
        this.menu.add((JMenuItem)absItem);
        KDRadioButtonMenuItem tableItem = new KDRadioButtonMenuItem();
        tableItem.addActionListener((ActionListener)new TableLayoutListener(this.container, el, this.formDesiger.getDesigner()));
        tableItem.setName("tableLayout");
        tableItem.setActionCommand("tableLayout");
        tableItem.setText("\u8868\u683c\u5e03\u5c40");
        boolean isTableLayout = this.container.getLayout() instanceof com.kingdee.eas.base.form.client.layout.Table.TableLayout;
        tableItem.setSelected(isTableLayout);
        this.menu.add((JMenuItem)tableItem);
        if (isTableLayout) {
            KDMenuItem menuItem = new KDMenuItem();
            menuItem.addActionListener((ActionListener)new TableLayoutListener(this.container, el, this.formDesiger.getDesigner()));
            menuItem.setName("addRow");
            menuItem.setActionCommand("addRow");
            menuItem.setText("\u6dfb\u52a0\u884c");
            this.menu.add((JMenuItem)menuItem);
            menuItem = new KDMenuItem();
            menuItem.addActionListener((ActionListener)new TableLayoutListener(this.container, el, this.formDesiger.getDesigner()));
            menuItem.setName("addCol");
            menuItem.setActionCommand("addCol");
            menuItem.setText("\u6dfb\u52a0\u5217");
            this.menu.add((JMenuItem)menuItem);
            menuItem = new KDMenuItem();
            menuItem.addActionListener((ActionListener)new TableLayoutListener(this.container, el, this.formDesiger.getDesigner()));
            menuItem.setName("deleteRow");
            menuItem.setActionCommand("deleteRow");
            menuItem.setText("\u5220\u9664\u884c");
            this.menu.add((JMenuItem)menuItem);
            menuItem = new KDMenuItem();
            menuItem.addActionListener((ActionListener)new TableLayoutListener(this.container, el, this.formDesiger.getDesigner()));
            menuItem.setName("deleteCol");
            menuItem.setActionCommand("deleteCol");
            menuItem.setText("\u5220\u9664\u5217");
            this.menu.add((JMenuItem)menuItem);
        }
    }

    class TableLayoutListener
    implements ActionListener {
        private Container container;
        private ElementPropertyAdpter el;
        private Designer designer;

        public TableLayoutListener(Container container, ElementPropertyAdpter el, Designer designer) {
            this.container = container;
            this.el = el;
            this.designer = designer;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().equalsIgnoreCase("tableLayout")) {
                this.createTableLayout();
                this.setComponentParent();
            } else if (e.getActionCommand().equalsIgnoreCase("addRow")) {
                this.addRow();
                this.setComponentParent();
            } else if (e.getActionCommand().equalsIgnoreCase("addCol")) {
                this.addCol();
                this.setComponentParent();
            } else if (e.getActionCommand().equalsIgnoreCase("deleteRow")) {
                this.deleteRow();
                this.setComponentParent();
            } else if (e.getActionCommand().equalsIgnoreCase("deleteCol")) {
                this.deleteCol();
                this.setComponentParent();
            }
        }

        private void addRow() {
            TableLayout tbInfo = (TableLayout)((ControlAppearance)this.el.getAppearance()).getLayout();
            Style lastRowStyle = (Style)tbInfo.getRowStyles().get(tbInfo.getRows() - 1);
            lastRowStyle.setOut(lastRowStyle.getOut() / 2);
            Style rowStyle = new Style(lastRowStyle.getOut());
            rowStyle.setMargin(2);
            tbInfo.getRowStyles().add(rowStyle);
            tbInfo.setRows(tbInfo.getRows() + 1);
            this.setLayout(tbInfo);
            this.designer.repaint();
        }

        private void addCol() {
            TableLayout tbInfo = (TableLayout)((ControlAppearance)this.el.getAppearance()).getLayout();
            com.kingdee.eas.base.form.client.layout.Table.TableLayout tb = (com.kingdee.eas.base.form.client.layout.Table.TableLayout)this.container.getLayout();
            Style lastColStyle = (Style)tbInfo.getColStyles().get(tbInfo.getCols() - 1);
            lastColStyle.setOut(lastColStyle.getOut() / 2);
            Style colStyle = new Style(lastColStyle.getOut());
            colStyle.setMargin(2);
            tbInfo.getColStyles().add(colStyle);
            tbInfo.setCols(tbInfo.getCols() + 1);
            this.setLayout(tbInfo);
            this.designer.repaint();
        }

        private void deleteRow() {
            TableLayout tbInfo = (TableLayout)((ControlAppearance)this.el.getAppearance()).getLayout();
            if (tbInfo.getRows() > 1) {
                tbInfo.getRowStyles().remove(tbInfo.getRows() - 1);
                tbInfo.setRows(tbInfo.getRows() - 1);
            }
            this.setLayout(tbInfo);
            this.designer.repaint();
        }

        private void deleteCol() {
            TableLayout tbInfo = (TableLayout)((ControlAppearance)this.el.getAppearance()).getLayout();
            if (tbInfo.getCols() > 1) {
                tbInfo.getColStyles().remove(tbInfo.getCols() - 1);
                tbInfo.setCols(tbInfo.getCols() - 1);
            }
            this.setLayout(tbInfo);
            this.designer.repaint();
        }

        private void createTableLayout() {
            if (this.container.getLayout() instanceof com.kingdee.eas.base.form.client.layout.Table.TableLayout) {
                return;
            }
            Component[] coms = this.container.getComponents();
            int cols = 3;
            int rows = 3;
            if (coms.length > 0) {
                ArrayList<Component> lstcom = new ArrayList<Component>();
                for (int i = 0; i < coms.length; ++i) {
                    lstcom.add(coms[i]);
                }
                Collections.sort(lstcom, new XCompare());
                cols = 3;
                rows = coms.length / cols;
                if (rows * cols < coms.length) {
                    ++rows;
                }
            }
            TableLayout tbInfo = this.createTableLayoutInfo(cols, rows);
            this.setLayout(tbInfo);
            ((ControlAppearance)this.el.getAppearance()).setLayout((AbstractLayout)tbInfo);
            this.designer.repaint();
        }

        private void setComponentParent() {
            Component[] coms = this.container.getComponents();
            for (int i = 0; i < coms.length; ++i) {
                this.designer.setComponentParent(coms[i], this.container);
            }
        }

        private TableLayout createTableLayoutInfo(int cols, int rows) {
            int i;
            TableLayout tbInfo = new TableLayout();
            tbInfo.setRows(rows);
            tbInfo.setCols(cols);
            ArrayList<Style> styles = new ArrayList<Style>();
            for (i = 0; i < cols; ++i) {
                Style colStyle = new Style(this.container.getWidth() / cols);
                colStyle.setMargin(2);
                styles.add(colStyle);
            }
            tbInfo.setColStyles(styles);
            styles = new ArrayList();
            for (i = 0; i < rows; ++i) {
                Style rowStyle = new Style(this.container.getHeight() / cols);
                rowStyle.setMargin(2);
                styles.add(rowStyle);
            }
            tbInfo.setRowStyles(styles);
            return tbInfo;
        }

        private void setLayout(TableLayout tbInfo) {
            com.kingdee.eas.base.form.client.layout.Table.TableLayout tb = com.kingdee.eas.base.form.client.layout.Table.TableLayout.split((int)tbInfo.getRows(), (int)tbInfo.getCols());
            ArrayList colStyles = tbInfo.getColStyles();
            int width = 0;
            for (int i = 0; i < colStyles.size(); ++i) {
                Style style = (Style)colStyles.get(i);
                tb.colStyle(i).setWidth(style.getOut());
                tb.colStyle(i).setMargin(style.getMargin());
                width += style.getOut();
            }
            ArrayList rowStyles = tbInfo.getRowStyles();
            for (int i = 0; i < rowStyles.size(); ++i) {
                Style style = (Style)rowStyles.get(i);
                tb.rowStyle(i).setHeight(style.getOut());
                tb.rowStyle(i).setMargin(style.getMargin());
            }
            this.container.setLayout((LayoutManager)tb);
            this.container.doLayout();
        }

        class XCompare
        implements Comparator {
            XCompare() {
            }

            public int compare(Object o1, Object o2) {
                int l2;
                Component x = (Component)o1;
                Component y = (Component)o2;
                int l1 = x.getX();
                if (l1 == (l2 = y.getX())) {
                    return 0;
                }
                return l1 < l2 ? -1 : 1;
            }
        }
    }

    class AbsolutionLayoutListener
    implements ActionListener {
        private Container container;
        private ElementPropertyAdpter el;

        public AbsolutionLayoutListener(Container container, ElementPropertyAdpter el) {
            this.container = container;
            this.el = el;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.container.getLayout() instanceof KDLayout) {
                return;
            }
            Component[] coms = this.container.getComponents();
            this.container.setLayout((LayoutManager)new KDLayout());
            for (int i = 0; i < coms.length; ++i) {
                this.container.add(coms[i], new KDLayout.Constraints(0, coms[i].getBounds()));
            }
        }
    }
}

