/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.ide.migration.help;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.form.ide.migration.help.IImportData;
import com.kingdee.eas.base.form.ide.migration.model.FileObjectItem;
import com.kingdee.eas.base.form.ide.migration.model.IData;
import com.kingdee.eas.base.form.ide.migration.model.TableObjectItem;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import com.kingdee.util.db.SQLUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class AbstractImportData
implements IImportData {
    public static final Logger log = Logger.getLogger(AbstractImportData.class);
    protected Connection con = null;
    protected Context context;
    protected IData data;
    protected String import_mode;
    protected Map import_config;
    protected String form_id;
    protected String sub_system_id;

    @Override
    public boolean importData(Context context, IData data, String import_mode, Map import_config) throws BOSException {
        boolean result = true;
        this.context = context;
        this.import_config = import_config;
        if (import_config != null) {
            this.form_id = import_config.get("form_id").toString();
            this.sub_system_id = import_config.get("sub_system_id").toString();
        }
        this.data = data;
        this.import_mode = import_mode;
        try {
            this.con = EJBFactory.getConnection((Context)context);
            this.con.setAutoCommit(false);
            if (this.executeImportData()) {
                this.con.commit();
            } else {
                this.con.rollback();
                result = false;
            }
        }
        catch (Exception e) {
            try {
                this.con.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            log.error((Object)e);
            throw new BOSException("\u63d2\u5165\u6570\u636e\u5931\u8d25", (Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)this.con);
        }
        return result;
    }

    public abstract boolean executeImportData() throws SQLException, BOSException;

    public void insertTableObjectToDB(TableObjectItem table_object_item) throws SQLException, UnsupportedEncodingException, BOSException {
        int row_count = table_object_item.getRowDataCount();
        if (row_count == 0) {
            return;
        }
        String table_name = table_object_item.getTableName();
        ResultSetMetaData meta_data = this.getResultSetMetaData(table_name);
        String insert_sql = this.createInsertSql(meta_data, table_name);
        PreparedStatement insertPs = this.con.prepareStatement(insert_sql);
        log.info((Object)("fillInsertData " + table_name));
        for (int i = 0; i < row_count; ++i) {
            Map row_data_map = table_object_item.getRowData(i);
            this.fillInsertData(insertPs, meta_data, row_data_map, table_name);
            insertPs.addBatch();
        }
        insertPs.executeBatch();
        SQLUtils.cleanup((Statement)insertPs);
    }

    public boolean isExistPerson(String person_id) {
        try {
            ObjectUuidPK person_pk = new ObjectUuidPK(BOSUuid.read((String)person_id));
            IPerson iPerson = PersonFactory.getLocalInstance((Context)this.context);
            PersonInfo personinfo = iPerson.getPersonInfo((IObjectPK)person_pk);
            if (personinfo != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean isExistUser(String user_id) {
        try {
            ObjectUuidPK user_pk = new ObjectUuidPK(BOSUuid.read((String)user_id));
            UserInfo user_info = UserFactory.getLocalInstance((Context)this.context).getUserInfo((IObjectPK)user_pk);
            if (user_info != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public IRowSet executeQuery(String selectSql, Object[] params) throws BOSException {
        JdbcRowSet jdbcRowSet;
        PreparedStatement ps = null;
        try {
            ps = this.con.prepareStatement(selectSql);
            if (params != null) {
                for (int i = 0; i < params.length; ++i) {
                    ps.setObject(i + 1, params[i]);
                }
            }
            ResultSet rs = ps.executeQuery();
            JdbcRowSet rowset = new JdbcRowSet();
            rowset.populate(rs);
            jdbcRowSet = rowset;
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps);
        return jdbcRowSet;
    }

    public boolean isExistTable(String table_name) {
        String sql = "SELECT * FROM KSQL_USERTABLES WHERE KSQL_TABNAME ='" + table_name + "'";
        try {
            IRowSet result = this.executeQuery(sql, null);
            return result.next();
        }
        catch (BOSException bOSException) {
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return false;
    }

    public TableObjectItem getTableObjectItemByName(String table_name) {
        List list = this.data.getTableObjectItems();
        for (int i = 0; i < list.size(); ++i) {
            TableObjectItem item = (TableObjectItem)list.get(i);
            if (!item.getTableName().equalsIgnoreCase(table_name)) continue;
            return item;
        }
        return null;
    }

    public boolean isExistRecord(String selectSql, Object[] params) throws BOSException {
        IRowSet row_set = this.executeQuery(selectSql, params);
        try {
            return row_set.next();
        }
        catch (SQLException sQLException) {
            return false;
        }
    }

    public void fillInsertData(PreparedStatement insertPs, ResultSetMetaData meta_data, Map row_data_map, String table_name) throws SQLException, UnsupportedEncodingException, BOSException {
        int col_count = meta_data.getColumnCount();
        block7: for (int col = 0; col < col_count; ++col) {
            String col_name = meta_data.getColumnName(col + 1);
            Object value = row_data_map.get(col_name.toUpperCase());
            int col_sql_type = meta_data.getColumnType(col + 1);
            switch (col_sql_type) {
                case 2004: {
                    if (value == null) {
                        insertPs.setNull(col + 1, 2004);
                        continue block7;
                    }
                    String ref_file_name = value.toString();
                    byte[] bytes = this.getBigObject(ref_file_name);
                    if (bytes == null) {
                        log.error((Object)(table_name + "\u4e2d\u7684\u5927\u6570\u636e\u5b57\u6bb5" + ref_file_name + "\u6ca1\u6709\u627e\u5230\u76f8\u5e94\u7684\u6570\u636e"));
                        throw new BOSException(table_name + "\u4e2d\u7684\u5927\u6570\u636e\u5b57\u6bb5" + ref_file_name + "\u6ca1\u6709\u627e\u5230\u76f8\u5e94\u7684\u6570\u636e");
                    }
                    insertPs.setBinaryStream(col + 1, (InputStream)new ByteArrayInputStream(bytes), bytes.length);
                    continue block7;
                }
                case 2005: {
                    if (value == null) {
                        insertPs.setNull(col + 1, 2005);
                        continue block7;
                    }
                    String ref_file_name = value.toString();
                    byte[] bytes = this.getBigObject(ref_file_name);
                    if (bytes == null) {
                        log.error((Object)(table_name + "\u4e2d\u7684\u5927\u6570\u636e\u5b57\u6bb5" + ref_file_name + "\u6ca1\u6709\u627e\u5230\u76f8\u5e94\u7684\u6570\u636e"));
                        throw new BOSException(table_name + "\u4e2d\u7684\u5927\u6570\u636e\u5b57\u6bb5" + ref_file_name + "\u6ca1\u6709\u627e\u5230\u76f8\u5e94\u7684\u6570\u636e");
                    }
                    insertPs.setString(col + 1, new String(bytes, "UTF-8"));
                    continue block7;
                }
                case 93: {
                    if (value == null || value.equals("")) {
                        insertPs.setNull(col + 1, 91);
                        continue block7;
                    }
                    try {
                        java.util.Date uDate = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss").parse(value.toString());
                        Date sDate = new Date(uDate.getTime());
                        insertPs.setDate(col + 1, sDate);
                        continue block7;
                    }
                    catch (ParseException e) {
                        log.error((Object)(table_name + "\u4e2d\u7684\u5b57\u6bb5" + col_name + "\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u5931\u8d25[date='" + value.toString() + "']"));
                        throw new BOSException(table_name + "\u4e2d\u7684\u5b57\u6bb5" + col_name + "\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u5931\u8d25[date='" + value.toString() + "']");
                    }
                }
                default: {
                    if (value == null || value.toString().equals("")) {
                        if (col_sql_type == 4 || col_sql_type == 2 || col_sql_type == 3 || col_sql_type == 6) {
                            insertPs.setInt(col + 1, 0);
                            continue block7;
                        }
                        insertPs.setNull(col + 1, 12);
                        continue block7;
                    }
                    insertPs.setObject(col + 1, value);
                }
            }
        }
    }

    private byte[] getBigObject(String ref_file_name) {
        List data_item_list = this.data.getFileObjectItems();
        for (int i = 0; i < data_item_list.size(); ++i) {
            FileObjectItem file_item;
            if (!(data_item_list.get(i) instanceof FileObjectItem) || !(file_item = (FileObjectItem)data_item_list.get(i)).getFileName().equals(ref_file_name)) continue;
            return file_item.getFileContext();
        }
        return null;
    }

    private ResultSetMetaData getResultSetMetaData(String table_name) throws SQLException {
        String sql = "select * from " + table_name + " where 1=2";
        PreparedStatement ps = this.con.prepareStatement(sql);
        ResultSet result = ps.executeQuery();
        ResultSetMetaData meta_data = result.getMetaData();
        return meta_data;
    }

    private String createInsertSql(ResultSetMetaData meta_data, String table_name) throws SQLException {
        int col;
        StringBuffer buf = new StringBuffer("INSERT INTO ");
        buf.append(table_name);
        buf.append(" (");
        int col_count = meta_data.getColumnCount();
        for (col = 1; col <= col_count; ++col) {
            buf.append(meta_data.getColumnName(col));
            if (col == col_count) {
                buf.append(") ");
                continue;
            }
            buf.append(",");
        }
        buf.append(" VALUES (");
        for (col = 1; col <= col_count; ++col) {
            buf.append("?");
            if (col == col_count) {
                buf.append(") ");
                continue;
            }
            buf.append(",");
        }
        return buf.toString();
    }

    public void executeBatch(String[] action_sql) throws BOSException {
        if (action_sql == null || action_sql.length == 0) {
            return;
        }
        Statement ps = null;
        try {
            ps = this.con.createStatement();
            for (int i = 0; i < action_sql.length; ++i) {
                ps.addBatch(action_sql[i]);
            }
            ps.executeBatch();
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Statement)ps);
        }
    }

    public void executeUpdate(String action_sql, Object[] params) throws BOSException {
        if (action_sql == null) {
            return;
        }
        PreparedStatement ps = null;
        try {
            ps = this.con.prepareStatement(action_sql);
            if (params != null) {
                for (int i = 0; i < params.length; ++i) {
                    ps.setObject(i + 1, params[i]);
                }
            }
            ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps);
    }

    public List getKeyIdsFromTable(String table_name, String key_col_name) throws SQLException {
        ArrayList<String> out = new ArrayList<String>();
        String sql = "select " + key_col_name + " from " + table_name;
        PreparedStatement ps = this.con.prepareStatement(sql);
        ResultSet result = ps.executeQuery();
        while (result.next()) {
            out.add(result.getObject(1).toString());
        }
        return out;
    }

    public static List getIDs(TableObjectItem table_item, String id_name) {
        ArrayList<String> out = new ArrayList<String>();
        id_name = id_name.toUpperCase();
        List list = table_item.getALlRowData();
        for (int i = 0; i < list.size(); ++i) {
            Map row_data = table_item.getRowData(i);
            if (!row_data.containsKey(id_name)) continue;
            out.add(row_data.get(id_name).toString());
        }
        return out;
    }

    public boolean existCU(String cu_id) {
        if (cu_id.equals("eThjryu4wEKoEK1veu3ZzDUlqpQ=")) {
            return true;
        }
        String sql = "select fid from T_ORG_CtrlUnit where fid ='" + cu_id + "'";
        try {
            IRowSet result = this.executeQuery(sql, null);
            return result.next();
        }
        catch (BOSException bOSException) {
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return false;
    }

    public void DelRepeatSql(DeleteTableInfo info) throws BOSException {
        ArrayList<String> del_sql = new ArrayList<String>();
        List data_list = this.data.getTableObjectItems();
        for (int i = 0; i < data_list.size(); ++i) {
            TableObjectItem table_item;
            String table_name;
            if (!(data_list.get(i) instanceof TableObjectItem) || !info.canDelete(table_name = (table_item = (TableObjectItem)data_list.get(i)).getTableName())) continue;
            String key = info.getKeyId(table_name);
            String sql = "delete  " + table_item.getTableName() + " where " + key + " in ( ";
            List id_list = AbstractImportData.getIDs(table_item, key);
            if (id_list.size() <= 0) continue;
            for (int idx = 0; idx < id_list.size(); ++idx) {
                sql = info.getKeyValueType(table_name).equals("String") ? sql + "'" + id_list.get(idx) + "'" : sql + id_list.get(idx);
                if (idx == id_list.size() - 1) continue;
                sql = sql + " , ";
            }
            sql = sql + " ) ";
            del_sql.add(sql);
        }
        if (del_sql.size() > 0) {
            String[] del_action = new String[del_sql.size()];
            del_sql.toArray(del_action);
            this.executeBatch(del_action);
        }
    }

    static abstract class DeleteTableInfo {
        DeleteTableInfo() {
        }

        abstract boolean canDelete(String var1);

        abstract String getKeyId(String var1);

        String getKeyValueType(String table_name) {
            return "String";
        }
    }
}

