/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.ide.migration.help;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.base.form.ide.migration.help.AbstractImportData;
import com.kingdee.eas.base.form.ide.migration.importdata.Import;
import com.kingdee.eas.base.form.ide.migration.model.TableObjectItem;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class EnumTypeDataImport
extends AbstractImportData {
    private static final String FVALUE = "FVALUE";
    private static final String FENUMID = "FENUMID";
    private String[] names = new String[]{"T_BAS_FormEnum", "T_BAS_FormEnumItem"};

    @Override
    public boolean executeImportData() throws SQLException, BOSException {
        if (this.import_mode.equals(Import.OVER_WRITE)) {
            this.DelRepeatSql(new AbstractImportData.DeleteTableInfo(){

                @Override
                public boolean canDelete(String table_name) {
                    for (int i = 0; i < EnumTypeDataImport.this.names.length; ++i) {
                        if (!table_name.equalsIgnoreCase(EnumTypeDataImport.this.names[i])) continue;
                        return true;
                    }
                    return false;
                }

                @Override
                public String getKeyId(String table_name) {
                    return "FID";
                }

                @Override
                String getKeyValueType(String table_name) {
                    if ("T_BAS_FormEnum".equalsIgnoreCase(table_name)) {
                        return "int";
                    }
                    return "String";
                }
            });
            this.deleteFormEnumItemFromDB();
        } else {
            this.deleteFormEnumFromData();
            this.DelRepeatSql(new AbstractImportData.DeleteTableInfo(){

                @Override
                public boolean canDelete(String table_name) {
                    return table_name.equalsIgnoreCase("T_BAS_FormEnumItem");
                }

                @Override
                public String getKeyId(String table_name) {
                    return "FID";
                }
            });
            this.filterFormEnumRecordFromData();
        }
        this.insertEnumTypeData();
        return true;
    }

    private Map getFormEnumItemValueFromDB() throws BOSException, SQLException {
        HashMap map = new HashMap();
        TableObjectItem item = this.getTableObjectItemByName("T_BAS_FormEnum");
        List ids = EnumTypeDataImport.getIDs(item, "FID");
        if (ids.size() > 0) {
            String param = "";
            for (int i = 0; i < ids.size(); ++i) {
                param = param + ids.get(i);
                if (i == ids.size() - 1) continue;
                param = param + ",";
            }
            String sql = "select distinct fenumid,fvalue from T_BAS_FormEnumItem where fenumid in (" + param + ")";
            IRowSet result = this.executeQuery(sql, null);
            while (result.next()) {
                String fenumid = result.getObject(1).toString();
                if (!map.containsKey(fenumid)) {
                    map.put(fenumid, new ArrayList());
                }
                ((ArrayList)map.get(fenumid)).add(result.getObject(2).toString());
            }
        }
        return map;
    }

    private void deleteFormEnumItemFromDB() throws BOSException, SQLException {
        String sql = "delete T_BAS_FormEnumItem where fenumid=? and fvalue=?";
        Object[] params = new Object[2];
        TableObjectItem item = this.getTableObjectItemByName("T_BAS_FormEnumItem");
        if (item != null) {
            Iterator iter = item.getAllRowDataIterator();
            while (iter.hasNext()) {
                Map row_data = (Map)iter.next();
                params[0] = Integer.valueOf(row_data.get(FENUMID).toString());
                params[1] = Integer.valueOf(row_data.get(FVALUE).toString());
                this.executeUpdate(sql, params);
            }
        }
    }

    private void deleteFormEnumFromData() throws BOSException, SQLException {
        Map enumid_itemvalue;
        TableObjectItem item = this.getTableObjectItemByName("T_BAS_FormEnumItem");
        if (item != null && (enumid_itemvalue = this.getFormEnumItemValueFromDB()).size() > 0) {
            Iterator iter = item.getAllRowDataIterator();
            while (iter.hasNext()) {
                Map row_data = (Map)iter.next();
                String fenujid = row_data.get(FENUMID).toString();
                if (!enumid_itemvalue.containsKey(fenujid)) continue;
                String fvalue = row_data.get(FVALUE).toString();
                if (!((ArrayList)enumid_itemvalue.get(fenujid)).contains(fvalue)) continue;
                iter.remove();
            }
        }
    }

    private void filterFormEnumRecordFromData() throws BOSException, SQLException {
        TableObjectItem item = this.getTableObjectItemByName("T_BAS_FormEnum");
        if (item != null) {
            List ids = EnumTypeDataImport.getIDs(item, "FID");
            String param = "";
            if (ids != null && ids.size() > 0) {
                for (int i = 0; i < ids.size(); ++i) {
                    param = param + ids.get(i);
                    if (i == ids.size() - 1) continue;
                    param = param + ",";
                }
                String sql = "select fid from T_BAS_FormEnum where fid in (" + param + ")";
                IRowSet result = this.executeQuery(sql, null);
                ArrayList<String> enum_exist_ids = new ArrayList<String>();
                while (result.next()) {
                    enum_exist_ids.add(result.getObject(1).toString());
                }
                if (enum_exist_ids.size() > 0) {
                    Iterator iter = item.getAllRowDataIterator();
                    while (iter.hasNext()) {
                        Map row_data = (Map)iter.next();
                        String enum_id = row_data.get("FID").toString();
                        if (!enum_exist_ids.contains(enum_id)) continue;
                        iter.remove();
                    }
                }
            }
        }
    }

    private void insertEnumTypeData() throws BOSException {
        List data_list = this.data.getTableObjectItems();
        for (int i = 0; i < data_list.size(); ++i) {
            if (!(data_list.get(i) instanceof TableObjectItem)) continue;
            TableObjectItem table_item = (TableObjectItem)data_list.get(i);
            try {
                this.insertTableObjectToDB(table_item);
                continue;
            }
            catch (Exception e) {
                log.error((Object)e);
                throw new BOSException("\u63d2\u5165\u679a\u4e3e\u6570\u636e\u5931\u8d25" + e.getMessage());
            }
        }
    }
}

