/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.ide.migration.help;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.base.form.ide.migration.help.AbstractImportData;
import com.kingdee.eas.base.form.ide.migration.help.TableReaderProvider;
import com.kingdee.eas.base.form.ide.migration.model.TableObjectItem;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class FlowTemplateDataImport
extends AbstractImportData {
    private static final String USER_ID = "user_id";
    private static final String FLASTUPDATEUSERID = "FLASTUPDATEUSERID";
    private static final String FCREATORID = "FCREATORID";
    private static final String FCONTROLUNITID = "FCONTROLUNITID";
    private static final String FLOGINCUID = "FLOGINCUID";
    private HashMap cache = new HashMap();
    private static final String[] user_key = new String[]{"FCREATORID", "FLASTUPDATEUSERID"};
    private static final String[] cu_key = new String[]{"FLOGINCUID", "FCONTROLUNITID"};
    String root_cu_id = "00000000-0000-0000-0000-000000000000CCE7AED4";

    @Override
    public boolean executeImportData() throws SQLException, BOSException {
        this.cache.clear();
        this.editFlowTemplateData();
        this.editTemplateTable();
        this.deleteUnnecessaryTableData();
        this.DelRepeatSql(new AbstractImportData.DeleteTableInfo(){

            @Override
            public boolean canDelete(String table_name) {
                return true;
            }

            @Override
            public String getKeyId(String table_name) {
                return "FID";
            }
        });
        this.insertFlowTemplateData();
        return true;
    }

    private void deleteUnnecessaryTableData() throws SQLException, BOSException {
        List id_list;
        ArrayList<String> sql_array = new ArrayList<String>();
        String sql = "";
        String name = "T_BAS_Template";
        String params = "";
        TableObjectItem table_item = this.getTableObjectItemByName(name);
        if (table_item != null) {
            id_list = FlowTemplateDataImport.getIDs(table_item, "FID");
            params = TableReaderProvider.getSqlParamString(id_list, true, null);
            sql = "delete T_BAS_TemplateWorkFlow where fparentid in (" + params + ")";
            sql_array.add(sql);
            sql = "delete T_BAS_SignValidConfig where ftemplateid in (" + params + ")";
            sql_array.add(sql);
            sql = "delete T_BAS_BoAttchAsso where fboid in  (" + params + ")";
            sql_array.add(sql);
            sql = "delete T_BAS_BillAttachment where fbillid in  (" + params + ")";
            sql_array.add(sql);
            name = "T_BAS_SignValidConfig";
            table_item = this.getTableObjectItemByName(name);
            if (table_item != null) {
                id_list = FlowTemplateDataImport.getIDs(table_item, "FID");
                params = TableReaderProvider.getSqlParamString(id_list, true, null);
                sql = "delete T_BAS_SignValidField where fparentid in (" + params + ")";
                sql_array.add(sql);
            }
        }
        if ((table_item = this.getTableObjectItemByName(name = "T_BAS_BoAttchAsso")) != null) {
            id_list = FlowTemplateDataImport.getIDs(table_item, "FAttachmentID");
            params = TableReaderProvider.getSqlParamString(id_list, true, null);
            sql = "delete T_BAS_Attachment where fid in (" + params + ")";
            sql_array.add(sql);
        }
        String[] entry_table = new String[]{"T_BAS_OfficeControlEntry", "T_BAS_FlowNCtlCEnt", "T_BAS_FlowNCtlFEnt", "T_BAS_FlowNCtlOEnt"};
        name = "T_BAS_FlowNodeCtrl";
        table_item = this.getTableObjectItemByName(name);
        if (table_item != null) {
            id_list = FlowTemplateDataImport.getIDs(table_item, "FID");
            params = TableReaderProvider.getSqlParamString(id_list, true, null);
            for (int i = 0; i < entry_table.length; ++i) {
                sql = "delete " + entry_table[i] + " where fparentid in ( " + params + " )";
                sql_array.add(sql);
            }
        }
        if (sql_array.size() > 0) {
            String[] acton_sql = new String[sql_array.size()];
            sql_array.toArray(acton_sql);
            try {
                this.executeBatch(acton_sql);
            }
            catch (BOSException e) {
                throw new BOSException("\u5220\u9664\u6d41\u7a0b\u6a21\u677f\u8bbe\u7f6e\u6570\u636e\u5931\u8d25", e.getCause());
            }
        }
    }

    private void deleteTemplateWorkFlow() throws BOSException {
        TableObjectItem item = this.getTableObjectItemByName("T_BAS_TemplateWorkFlow");
        final ArrayList sqls = new ArrayList();
        String del = "delete T_BAS_TemplateWorkFlow where ";
        if (item != null) {
            item.visitRowData(new TableObjectItem.VisistData(){

                @Override
                public void handleData(Map row_data) {
                    String sql = " FFLOWID='" + row_data.get("FFLOWID") + "' and  FPARENTID='" + row_data.get("FPARENTID") + "' ";
                    sqls.add("delete T_BAS_TemplateWorkFlow where " + sql);
                }
            });
        }
        if (sqls.size() > 0) {
            String[] update_sqls = new String[sqls.size()];
            sqls.toArray(update_sqls);
            this.executeBatch(update_sqls);
        }
    }

    private void insertFlowTemplateData() throws BOSException {
        List data_list = this.data.getItems();
        for (int i = 0; i < data_list.size(); ++i) {
            if (!(data_list.get(i) instanceof TableObjectItem)) continue;
            TableObjectItem table_item = (TableObjectItem)data_list.get(i);
            try {
                this.insertTableObjectToDB(table_item);
                continue;
            }
            catch (Exception e) {
                log.error((Object)e);
                throw new BOSException("\u63d2\u5165\u6d41\u7a0b\u6a21\u677f\u8bbe\u7f6e\u5931\u8d25[" + table_item.getTableName() + "], " + e.getMessage());
            }
        }
    }

    private List getSortTemplateList() {
        ArrayList<Map> list = new ArrayList<Map>();
        TableObjectItem item = this.getTableObjectItemByName("T_BAS_Template");
        if (item != null) {
            Iterator iter = item.getAllRowDataIterator();
            while (iter.hasNext()) {
                String cu_id;
                Map row_data = (Map)iter.next();
                if (row_data.containsKey(FCONTROLUNITID) && (cu_id = row_data.get(FCONTROLUNITID).toString()).equals("eThjryu4wEKoEK1veu3ZzDUlqpQ=")) {
                    list.add(0, row_data);
                    continue;
                }
                list.add(row_data);
            }
        }
        return list;
    }

    private boolean replaceCuId(Map row_data) {
        boolean is_replace = false;
        for (int idx = 0; idx < cu_key.length; ++idx) {
            String key = cu_key[idx];
            if (!row_data.containsKey(key)) continue;
            String cu_id = row_data.get(key).toString();
            if (this.cache.containsKey(cu_id)) {
                is_replace = true;
                row_data.put(key, this.cache.get(cu_id).toString());
                continue;
            }
            if (cu_id.trim().equals("") || this.existCU(cu_id)) continue;
            String cuid = this.import_config.get("person_cu_id").toString();
            row_data.put(key, cuid);
            this.cache.put(cu_id, cuid);
            is_replace = true;
        }
        return is_replace;
    }

    private boolean replaceUserId(Map row_data) {
        boolean is_replace = false;
        for (int idx = 0; idx < user_key.length; ++idx) {
            String key = user_key[idx];
            if (!row_data.containsKey(key)) continue;
            String user_id = row_data.get(key).toString();
            if (this.cache.containsKey(user_id)) {
                row_data.put(key, this.cache.get(user_id));
                is_replace = true;
                continue;
            }
            if (user_id.trim().equals("") || this.isExistUser(user_id)) continue;
            row_data.put(key, this.import_config.get(USER_ID));
            this.cache.put(user_id, this.import_config.get(USER_ID));
            is_replace = true;
        }
        return is_replace;
    }

    private boolean findMatchTemplateTableWithCu() {
        final ArrayList list = new ArrayList();
        TableObjectItem item = this.getTableObjectItemByName("T_BAS_Template");
        if (item != null) {
            item.visitRowData(new TableObjectItem.VisistData(){

                @Override
                public void handleData(Map row_data) {
                    boolean out = true;
                    for (int i = 0; i < cu_key.length; ++i) {
                        String cu_id;
                        if (!row_data.containsKey(cu_key[i]) || FlowTemplateDataImport.this.existCU(cu_id = row_data.get(cu_key[i]).toString())) continue;
                        out = false;
                        break;
                    }
                    list.add(out ? Boolean.TRUE : Boolean.FALSE);
                }
            });
        }
        return list.contains(Boolean.TRUE);
    }

    private void editTemplateTable() {
        boolean handle_data = false;
        boolean match_cu = this.findMatchTemplateTableWithCu();
        int count = 0;
        Iterator iter = this.getSortTemplateList().iterator();
        while (iter.hasNext()) {
            Map row_data = (Map)iter.next();
            this.replaceUserId(row_data);
            if (!this.replaceCuId(row_data)) continue;
            if (count != 0 && (match_cu || handle_data)) {
                Iterator it = this.getTableObjectItemByName("T_BAS_Template").getAllRowDataIterator();
                while (it.hasNext()) {
                    Map data = (Map)it.next();
                    if (!data.get("FID").toString().equals(row_data.get("FID").toString())) continue;
                    it.remove();
                    break;
                }
                iter.remove();
                continue;
            }
            ++count;
            handle_data = true;
        }
    }

    private void editFlowTemplateData() throws BOSException, SQLException {
        String[] names = new String[]{"T_BAS_BillAttachment", "T_BAS_FlowNodeCtrl", "T_BAS_Attachment", "T_BAS_TemplateType", "T_BAS_SignValidField", "T_BAS_SignValidConfig"};
        for (int i = 0; i < names.length; ++i) {
            TableObjectItem item = this.getTableObjectItemByName(names[i]);
            if (item == null) continue;
            Iterator iter = item.getAllRowDataIterator();
            while (iter.hasNext()) {
                Map row_data = (Map)iter.next();
                this.replaceCuId(row_data);
                this.replaceUserId(row_data);
            }
        }
    }
}

