/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.ide.migration.help;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.eas.base.form.ide.migration.help.AbstractImportData;
import com.kingdee.eas.base.form.ide.migration.model.TableObjectItem;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class FormDataImport
extends AbstractImportData {
    private static final String FISCREATE = "FISCREATE";
    private static final String FUSERID = "FUSERID";
    public static final String[] table_names = new String[]{"T_BAS_FormTopClass", "T_BAS_FormSubsystem", "T_BAS_BarItemLink", "T_BAS_BarItem", "T_BAS_FormMenuScheme", "T_BAS_FCEntry", "T_BAS_FormContainerLayout", "T_BAS_FormLayoutTabPage", "T_BAS_FormLayoutCtrl", "T_BAS_FormLayoutField", "T_BAS_FormLayoutEntity", "T_CON_EntityPKMapping", "T_CON_DynamicMetadata", "T_EP_CustomizedUnit", "T_BAS_Form", "T_BAS_FormField", "T_BAS_FormEntity", "T_BAS_FormActionList", "T_BAS_FormLayout", "T_BAS_Form_Permission", "T_BAS_Form_Notes", "T_BAS_FormTableLayoutStyle", "T_BAS_FormOperation", "T_BAS_FormMenu", "T_BAS_FormPlugin", "T_BAS_FormExtProperty", "T_BAS_FormEventPm", "T_BAS_FormCondition", "T_BAS_BaseTableInfo", "T_BAS_ComPageSet"};

    @Override
    public boolean executeImportData() throws BOSException {
        this.deleteOldTableData();
        this.updateFormPermissionTableData();
        this.deleteRepeatMetaData();
        try {
            this.insertFormTableData();
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return true;
    }

    private void deleteRepeatMetaData() throws BOSException {
        ArrayList<String> del_sql = new ArrayList<String>();
        List data_list = this.data.getTableObjectItems();
        for (int i = 0; i < data_list.size(); ++i) {
            TableObjectItem table_item;
            if (!(data_list.get(i) instanceof TableObjectItem) || !(table_item = (TableObjectItem)data_list.get(i)).getTableName().equalsIgnoreCase("T_CON_EntityPKMapping") && !table_item.getTableName().equalsIgnoreCase("T_CON_DynamicMetadata") && !table_item.getTableName().equalsIgnoreCase("T_EP_CustomizedUnit")) continue;
            String sql = "delete  " + table_item.getTableName() + " where fid in ( ";
            List id_list = FormDataImport.getIDs(table_item, "FID");
            if (id_list.size() <= 0) continue;
            for (int idx = 0; idx < id_list.size(); ++idx) {
                sql = sql + "'" + id_list.get(idx) + "'";
                if (idx == id_list.size() - 1) continue;
                sql = sql + " , ";
            }
            sql = sql + " ) ";
            del_sql.add(sql);
        }
        if (del_sql.size() > 0) {
            String[] del_action = new String[del_sql.size()];
            del_sql.toArray(del_action);
            this.executeBatch(del_action);
        }
    }

    private void updateFormPermissionTableData() {
        if (!this.isExistTable("t_bas_form_permission")) {
            return;
        }
        List data_list = this.data.getTableObjectItems();
        for (int i = 0; i < data_list.size(); ++i) {
            TableObjectItem table_item;
            if (!(data_list.get(i) instanceof TableObjectItem) || !(table_item = (TableObjectItem)data_list.get(i)).getTableName().equalsIgnoreCase("t_bas_form_permission")) continue;
            Iterator all_row_iter = table_item.getAllRowDataIterator();
            while (all_row_iter.hasNext()) {
                Map row_data = (Map)all_row_iter.next();
                int is_create = Integer.parseInt(row_data.get(FISCREATE).toString());
                String person_id = row_data.get(FUSERID).toString();
                boolean has_exist_person = this.isExistPerson(person_id);
                if (is_create == 1) {
                    if (has_exist_person || !this.import_config.containsKey("person_id")) continue;
                    row_data.put(FUSERID, this.import_config.get("person_id"));
                    continue;
                }
                if (has_exist_person) continue;
                all_row_iter.remove();
            }
            break;
        }
    }

    private void insertFormTableData() throws UnsupportedEncodingException, BOSException, SQLException {
        List data_list = this.data.getTableObjectItems();
        for (int i = 0; i < data_list.size(); ++i) {
            TableObjectItem table_item;
            if (!(data_list.get(i) instanceof TableObjectItem) || !this.canImport(table_item = (TableObjectItem)data_list.get(i)) || !this.isExistTable(table_item.getTableName())) continue;
            this.deleteRecore(table_item);
            try {
                this.insertTableObjectToDB(table_item);
                continue;
            }
            catch (SQLException e) {
                throw new SQLException(table_item.getTableName() + "\u8868\u63d2\u5165\u6570\u636e\u9519\u8bef ," + e.getMessage());
            }
        }
    }

    private boolean canImport(TableObjectItem table_item) {
        ArrayList<String> no_import_table_names = new ArrayList<String>();
        no_import_table_names.add("T_BAS_FormTopClass".toLowerCase());
        no_import_table_names.add("T_BAS_FormSubsystem".toLowerCase());
        return !no_import_table_names.contains(table_item.getTableName().toLowerCase());
    }

    private void deleteRecore(TableObjectItem table_item) throws BOSException {
        String table_name = table_item.getTableName();
        if ("T_BAS_FCEntry".equalsIgnoreCase(table_name)) {
            ArrayList<String> ids = new ArrayList<String>();
            List row_date_set = table_item.getALlRowData();
            for (int i = 0; i < row_date_set.size(); ++i) {
                Map row_data = (Map)row_date_set.get(i);
                ids.add(row_data.get("FID").toString());
            }
            if (ids.size() > 0) {
                String param = "";
                for (int i = 0; i < ids.size(); ++i) {
                    param = param + "'" + ids.get(i).toString() + "'";
                    if (i == ids.size() - 1) continue;
                    param = param + ",";
                }
                String sql = "delete T_BAS_FCEntry where fid in (" + param + ")";
                this.executeBatch(new String[]{sql});
            }
        }
    }

    private void deleteOldTableData() throws BOSException {
        String[] table_names = FormDataImport.table_names;
        ArrayList<String> sql_array = new ArrayList<String>();
        for (int i = 0; i < table_names.length; ++i) {
            String sql;
            if (!this.isExistTable(table_names[i]) || StringUtils.isEmpty((String)(sql = this.getDeleteSqlWithTable(table_names[i])))) continue;
            String[] sqls = sql.split(";");
            for (int idx = 0; idx < sqls.length; ++idx) {
                sql_array.add(sqls[idx]);
            }
        }
        if (sql_array.size() > 0) {
            String[] acton_sql = new String[sql_array.size()];
            sql_array.toArray(acton_sql);
            try {
                this.executeBatch(acton_sql);
            }
            catch (BOSException e) {
                throw new BOSException("\u5220\u9664\u8868\u6570\u636e\u5931\u8d25", e.getCause());
            }
        }
    }

    public String getDeleteSqlWithTable(String table_name) {
        String del_sql = "delete " + table_name;
        if ("T_BAS_FormSubsystem".equalsIgnoreCase(table_name)) {
            del_sql = "";
        } else if ("T_BAS_FormTopClass".equalsIgnoreCase(table_name)) {
            del_sql = "";
        } else if ("T_BAS_BarItemLink".equalsIgnoreCase(table_name)) {
            del_sql = del_sql + " where FMenuId in ( select FMenuId from T_BAS_FormMenu where fformid='" + this.form_id + "')";
        } else if ("T_BAS_BarItem".equalsIgnoreCase(table_name)) {
            del_sql = del_sql + " where FMenuId in ( select FMenuId from T_BAS_FormMenu where fformid='" + this.form_id + "')";
        } else if ("T_BAS_FormMenuScheme".equalsIgnoreCase(table_name)) {
            del_sql = del_sql + " where FID in ( select FMenuId from T_BAS_FormMenu where fformid='" + this.form_id + "')";
        } else if ("T_BAS_FCEntry".equalsIgnoreCase(table_name)) {
            del_sql = "delete  T_BAS_FCEntry where FParentId in ( select fid from T_BAS_FormCondition  where FFormID='" + this.form_id + "') ;";
            del_sql = del_sql + "delete T_BAS_FCEntry where FParentId in ( select fid from T_BAS_FormActionList where FFormID='" + this.form_id + "')";
        } else {
            del_sql = "T_BAS_FormContainerLayout".equalsIgnoreCase(table_name) || "T_BAS_FormLayoutTabPage".equalsIgnoreCase(table_name) || "T_BAS_FormLayoutCtrl".equalsIgnoreCase(table_name) || "T_BAS_FormLayoutField".equalsIgnoreCase(table_name) || "T_BAS_FormLayoutEntity".equalsIgnoreCase(table_name) ? del_sql + " where FLayoutID IN ( SELECT FID FROM T_BAS_FormLayout where FFormID='" + this.form_id + "')" : ("T_CON_EntityPKMapping".equalsIgnoreCase(table_name) || "T_CON_DynamicMetadata".equalsIgnoreCase(table_name) || "T_EP_CustomizedUnit".equalsIgnoreCase(table_name) ? "" : ("T_BAS_Form_Permission".equalsIgnoreCase(table_name) || "T_BAS_Form_Notes".equalsIgnoreCase(table_name) ? del_sql + " where fid ='" + this.form_id + "'" : ("T_BAS_Form".equalsIgnoreCase(table_name) ? del_sql + " where fid ='" + this.form_id + "'" : "delete  " + table_name + " where fformid='" + this.form_id + "'")));
        }
        return del_sql;
    }
}

