/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.ide.migration.help;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.form.ide.migration.help.DbTableAccessFactory;
import com.kingdee.eas.base.form.ide.migration.help.DomHelp;
import com.kingdee.eas.base.form.ide.migration.help.FormModelBuilder;
import com.kingdee.eas.base.form.ide.migration.help.ZipHelp;
import com.kingdee.eas.base.form.ide.migration.model.DataModel;
import com.kingdee.eas.base.form.ide.migration.model.DataType;
import com.kingdee.eas.base.form.ide.migration.model.FileObjectItem;
import com.kingdee.eas.base.form.ide.migration.model.IData;
import com.kingdee.eas.base.form.ide.migration.model.TableObjectItem;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.jdbc.rowset.IRowSet;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;

public class PackageManager {
    private static final String PERSON_CU_ID = "person_cu_id";
    private static final String USER_ID = "user_id";
    public static final String PERSON_ID = "person_id";
    public static final String VERSION = "version";
    public static final String REQUIRE_TOOL_VERSION = "require_tool_version";
    public static final String SUB_SYSTEM_NAME = "sub_system_name";
    public static final String SUB_SYSTEM_ID = "sub_system_id";
    public static final String FORM_NAME = "form_name";
    public static final String FORM_ID = "form_id";
    public static final Logger logger = CoreUIObject.getLogger(PackageManager.class);
    public static final String CONFIG_FILE_NAME = "config.xml";

    public boolean zip(String form_id, String save_file_name, List exclude__list) throws BOSException, SQLException {
        FormModelBuilder form_builder = new FormModelBuilder(form_id);
        DataType[] types = new DataType[]{DataType.FormDataType, DataType.UserDefDataType, DataType.BaseDataType, DataType.EnumTypeDataType, DataType.PrintDataType, DataType.FlowTempDataType, DataType.WorkflowDataType, DataType.FormImgDataType};
        for (int i = 0; i < types.length; ++i) {
            if (exclude__list.contains(types[i])) continue;
            this.buildData(form_builder, types[i]);
        }
        DataModel model = form_builder.getModel();
        if (model == null || model.getDataCount() == 0) {
            return false;
        }
        String sql = "select * from t_bas_form where fid='" + form_id + "'";
        IRowSet result = DbTableAccessFactory.getDbTableAccessInstance(null).queryTable(sql, null);
        if (result.first()) {
            model.setSubSystemID(result.getString("fsubsysid"));
            model.setFormId(form_id);
            model.setFormName(result.getString("fname_l2"));
            sql = "select fname_l2 from T_BAS_FormSubsystem where fsubsysid = '" + model.getSubSystemID() + "'";
            result = DbTableAccessFactory.getDbTableAccessInstance(null).queryTable(sql, null);
            if (result.first()) {
                model.setSub_system_name(result.getString(1));
            }
        }
        try {
            this.createZipFile(model, save_file_name);
        }
        catch (IOException e) {
            logger.error((Object)e);
            throw new BOSException("\u6570\u636e\u6253\u5305\u9519\u8bef");
        }
        return true;
    }

    private void buildData(FormModelBuilder form_builder, DataType data_type) throws BOSException {
        try {
            if (DataType.FormDataType == data_type) {
                form_builder.buildFormData();
            }
            if (DataType.BaseDataType == data_type) {
                form_builder.buildBaseData();
            }
            if (DataType.EnumTypeDataType == data_type) {
                form_builder.buildEnumTypeData();
            }
            if (DataType.FlowTempDataType == data_type) {
                form_builder.buildFlowTemplateData();
            }
            if (DataType.PrintDataType == data_type) {
                form_builder.buildPrintData();
            }
            if (DataType.UserDefDataType == data_type) {
                form_builder.buildUserDefinedData();
            }
            if (DataType.WorkflowDataType == data_type) {
                form_builder.buildWorkFlowData();
            }
            if (DataType.FormImgDataType == data_type) {
                form_builder.buildFormImgData();
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException("\u6784\u5efa" + data_type.toString() + "\u9519\u8bef");
        }
    }

    public DataModel parse(String zip_file_name) throws IOException, JDOMException, BOSException {
        DataModel model = new DataModel();
        int BUFFER = 2048;
        ZipFile zipFile = new ZipFile(zip_file_name);
        Enumeration<? extends ZipEntry> emu = zipFile.entries();
        SAXBuilder buider = new SAXBuilder();
        while (emu.hasMoreElements()) {
            int count;
            IData data;
            String data_name;
            Document dom;
            ZipEntry entry = emu.nextElement();
            if (entry.isDirectory()) continue;
            String name = entry.getName();
            if (CONFIG_FILE_NAME.equals(name)) {
                dom = buider.build(zipFile.getInputStream(entry));
                Map config = this.extractConfigInfo(dom);
                PersonInfo current_person = SysContext.getSysContext().getCurrentUserInfo().getPerson();
                String person_id = "";
                String person_cu_id = "";
                try {
                    person_id = current_person.getId().toString();
                    ObjectUuidPK person_pk = new ObjectUuidPK(person_id);
                    PersonInfo info = PersonFactory.getRemoteInstance().getPersonInfo((IObjectPK)person_pk);
                    person_cu_id = info.getCU().getId().toString();
                }
                catch (EASBizException person_pk) {
                    // empty catch block
                }
                model.getConfig().put(USER_ID, SysContext.getSysContext().getCurrentUserInfo().getId().toString());
                model.getConfig().put(PERSON_CU_ID, person_cu_id);
                model.getConfig().put(PERSON_ID, person_id);
                if (config.containsKey(FORM_ID)) {
                    model.setFormId(config.get(FORM_ID).toString());
                }
                if (config.containsKey(FORM_NAME)) {
                    model.setFormName(config.get(FORM_NAME).toString());
                }
                if (config.containsKey(SUB_SYSTEM_ID)) {
                    model.setSubSystemID(config.get(SUB_SYSTEM_ID).toString());
                }
                if (config.containsKey(SUB_SYSTEM_NAME)) {
                    model.setSub_system_name(config.get(SUB_SYSTEM_NAME).toString());
                }
                if (config.containsKey(REQUIRE_TOOL_VERSION)) {
                    model.getConfig().put(REQUIRE_TOOL_VERSION, config.get(REQUIRE_TOOL_VERSION).toString());
                }
                if (!config.containsKey(VERSION)) continue;
                model.getConfig().put(VERSION, config.get(VERSION).toString());
                continue;
            }
            if (name.endsWith(".xml")) {
                data_name = name.substring(0, name.length() - ".xml".length());
                if (model.getData(data_name) != null) continue;
                data = this.createDataWithName(data_name);
                dom = buider.build(zipFile.getInputStream(entry));
                model.addData(data);
                this.fillDataFromDom(data, dom);
                continue;
            }
            int pos = name.indexOf(46);
            if (pos == -1) {
                throw new BOSException("\u65e0\u6cd5\u8bc6\u522b\u7684\u6570\u636e\u6587\u4ef6" + name);
            }
            data_name = name.substring(pos + 1);
            String file_name = name.substring(0, pos);
            data = model.getData(data_name);
            if (data == null) {
                data = this.createDataWithName(data_name);
                model.addData(data);
            }
            FileObjectItem file_item = new FileObjectItem(file_name);
            InputStream input_stream = zipFile.getInputStream(entry);
            ByteArrayOutputStream output_stream = new ByteArrayOutputStream();
            byte[] temp = new byte[BUFFER];
            while ((count = input_stream.read(temp, 0, BUFFER)) != -1) {
                output_stream.write(temp, 0, count);
            }
            file_item.setContext(output_stream.toByteArray());
            data.addItem(file_item);
        }
        zipFile.close();
        return model;
    }

    private void fillDataFromDom(IData data, Document dom) {
        Element root = dom.getRootElement();
        List list = root.getChildren();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Element ele = DomHelp.converElement(iter.next());
            if (ele == null) continue;
            TableObjectItem table_item = new TableObjectItem(ele.getAttributeValue("name"));
            data.addItem(table_item);
            Iterator row_iter = ele.getChildren().iterator();
            while (row_iter.hasNext()) {
                Element row_ele = DomHelp.converElement(row_iter.next());
                if (row_ele == null) continue;
                HashMap<String, String> map = new HashMap<String, String>();
                List property_list = row_ele.getChildren();
                for (int i = 0; i < property_list.size(); ++i) {
                    if (!(property_list.get(i) instanceof Element)) continue;
                    Element prop_ele = (Element)property_list.get(i);
                    map.put(prop_ele.getName().toUpperCase(), prop_ele.getText());
                }
                table_item.addRowData(map);
            }
        }
    }

    private IData createDataWithName(String data_name) throws BOSException {
        String class_name = IData.class.getPackage().getName() + "." + data_name;
        try {
            Object obj = Class.forName(class_name).newInstance();
            if (obj instanceof IData) {
                return (IData)obj;
            }
            throw new BOSException("\u7cfb\u7edf\u65e0\u6cd5\u8bc6\u522b\u7684\u6587\u4ef6. " + data_name + ".xml");
        }
        catch (Exception e) {
            throw new BOSException("\u521b\u5efa\u5bf9\u8c61\u5931\u8d25. " + class_name);
        }
    }

    private void createZipFile(DataModel model, String save_file_name) throws IOException {
        ZipHelp zip_help = new ZipHelp(save_file_name);
        IData[] data_array = model.getDataArray();
        for (int i = 0; i < data_array.length; ++i) {
            IData data = data_array[i];
            Document dom = DomHelp.createDocument(data);
            String file_name = data.getName() + ".xml";
            zip_help.addDocument(file_name, dom);
            if (data.getItems().size() <= 0) continue;
            for (int idx = 0; idx < data.getItems().size(); ++idx) {
                if (!(data.getItems().get(idx) instanceof FileObjectItem)) continue;
                FileObjectItem file_item = (FileObjectItem)data.getItems().get(idx);
                zip_help.addFile(file_item.getFileName() + "." + data.getName(), file_item.getFileContext());
            }
        }
        Document config_dom = DomHelp.createConfigInfo(model);
        if (config_dom != null) {
            zip_help.addDocument(CONFIG_FILE_NAME, config_dom);
        }
        zip_help.save();
    }

    private Map extractConfigInfo(Document dom) {
        List list = dom.getRootElement().getChildren();
        HashMap<String, String> map = new HashMap<String, String>();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Element child_ele = DomHelp.converElement(iter.next());
            if (child_ele == null) continue;
            map.put(child_ele.getName(), child_ele.getText());
        }
        return map;
    }

    public boolean hasExistSubSystemId(String sub_system_id) throws BOSException, SQLException {
        String sql = "select fsubsysid from T_BAS_FormSubsystem where fsubsysid='" + sub_system_id + "'";
        IRowSet result = DbTableAccessFactory.getDbTableAccessInstance(null).queryTable(sql, null);
        return result.next();
    }
}

