/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.ide.migration.help;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.form.ide.migration.help.ITableReader;
import com.kingdee.eas.dynbusiness.util.DBUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TableReaderFactory {
    private static final Log log = LogFactory.getLog(DefaultTableReader.class);
    private static ITableReader default_reader = new DefaultTableReader();
    private static HashMap regist_reader = new HashMap();

    public static void registReader(String table_name, ITableReader reader) {
        regist_reader.put(table_name, reader);
    }

    public static ITableReader getTableReader(String table_name) {
        if (regist_reader.containsKey(table_name) && regist_reader.get(table_name) instanceof ITableReader) {
            return (ITableReader)regist_reader.get(table_name);
        }
        return default_reader;
    }

    public static List RowSetToMap(IRowSet row_set) throws SQLException, IOException {
        ArrayList result = new ArrayList();
        while (row_set.next()) {
            HashMap row_data = new HashMap();
            TableReaderFactory.handle_big_data_type(row_set, row_data);
            result.add(row_data);
        }
        return result;
    }

    public static List RowSetToMap(ArrayList list) throws SQLException, IOException {
        ArrayList result = new ArrayList();
        for (int i = 0; i < list.size(); ++i) {
            if (!(list.get(i) instanceof IRowSet)) continue;
            IRowSet row_set = (IRowSet)list.get(i);
            while (row_set.next()) {
                HashMap row_data = new HashMap();
                TableReaderFactory.handle_big_data_type(row_set, row_data);
                result.add(row_data);
            }
        }
        return result;
    }

    private static boolean handle_big_data_type(IRowSet row_set, HashMap row_data) throws SQLException, IOException {
        ResultSetMetaData meta = row_set.getMetaData();
        int col_num = meta.getColumnCount();
        block4: for (int col = 1; col <= col_num; ++col) {
            int sql_type = meta.getColumnType(col);
            switch (sql_type) {
                case 2004: {
                    String key = meta.getColumnName(col) + ":BLOB";
                    byte[] b = null;
                    Blob tmpBlob = row_set.getBlob(col);
                    if (tmpBlob == null) continue block4;
                    int size = new Long(tmpBlob.length()).intValue();
                    b = new byte[size];
                    InputStream is = tmpBlob.getBinaryStream();
                    is.read(b);
                    Object value = b;
                    row_data.put(key, value);
                    is.close();
                    continue block4;
                }
                case 2005: {
                    String key = meta.getColumnName(col) + ":CLOB";
                    Object value = row_set.getString(col);
                    row_data.put(key, value);
                    continue block4;
                }
                default: {
                    String key = meta.getColumnName(col);
                    Object value = row_set.getObject(col);
                    row_data.put(key, value);
                }
            }
        }
        return true;
    }

    public static String getTableID(String table_name) {
        String[] key_is_id = new String[]{"t_bas_form", "t_bas_form_permission", "t_bas_form_notes"};
        String default_id = "FFormID";
        for (int i = 0; i < key_is_id.length; ++i) {
            if (!table_name.equalsIgnoreCase(key_is_id[i])) continue;
            return "fid";
        }
        return default_id;
    }

    public static String getString(Map params, String key) throws BOSException {
        if (params.get(key) != null && params.get(key) instanceof String) {
            return (String)params.get(key);
        }
        throw new BOSException("\u53c2\u6570\u4e0d\u5b58\u5728:" + key);
    }

    static {
        try {
            String package_name = TableReaderFactory.class.getPackage().getName();
            Class.forName(package_name + ".TableReaderProvider");
        }
        catch (ClassNotFoundException e) {
            log.error((Object)e);
        }
    }

    public static abstract class abstractTableReader
    implements ITableReader {
        public abstract String getWhereSql();

        @Override
        public List readRowData(Context ctx, Map params) throws BOSException, SQLException, IOException {
            String form_id = TableReaderFactory.getString(params, "form_id");
            String table_name = TableReaderFactory.getString(params, "table_name");
            String sql = MessageFormat.format("select * from  {0} where  " + this.getWhereSql(), table_name, form_id);
            try {
                IRowSet result = DBUtil.executeQuery((Context)ctx, (String)sql, null);
                return TableReaderFactory.RowSetToMap(result);
            }
            catch (BOSException e) {
                throw new BOSException("\u8bfb\u53d6\u8868" + table_name + "\u9519\u8bef.\n" + e.getMessage());
            }
        }
    }

    public static class DefaultTableReader
    implements ITableReader {
        public boolean isExistTable(Context ctx, String table_name) {
            String sql = "SELECT id FROM KSQL_USERTABLES WHERE KSQL_TABNAME ='" + table_name + "'";
            try {
                IRowSet result = DBUtil.executeQuery((Context)ctx, (String)sql, null);
                return result.next();
            }
            catch (BOSException bOSException) {
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            return false;
        }

        @Override
        public List readRowData(Context ctx, Map params) throws BOSException, SQLException, IOException {
            String table_name = TableReaderFactory.getString(params, "table_name");
            String id = TableReaderFactory.getTableID(table_name);
            String form_id = TableReaderFactory.getString(params, "form_id");
            String sql = MessageFormat.format("select * from  {0} where {1}= ''{2}'' ", table_name, id, form_id);
            try {
                IRowSet result = DBUtil.executeQuery((Context)ctx, (String)sql, null);
                return TableReaderFactory.RowSetToMap(result);
            }
            catch (BOSException e) {
                if (!this.isExistTable(ctx, table_name)) {
                    return new ArrayList();
                }
                throw new BOSException("\u8bfb\u53d6\u8868" + table_name + "\u9519\u8bef.\n" + e.getMessage());
            }
        }
    }
}

