/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.ide.migration.help;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.PathUtil;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.form.ide.migration.help.ITableReader;
import com.kingdee.eas.base.form.ide.migration.help.TableReaderFactory;
import com.kingdee.eas.base.form.ide.utils.EntityObjectInfoHelp;
import com.kingdee.eas.dynbusiness.util.DBUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.io.IOException;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TableReaderProvider {
    public static String[] getMetaDataPK(String[] bos_types) throws BOSException {
        String[] out = null;
        if (bos_types != null) {
            ArrayList<String> list = new ArrayList<String>();
            for (int i = 0; i < bos_types.length; ++i) {
                EntityObjectInfo entity = EntityObjectInfoHelp.getEntity(BOSObjectType.create((String)bos_types[i]));
                if (null == entity) continue;
                String entity_name = entity.getName();
                String package_name = entity.getPackage();
                if (entity.getTable() == null) {
                    throw new BOSException(entity_name + "\u8be5\u5b9e\u4f53\u7684\u8868\u6ca1\u627e\u5230!");
                }
                list.add(entity.getFullName());
                list.add(entity.getTable().getFullName());
                if (i == 0) {
                    list.add(package_name + "." + entity_name + "Query");
                }
                PropertyCollection collect = entity.getProperties();
                for (int col = 0; col < collect.size(); ++col) {
                    if (!(collect.get(col) instanceof LinkPropertyInfo)) continue;
                    LinkPropertyInfo link_prop = (LinkPropertyInfo)collect.get(col);
                    list.add(link_prop.getRelationship().getFullName());
                }
            }
            if (list.size() > 0) {
                out = new String[list.size()];
                list.toArray(out);
            }
        }
        return out;
    }

    public static String getSqlParamString(Object obj, boolean single_quotation, String key) throws SQLException {
        String param_str = "";
        Object[] items = null;
        if (obj.getClass().isArray()) {
            items = (Object[])obj;
        } else if (obj instanceof ArrayList) {
            items = ((ArrayList)obj).toArray();
        } else if (obj instanceof IRowSet) {
            IRowSet set = (IRowSet)obj;
            ArrayList<Object> list = new ArrayList<Object>();
            while (set.next()) {
                list.add(set.getObject(key));
            }
            items = list.toArray();
        }
        if (items != null && items.length > 0) {
            for (int i = 0; i < items.length; ++i) {
                param_str = single_quotation ? param_str + "'" + items[i] + "'" : param_str + items[i];
                if (i == items.length - 1) continue;
                param_str = param_str + ",";
            }
        }
        return param_str;
    }

    static {
        TableReaderFactory.registReader("T_BAS_FormSubsystem", new TableReaderFactory.abstractTableReader(){

            @Override
            public String getWhereSql() {
                return " fsubsysid in  ( select fsubsysid from t_bas_form where fid = ''{1}'') ";
            }
        });
        TableReaderFactory.registReader("T_BAS_FormTopClass", new TableReaderFactory.abstractTableReader(){

            @Override
            public String getWhereSql() {
                return " ftopclassid in (select ftopclassid from  t_bas_formsubsystem where fsubsysid in ( select fsubsysid from t_bas_form where fid = ''{1}'')  )";
            }
        });
        TableReaderFactory.registReader("T_BAS_BarItemLink", new TableReaderFactory.abstractTableReader(){

            @Override
            public String getWhereSql() {
                return " FMenuId in ( select FMenuId from T_BAS_FormMenu where fformid=''{1}'') ";
            }
        });
        TableReaderFactory.registReader("T_BAS_BarItem", new TableReaderFactory.abstractTableReader(){

            @Override
            public String getWhereSql() {
                return " FMenuId in ( select FMenuId from T_BAS_FormMenu where fformid=''{1}'') ";
            }
        });
        TableReaderFactory.registReader("T_BAS_FormMenuScheme", new TableReaderFactory.abstractTableReader(){

            @Override
            public String getWhereSql() {
                return "  fid in  ( select fmenuid from t_bas_formmenu where fformid=''{1}'') ";
            }
        });
        TableReaderFactory.registReader("T_BAS_FormContainerLayout", new TableReaderFactory.abstractTableReader(){

            @Override
            public String getWhereSql() {
                return "  FLayoutID IN ( SELECT FID FROM T_BAS_FormLayout WHERE FFormID=''{1}'') ";
            }
        });
        TableReaderFactory.registReader("T_BAS_FormLayoutTabPage", new TableReaderFactory.abstractTableReader(){

            @Override
            public String getWhereSql() {
                return "  FLayoutID IN ( SELECT FID FROM T_BAS_FormLayout WHERE FFormID=''{1}'') ";
            }
        });
        TableReaderFactory.registReader("T_BAS_FormLayoutCtrl", new TableReaderFactory.abstractTableReader(){

            @Override
            public String getWhereSql() {
                return " FLayoutID IN ( SELECT FID FROM T_BAS_FormLayout WHERE FFormID=''{1}'') ";
            }
        });
        TableReaderFactory.registReader("T_BAS_FormLayoutField", new TableReaderFactory.abstractTableReader(){

            @Override
            public String getWhereSql() {
                return " FLayoutID IN ( SELECT FID FROM T_BAS_FormLayout WHERE FFormID=''{1}'') ";
            }
        });
        TableReaderFactory.registReader("T_BAS_FormLayoutEntity", new TableReaderFactory.abstractTableReader(){

            @Override
            public String getWhereSql() {
                return " FLayoutID IN ( SELECT FID FROM T_BAS_FormLayout WHERE FFormID=''{1}'') ";
            }
        });
        TableReaderFactory.registReader("T_BAS_FCEntry", new ITableReader(){

            @Override
            public List readRowData(Context ctx, Map params) throws BOSException, SQLException, IOException {
                String form_id = TableReaderFactory.getString(params, "form_id");
                String table_name = TableReaderFactory.getString(params, "table_name");
                String temp = "select * from  {0} where   FParentId in ( select fid from {1} where FFormID=''{2}'')";
                String[] sub_tab_name = new String[]{"T_BAS_FormActionList", "T_BAS_FormCondition"};
                ArrayList<IRowSet> list = new ArrayList<IRowSet>();
                for (int i = 0; i < sub_tab_name.length; ++i) {
                    String sql = MessageFormat.format(temp, table_name, sub_tab_name[i], form_id);
                    IRowSet result = DBUtil.executeQuery((Context)ctx, (String)sql, null);
                    list.add(result);
                }
                return TableReaderFactory.RowSetToMap(list);
            }
        });
        TableReaderFactory.registReader("T_CON_EntityPKMapping", new ITableReader(){

            @Override
            public List readRowData(Context ctx, Map params) throws BOSException, SQLException, IOException {
                String form_id = TableReaderFactory.getString(params, "form_id");
                String sql = "select frefbostypes from t_bas_form where fid='" + form_id + "'";
                IRowSet result = DBUtil.executeQuery((Context)ctx, (String)sql, null);
                result.next();
                String fref_bostype = result.getString(1);
                String[] bos_list = fref_bostype.split(",");
                sql = "select * from T_CON_EntityPKMapping  where fbostype in (";
                String temp = TableReaderProvider.getSqlParamString(bos_list, true, null);
                sql = sql + temp + ")";
                result = DBUtil.executeQuery((Context)ctx, (String)sql, null);
                return TableReaderFactory.RowSetToMap(result);
            }
        });
        TableReaderFactory.registReader("T_CON_DynamicMetadata", new ITableReader(){

            @Override
            public List readRowData(Context ctx, Map params) throws BOSException, SQLException, IOException {
                String form_id = TableReaderFactory.getString(params, "form_id");
                String sql = "select frefbostypes from t_bas_form where fid='" + form_id + "'";
                IRowSet result = DBUtil.executeQuery((Context)ctx, (String)sql, null);
                result.next();
                String fref_bostype = result.getString(1);
                String[] bos_type_list = fref_bostype.split(",");
                String[] meta_array = TableReaderProvider.getMetaDataPK(bos_type_list);
                String param = TableReaderProvider.getSqlParamString(meta_array, true, null);
                sql = "select * from T_CON_DynamicMetadata where FMetaDataPK in (";
                sql = sql + param + ")";
                result = DBUtil.executeQuery((Context)ctx, (String)sql, null);
                return TableReaderFactory.RowSetToMap(result);
            }
        });
        TableReaderFactory.registReader("T_EP_CustomizedUnit", new ITableReader(){

            @Override
            public List readRowData(Context ctx, Map params) throws BOSException, SQLException, IOException {
                String form_id = TableReaderFactory.getString(params, "form_id");
                String sql = "select fbostype from t_bas_form where fid = '" + form_id + "'";
                IRowSet result = DBUtil.executeQuery((Context)ctx, (String)sql, null);
                if (!result.next()) {
                    return null;
                }
                sql = "select FMetaDataPK from T_CON_EntityPKMapping  where fbostype= '" + result.getString(1) + "'";
                result = DBUtil.executeQuery((Context)ctx, (String)sql, null);
                if (result.next()) {
                    String meta_pk;
                    String entity_ame = meta_pk = result.getString(1);
                    int pos = meta_pk.lastIndexOf(46);
                    if (pos != -1) {
                        entity_ame = entity_ame.substring(pos + 1, entity_ame.length());
                    }
                    sql = "select * from T_EP_CustomizedUnit where fname_l2 ='" + entity_ame + "'";
                    result = DBUtil.executeQuery((Context)ctx, (String)sql, null);
                    return TableReaderFactory.RowSetToMap(result);
                }
                return null;
            }
        });
        TableReaderFactory.registReader("T_BAS_UserDefinedData", new ITableReader(){

            @Override
            public List readRowData(Context ctx, Map params) throws BOSException, SQLException, IOException {
                ArrayList out = new ArrayList();
                String form_id = TableReaderFactory.getString(params, "form_id");
                String sql = "select distinct flink from t_bas_formfield where fformid='" + form_id + "' and  flink is not null";
                IRowSet result = DBUtil.executeQuery((Context)ctx, (String)sql, null);
                ArrayList UserDefinedData_list = new ArrayList();
                ArrayList UserDefinedDataEntry_list = new ArrayList();
                ArrayList<String> exist_parentid = new ArrayList<String>();
                while (result.next()) {
                    String link_id = result.getString(1);
                    sql = "select * from T_BAS_UserDefinedData where fid='" + link_id + "'";
                    IRowSet head_result = DBUtil.executeQuery((Context)ctx, (String)sql, null);
                    List list = TableReaderFactory.RowSetToMap(head_result);
                    for (int i = 0; i < list.size(); ++i) {
                        UserDefinedData_list.add(list.get(i));
                    }
                    if (list.size() > 0) {
                        head_result.first();
                        String parent_id = head_result.getString("fparentid");
                        if (parent_id != null && !exist_parentid.contains(parent_id)) {
                            exist_parentid.add(parent_id);
                            while (parent_id != null) {
                                sql = "select * from T_BAS_UserDefinedData where fid='" + parent_id + "'";
                                head_result = DBUtil.executeQuery((Context)ctx, (String)sql, null);
                                list = TableReaderFactory.RowSetToMap(head_result);
                                for (int i = 0; i < list.size(); ++i) {
                                    UserDefinedData_list.add(list.get(i));
                                }
                                if (!head_result.first()) break;
                                parent_id = head_result.getString("fparentid");
                            }
                        }
                    }
                    sql = "select * from T_BAS_UserDefinedDataEntry where fhead='" + link_id + "'";
                    IRowSet item_result = DBUtil.executeQuery((Context)ctx, (String)sql, null);
                    list = TableReaderFactory.RowSetToMap(item_result);
                    for (int idx = 0; idx < list.size(); ++idx) {
                        UserDefinedDataEntry_list.add(list.get(idx));
                    }
                }
                HashMap<String, List> map = new HashMap<String, List>();
                if (UserDefinedData_list.size() > 0) {
                    map.put("T_BAS_UserDefinedData", UserDefinedData_list);
                }
                if (UserDefinedDataEntry_list.size() > 0) {
                    map.put("T_BAS_UserDefinedDataEntry", UserDefinedDataEntry_list);
                    String[] fids = new String[UserDefinedDataEntry_list.size()];
                    for (int i = 0; i < UserDefinedDataEntry_list.size(); ++i) {
                        Map row_data = (Map)UserDefinedDataEntry_list.get(i);
                        fids[i] = row_data.get("FID").toString();
                    }
                    String param = TableReaderProvider.getSqlParamString(fids, true, null);
                    sql = "select * from T_BD_DataBaseDAssign where fdatabasedid in (" + param + ")";
                    result = DBUtil.executeQuery((Context)ctx, (String)sql, null);
                    List dataBaseDAssignList = TableReaderFactory.RowSetToMap(result);
                    if (dataBaseDAssignList.size() > 0) {
                        map.put("T_BD_DataBaseDAssign", dataBaseDAssignList);
                    }
                }
                if (map.size() > 0) {
                    out.add(map);
                }
                return out;
            }
        });
        TableReaderFactory.registReader("T_BAS_FormEnum", new ITableReader(){

            @Override
            public List readRowData(Context ctx, Map params) throws BOSException, SQLException, IOException {
                int Max_Cust_Enum = 1000000;
                ArrayList out = new ArrayList();
                String form_id = TableReaderFactory.getString(params, "form_id");
                String sql = "select * from t_bas_formenum where fid in (select  distinct fenumtype from t_bas_formfield where fformid= ? and FEnumType >? )";
                IRowSet result = DBUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{form_id, new Integer(Max_Cust_Enum)});
                List list = TableReaderFactory.RowSetToMap(result);
                if (list.size() > 0) {
                    HashMap<String, List> map = new HashMap<String, List>();
                    map.put("T_BAS_FormEnum", list);
                    String param = "";
                    for (int i = 0; i < list.size(); ++i) {
                        Map record = (Map)list.get(i);
                        param = param + record.get("FID");
                        if (i == list.size() - 1) continue;
                        param = param + ",";
                    }
                    if (param.length() > 0) {
                        sql = "select * from t_bas_formenumitem where fenumid in ( {0} )";
                        result = DBUtil.executeQuery((Context)ctx, (String)(sql = MessageFormat.format(sql, param)), null);
                        list = TableReaderFactory.RowSetToMap(result);
                        if (list.size() > 0) {
                            map.put("T_BAS_FormEnumItem", list);
                        }
                    }
                    out.add(map);
                }
                return out;
            }
        });
        TableReaderFactory.registReader("T_BAS_LookUpClass", new ITableReader(){

            @Override
            public List readRowData(Context ctx, Map params) throws BOSException, SQLException, IOException {
                ArrayList out = new ArrayList();
                String form_id = TableReaderFactory.getString(params, "form_id");
                String sql = "select distinct FLookUpObjectID from t_bas_formfield where  FLookUpObjectID is not null and fformid='" + form_id + "'";
                IRowSet result = DBUtil.executeQuery((Context)ctx, (String)sql, null);
                String sql_param = TableReaderProvider.getSqlParamString(result, false, "FLookUpObjectID");
                if (sql_param.length() > 0) {
                    sql = "select * from t_bas_lookupclass where fid in (" + sql_param + ")";
                    result = DBUtil.executeQuery((Context)ctx, (String)sql, null);
                    HashMap<String, List> map = new HashMap<String, List>();
                    List list = TableReaderFactory.RowSetToMap(result);
                    if (list.size() > 0) {
                        map.put("T_BAS_LookUpClass", list);
                    }
                    out.add(map);
                }
                return out;
            }
        });
        TableReaderFactory.registReader("T_BAS_Template", new ITableReader(){

            @Override
            public List readRowData(Context ctx, Map params) throws BOSException, SQLException, IOException {
                List list;
                IRowSet result;
                ArrayList out = new ArrayList();
                String form_id = TableReaderFactory.getString(params, "form_id");
                String sql = "";
                HashMap<String, List> map = new HashMap<String, List>();
                String[] main_table = new String[]{"T_BAS_Template", "T_BAS_FlowNodeCtrl"};
                for (int i = 0; i < main_table.length; ++i) {
                    String table_name = main_table[i];
                    sql = "select * from {0} where fformid=''" + form_id + "''";
                    result = DBUtil.executeQuery((Context)ctx, (String)(sql = MessageFormat.format(sql, table_name)), null);
                    list = TableReaderFactory.RowSetToMap(result);
                    if (list.size() <= 0) continue;
                    map.put(table_name, list);
                }
                sql = "select * from T_BAS_TemplateWorkFlow where fparentid in (select fid  from T_BAS_Template where fformid='" + form_id + "')";
                result = DBUtil.executeQuery((Context)ctx, (String)sql, null);
                list = TableReaderFactory.RowSetToMap(result);
                if (list.size() > 0) {
                    map.put("T_BAS_TemplateWorkFlow", list);
                }
                if ((list = TableReaderFactory.RowSetToMap(result = DBUtil.executeQuery((Context)ctx, (String)(sql = "select * from T_BAS_SignValidConfig where ftemplateid in (select fid from t_bas_template where fformid='" + form_id + "')"), null))).size() > 0) {
                    map.put("T_BAS_SignValidConfig", list);
                    result.beforeFirst();
                    ArrayList<String> ids = new ArrayList<String>();
                    while (result.next()) {
                        if (!ids.contains(result.getString("FID"))) {
                            ids.add(result.getString("FID"));
                        }
                        String param_sql = TableReaderProvider.getSqlParamString(ids, true, null);
                        sql = "select * from T_BAS_SignValidField  where fparentid in(" + param_sql + ")";
                        result = DBUtil.executeQuery((Context)ctx, (String)sql, null);
                        list = TableReaderFactory.RowSetToMap(result);
                        if (list.size() <= 0) continue;
                        map.put("T_BAS_SignValidField", list);
                    }
                }
                if ((list = TableReaderFactory.RowSetToMap(result = DBUtil.executeQuery((Context)ctx, (String)(sql = "select * from T_BAS_TemplateType where fid in (select FTemplateTypeID  from T_BAS_Template where fformid='" + form_id + "')"), null))).size() > 0) {
                    map.put("T_BAS_TemplateType", list);
                }
                String[] entry_table = new String[]{"T_BAS_OfficeControlEntry", "T_BAS_FlowNCtlCEnt", "T_BAS_FlowNCtlFEnt", "T_BAS_FlowNCtlOEnt"};
                for (int i = 0; i < entry_table.length; ++i) {
                    String entry_table_name = entry_table[i];
                    String entry_sql = "select * from {0} where fparentid in (select fid from T_BAS_FlowNodeCtrl where fformid = ''{1}'')";
                    result = DBUtil.executeQuery((Context)ctx, (String)(entry_sql = MessageFormat.format(entry_sql, entry_table_name, form_id)), null);
                    list = TableReaderFactory.RowSetToMap(result);
                    if (list.size() <= 0) continue;
                    map.put(entry_table_name, list);
                }
                sql = "select * from T_BAS_BoAttchAsso where fboid in (select fid from T_BAS_Template where fformid='" + form_id + "')";
                result = DBUtil.executeQuery((Context)ctx, (String)sql, null);
                list = TableReaderFactory.RowSetToMap(result);
                if (list.size() > 0) {
                    map.put("T_BAS_BoAttchAsso", list);
                    result.beforeFirst();
                    ArrayList<String> ids = new ArrayList<String>();
                    while (result.next()) {
                        if (ids.contains(result.getString("FAttachmentID"))) continue;
                        ids.add(result.getString("FAttachmentID"));
                    }
                    String param_sql = TableReaderProvider.getSqlParamString(ids, true, null);
                    sql = "select * from T_BAS_Attachment  where fid in(" + param_sql + ")";
                    result = DBUtil.executeQuery((Context)ctx, (String)sql, null);
                    list = TableReaderFactory.RowSetToMap(result);
                    if (list.size() > 0) {
                        map.put("T_BAS_Attachment", list);
                    }
                }
                if ((list = TableReaderFactory.RowSetToMap(result = DBUtil.executeQuery((Context)ctx, (String)(sql = "select * from T_BAS_BillAttachment  where fbillid  in (select fid from T_BAS_Template  where fformid ='" + form_id + "')"), null))).size() > 0) {
                    map.put("T_BAS_BillAttachment", list);
                }
                if (map.size() > 0) {
                    out.add(map);
                }
                return out;
            }
        });
        TableReaderFactory.registReader("T_RPTS_StorageFileData", new ITableReader(){
            String print_root_path = "/eas/EAS_Note.kdrs";

            private String[] getTempPaths(String str) {
                ArrayList<String> list = new ArrayList<String>();
                list.add(this.print_root_path);
                String[] items = str.split("/");
                String mem = this.print_root_path;
                for (int i = 0; i < items.length; ++i) {
                    String item = items[i];
                    if (item.trim().length() == 0) continue;
                    mem = mem + "/" + item;
                    list.add(mem);
                }
                String[] out = new String[list.size()];
                list.toArray(out);
                return out;
            }

            @Override
            public List readRowData(Context ctx, Map params) throws BOSException, SQLException, IOException {
                String temp_path_name;
                ArrayList out = new ArrayList();
                String form_id = TableReaderFactory.getString(params, "form_id");
                String sql = "select FTemplatePath from t_bas_form where fid='" + form_id + "'";
                IRowSet result = DBUtil.executeQuery((Context)ctx, (String)sql, null);
                HashMap<String, List> map = new HashMap<String, List>();
                if (result.first() && !StringUtils.isEmpty((String)(temp_path_name = result.getString(1)))) {
                    String[] temp_paths = this.getTempPaths(temp_path_name);
                    String param = TableReaderProvider.getSqlParamString(temp_paths, true, null);
                    temp_path_name = PathUtil.makeChildPath((String)this.print_root_path, (String)temp_path_name);
                    sql = "select * from T_RPTS_StorageTree where fpath in (" + param + ") or fpath like '" + temp_path_name + "/%'";
                    ArrayList<String> node_ids = new ArrayList<String>();
                    result = DBUtil.executeQuery((Context)ctx, (String)sql, null);
                    List list = TableReaderFactory.RowSetToMap(result);
                    if (list.size() > 0) {
                        result.beforeFirst();
                        while (result.next()) {
                            node_ids.add(result.getString("FID"));
                        }
                        map.put("T_RPTS_StorageTree", list);
                        String param_str = TableReaderProvider.getSqlParamString(node_ids, true, null);
                        sql = "select * from T_RPTS_StorageFileData where fid in ( " + param_str + ")";
                        result = DBUtil.executeQuery((Context)ctx, (String)sql, null);
                        list = TableReaderFactory.RowSetToMap(result);
                        if (list.size() > 0) {
                            map.put("T_RPTS_StorageFileData", list);
                        }
                        if ((list = TableReaderFactory.RowSetToMap(result = DBUtil.executeQuery((Context)ctx, (String)(sql = "select * from T_RPTS_Attributes where fid in (" + param_str + ")"), null))).size() > 0) {
                            map.put("T_RPTS_Attributes", list);
                        }
                    }
                }
                if (map.size() > 0) {
                    out.add(map);
                }
                return out;
            }
        });
        TableReaderFactory.registReader("T_WFD_ProcessDef", new ITableReader(){

            @Override
            public List readRowData(Context ctx, Map params) throws BOSException, SQLException, IOException {
                String id;
                ArrayList out = new ArrayList();
                ArrayList<String> flowids = new ArrayList<String>();
                String form_id = TableReaderFactory.getString(params, "form_id");
                String sql = "select fflowid from T_BAS_FlowNodeCtrl where fformid='" + form_id + "'";
                IRowSet result = DBUtil.executeQuery((Context)ctx, (String)sql, null);
                while (result.next()) {
                    id = result.getString(1);
                    if (flowids.contains(id)) continue;
                    flowids.add(id);
                }
                sql = "select fflowid  from t_bas_template where fformid='" + form_id + "'";
                result = DBUtil.executeQuery((Context)ctx, (String)sql, null);
                while (result.next()) {
                    id = result.getString(1);
                    if (flowids.contains(id)) continue;
                    flowids.add(id);
                }
                sql = "select fflowid from t_bas_templateworkflow where fparentid in (select fid from t_bas_template where fformid='" + form_id + "')";
                result = DBUtil.executeQuery((Context)ctx, (String)sql, null);
                while (result.next()) {
                    id = result.getString(1);
                    if (flowids.contains(id)) continue;
                    flowids.add(id);
                }
                String sql_param = "";
                for (int i = 0; i < flowids.size(); ++i) {
                    sql_param = sql_param + "'" + flowids.get(i) + "'";
                    if (i == flowids.size() - 1) continue;
                    sql_param = sql_param + ",";
                }
                HashMap<String, List> map = new HashMap<String, List>();
                if (sql_param.length() > 0) {
                    sql = "select * from T_WFD_ProcessDef where FPROCESSID in (" + sql_param + ")";
                    result = DBUtil.executeQuery((Context)ctx, (String)sql, null);
                    List list = TableReaderFactory.RowSetToMap(result);
                    if (list.size() > 0) {
                        map.put("T_WFD_ProcessDef", list);
                    }
                    sql = "select * from T_WFR_ProcDef where FPROCDEFID in (" + sql_param + ")";
                    result = DBUtil.executeQuery((Context)ctx, (String)sql, null);
                    list = TableReaderFactory.RowSetToMap(result);
                    ArrayList<Map> filer_list = new ArrayList<Map>();
                    if (list.size() > 0) {
                        HashMap<String, Integer> id_version = new HashMap<String, Integer>();
                        for (int i = 0; i < list.size(); ++i) {
                            Map item = (Map)list.get(i);
                            String key = item.get("FPROCDEFID").toString();
                            Integer version = Integer.valueOf(item.get("FINNERVERSION").toString());
                            if (!id_version.containsKey(key)) {
                                id_version.put(key, version);
                                continue;
                            }
                            if (version <= (Integer)id_version.get(key)) continue;
                            id_version.put(key, version);
                        }
                        block5: for (Map.Entry entry : id_version.entrySet()) {
                            String target_key = entry.getKey().toString();
                            int target_version = Integer.parseInt(entry.getValue().toString());
                            for (int i = 0; i < list.size(); ++i) {
                                Map item = (Map)list.get(i);
                                String key = item.get("FPROCDEFID").toString();
                                int version = Integer.parseInt(item.get("FINNERVERSION").toString());
                                if (!target_key.equals(key) || target_version != version) continue;
                                filer_list.add(item);
                                continue block5;
                            }
                        }
                        map.put("T_WFR_ProcDef", filer_list);
                    }
                    if (map.size() > 0) {
                        out.add(map);
                    }
                }
                return out;
            }
        });
        TableReaderFactory.registReader("T_BAS_FormImg", new ITableReader(){

            @Override
            public List readRowData(Context ctx, Map params) throws BOSException, SQLException, IOException {
                ArrayList out = new ArrayList();
                String form_id = TableReaderFactory.getString(params, "form_id");
                String sql = "select * from T_BAS_FormImg where fformid = '" + form_id + "'";
                IRowSet result = DBUtil.executeQuery((Context)ctx, (String)sql, null);
                HashMap<String, List> map = new HashMap<String, List>();
                List list = TableReaderFactory.RowSetToMap(result);
                if (list.size() > 0) {
                    map.put("T_BAS_FormImg", list);
                }
                out.add(map);
                return out;
            }
        });
    }
}

