/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.ide.migration.help;

import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.data.PrimaryKeyInfo;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.form.util.Util;
import com.kingdee.util.StringUtils;
import java.util.List;
import org.apache.log4j.Logger;

public class TableSQLProvider {
    private static final Logger logger = CoreUIObject.getLogger(TableSQLProvider.class);

    public static void createSql(EntityObjectInfo entity, List sqlList) {
        if (entity != null) {
            DataTableInfo table = entity.getTable();
            if (table == null) {
                logger.error((Object)("\u521b\u5efa\u8868\u7ed3\u6784\u65f6\u4ea7\u751f\u9519\u8bef,\u8be5\u5b9e\u4f53\u2014\u2014" + entity.getAlias() + "\u6ca1\u6709\u5b9a\u4e49\u8868\uff01"));
            } else {
                String sql1 = "If not exists ( select * from KSQL_USERCOLUMNS where KSQL_COL_TABNAME = '" + table.getName() + "') \n";
                String sql2 = "Create Table " + table.getName() + "( FID varchar(44) not null, ";
                String sql3 = "";
                PrimaryKeyInfo primaryKey = table.getPrimaryKey();
                String tmp = "";
                for (int i = 0; i < primaryKey.getPKColumns().size(); ++i) {
                    tmp = tmp + primaryKey.getPKColumns().get(i).getColumn().getName() + ",";
                }
                if (tmp.length() > 0) {
                    tmp = tmp.substring(0, tmp.length() - 1);
                    sql3 = " CONSTRAINT " + primaryKey.getName() + " PRIMARY KEY (" + tmp + ")); \n";
                } else {
                    sql2 = sql2.substring(0, sql2.length() - 2);
                    sql3 = " ); \n";
                }
                sqlList.add(sql1 + sql2 + sql3);
                PropertyCollection properties = Util.getAllEntityProperties((EntityObjectInfo)entity);
                for (int i = 0; i < properties.size(); ++i) {
                    String tmpSql;
                    PropertyInfo prop = properties.get(i);
                    if (prop == null || prop.getName().equalsIgnoreCase("id") || StringUtils.isEmpty((String)(tmpSql = TableSQLProvider.getFieldSql(entity, prop)))) continue;
                    sqlList.add(tmpSql);
                }
            }
        }
    }

    private static String getFieldSql(EntityObjectInfo info, PropertyInfo prop) {
        ColumnInfo mappingField = prop.getMappingField();
        DataTableInfo table = info.getTable();
        if (mappingField == null || StringUtils.isEmpty((String)mappingField.getName())) {
            return null;
        }
        if ((mappingField = table.getColumnByName(mappingField.getName())).isMultilingual()) {
            String[] columnStr = TableSQLProvider.getDefineColumnSql(mappingField);
            String sql = "";
            for (int j = 1; j <= columnStr.length; ++j) {
                String sql1 = "If not exists ( select * from KSQL_USERCOLUMNS where KSQL_COL_NAME = '" + mappingField.getName() + "_L" + j + "' and KSQL_COL_TABNAME = '" + table.getName() + "') \n";
                String sql2 = "alter table " + table.getName() + " add " + columnStr[j - 1] + ";\n\n";
                sql = sql + sql1 + sql2;
            }
            return sql;
        }
        String sql1 = "If not exists ( select * from KSQL_USERCOLUMNS where KSQL_COL_NAME = '" + mappingField.getName() + "' and KSQL_COL_TABNAME = '" + table.getName() + "') \n";
        String[] columnStr = TableSQLProvider.getDefineColumnSql(mappingField);
        String sql2 = "alter table " + table.getName() + " add " + columnStr[0] + ";\n";
        return sql1 + sql2;
    }

    private static String[] getDefineColumnSql(ColumnInfo mappingField) {
        SQLType type = mappingField.getTypeName();
        String typeStr = null;
        typeStr = type.getName().equals(SQLType.CHAR.getName()) || type.getName().equals(SQLType.NCHAR.getName()) || type.getName().equals(SQLType.VARCHAR.getName()) || type.getName().equals(SQLType.NVARCHAR.getName()) || type.getName().equals(SQLType.BLOB.getName()) || type.getName().equals(SQLType.CLOB.getName()) || type.getName().equals(SQLType.NCLOB.getName()) ? (mappingField.isMultilingual() ? type.getName() + "(" + mappingField.getLength() * 3 + ")" : type.getName() + "(" + mappingField.getLength() + ")") : (type.getName().equals(SQLType.NUMERIC.getName()) ? type.getName() + "(" + mappingField.getPrecision() + "," + mappingField.getScale() + ")" : type.getName());
        String nullableStr = " ";
        if (mappingField.getName().equalsIgnoreCase("FID")) {
            nullableStr = " not null ";
        }
        String defaultValueStr = " default ";
        String defaultValue = mappingField.getDefaultValue();
        defaultValueStr = StringUtils.isEmpty((String)defaultValue) || defaultValue.equals("''") ? (type.getName().equals(SQLType.CHAR.getName()) || type.getName().equals(SQLType.NCHAR.getName()) || type.getName().equals(SQLType.VARCHAR.getName()) || type.getName().equals(SQLType.NVARCHAR.getName()) ? "default ' ' " : (type.getName().equals(SQLType.NUMERIC.getName()) || type.getName().equals(SQLType.INT.getName()) ? defaultValueStr + " 0 " : " ")) : (type.getName().equals(SQLType.CHAR.getName()) || type.getName().equals(SQLType.NCHAR.getName()) || type.getName().equals(SQLType.VARCHAR.getName()) || type.getName().equals(SQLType.NVARCHAR.getName()) ? defaultValueStr + defaultValue : (type.getName().equals(SQLType.NUMERIC.getName()) || type.getName().equals(SQLType.INT.getName()) ? defaultValueStr + " " + defaultValue : " "));
        String[] columnStr = new String[]{mappingField.getName() + " " + typeStr + " " + nullableStr + " " + defaultValueStr};
        if (mappingField.isMultilingual()) {
            columnStr = new String[]{mappingField.getName() + "_L1 " + typeStr + " " + nullableStr + " " + defaultValueStr, mappingField.getName() + "_L2 " + typeStr + " " + nullableStr + " " + defaultValueStr, mappingField.getName() + "_L3 " + typeStr + " " + nullableStr + " " + defaultValueStr};
        }
        return columnStr;
    }
}

