/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.ide.migration.importdata;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.form.ide.migration.help.DbTableAccessFactory;
import com.kingdee.eas.base.form.ide.migration.help.IDbTableAccess;
import com.kingdee.eas.base.form.ide.migration.model.DataModel;
import com.kingdee.eas.base.form.ide.migration.model.DataType;
import com.kingdee.eas.base.form.ide.migration.model.IData;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ep.client.editor.editui.designer.util.CustomSchemeUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class Import {
    public static String OVER_WRITE = "over_write";
    public static String NEW_COMB = "new_combination";
    private static final Logger logger = CoreUIObject.getLogger(Import.class);
    private String import_mode;
    private List filter_list;
    private DataModel model;
    private ArrayList message_list = new ArrayList();
    private DisplayMessage display_message;

    public void setDataModel(DataModel model) {
        this.model = model;
    }

    public void setDisplayMessage(DisplayMessage display_message) {
        this.display_message = display_message;
    }

    public void setFilter(List exclude__list) {
        this.filter_list = exclude__list;
    }

    public void setImportMode(String mode) {
        this.import_mode = mode;
    }

    public boolean executeImport() {
        ArrayList<IData> import_data_list = new ArrayList<IData>();
        if (this.model != null) {
            IData[] data_list = this.model.getDataArray();
            for (int i = 0; i < data_list.length; ++i) {
                IData data = data_list[i];
                if (this.filter_list != null && this.filter_list.contains(data.getType())) {
                    this.postMessage(data.getDescription() + "\u5bfc\u5165 : \u8df3\u8fc7");
                    this.message_list.add(data.getDescription() + "\u5bfc\u5165 : \u8df3\u8fc7");
                    continue;
                }
                if (data.getType().equals(DataType.FormDataType)) {
                    import_data_list.add(0, data);
                    continue;
                }
                import_data_list.add(data);
            }
            return this.import_data(import_data_list);
        }
        return false;
    }

    private void postMessage(String message) {
        if (this.display_message != null) {
            this.display_message.postMessage(message);
        }
    }

    private boolean import_data(ArrayList import_data_list) {
        boolean sucess = true;
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("form_id", this.model.getFormId());
        config.put("sub_system_id", this.model.getSubSystemID());
        config.put("person_id", (String)this.model.getConfig().get("person_id"));
        config.put("person_cu_id", (String)this.model.getConfig().get("person_cu_id"));
        config.put("user_id", (String)this.model.getConfig().get("user_id"));
        IDbTableAccess db_access = DbTableAccessFactory.getDbTableAccessInstance(null);
        for (int i = 0; i < import_data_list.size(); ++i) {
            IData data = (IData)import_data_list.get(i);
            this.postMessage(data.getDescription() + "\u5bfc\u5165");
            try {
                boolean result = db_access.importData(data, this.import_mode, config);
                String state = result ? "\u6210\u529f" : "\u5931\u8d25";
                this.postMessage(data.getDescription() + "\u5bfc\u5165" + state);
                this.message_list.add(data.getDescription() + "\u5bfc\u5165" + state);
                if (!result && data.getType().equals(DataType.FormDataType)) {
                    return false;
                }
                if (result) continue;
                sucess = false;
                continue;
            }
            catch (BOSException e) {
                this.message_list.add(data.getDescription() + "\u5bfc\u5165\u5931\u8d25,\u539f\u56e0\u662f:\n" + e.getMessage());
                logger.error((Object)("\u5bfc\u5165\u5931\u8d25:\n" + e.getMessage()));
                this.postMessage("\u5bfc\u5165\u5931\u8d25:\n" + e.getMessage());
                if (data.getType().equals(DataType.FormDataType)) {
                    return false;
                }
                sucess = false;
            }
        }
        if (sucess) {
            try {
                CustomSchemeUtil.enableScheme((String)"s39q05mDTtWvGKJ8yak72yyY1lE=");
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        return sucess;
    }

    public List getImportMessage() {
        return this.message_list;
    }

    public static interface DisplayMessage {
        public void postMessage(String var1);
    }
}

