/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.ide.migration.model;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.base.form.ide.migration.help.IDbTableAccess;
import com.kingdee.eas.base.form.ide.migration.model.DataType;
import com.kingdee.eas.base.form.ide.migration.model.FileObjectItem;
import com.kingdee.eas.base.form.ide.migration.model.IItem;
import com.kingdee.eas.base.form.ide.migration.model.TableObjectItem;
import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public interface IData
extends Serializable {
    public List getItems();

    public List getTableObjectItems();

    public List getFileObjectItems();

    public String getName();

    public String getDescription();

    public DataType getType();

    public IItem addItem(IItem var1);

    public boolean removeItem(IItem var1);

    public static abstract class AbstractData
    implements IData {
        private static final long serialVersionUID = -719412900628756769L;
        private List item_list = new ArrayList();
        protected String form_id;
        protected transient IDbTableAccess dbTableAccess;

        @Override
        public IItem addItem(IItem item) {
            this.item_list.add(item);
            return item;
        }

        @Override
        public List getItems() {
            return this.item_list;
        }

        @Override
        public List getTableObjectItems() {
            ArrayList list = new ArrayList();
            for (int i = 0; i < this.item_list.size(); ++i) {
                Object item = this.item_list.get(i);
                if (!(item instanceof TableObjectItem)) continue;
                list.add(item);
            }
            return list;
        }

        @Override
        public List getFileObjectItems() {
            ArrayList list = new ArrayList();
            for (int i = 0; i < this.item_list.size(); ++i) {
                Object item = this.item_list.get(i);
                if (!(item instanceof FileObjectItem)) continue;
                list.add(item);
            }
            return list;
        }

        @Override
        public boolean removeItem(IItem item) {
            return this.item_list.remove(item);
        }

        public void setFormID(String form_id) {
            this.form_id = form_id;
        }

        public void setDbTableAccess(IDbTableAccess access) {
            this.dbTableAccess = access;
        }

        protected void createItem(Map table_map_data) {
            for (Map.Entry table_entry : table_map_data.entrySet()) {
                String table_name = table_entry.getKey().toString();
                TableObjectItem table_obj = new TableObjectItem(table_name);
                if (table_entry.getValue() != null && table_entry.getValue() instanceof List) {
                    List list = (List)table_entry.getValue();
                    for (int i = 0; i < list.size(); ++i) {
                        table_obj.addRowData((Map)list.get(i));
                    }
                }
                this.addItem(table_obj);
            }
        }

        protected void createItemWithBinary(Map table_map_data) throws BOSException, SQLException, IOException {
            for (Map.Entry table_entry : table_map_data.entrySet()) {
                if (!(table_entry.getValue() instanceof List)) continue;
                String table_name = table_entry.getKey().toString();
                int file_no = 1;
                TableObjectItem table_object_item = new TableObjectItem(table_name);
                List table_row_list = (List)table_entry.getValue();
                for (int i = 0; i < table_row_list.size(); ++i) {
                    Map row_record = (Map)table_row_list.get(i);
                    for (Map.Entry entry : row_record.entrySet()) {
                        String col_name = entry.getKey().toString();
                        String[] array = col_name.split(":");
                        if (array.length <= 1) continue;
                        String file_name = table_name + file_no++;
                        FileObjectItem file_item = new FileObjectItem(file_name);
                        String sql_type = array[1];
                        if ("BLOB".equalsIgnoreCase(sql_type) && entry.getValue() instanceof byte[]) {
                            file_item.setContext((byte[])entry.getValue());
                        } else if ("CLOB".equalsIgnoreCase(sql_type) && entry.getValue() instanceof String) {
                            file_item.setContext(entry.getValue().toString().getBytes("utf-8"));
                        }
                        entry.setValue(file_name);
                        this.addItem(file_item);
                    }
                    table_object_item.addRowData(row_record);
                }
                this.addItem(table_object_item);
            }
        }

        public abstract void fillData(String[] var1) throws BOSException, SQLException, IOException;
    }
}

