/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.ide.model;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.ObjectUtil;
import com.kingdee.eas.base.form.core.PropertyUtil;
import com.kingdee.eas.base.form.ide.model.MetaDataDesinerModel;
import com.kingdee.eas.base.form.ide.model.ObjectProperty;
import com.kingdee.eas.base.form.ide.model.PropertyAdpterListner;
import com.kingdee.eas.base.form.ide.model.property.check.CheckUtil;
import com.kingdee.eas.base.form.ide.pe.propsheet.Property;
import com.kingdee.eas.base.form.metadata.Appearance;
import com.kingdee.eas.base.form.metadata.Element;
import com.kingdee.eas.base.form.metadata.ElementProperty;
import com.kingdee.eas.base.form.metadata.ElementType;
import com.kingdee.eas.common.client.SysContext;
import java.awt.Rectangle;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.swing.event.EventListenerList;
import org.apache.log4j.Logger;

public class ElementPropertyAdpter
implements Serializable {
    private Appearance appearance;
    private Element element;
    private String listCaption;
    public ElementType elementType;
    private List propertys;
    private HashMap propertymap;
    private EventListenerList listenerList;
    private String checkClass = null;
    private MetaDataDesinerModel model;
    protected static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.form.ide.model.ElementPropertyAdpter");

    public static String getDefaultPropertyCheckClass() {
        return "com.kingdee.eas.base.form.ide.model.property.check.DefaultPropertyCheck";
    }

    public ElementPropertyAdpter(ElementType elementType, Appearance ap, Element bi, MetaDataDesinerModel model) {
        this.appearance = ap;
        this.elementType = elementType;
        this.element = bi;
        this.model = model;
        this.initPropertys();
        this.listenerList = new EventListenerList();
        this.checkClass = CheckUtil.getCheckClass(elementType.getId());
    }

    public void addPropertyAdpterListner(PropertyAdpterListner pl) {
        this.listenerList.add(PropertyAdpterListner.class, pl);
    }

    public void removePropertyAdpterListner(PropertyAdpterListner pl) {
        this.listenerList.remove(PropertyAdpterListner.class, pl);
    }

    public void setElement(Element element) {
        this.element = element;
    }

    private void initPropertys() {
        this.propertys = new ArrayList();
        this.propertymap = new HashMap();
        for (ElementProperty propDesc : this.elementType.getElementPropertyArray()) {
            Property prop = this.createProperty(propDesc);
            if (prop == null) continue;
            this.propertys.add(prop);
            this.propertymap.put(propDesc.getPropertyName(), prop);
        }
    }

    public void setAppearance(Appearance appearance) {
        this.appearance = appearance;
    }

    private Property createProperty(ElementProperty propDesc) {
        try {
            String classType = propDesc.getPropClass();
            if (classType == null) {
                return null;
            }
            Class<?> type = Class.forName(classType);
            Class[] partypes = new Class[]{this.getClass(), propDesc.getClass()};
            Constructor<?> ct = type.getConstructor(partypes);
            Object[] arglist = new Object[]{this, propDesc};
            Property prop = (Property)ct.newInstance(arglist);
            return prop;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Property[] getPropertys() {
        ArrayList<ObjectProperty> list = new ArrayList<ObjectProperty>();
        for (ObjectProperty prop : this.propertys) {
            if (prop.getElementProperty().getVisible() <= 0) continue;
            prop.setVisible(true);
            this.fireFilterProperty(prop);
            if (!prop.isVisible()) continue;
            list.add(prop);
        }
        Property[] props = new Property[list.size()];
        list.toArray(props);
        return props;
    }

    public ObjectProperty getProperty(String propName) {
        return (ObjectProperty)this.propertymap.get(propName);
    }

    public Appearance getAppearance() {
        return this.appearance;
    }

    public Element getElement() {
        return this.element;
    }

    public String getListCaption() {
        if (this.listCaption != null) {
            return this.listCaption + "-" + this.getKey();
        }
        return this.getCaption() + "-" + this.getKey();
    }

    public void setListCaption(String listCaption) {
        this.listCaption = listCaption;
    }

    public String getCaption() {
        if (this.appearance != null) {
            try {
                return this.getPropertyValue("Caption_" + SysContext.getSysContext().getLocale().getLanguage().toUpperCase()).toString();
            }
            catch (Exception e) {
                return "";
            }
        }
        return "";
    }

    public void setCaption(String caption) {
        if (this.appearance != null) {
            try {
                this.appearance.setCaption(caption);
                this.setPropertyValue("Caption_" + SysContext.getSysContext().getLocale().getLanguage().toUpperCase(), caption);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String getKey() {
        if (this.appearance != null) {
            return this.appearance.getKey();
        }
        if (this.element != null) {
            return this.element.getKey();
        }
        return "";
    }

    public String getElementTypeName() {
        return this.elementType.getName();
    }

    public int getElementType() {
        if (this.appearance != null) {
            return this.appearance.getElementType();
        }
        if (this.element != null) {
            return this.element.getElementType();
        }
        return 0;
    }

    public int getType() {
        if (this.elementType != null) {
            return this.elementType.getType();
        }
        return 0;
    }

    public Object getPropertyValue(String PropertyName) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Appearance obj = null;
        Method mi = null;
        switch (this.getProperty(PropertyName).getElementProperty().getBindingFlags()) {
            case 3: {
                if (this.appearance != null) {
                    mi = this.appearance.getClass().getMethod("get" + PropertyName, null);
                    obj = this.appearance;
                }
                if (mi != null || this.element == null) break;
                mi = this.element.getClass().getMethod("get" + PropertyName, null);
                obj = this.element;
                break;
            }
            case 1: {
                if (this.appearance == null) break;
                mi = this.appearance.getClass().getMethod("get" + PropertyName, null);
                obj = this.appearance;
                break;
            }
            case 2: {
                if (this.element == null) break;
                mi = this.element.getClass().getMethod("get" + PropertyName, null);
                obj = this.element;
                break;
            }
        }
        if (mi != null && obj != null) {
            return mi.invoke(obj, new Object[0]);
        }
        return null;
    }

    public void setPropertyValue(String PropertyName, Object value) throws BOSException {
        this.setPropertyValue(PropertyName, value, false);
    }

    public void setBounds(Rectangle rc) {
        if (this.appearance != null) {
            this.appearance.setBounds(rc);
        }
    }

    public void setPropertyValue(String propertyName, Object value, boolean bFireChangeEvents) throws BOSException {
        ObjectProperty property = this.getProperty(propertyName);
        if (property != null) {
            int bindingFlags = property.elementProperty.getBindingFlags();
            Object oldValue = property.getValue();
            if (ObjectUtil.equals((Object)oldValue, (Object)value)) {
                return;
            }
            if (bFireChangeEvents) {
                this.firepropertyChanging(property, value, oldValue);
            }
            if (bindingFlags == 3 || bindingFlags == 1) {
                PropertyUtil.setPropertyValue((Object)this.appearance, (String)propertyName, (Object)value);
                Locale locale = SysContext.getSysContext().getLocale();
                if (propertyName != null && propertyName.equalsIgnoreCase("Caption_" + locale)) {
                    PropertyUtil.setPropertyValue((Object)this.appearance, (String)"Caption", (Object)value);
                }
            }
            if ((bindingFlags == 3 || bindingFlags == 2) && this.element != null) {
                PropertyUtil.setPropertyValue((Object)this.element, (String)propertyName, (Object)value);
            }
            if (bFireChangeEvents) {
                this.firepropertyChanged(property, value, oldValue);
            }
        }
    }

    public String toString() {
        return this.getListCaption();
    }

    public void fireFilterProperty(ObjectProperty prop) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != PropertyAdpterListner.class) continue;
            ((PropertyAdpterListner)listeners[i + 1]).filterProperty(prop);
        }
    }

    public void firepropertyChanging(ObjectProperty prop, Object newValue, Object oldValue) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != PropertyAdpterListner.class) continue;
            ((PropertyAdpterListner)listeners[i + 1]).propertyChanging(prop, newValue, oldValue);
        }
    }

    public void firepropertyChanged(ObjectProperty prop, Object newValue, Object oldValue) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != PropertyAdpterListner.class) continue;
            ((PropertyAdpterListner)listeners[i + 1]).propertyChanged(prop, newValue, oldValue);
        }
    }

    public MetaDataDesinerModel getModel() {
        return this.model;
    }

    public void setModel(MetaDataDesinerModel model) {
        this.model = model;
    }

    public String getCheckClass() {
        return this.checkClass;
    }
}

