/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.ide.model.property;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.base.form.ide.model.ElementPropertyAdpter;
import com.kingdee.eas.base.form.ide.model.ObjectProperty;
import com.kingdee.eas.base.form.ide.propertyeditor.ColorPropertyEditor;
import com.kingdee.eas.base.form.ide.propertyeditor.render.ColorCellRenderer;
import com.kingdee.eas.base.form.metadata.ElementProperty;
import java.awt.Color;
import java.lang.reflect.InvocationTargetException;
import javax.swing.table.TableCellRenderer;

public class ColorProp
extends ObjectProperty {
    public ColorProp(ElementPropertyAdpter propertyAdpter, ElementProperty elementProperty) {
        super(propertyAdpter, elementProperty);
    }

    @Override
    public Object getValue() {
        try {
            String colorStr = (String)this.propertyAdpter.getPropertyValue(this.elementProperty.getPropertyName());
            if (colorStr != null && colorStr.trim().length() > 0) {
                String[] tmp = colorStr.split(",");
                if (tmp == null || tmp.length != 3) {
                    tmp = new String[]{"255", "255", "0"};
                }
                int r = Integer.parseInt(tmp[0]);
                int g = Integer.parseInt(tmp[1]);
                int b = Integer.parseInt(tmp[2]);
                return new Color(r, g, b);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return Color.BLACK;
    }

    @Override
    public void setValue(Object value) {
        Color color = (Color)value;
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        String result = r + "," + g + "," + b;
        try {
            this.propertyAdpter.setPropertyValue(this.elementProperty.getPropertyName(), result);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        super.setValue(color, false);
    }

    @Override
    public Class getEditorClass() {
        return ColorPropertyEditor.class;
    }

    @Override
    public TableCellRenderer createTableCellRenderer() {
        ColorCellRenderer colorRenderer = new ColorCellRenderer();
        return colorRenderer;
    }
}

