/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.ide.model.property;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.base.form.ide.model.ElementPropertyAdpter;
import com.kingdee.eas.base.form.ide.model.ObjectProperty;
import com.kingdee.eas.base.form.ide.propertyeditor.FontNameEditor;
import com.kingdee.eas.base.form.ide.propertyeditor.render.FontRender;
import com.kingdee.eas.base.form.json.JSONException;
import com.kingdee.eas.base.form.json.JSONObject;
import com.kingdee.eas.base.form.metadata.ElementProperty;
import com.kingdee.eas.base.form.metadata.FieldAppearance;
import java.awt.Font;
import java.beans.PropertyEditor;
import javax.swing.table.TableCellRenderer;

public class FontProp
extends ObjectProperty {
    public FontProp(ElementPropertyAdpter propertyAdpter, ElementProperty elementProperty) {
        super(propertyAdpter, elementProperty);
    }

    @Override
    public PropertyEditor createPropertyEditor(PropertyEditor editor) {
        if (editor == null) {
            editor = this.createEditor();
        }
        return editor;
    }

    @Override
    public Class getEditorClass() {
        return FontNameEditor.class;
    }

    @Override
    public TableCellRenderer createTableCellRenderer() {
        FontRender render = new FontRender();
        return render;
    }

    @Override
    public Object getValue() {
        try {
            String fontStr = ((FieldAppearance)this.propertyAdpter.getAppearance()).getFont();
            if (fontStr != null && fontStr.trim().length() > 0) {
                JSONObject json = new JSONObject(fontStr);
                String name = (String)json.get("fontName");
                Integer style = (Integer)json.get("fontStyle");
                Integer size = (Integer)json.get("fontSize");
                return new Font(name, (int)style, size);
            }
        }
        catch (SecurityException e) {
            logger.error((Object)e);
        }
        catch (IllegalArgumentException e) {
            logger.error((Object)e);
        }
        catch (JSONException e) {
            logger.error((Object)e);
        }
        return new Font("Dialog", 0, 5);
    }

    @Override
    public void setValue(Object value) {
        Font font = (Font)value;
        String name = font.getFontName();
        int style = font.getStyle();
        int size = font.getSize();
        JSONObject json = new JSONObject();
        try {
            json.put("fontName", (Object)name);
            json.put("fontStyle", (Object)new Integer(style));
            json.put("fontSize", (Object)new Integer(size));
        }
        catch (JSONException e) {
            logger.error((Object)e);
        }
        try {
            this.propertyAdpter.setPropertyValue(this.elementProperty.getPropertyName(), json.toString(), true);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        super.setValue(value, true);
    }
}

