/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.ide.pe.propsheet;

import com.kingdee.eas.base.form.ide.pe.propsheet.Property;
import com.kingdee.eas.base.form.ide.pe.propsheet.PropertyDescriptorAdapter;
import com.kingdee.eas.base.form.ide.pe.propsheet.PropertyEditorFactory;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.util.HashMap;
import java.util.Map;

public class PropertyEditorRegistry
implements PropertyEditorFactory {
    private Map typeToEditor = new HashMap();
    private Map propertyToEditor = new HashMap();

    public PropertyEditorRegistry() {
        this.registerDefaults();
    }

    @Override
    public PropertyEditor createPropertyEditor(Property property) {
        return this.getEditor(property);
    }

    public synchronized PropertyEditor getEditor(Property property) {
        Class<?> clz;
        PropertyDescriptor descriptor;
        PropertyEditor editor = null;
        if (property instanceof PropertyDescriptorAdapter && (descriptor = ((PropertyDescriptorAdapter)property).getDescriptor()) != null && (clz = descriptor.getPropertyEditorClass()) != null) {
            editor = this.loadPropertyEditor(clz);
        }
        if (editor == null) {
            Object value = this.propertyToEditor.get(property);
            editor = value instanceof PropertyEditor ? (PropertyEditor)value : (value instanceof Class ? this.loadPropertyEditor((Class)value) : this.getEditor(property.getType()));
        }
        if (editor == null && property instanceof PropertyDescriptorAdapter) {
            descriptor = ((PropertyDescriptorAdapter)property).getDescriptor();
            clz = descriptor.getPropertyType();
            editor = PropertyEditorManager.findEditor(clz);
        }
        return editor;
    }

    private PropertyEditor loadPropertyEditor(Class clz) {
        PropertyEditor editor = null;
        try {
            editor = (PropertyEditor)clz.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return editor;
    }

    public synchronized PropertyEditor getEditor(Class type) {
        PropertyEditor editor = null;
        Object value = this.typeToEditor.get(type);
        if (value instanceof PropertyEditor) {
            editor = (PropertyEditor)value;
        } else if (value instanceof Class) {
            try {
                editor = (PropertyEditor)((Class)value).newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return editor;
    }

    public synchronized void registerEditor(Class type, Class editorClass) {
        this.typeToEditor.put(type, editorClass);
    }

    public synchronized void registerEditor(Class type, PropertyEditor editor) {
        this.typeToEditor.put(type, editor);
    }

    public synchronized void unregisterEditor(Class type) {
        this.typeToEditor.remove(type);
    }

    public synchronized void registerEditor(Property property, Class editorClass) {
        this.propertyToEditor.put(property, editorClass);
    }

    public synchronized void registerEditor(Property property, PropertyEditor editor) {
        this.propertyToEditor.put(property, editor);
    }

    public synchronized void unregisterEditor(Property property) {
        this.propertyToEditor.remove(property);
    }

    public void registerDefaults() {
        this.typeToEditor.clear();
        this.propertyToEditor.clear();
    }
}

