/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.ide.propertyeditor;

import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.eas.base.form.ide.propertyeditor.AbstractPropertyEditor;
import com.kingdee.eas.base.form.ide.propertyeditor.render.DefaultComboRenderer;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ListCellRenderer;

public class ComboBoxPropertyEditor
extends AbstractPropertyEditor {
    protected Object oldValue;
    protected Icon[] icons;
    protected String[] texts;
    protected KDComboBox cb;
    private Class type;
    private ActionListener editorAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            ComboBoxPropertyEditor.this.firePropertyChange(ComboBoxPropertyEditor.this.oldValue, ComboBoxPropertyEditor.this.cb.getSelectedItem());
        }
    };

    public ComboBoxPropertyEditor(Class type) {
        this.type = type;
        this.cb = new KDComboBox(){

            public void setSelectedItem(Object anObject) {
                ComboBoxPropertyEditor.this.oldValue = this.getSelectedItem();
                super.setSelectedItem(anObject);
            }
        };
        this.cb.setRenderer((ListCellRenderer)new DefaultComboRenderer(this.icons, this.texts));
        this.cb.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    ComboBoxPropertyEditor.this.firePropertyChange(ComboBoxPropertyEditor.this.oldValue, ComboBoxPropertyEditor.this.cb.getSelectedItem());
                }
            }
        });
        this.cb.setSelectedIndex(-1);
    }

    public void setEditable(boolean editable) {
        this.cb.setEditable(editable);
        if (editable) {
            this.cb.getEditor().addActionListener(this.editorAction);
        } else {
            this.cb.getEditor().removeActionListener(this.editorAction);
        }
    }

    @Override
    public Object getValue() {
        try {
            Object newValue = null;
            if (this.cb.isDisplayable() && (newValue = this.cb.getSelectedItem()) == null) {
                newValue = this.oldValue;
            }
            return newValue;
        }
        catch (Exception e) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public void setValue(Object value) {
        if (value != null) {
            if (value.getClass() != this.type) {
                throw new IllegalArgumentException("The type of value doesn't comply with the init editor type.");
            }
            Object v = value;
            if (v != null) {
                Object current = null;
                int index = -1;
                int c = this.cb.getModel().getSize();
                for (int i = 0; i < c; ++i) {
                    current = this.cb.getModel().getElementAt(i);
                    if (v == current) {
                        index = i;
                        break;
                    }
                    if (v == null || current == null || !current.equals(v)) continue;
                    index = i;
                    break;
                }
                if (index < 0) {
                    this.cb.setSelectedItem(v);
                } else {
                    this.cb.setSelectedIndex(index);
                }
            }
        }
    }

    public void setAvailableValues(Object[] values) {
        this.cb.setModel(new DefaultComboBoxModel<Object>(values));
    }

    public void setAvailableTexts(String[] texts) {
        this.texts = texts;
    }

    public void setAvailableIcons(Icon[] icons) {
        this.icons = icons;
    }

    @Override
    public Component getCustomEditor() {
        return this.cb;
    }
}

