/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.ide.propertyeditor;

import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.metadata.MetaDataNotFoundException;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.commonquery.client.Util;
import com.kingdee.eas.base.form.ide.propertyeditor.ComboBoxPropertyEditor;
import com.kingdee.eas.base.form.ide.propertyeditor.render.DefaultComboRenderer;
import com.kingdee.eas.base.form.ide.utils.EntityObjectInfoHelp;
import java.awt.Component;
import javax.swing.ListCellRenderer;

public class EntityBosTypePropertyEditor
extends ComboBoxPropertyEditor {
    public EntityBosTypePropertyEditor(Class type) {
        super(type);
    }

    public EntityBosTypePropertyEditor() {
        super(String.class);
        this.setEditable(false);
    }

    public void initData(String[] bosTypes) {
        if (bosTypes != null) {
            Object[] bosTypesCopy = new String[bosTypes.length + 1];
            this.texts = new String[bosTypes.length + 1];
            bosTypesCopy[0] = "   ";
            this.texts[0] = "   ";
            for (int i = 0; i < bosTypes.length; ++i) {
                try {
                    EntityObjectInfo entity = EntityObjectInfoHelp.getEntity(BOSObjectType.create((String)bosTypes[i]));
                    this.texts[i + 1] = Util.getEntityAlias((EntityObjectInfo)entity);
                    bosTypesCopy[i + 1] = bosTypes[i];
                    continue;
                }
                catch (MetaDataNotFoundException e) {
                    this.setAvailableValues(new String[]{"   "});
                    this.setAvailableTexts(new String[]{"   "});
                    return;
                }
            }
            this.initComboBox(this, bosTypesCopy, this.texts);
        }
    }

    @Override
    public Object getValue() {
        this.oldValue = this.cb.getSelectedItem();
        return this.oldValue;
    }

    @Override
    public void setValue(Object value) {
        this.cb.setSelectedItem(value);
    }

    @Override
    public Component getCustomEditor() {
        return this.cb;
    }

    public void initComboBox(ComboBoxPropertyEditor editor1, Object[] values, String[] alias) {
        editor1.setAvailableValues(values);
        editor1.setAvailableTexts(alias);
        ((KDComboBox)editor1.getCustomEditor()).setRenderer((ListCellRenderer)new DefaultComboRenderer(null, alias));
    }
}

