/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.ide.propertyeditor;

import com.kingdee.eas.base.form.ide.propertyeditor.AbstractPropertyEditor;
import javax.swing.JFormattedTextField;

public class NumberPropertyEditor
extends AbstractPropertyEditor {
    private final Class type;
    protected Object lastGoodValue;
    protected JFormattedTextField ftf = new JFormattedTextField();

    public NumberPropertyEditor(Class type) {
        if (!Number.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException("type must be a subclass of Number");
        }
        this.type = type;
        this.ftf.setValue(this.getDefaultValue());
    }

    protected Object getDefaultValue() {
        try {
            return this.type.getConstructor(String.class).newInstance("0");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected Object getNumberByText() {
        String text = this.ftf.getText();
        if (text == null || text.trim().length() == 0) {
            return this.getDefaultValue();
        }
        text = text.replace(',', '.');
        StringBuffer number = new StringBuffer();
        number.ensureCapacity(text.length());
        int c = text.length();
        for (int i = 0; i < c; ++i) {
            char character = text.charAt(i);
            if ('.' == character || '-' == character || Double.class.equals((Object)this.type) && 'E' == character || Float.class.equals((Object)this.type) && 'E' == character || Character.isDigit(character)) {
                number.append(character);
                continue;
            }
            if (' ' != character) break;
        }
        try {
            this.lastGoodValue = this.type.getConstructor(String.class).newInstance(number.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.lastGoodValue;
    }
}

