/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.ide.propertyeditor.f7;

import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDSeparator;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.KDTreeView;
import com.kingdee.bos.ctrl.swing.event.TreeWillExpandAdapter;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.ITreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.Util;
import com.kingdee.eas.base.form.ide.DataObjectEx;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Uuid;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class EntityTreePromptDialog
extends KDDialog
implements KDPromptSelector {
    private EntityObjectInfo entity;
    private KDTree tree;
    private KDButton btnCommit;
    private KDButton btnCancel;
    private boolean cancel = false;
    private DefaultKingdeeTreeNode result = null;
    private Map entities = new Hashtable();
    private HashSet preferedProperties = null;
    private Set linkPropertyNames = null;
    private Map filterPropertyClassType = null;
    private boolean extendConditon;
    private boolean showFirstLayer = true;
    private int maxLevel = 1;
    private int level = 0;
    private static final String entityTreePromptDialogRes = "com.kingdee.eas.base.commonquery.client.EntityTreePromptDialog";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.form.ide.propertyeditor.f7.EntityTreePromptDialog");
    private boolean isShowEntry = false;

    public EntityTreePromptDialog(Frame owner, String title, boolean modal, EntityObjectInfo entity, String[] properties, boolean extendCondition, Map filterPropertyClassType, boolean showFirstLayer, int maxLevel) {
        this(owner, title, modal, entity, properties, false, false, filterPropertyClassType, showFirstLayer, maxLevel);
    }

    public EntityTreePromptDialog(Frame owner, String title, boolean modal, EntityObjectInfo entity, String[] properties, boolean extendCondition, boolean isShowEntry, Map filterPropertyClassType, boolean showFirstLayer, int maxLevel) {
        super(owner, title, modal);
        this.setShowEntry(isShowEntry);
        this.entity = entity;
        this.extendConditon = extendCondition;
        if (properties != null && properties.length > 0) {
            this.preferedProperties = EntityTreePromptDialog.toHashSet(properties);
            this.linkPropertyNames = this.getLinkPropertyNames(this.preferedProperties);
        }
        this.filterPropertyClassType = filterPropertyClassType;
        this.showFirstLayer = showFirstLayer;
        this.maxLevel = maxLevel;
        this.jbInit();
    }

    public EntityTreePromptDialog(Frame owner, String title, boolean modal, EntityObjectInfo entity, String[] properties, Map filterPropertyClassType, boolean showFirstLayer, int maxLevel) {
        this(owner, title, modal, entity, properties, false, filterPropertyClassType, showFirstLayer, maxLevel);
    }

    public EntityTreePromptDialog(Dialog owner, String title, boolean modal, EntityObjectInfo entity, String[] properties, boolean extendCondition) {
        this(owner, title, modal, entity, properties, false, false);
    }

    public EntityTreePromptDialog(Dialog owner, String title, boolean modal, EntityObjectInfo entity, String[] properties, boolean extendCondition, boolean isShowEntry) {
        super(owner, title, modal);
        this.setShowEntry(isShowEntry);
        this.entity = entity;
        this.extendConditon = extendCondition;
        if (properties != null && properties.length > 0) {
            this.preferedProperties = EntityTreePromptDialog.toHashSet(properties);
            this.linkPropertyNames = this.getLinkPropertyNames(this.preferedProperties);
        }
        this.jbInit();
    }

    public EntityTreePromptDialog(Dialog owner, String title, boolean modal, EntityObjectInfo entity, String[] properties) {
        this(owner, title, modal, entity, properties, false);
    }

    public EntityTreePromptDialog(Frame owner, String title, EntityObjectInfo entity, String[] properties, Map filterPropertyClassType, boolean showFirstLayer, int maxLevel) {
        this(owner, title, true, entity, properties, filterPropertyClassType, showFirstLayer, maxLevel);
    }

    public EntityTreePromptDialog(Dialog owner, String title, EntityObjectInfo entity, String[] properties, String filterPropertyClassType) {
        this(owner, title, true, entity, properties);
    }

    public EntityTreePromptDialog(Frame owner, EntityObjectInfo entity, String[] properties, Map filterPropertyClassType, boolean showFirstLayer, int maxLevel) {
        this(owner, EASResource.getString((String)entityTreePromptDialogRes, (String)"dialogTitle"), true, entity, properties, filterPropertyClassType, showFirstLayer, maxLevel);
    }

    public EntityTreePromptDialog(Dialog owner, EntityObjectInfo entity, String[] properties) {
        this(owner, EASResource.getString((String)entityTreePromptDialogRes, (String)"dialogTitle"), true, entity, properties);
    }

    public EntityTreePromptDialog(Frame owner, EntityObjectInfo entity, Map filterPropertyClassType, boolean showFirstLayer, int maxLevel) {
        this(owner, entity, null, filterPropertyClassType, showFirstLayer, maxLevel);
    }

    public EntityTreePromptDialog(Dialog owner, EntityObjectInfo entity) {
        this(owner, entity, null);
    }

    private static HashSet toHashSet(String[] strary) {
        if (strary == null) {
            return null;
        }
        HashSet<String> hs = new HashSet<String>();
        int len = strary.length;
        for (int i = 0; i < len; ++i) {
            hs.add(strary[i]);
        }
        return hs;
    }

    public void show() {
        super.show();
    }

    public boolean isCanceled() {
        return this.cancel;
    }

    public Object getData() {
        if (this.result != null) {
            DataObjectEx dataObject = null;
            if (this.result.getUserObject() instanceof DataObjectEx) {
                dataObject = (DataObjectEx)((Object)this.result.getUserObject());
                String property = dataObject.getValue();
                int index = property.lastIndexOf(".");
                if (index != -1) {
                    property = property.substring(index + 1);
                }
                String alias = com.kingdee.eas.base.form.util.Util.processEntityPropertyAlias((EntityObjectInfo)this.getEntity(dataObject.getExtendValue()), (String)property, (String)dataObject.getName());
                dataObject.setName(alias);
                return dataObject;
            }
        }
        return null;
    }

    private void jbInit() {
        this.createTree(this.extendConditon, this.filterPropertyClassType);
        KDTreeView kDTreeView = new KDTreeView();
        kDTreeView.setShowButton(false);
        kDTreeView.setShowControlPanel(false);
        kDTreeView.setTree(this.tree);
        kDTreeView.setAutoscrolls(true);
        this.setSize(new Dimension(510, 410));
        this.setLocationRelativeTo(null);
        this.getContentPane().setLayout(null);
        this.getContentPane().add((Component)kDTreeView);
        kDTreeView.setBounds(10, 10, 480, 323);
        KDSeparator separator = new KDSeparator();
        this.getContentPane().add((Component)separator);
        separator.setBounds(0, 343, 500, 2);
        this.btnCommit = new KDButton();
        this.btnCommit.setText(EASResource.getString((String)entityTreePromptDialogRes, (String)"confirm"));
        this.btnCommit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EntityTreePromptDialog.this.btnCommit_onclick(e);
            }
        });
        this.btnCancel = new KDButton();
        this.btnCancel.setText(EASResource.getString((String)entityTreePromptDialogRes, (String)"cancel"));
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EntityTreePromptDialog.this.btnCancel_onclick(e);
            }
        });
        this.getContentPane().add((Component)this.btnCommit);
        this.getContentPane().add((Component)this.btnCancel);
        this.btnCommit.setBounds(341, 353, 73, 21);
        this.btnCancel.setBounds(417, 353, 73, 21);
        this.setResizable(false);
    }

    private void btnCommit_onclick(ActionEvent e) {
        this.result = (DefaultKingdeeTreeNode)this.tree.getLastSelectedPathComponent();
        if (this.result == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)entityTreePromptDialogRes, (String)"choseWarning"));
        } else if (this.result instanceof DefaultKingdeeTreeNode) {
            this.dispose();
            this.cancel = false;
        }
    }

    private void btnCancel_onclick(ActionEvent e) {
        this.dispose();
        this.cancel = true;
    }

    private DefaultKingdeeTreeNode createRoot(boolean extendCondition, Map classTypeMap) {
        EntityObjectInfo entity = this.getEntity(this.entity.getFullName());
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode();
        root.setText(Util.getEntityAlias((EntityObjectInfo)this.entity));
        DataObjectEx dataObject = new DataObjectEx();
        dataObject.setExtendValue(entity.getFullName());
        dataObject.setName("");
        dataObject.setValue("");
        root.setUserObject((Object)dataObject);
        this.createChildNode(root, extendCondition, classTypeMap);
        return root;
    }

    private void createTree(boolean extendCondition, final Map classTypeMap) {
        DefaultKingdeeTreeNode root = this.createRoot(extendCondition, classTypeMap);
        this.tree = new KDTree((ITreeNode)root, false);
        ((KingdeeTreeModel)this.tree.getModel()).setAsksAllowsChildren(true);
        this.tree.addTreeWillExpandListener((TreeWillExpandListener)new TreeWillExpandAdapter(){

            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                EntityTreePromptDialog.this.tree_treeWillExpand(event, classTypeMap);
            }
        });
        this.tree.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                EntityTreePromptDialog.this.tree_mouseClicked(e);
            }
        });
    }

    private void tree_treeWillExpand(TreeExpansionEvent e, Map classTypeMap) {
        this.result = (DefaultKingdeeTreeNode)e.getPath().getLastPathComponent();
        if (this.result.getChildCount() == 0) {
            this.createChildNode(this.result, this.extendConditon, classTypeMap);
            ((KingdeeTreeModel)this.tree.getModel()).reload((TreeNode)this.result);
        }
    }

    private void tree_mouseClicked(MouseEvent e) {
        this.result = (DefaultKingdeeTreeNode)this.tree.getLastSelectedPathComponent();
        if (e.getClickCount() == 2 && e.getButton() == 1) {
            if (this.result == null) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)entityTreePromptDialogRes, (String)"choseWarning"));
            } else if (this.result instanceof DefaultKingdeeTreeNode && !this.result.getAllowsChildren()) {
                this.dispose();
                this.cancel = false;
            }
        }
    }

    private Set getLinkPropertyNames(Set preferedProperties) {
        HashSet<String> linkPropertyNames = new HashSet<String>();
        for (String propertyName : preferedProperties) {
            int index = propertyName.lastIndexOf(".");
            if (index == -1) continue;
            linkPropertyNames.add(propertyName.substring(0, index));
        }
        return linkPropertyNames;
    }

    public void setShowEntry(boolean isShowEntry) {
        this.isShowEntry = isShowEntry;
    }

    protected boolean isShowEntry() {
        return this.isShowEntry;
    }

    private void createChildNode(DefaultKingdeeTreeNode parentNode, boolean extendCondition, Map classTypeMap) {
        ++this.level;
        DataObjectEx dataObject = (DataObjectEx)((Object)parentNode.getUserObject());
        EntityObjectInfo entity = this.getEntity(dataObject.getExtendValue());
        PropertyCollection properties = Util.getAllEntityProperties((EntityObjectInfo)entity);
        int size = properties.size();
        for (int i = 0; i < size; ++i) {
            PropertyInfo propertyInfo = properties.get(i);
            if (classTypeMap != null) {
                if (classTypeMap.containsKey("ONLY_SELECT_LINK")) {
                    if (propertyInfo instanceof OwnPropertyInfo) {
                        continue;
                    }
                } else if (!classTypeMap.containsKey("ONLY_SELECT_OWN") ? !classTypeMap.containsKey("SELECT_ALL") && propertyInfo instanceof LinkPropertyInfo : !(propertyInfo instanceof OwnPropertyInfo)) continue;
                if (!EntityTreePromptDialog.isSameClassType(propertyInfo, classTypeMap)) continue;
            }
            if (propertyInfo instanceof OwnPropertyInfo && this.preferedProperties != null && !this.preferedProperties.contains(this.getValue(dataObject, propertyInfo.getName())) || Util.checkIsMultiEntry((EntityObjectInfo)entity, (PropertyInfo)propertyInfo) && !this.isShowEntry()) continue;
            DataObjectEx childDataObject = new DataObjectEx();
            childDataObject.setName(this.getName(dataObject, Util.getPropertyAlias((PropertyInfo)propertyInfo)));
            childDataObject.setValue(this.getValue(dataObject, propertyInfo.getName()));
            childDataObject.setExtendValue(this.getExtendValue(dataObject, propertyInfo));
            DefaultKingdeeTreeNode childNode = new DefaultKingdeeTreeNode((Object)childDataObject);
            childNode.setText(Util.getPropertyAlias((PropertyInfo)propertyInfo));
            if (propertyInfo instanceof OwnPropertyInfo) {
                childDataObject.setDataType(((OwnPropertyInfo)propertyInfo).getDataType());
            }
            childDataObject.setLinkProperty(propertyInfo instanceof LinkPropertyInfo);
            if (propertyInfo instanceof LinkPropertyInfo) {
                childNode.setCustomIcon(EASResource.getIcon((String)"imgTree_folder_close"));
                if (this.showFirstLayer) {
                    childNode.setAllowsChildren(false);
                } else if (this.maxLevel == -1) {
                    childNode.setAllowsChildren(true);
                } else {
                    if (this.level >= this.maxLevel) continue;
                    childNode.setAllowsChildren(true);
                }
            } else {
                childNode.setAllowsChildren(false);
            }
            if (propertyInfo instanceof LinkPropertyInfo) {
                if (this.preferedProperties != null && this.preferedProperties.size() > 0 && !this.linkPropertyNames.contains(childDataObject.getValue())) {
                    continue;
                }
            } else if (((OwnPropertyInfo)propertyInfo).getDataType().equals((Object)DataType.BYTEARRAY)) {
                // empty if block
            }
            if (propertyInfo.isConfigured()) {
                childNode.setCustomIcon(EASResource.getIcon((String)"imgTree_attribute"));
            }
            parentNode.add((MutableTreeNode)childNode);
        }
    }

    public static boolean isSameClassType(PropertyInfo propertyInfo, Map classTypeMap) {
        boolean result = true;
        if (classTypeMap == null || classTypeMap.isEmpty()) {
            result = true;
        } else if (propertyInfo instanceof OwnPropertyInfo) {
            String javaType = EntityTreePromptDialog.getJavaTypeClassName((OwnPropertyInfo)propertyInfo);
            if (javaType == null) {
                result = true;
            } else {
                try {
                    Class<?> nodeClassType = Class.forName(javaType);
                    Iterator it = classTypeMap.keySet().iterator();
                    while (it.hasNext()) {
                        String classType = it.next().toString();
                        Class<?> targetClassType = Class.forName(classType);
                        if (targetClassType.isAssignableFrom(nodeClassType)) {
                            result = true;
                        }
                        result = false;
                    }
                }
                catch (ClassNotFoundException e) {
                    logger.error((Object)e);
                }
            }
        } else {
            result = true;
        }
        return result;
    }

    public static String getJavaTypeClassName(OwnPropertyInfo prop) {
        String javaType = prop.getJavaType();
        if (javaType.equals("short")) {
            return "java.lang.Short";
        }
        if (javaType.equals("int")) {
            return "java.lang.Integer";
        }
        if (javaType.equals("long")) {
            return "java.lang.Long";
        }
        if (javaType.equals("float")) {
            return "java.math.BigDecimal";
        }
        if (javaType.equals("double")) {
            return "java.math.BigDecimal";
        }
        if (javaType.equals("java.math.BigDecimal")) {
            return "java.math.BigDecimal";
        }
        if (javaType.equals("java.util.Date")) {
            return "java.util.Date";
        }
        if (javaType.equals("java.sql.Time")) {
            return "java.sql.Time";
        }
        if (javaType.equals("java.sql.Timestamp")) {
            return "java.sql.Timestamp";
        }
        if (javaType.equals("char")) {
            return "java.lang.String";
        }
        if (javaType.equals("boolean")) {
            return "java.lang.Boolean";
        }
        if (javaType.equals("byte") || javaType.equals("byte[]")) {
            return "java.lang.Byte";
        }
        if (javaType.equals("String")) {
            return "java.lang.String";
        }
        if (javaType.equals(IObjectPK.class.getName())) {
            return IObjectPK.class.getName();
        }
        if (javaType.equals(BOSUuid.class.getName())) {
            return BOSUuid.class.getName();
        }
        if (javaType.equals(Uuid.class.getName())) {
            return Uuid.class.getName();
        }
        if (javaType.equals("com.kingdee.util.enums.Enum") && prop.getEnumType() != null) {
            Object obj = prop.getEnumType().get("enumDataType");
            if (obj != null) {
                if (obj.toString().equalsIgnoreCase("string")) {
                    return "java.lang.String";
                }
                return "java.lang.Integer";
            }
            return null;
        }
        if (javaType.equals(IObjectValue.class.getName())) {
            return IObjectValue.class.getName();
        }
        if (javaType.equals(IObjectCollection.class.getName())) {
            return IObjectCollection.class.getName();
        }
        if (javaType.equals(IRowSet.class.getName())) {
            return IRowSet.class.getName();
        }
        return null;
    }

    private EntityObjectInfo getEntity(String entityName) {
        EntityObjectInfo objectInfo = null;
        if (!this.entities.containsKey(entityName)) {
            objectInfo = Util.getEntity((IMetaDataPK)new MetaDataPK(entityName));
            this.entities.put(entityName, objectInfo);
        } else {
            objectInfo = (EntityObjectInfo)this.entities.get(entityName);
        }
        return objectInfo;
    }

    private String getName(DataObjectEx parent, String propertyAlias) {
        String name = "";
        String parentName = parent.getName();
        name = parentName.length() == 0 ? propertyAlias : parentName + "." + propertyAlias;
        return name;
    }

    private String getValue(DataObjectEx parent, String propertyName) {
        String value = "";
        String parentValue = parent.getValue();
        value = parentValue.length() == 0 ? propertyName : parentValue + "." + propertyName;
        return value;
    }

    private String getExtendValue(DataObjectEx parent, PropertyInfo propertyInfo) {
        String extendValue = "";
        String parentExtendValue = parent.getExtendValue();
        String refEntityName = null;
        if (propertyInfo instanceof LinkPropertyInfo) {
            LinkPropertyInfo linkPropertyInfo = (LinkPropertyInfo)propertyInfo;
            refEntityName = Util.getEntity((String)parentExtendValue, (LinkPropertyInfo)linkPropertyInfo).getFullName();
        }
        extendValue = refEntityName == null ? parentExtendValue : refEntityName;
        return extendValue;
    }

    protected static String processEntityPropertyAlias(EntityObjectInfo entity, String property, String alias) {
        if (Util.isMultiKey((EntityObjectInfo)entity)) {
            return alias;
        }
        if (Util.isEntityPK((EntityObjectInfo)entity, (String)property)) {
            int sep = alias.lastIndexOf(".");
            alias = sep == -1 ? Util.getEntityAlias((EntityObjectInfo)entity) : alias.substring(0, sep);
        }
        return alias;
    }

    public Map getFilterPropertyClassType() {
        return this.filterPropertyClassType;
    }

    public void setFilterPropertyClassType(Map filterPropertyClassType) {
        this.filterPropertyClassType = filterPropertyClassType;
    }

    public boolean isShowFirstLayer() {
        return this.showFirstLayer;
    }

    public void setShowFirstLayer(boolean showFirstLayer) {
        this.showFirstLayer = showFirstLayer;
    }
}

