/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.ide.propertyeditor.render;

import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.form.ide.model.property.BOSTypeProp;
import com.kingdee.eas.base.form.ide.model.property.BindingDataProp;
import com.kingdee.eas.base.form.ide.utils.EntityObjectInfoHelp;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.table.TableCellRenderer;

public class BindingDataCellRenderer
extends KDTextField
implements TableCellRenderer,
ListCellRenderer {
    private BindingDataProp prop;

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.setOpaque(true);
        if (isSelected) {
            this.setBackground(table.getSelectionBackground());
            this.setForeground(table.getSelectionForeground());
        } else {
            this.setBackground(table.getBackground());
            this.setForeground(table.getForeground());
        }
        this.setText(value);
        return this;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
        this.setText(value);
        return this;
    }

    private void setText(Object value) {
        Object bos_type = this.prop.getBosType();
        if (bos_type == null || value == null || value.toString().length() == 0) {
            this.setText("");
        } else {
            EntityObjectInfo entity = EntityObjectInfoHelp.getEntity(BOSObjectType.create((String)bos_type.toString()));
            if (entity != null) {
                String alias;
                String properKey = value.toString();
                if (properKey.indexOf(".") > 0) {
                    properKey = properKey.substring(properKey.indexOf(".") + 1);
                }
                if (StringUtils.isEmpty((String)(alias = BOSTypeProp.getPropertyLongAlias(properKey, entity)))) {
                    this.setText("xxxxxx");
                    this.setCustomForegroundColor(Color.RED);
                    this.setToolTipText("\u7ed1\u5b9a\u7684\u5b9e\u4f53\u5c5e\u6027\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u7ed1\u5b9a");
                } else {
                    this.setText(alias);
                }
            } else {
                this.setText("");
            }
        }
    }

    public BindingDataProp getProp() {
        return this.prop;
    }

    public void setProp(BindingDataProp prop) {
        this.prop = prop;
    }
}

