/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.ide.propertyeditor.render;

import com.kingdee.eas.base.form.metadata.EnumItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.EnumUtils;
import com.kingdee.util.enums.IntEnum;
import com.kingdee.util.enums.StringEnum;
import java.awt.Component;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.apache.log4j.Logger;

public class EnumCellRenderer
extends JLabel
implements TableCellRenderer,
ListCellRenderer {
    protected Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.form.ide.propertyeditor.render.EnumCellRenderer");
    private String enumClassName;
    private List enumItems;
    private Map iconMap;
    private boolean isRequiredIcon = false;
    private boolean isRequiredText = true;

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.setOpaque(true);
        if (isSelected) {
            this.setBackground(table.getSelectionBackground());
            this.setForeground(table.getSelectionForeground());
        } else {
            this.setBackground(table.getBackground());
            this.setForeground(table.getForeground());
        }
        if (this.isRequiredText) {
            this.setText(value);
        }
        if (this.isRequiredIcon) {
            this.setIcon(this.getIcon(value));
        }
        return this;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
        this.setText(value);
        return this;
    }

    private void setText(Object value) {
        List enumList = null;
        enumList = !StringUtils.isEmpty((String)this.enumClassName) ? EnumUtils.getEnumList((String)this.enumClassName) : this.enumItems;
        if (value == null || value.toString().trim().length() == 0) {
            this.setText("");
        } else {
            try {
                Object firstEnum = enumList.get(0);
                if (firstEnum instanceof IntEnum) {
                    String alias = "";
                    for (int i = 0; i < enumList.size(); ++i) {
                        if (((IntEnum)enumList.get(i)).getValue() != Integer.parseInt(value.toString())) continue;
                        alias = ((IntEnum)enumList.get(i)).getAlias();
                        break;
                    }
                    this.setText(alias);
                } else if (firstEnum instanceof StringEnum) {
                    String alias = "";
                    for (int i = 0; i < enumList.size(); ++i) {
                        if (!((StringEnum)enumList.get(i)).getValue().equalsIgnoreCase(value.toString())) continue;
                        alias = ((StringEnum)enumList.get(i)).getAlias();
                        break;
                    }
                    this.setText(alias);
                } else if (firstEnum instanceof EnumItem) {
                    String alias = "";
                    for (int i = 0; i < enumList.size(); ++i) {
                        if (((EnumItem)enumList.get(i)).getValue() != Integer.parseInt(value.toString())) continue;
                        alias = ((EnumItem)enumList.get(i)).getDisplayValue();
                        break;
                    }
                    this.setText(alias);
                }
            }
            catch (NumberFormatException e) {
                this.logger.error((Object)e);
            }
        }
    }

    private Icon getIcon(Object value) {
        if (value == null || value.toString().trim().length() == 0) {
            IntEnum firstEnum = (IntEnum)EnumUtils.getEnumList((String)this.enumClassName).get(0);
            return (Icon)this.iconMap.get(firstEnum.getValue() + "");
        }
        try {
            IntEnum aEnum = EnumUtils.getEnum(Class.forName(this.enumClassName), (int)Integer.parseInt(value.toString()));
            return (Icon)this.iconMap.get(aEnum.getValue() + "");
        }
        catch (NumberFormatException e) {
            this.logger.error((Object)e);
        }
        catch (ClassNotFoundException e) {
            this.logger.error((Object)e);
        }
        return null;
    }

    public void setEnumClassName(String enumClassName) {
        this.enumClassName = enumClassName;
    }

    public void setIconMap(Map iconMap) {
        this.iconMap = iconMap;
    }

    public void setRequiredIcon(boolean isRequiredIcon) {
        this.isRequiredIcon = isRequiredIcon;
    }

    public void setRequiredText(boolean isRequiredText) {
        this.isRequiredText = isRequiredText;
    }

    public List getEnumitems() {
        return this.enumItems;
    }

    public void setEnumitems(List enumItems) {
        this.enumItems = enumItems;
    }
}

