/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.ide.propertyeditor.render;

import com.kingdee.eas.base.form.ide.propertyeditor.render.DefaultCellRenderer;
import com.kingdee.eas.base.form.json.JSONException;
import com.kingdee.eas.base.form.json.JSONObject;
import com.kingdee.eas.base.form.util.LabelStyleConstants;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import javax.swing.Icon;
import javax.swing.UIManager;

public class TextStyleRenderer
extends DefaultCellRenderer {
    private PaintIcon iconCache = new PaintIcon(null);

    @Override
    protected String convertToString(Object value) {
        if (null == value) {
            return null;
        }
        try {
            return new JSONObject((String)value).getString(LabelStyleConstants.FONT_NAME);
        }
        catch (JSONException e) {
            return null;
        }
    }

    @Override
    protected Icon convertToIcon(Object value) {
        PaintIcon retIcon = null;
        if (value != null) {
            try {
                JSONObject json = new JSONObject((String)value);
                String[] tmp = ((String)json.get(LabelStyleConstants.COLOR)).split(LabelStyleConstants.COLOR_SPLIT);
                Color color = new Color(Integer.parseInt(tmp[0]), Integer.parseInt(tmp[1]), Integer.parseInt(tmp[2]));
                this.iconCache.setPaint(color);
                retIcon = this.iconCache;
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return retIcon;
    }

    public static class PaintIcon
    implements Icon {
        private Paint color;
        private final int width;
        private final int height;

        public PaintIcon(Paint color) {
            this(color, 20, 10);
        }

        public PaintIcon(Paint color, int width, int height) {
            this.color = color;
            this.width = width;
            this.height = height;
        }

        @Override
        public int getIconHeight() {
            return this.height;
        }

        @Override
        public int getIconWidth() {
            return this.width;
        }

        public void setPaint(Paint paint) {
            this.color = paint;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2d = (Graphics2D)g;
            Paint oldPaint = g2d.getPaint();
            if (this.color != null) {
                g2d.setPaint(this.color);
                g.fillRect(x, y, this.getIconWidth(), this.getIconHeight());
            }
            g.setColor(UIManager.getColor("controlDkShadow"));
            g.drawRect(x, y, this.getIconWidth(), this.getIconHeight());
            g2d.setPaint(oldPaint);
        }
    }
}

