/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.ide.view;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.ctrl.swing.event.TabbedPaneCloseAllTabListener;
import com.kingdee.eas.base.form.core.MetaDataFactory;
import com.kingdee.eas.base.form.designer.ToolBarOperation;
import com.kingdee.eas.base.form.designer.listenner.CommandListChangedListener;
import com.kingdee.eas.base.form.ide.ExtToolbarManager;
import com.kingdee.eas.base.form.ide.designer.CombinUIDesigner;
import com.kingdee.eas.base.form.ide.designer.FilterDesigner;
import com.kingdee.eas.base.form.ide.designer.SubDesignerView;
import com.kingdee.eas.base.form.ide.model.MetaDataDesinerModel;
import com.kingdee.eas.base.form.ide.view.EntityView;
import com.kingdee.eas.base.form.ide.view.IDesignerContent;
import com.kingdee.eas.base.form.ide.view.IDesignerView;
import com.kingdee.eas.base.form.ide.view.IPropertyView;
import com.kingdee.eas.base.form.ide.view.IToolBoxView;
import com.kingdee.eas.base.form.ide.view.SolutionView;
import com.kingdee.eas.base.form.ide.workbench.ui.ITrimView;
import com.kingdee.eas.base.form.metadata.ElementTypes;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class DesignerView
extends KDPanel
implements ITrimView,
IDesignerView,
Observer {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.form.ide.view.DesignerView");
    protected KDTabbedPane tab;
    protected IPropertyView propertyView;
    protected IToolBoxView toolBoxView;
    protected EntityView entityView;
    protected SolutionView solutionView;
    protected ExtToolbarManager toolbarManager;
    protected Map cacheContentMap = new HashMap();
    protected Map cacheElementTypesMap = new HashMap();
    protected IDesignerContent currentContent;

    public DesignerView() {
        this.setLayout(new BorderLayout());
    }

    public DesignerView(IPropertyView propertyView, IToolBoxView toolBoxView, ExtToolbarManager toolbarManager, EntityView entityView, SolutionView solutionView) {
        this();
        this.propertyView = propertyView;
        this.toolBoxView = toolBoxView;
        this.toolbarManager = toolbarManager;
        this.entityView = entityView;
        this.solutionView = solutionView;
    }

    public void closeCurrentPanel() {
        if (this.tab != null && this.tab.getTabCount() > 0) {
            int selectedIndex = this.tab.getSelectedIndex();
            Component comp = this.tab.getSelectedComponent();
            if (comp instanceof SubDesignerView) {
                ((SubDesignerView)((Object)comp)).closeAllTabs();
            } else {
                IDesignerContent content = (IDesignerContent)this.cacheContentMap.get(this.currentContent.getKey());
                if (content != null && content.queryUnLoad()) {
                    content.deActive();
                }
                this.cacheContentMap.remove(this.currentContent.getKey());
                this.tab.remove(selectedIndex);
                this.refreshToolBox();
            }
        }
    }

    public void deleteLayoutPanel(String formKey, String layoutKey) {
        IDesignerContent content;
        if (this.tab != null && this.tab.getTabCount() > 0 && (content = (IDesignerContent)this.cacheContentMap.get(formKey)) != null) {
            SubDesignerView subView = (SubDesignerView)((Object)content.getDesignerComponent());
            subView.closePanel(formKey, layoutKey);
            subView.removeLayout(layoutKey);
        }
    }

    public void closePanel(String formKey, String layoutKey) {
        if (this.tab != null && this.tab.getTabCount() > 0) {
            String key = this instanceof SubDesignerView ? layoutKey : formKey;
            IDesignerContent content = (IDesignerContent)this.cacheContentMap.get(key);
            if (content != null) {
                this.tab.remove(content.getDesignerComponent());
                if (content.queryUnLoad()) {
                    content.deActive();
                }
            }
            this.cacheContentMap.remove(key);
            this.refreshToolBox();
        }
    }

    public void closeAllTabs() {
        if (this.tab != null && this.tab.getTabCount() > 0) {
            for (int i = this.tab.getTabCount() - 1; i >= 0; --i) {
                this.tab.removeTabAt(i);
            }
            for (Object key : this.cacheContentMap.keySet()) {
                IDesignerContent content = (IDesignerContent)this.cacheContentMap.get(key);
                if (content == null) continue;
                content.deActive();
            }
            this.cacheContentMap.clear();
        }
    }

    protected void setTab() {
    }

    protected void showDesignContent(IDesignerContent content) {
        if (this.tab == null) {
            this.tab = new KDTabbedPane();
            this.setTab();
            this.add((Component)this.tab, "Center");
            this.tab.setViewStyle(2);
            this.tab.addCloseActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DesignerView.this.closeCurrentPanel();
                }
            });
            this.tab.addCloseAllTabListener(new TabbedPaneCloseAllTabListener(){

                public void closeAllTab(ActionEvent e) {
                    DesignerView.this.closeAllTabs();
                }
            });
            this.tab.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    DesignerView.this.selectedChanged(e);
                }
            });
        }
        Component designerComp = content.getDesignerComponent();
        ToolBarOperation tbo = content.getToolBarOperation();
        if (tbo != null) {
            content.getToolBarOperation().getCommandList().removeCommandSizeChangedListener((CommandListChangedListener)this.toolbarManager);
            content.getToolBarOperation().getCommandList().addCommandSizeChangedListener((CommandListChangedListener)this.toolbarManager);
            content.getToolBarOperation().getCommandList().initUndoRedoAction();
        }
        this.cacheContentMap.put(content.getKey(), content);
        this.tab.add(content.getTitle(), designerComp);
        this.tab.setSelectedComponent(designerComp);
        List groupIDList = content.getElementGroupIDList();
        if (groupIDList == null) {
            return;
        }
        Collections.sort(groupIDList);
        this.toolBoxView.refreshToolBox(groupIDList);
    }

    private void selectedChanged(ChangeEvent e) {
        if (e.getSource() != null && e.getSource() instanceof KDTabbedPane) {
            this.refreshToolBox();
        }
    }

    private void refreshToolBox() {
        int selectedIndex = this.tab.getSelectedIndex();
        this.propertyView.commitCurrentPropEditing();
        if (this.currentContent != null) {
            this.currentContent.deActive();
        }
        Component comp = this.tab.getSelectedComponent();
        Object key = null;
        if (comp instanceof KDScrollPane) {
            KDScrollPane sPanel = (KDScrollPane)comp;
            key = sPanel.getUserObject();
        } else if (comp instanceof SubDesignerView) {
            SubDesignerView subView = (SubDesignerView)((Object)comp);
            key = subView.getKey();
        }
        if (this.cacheContentMap.containsKey(key)) {
            if (this.currentContent != (IDesignerContent)this.cacheContentMap.get(key)) {
                this.currentContent = (IDesignerContent)this.cacheContentMap.get(key);
                this.currentContent.active();
                this.toolBoxView.refreshToolBox(this.currentContent.getElementGroupIDList());
                ToolBarOperation tbo = this.currentContent.getToolBarOperation();
                if (tbo != null) {
                    tbo.getCommandList().removeCommandSizeChangedListener((CommandListChangedListener)this.toolbarManager);
                    tbo.getCommandList().addCommandSizeChangedListener((CommandListChangedListener)this.toolbarManager);
                    tbo.getCommandList().initUndoRedoAction();
                }
            }
        } else if (selectedIndex == -1) {
            this.toolBoxView.refreshToolBox(null);
            this.toolbarManager.initToolbarAction();
            this.entityView.refreshEntity("");
        }
    }

    @Override
    public void onViewHide() {
    }

    @Override
    public void onViewShow() {
    }

    @Override
    public void onExclusive(boolean isExclusive) {
    }

    @Override
    public void update(Observable o, Object arg) {
        Map dataMap = (Map)arg;
        try {
            int operation_type = dataMap.get("operation_type") == null ? 0 : (Integer)dataMap.get("operation_type");
            String layoutKey = (String)dataMap.get("layout_key");
            String formKey = (String)dataMap.get("form_id");
            if (operation_type == 4) {
                this.deleteLayoutPanel(formKey, layoutKey);
            } else if (operation_type == 3) {
                this.closePanel(formKey, layoutKey);
            } else {
                this.showFormDesignerPanel(dataMap);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.handUIException(e);
        }
    }

    public void handUIException(Throwable e) {
        logger.error((Object)e);
        MsgBox.showError((Component)((Object)this), (String)e.getMessage());
        SysUtil.abort();
    }

    private void showFormDesignerPanel(Map dataMap) throws Exception {
        String formId = (String)dataMap.get("form_id");
        int solutionID = (Integer)dataMap.get("solution_id");
        Object operType = dataMap.get("operation_type");
        IDesignerContent d = null;
        if ((operType == null || operType != null && (Integer)operType != 1) && formId != null && formId.trim().length() > 0 && this.cacheContentMap.containsKey(formId)) {
            IDesignerContent tmpContent = (IDesignerContent)this.cacheContentMap.get(formId);
            Component comp = tmpContent.getDesignerComponent();
            this.tab.setSelectedComponent(comp);
            if (comp instanceof SubDesignerView) {
                ((SubDesignerView)((Object)comp)).showPanel(dataMap);
            }
        } else {
            ElementTypes types = null;
            if (this.cacheElementTypesMap.containsKey(new Integer(solutionID))) {
                types = (ElementTypes)this.cacheElementTypesMap.get(new Integer(solutionID));
            } else {
                try {
                    types = MetaDataFactory.getElementTypes(null, (int)solutionID);
                    this.cacheElementTypesMap.put(new Integer(solutionID), types);
                }
                catch (BOSException e) {
                    e.printStackTrace();
                    MsgBox.showError((String)e.getMessage());
                    return;
                }
            }
            MetaDataDesinerModel model = new MetaDataDesinerModel(formId, types, dataMap);
            switch (model.getElementTypeId()) {
                case 100: {
                    d = new SubDesignerView(model, this.propertyView, this.toolBoxView, dataMap, this.toolbarManager, this.entityView, this.solutionView);
                    break;
                }
                case 210: {
                    d = new CombinUIDesigner(model, this.propertyView, this.toolBoxView, this.solutionView);
                    break;
                }
                case 200: {
                    d = new FilterDesigner(model, this.propertyView, this.toolBoxView, this.toolbarManager, this.solutionView);
                }
            }
            this.showDesignContent(d);
            this.updateUI();
        }
    }

    @Override
    public IDesignerContent getContent() {
        return this.currentContent;
    }

    @Override
    public void showNewForm(Map dataMap) {
        try {
            this.showFormDesignerPanel(dataMap);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    @Override
    public void close() {
        this.closeCurrentPanel();
    }

    @Override
    public void closeAll() {
        this.closeAllTabs();
    }

    @Override
    public void saveAll() {
        if (this.cacheContentMap != null && !this.cacheContentMap.isEmpty()) {
            this.saveAll(new HashMap());
        }
    }

    private void saveAll(Map savedMap) {
        boolean isSave = false;
        for (Object key : this.cacheContentMap.keySet()) {
            IDesignerContent content;
            if (savedMap.containsKey(key) || (content = (IDesignerContent)this.cacheContentMap.get(key)) == null) continue;
            try {
                content.save();
                content.afterSave();
                savedMap.put(content.getKey(), null);
                isSave = true;
                break;
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        if (isSave) {
            this.saveAll(savedMap);
        }
    }

    public Map getCacheContentMap() {
        return this.cacheContentMap;
    }

    @Override
    public void clearAllContentCommandList() {
        if (this.cacheContentMap != null) {
            for (Object key : this.cacheContentMap.keySet()) {
                IDesignerContent content = (IDesignerContent)this.cacheContentMap.get(key);
                if (content == null) continue;
                content.getToolBarOperation().getCommandList().clear();
            }
        }
    }

    @Override
    public void clearCurrentContentCommandList() {
        if (this.currentContent != null) {
            this.currentContent.getToolBarOperation().getCommandList().clear();
        }
    }

    @Override
    public List getSelectedBills() {
        if (this.solutionView != null) {
            return this.solutionView.getBills();
        }
        return null;
    }

    public int getOpenForms() {
        if (this.tab == null) {
            return 0;
        }
        return this.tab.getTabCount();
    }
}

