/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.ide.view;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.KDTreeView;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.configure.IMetadataStore;
import com.kingdee.bos.metadata.configure.MetadataStoreFactory;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.data.PrimaryKeyInfo;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.util.CloneUtils;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.form.core.MetaDataHelper;
import com.kingdee.eas.base.form.ide.client.EntityDataSelector;
import com.kingdee.eas.base.form.ide.client.FormPropertyEditUI;
import com.kingdee.eas.base.form.ide.client.util.IdeUtil;
import com.kingdee.eas.base.form.ide.view.DragHandler;
import com.kingdee.eas.base.form.ide.view.ICreateDataChangeListener;
import com.kingdee.eas.base.form.ide.view.ICreateDataView;
import com.kingdee.eas.base.form.ide.view.IDragData;
import com.kingdee.eas.base.form.ide.view.PropertyNodeObject;
import com.kingdee.eas.base.form.ide.workbench.ui.ITrimView;
import com.kingdee.eas.base.form.metadata.BusinessInfo;
import com.kingdee.eas.base.form.metadata.Entity;
import com.kingdee.eas.base.form.metadata.Field;
import com.kingdee.eas.base.form.metadata.LayoutInfo;
import com.kingdee.eas.base.form.util.Util;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.dynbusiness.util.BusinessProcessUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ComponentUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Observer;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.event.EventListenerList;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class EntityView
extends KDPanel
implements ITrimView,
ICreateDataView,
IDragData {
    protected KDTreeView kDTreeView;
    protected KDTree kDTree;
    protected KDLabelContainer contEntity;
    protected KDBizPromptBox prmtEntity;
    private EntityObjectInfo mainEntity;
    private Map entities = new Hashtable();
    private KDPopupMenu popupMenu;
    private KDMenuItem miView;
    private KDMenuItem miNew;
    private KDMenuItem miEdit;
    private KDMenuItem miDelete;
    private KDMenuItem miCreateTableSQL;
    private KDMenuItem miCreateFieldSQL;
    private DefaultKingdeeTreeNode selectedNode;
    private KDWorkButton btnEntity;
    private boolean canEdit;
    private Vector obs = null;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.form.ide.view.EntityView");
    private EventListenerList listenerList;
    private String entityKey = "";
    private String bosType = "";

    public EntityView() {
        super((LayoutManager)new BorderLayout(), true);
        this.initComp();
        this.obs = new Vector();
        this.listenerList = new EventListenerList();
    }

    public void addObserver(Observer o) {
        if (!this.obs.contains(o) && o != null) {
            this.obs.add(o);
        }
    }

    public void removeObserver(Observer o) {
        this.obs.remove(o);
    }

    public void setCanEdit(boolean canEdit) {
        this.canEdit = canEdit;
    }

    private void initComp() {
        this.kDTreeView = new KDTreeView();
        this.kDTree = new KDTree();
        this.kDTreeView.setName("kDTreeView");
        this.kDTree.setName("kDTree");
        this.kDTree.setDragEnabled(true);
        DragHandler l = new DragHandler(this);
        this.kDTree.addMouseListener((MouseListener)l);
        this.kDTree.addMouseMotionListener((MouseMotionListener)l);
        this.kDTreeView.setBounds(new Rectangle(51, 55, 170, 267));
        this.add((Component)this.kDTreeView, null);
        this.kDTreeView.setTree(this.kDTree);
        this.kDTree.addMouseListener((MouseListener)new ShowPropertyAdapter());
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode((Object)"\u5b9e\u4f53");
        this.kDTree.setModel((TreeModel)new KingdeeTreeModel((TreeNode)root));
        this.kDTree.setRootVisible(false);
        this.kDTree.updateUI();
        this.kDTreeView.getControlPane().remove(0);
        this.kDTreeView.getControlPane().remove(1);
        this.kDTreeView.getControlPane().remove(1);
        this.kDTreeView.getControlPane().remove(1);
        this.kDTreeView.getControlPane().remove(1);
        this.kDTreeView.getControlPane().remove(0);
        this.btnEntity = new KDWorkButton(EASResource.getIcon((String)"imgTbtn_uniterangemaintenance"));
        this.btnEntity.setToolTipText("\u9009\u62e9\u5b9e\u4f53");
        this.btnEntity.setVisible(false);
        this.kDTreeView.getControlPane().add((Component)this.btnEntity);
        this.btnEntity.addActionListener((ActionListener)new BindEntityActionListner(this));
        this.popupMenu = new KDPopupMenu();
        this.miView = new KDMenuItem("\u67e5\u770b");
        this.miView.addActionListener((ActionListener)new EditPropertyActionListner(OprtState.VIEW));
        this.popupMenu.add((JMenuItem)this.miView);
        this.miNew = new KDMenuItem("\u65b0\u589e");
        this.miNew.addActionListener((ActionListener)new EditPropertyActionListner(OprtState.ADDNEW));
        this.popupMenu.add((JMenuItem)this.miNew);
        this.miEdit = new KDMenuItem("\u4fee\u6539");
        this.miEdit.addActionListener((ActionListener)new EditPropertyActionListner(OprtState.EDIT));
        this.popupMenu.add((JMenuItem)this.miEdit);
        this.miDelete = new KDMenuItem("\u5220\u9664");
        this.miDelete.addActionListener((ActionListener)new EditPropertyActionListner("Delete"));
        this.popupMenu.add((JMenuItem)this.miDelete);
        this.miCreateTableSQL = new KDMenuItem("\u5bfc\u51fa\u8868\u811a\u672c");
        this.miCreateTableSQL.addActionListener((ActionListener)new CreateSQLActionListner("Table"));
        this.popupMenu.add((JMenuItem)this.miCreateTableSQL);
        this.miCreateFieldSQL = new KDMenuItem("\u5bfc\u51fa\u8868\u5b57\u6bb5\u811a\u672c");
        this.miCreateFieldSQL.addActionListener((ActionListener)new CreateSQLActionListner("Field"));
        this.popupMenu.add((JMenuItem)this.miCreateFieldSQL);
    }

    @Override
    public void onViewHide() {
    }

    @Override
    public void onViewShow() {
    }

    @Override
    public void onExclusive(boolean isExclusive) {
    }

    @Override
    public void addCreateDataChangeListener(ICreateDataChangeListener l) {
        this.listenerList.add(ICreateDataChangeListener.class, l);
    }

    @Override
    public void removeCreateDataChangeListener(ICreateDataChangeListener l) {
        this.listenerList.remove(ICreateDataChangeListener.class, l);
    }

    @Override
    public void fireCreateDataChanged(Object data) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ICreateDataChangeListener.class) continue;
            ((ICreateDataChangeListener)listeners[i + 1]).createDataChanged(data);
        }
    }

    public void refreshEntity(String key, BusinessInfo businessInfo, LayoutInfo layoutinfo) {
        this.entityKey = key;
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode();
        root.setText("Entity");
        List list = businessInfo.getEntrys();
        for (int i = 0; i < list.size(); ++i) {
            Entity entity = (Entity)list.get(i);
            DefaultKingdeeTreeNode node = layoutinfo.getAppearance(entity.getKey()) != null ? this.createChild(root, entity.getTableName(), entity, EASResource.getIcon((String)"imgTbtn_reportformsopen")) : this.createChild(root, entity.getTableName(), entity, null);
            Vector fields = entity.getFields();
            for (int j = 0; j < fields.size(); ++j) {
                Field fld = (Field)fields.get(j);
                if (fld.getElementType() == 14) continue;
                if (layoutinfo.getAppearance(fld.getKey()) != null) {
                    this.createChild(node, fld.getName(SysContext.getSysContext().getLocale()), fld, EASResource.getIcon((String)"imgTbtn_openreport"));
                    continue;
                }
                this.createChild(node, fld.getName(SysContext.getSysContext().getLocale()), fld, null);
            }
        }
        this.kDTree.setModel((TreeModel)new KingdeeTreeModel((TreeNode)root));
        this.kDTree.setRootVisible(false);
        this.kDTree.updateUI();
        this.kDTree.expandAllNodes(true, (TreeNode)root);
    }

    private DefaultKingdeeTreeNode createChild(DefaultKingdeeTreeNode parent, String text, Object userData, Icon icon) {
        DefaultKingdeeTreeNode childNode = new DefaultKingdeeTreeNode();
        childNode.setText(text);
        childNode.setUserObject(userData);
        if (icon != null) {
            childNode.setCustomIcon(icon);
        }
        parent.add((MutableTreeNode)childNode);
        return childNode;
    }

    public void refreshEntity() {
        this.refreshEntity(this.bosType);
    }

    public void refreshEntity(String bosType) {
        this.bosType = bosType;
        if (StringUtils.isEmpty((String)bosType)) {
            this.kDTree.setModel(null);
            return;
        }
        try {
            this.mainEntity = BusinessProcessUtil.getEntityInfo(null, (BOSObjectType)BOSObjectType.create((String)bosType));
        }
        catch (Exception ex) {
            this.kDTree.setModel(null);
            return;
        }
        if (this.mainEntity == null) {
            return;
        }
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode();
        root.setText(MetaDataHelper.getEntityAlias((EntityObjectInfo)this.mainEntity));
        root.setUserObject((Object)new PropertyNodeObject(this.mainEntity, null));
        this.createChildNode(root);
        this.kDTree.setModel((TreeModel)new KingdeeTreeModel((TreeNode)root));
        this.kDTree.setRootVisible(true);
        this.kDTree.updateUI();
    }

    private void createChildNode(DefaultKingdeeTreeNode parentNode) {
        PropertyNodeObject nodeObject = (PropertyNodeObject)parentNode.getUserObject();
        EntityObjectInfo entity = nodeObject.entity;
        PropertyCollection properties = MetaDataHelper.getAllEntityProperties((EntityObjectInfo)entity);
        int size = properties.size();
        for (int i = 0; i < size; ++i) {
            PropertyInfo propertyInfo = properties.get(i);
            this.createAChildNode(parentNode, entity, propertyInfo);
        }
    }

    private void createAChildNode(DefaultKingdeeTreeNode parentNode, EntityObjectInfo entity, PropertyInfo propertyInfo) {
        PropertyNodeObject childObject = new PropertyNodeObject(propertyInfo);
        DefaultKingdeeTreeNode childNode = new DefaultKingdeeTreeNode((Object)childObject);
        childNode.setText(MetaDataHelper.getPropertyAlias((PropertyInfo)propertyInfo));
        if (!(propertyInfo instanceof LinkPropertyInfo)) {
            childNode.setAllowsChildren(false);
            if (propertyInfo.isConfigured()) {
                childNode.setCustomIcon(EASResource.getIcon((String)"imgTree_attribute"));
            }
            parentNode.add((MutableTreeNode)childNode);
        } else if (BusinessProcessUtil.isCompositionLink((EntityObjectInfo)entity, (PropertyInfo)propertyInfo)) {
            LinkPropertyInfo linkPropertyInfo = (LinkPropertyInfo)propertyInfo;
            EntityObjectInfo supplyEntity = linkPropertyInfo.getRelationship().getSupplierObject();
            EntityObjectInfo childEntity = linkPropertyInfo.getRelationship().getClientObject();
            if (Util.isSameOrAncestor((EntityObjectInfo)childEntity, (EntityObjectInfo)entity)) {
                childObject.entity = supplyEntity;
                this.createChildNode(childNode);
                childNode.setAllowsChildren(true);
                parentNode.add((MutableTreeNode)childNode);
            }
        } else {
            childNode.setAllowsChildren(false);
            if (propertyInfo.isConfigured()) {
                childNode.setCustomIcon(EASResource.getIcon((String)"imgTree_attribute"));
            }
            parentNode.add((MutableTreeNode)childNode);
        }
    }

    private EntityObjectInfo getEntity(String entityName, boolean isUpdated) {
        EntityObjectInfo objectInfo = null;
        if (isUpdated || !this.entities.containsKey(entityName)) {
            objectInfo = MetaDataHelper.getEntity((IMetaDataPK)new MetaDataPK(entityName));
            this.entities.put(entityName, objectInfo);
        } else {
            objectInfo = (EntityObjectInfo)this.entities.get(entityName);
        }
        return objectInfo;
    }

    private void updateEntity(DefaultKingdeeTreeNode node) {
        PropertyNodeObject nodeObject;
        PropertyNodeObject nodeEntity = nodeObject = (PropertyNodeObject)node.getUserObject();
        EntityObjectInfo newEntity = null;
        if (nodeEntity.entity == null) {
            DefaultKingdeeTreeNode parentNode = (DefaultKingdeeTreeNode)node.getParent();
            nodeEntity = (PropertyNodeObject)parentNode.getUserObject();
        }
        nodeObject.entity = newEntity = this.getEntity(nodeEntity.entity.getFullName(), true);
    }

    public void openEntityDesigner() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("EntityDesignerKey", this.entityKey);
        for (int i = 0; i < this.obs.size(); ++i) {
            ((Observer)this.obs.get(i)).update(null, map);
        }
    }

    private void handlePropertyEdit(DefaultKingdeeTreeNode node, String operation) {
        if (node == null || !(node.getUserObject() instanceof PropertyNodeObject)) {
            return;
        }
        PropertyNodeObject nodeObject = (PropertyNodeObject)node.getUserObject();
        EntityObjectInfo entity = nodeObject.entity;
        DefaultKingdeeTreeNode parentNode = node;
        if (entity == null) {
            parentNode = (DefaultKingdeeTreeNode)node.getParent();
            PropertyNodeObject parentNO = (PropertyNodeObject)parentNode.getUserObject();
            entity = parentNO.entity;
        }
        EntityObjectInfo clone = null;
        DataTableInfo cloneTable = null;
        if (operation.equals("Delete")) {
            if (!MsgBox.isYes((int)MsgBox.showConfirm2((String)"\u51c6\u5907\u5220\u9664\u5f53\u524d\u6570\u636e\uff0c\u786e\u5b9a\u7ee7\u7eed\u5417\uff1f"))) {
                return;
            }
        } else {
            nodeObject = this.showPropertyEditUI(operation, nodeObject, entity);
            if (!nodeObject.isChanged) {
                return;
            }
            nodeObject.setChanged(false);
        }
        try {
            clone = CloneUtils.clone((EntityObjectInfo)entity);
            cloneTable = (DataTableInfo)clone.getTable().clone();
        }
        catch (CloneNotSupportedException e1) {
            e1.printStackTrace();
        }
        if (operation.equals(OprtState.ADDNEW)) {
            clone.getProperties().add(nodeObject.property);
            this.createAChildNode(parentNode, entity, nodeObject.property);
        } else if (operation.equals("Delete")) {
            clone.getProperties().remove(nodeObject.property);
            if (nodeObject.property.getMappingField() != null && !StringUtils.isEmpty((String)nodeObject.property.getMappingField().getName())) {
                cloneTable.getColumns().remove(nodeObject.property.getMappingField());
            }
            parentNode.remove(parentNode.getIndex((TreeNode)node));
        } else if (null == nodeObject.property) {
            node.setText(nodeObject.entity.getAlias());
        } else {
            node.setText(nodeObject.property.getAlias());
        }
        IMetadataStore mds = MetadataStoreFactory.getMetadataStore(null);
        try {
            mds.validate(clone);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (operation.equals("Delete")) {
            this.updateEntity(parentNode);
        } else {
            this.updateEntity(node);
        }
        this.kDTree.updateUI();
    }

    private void createSQL(EntityObjectInfo info, PropertyInfo prop, String operation) {
        if (operation.equalsIgnoreCase("table")) {
            DataTableInfo table = info.getTable();
            if (table == null) {
                MsgBox.showError((Component)ComponentUtil.getCurrentActiveWindow(), (String)"\u8be5\u5b9e\u4f53\u6ca1\u6709\u5b9a\u4e49\u8868\uff01");
                return;
            }
            String sql1 = "If not exists ( select * from KSQL_USERCOLUMNS where KSQL_COL_TABNAME = '" + table.getName() + "') \n";
            String sql2 = "Create Table " + table.getName() + "( ";
            String sql3 = "";
            for (int i = 0; i < table.getColumns().size(); ++i) {
                ColumnInfo col = table.getColumns().get(i);
                if (col == null || StringUtils.isEmpty((String)col.getName())) continue;
                String[] columnStr = this.getDefineColumnSql(col);
                for (int j = 0; j < columnStr.length; ++j) {
                    sql2 = sql2 + columnStr[j] + ", ";
                }
            }
            PrimaryKeyInfo primaryKey = table.getPrimaryKey();
            String tmp = "";
            for (int i = 0; i < primaryKey.getPKColumns().size(); ++i) {
                tmp = tmp + primaryKey.getPKColumns().get(i).getColumn().getName() + ",";
            }
            if (tmp.length() > 0) {
                tmp = tmp.substring(0, tmp.length() - 1);
                sql3 = " CONSTRAINT " + primaryKey.getName() + " PRIMARY KEY (" + tmp + ")); \n";
            } else {
                sql2 = sql2.substring(0, sql2.length() - 2);
                sql3 = " ); \n";
            }
            this.outputSQL(sql1 + sql2 + sql3, "\u6570\u636e\u8868\u811a\u672c", table.getName());
        } else if (operation.equalsIgnoreCase("field")) {
            ColumnInfo mappingField = prop.getMappingField();
            DataTableInfo table = info.getTable();
            if (mappingField == null || StringUtils.isEmpty((String)mappingField.getName())) {
                MsgBox.showError((Component)ComponentUtil.getCurrentActiveWindow(), (String)"\u8be5\u5c5e\u6027\u6ca1\u6709\u5b9a\u4e49\u5b57\u6bb5\uff01");
            } else if ((mappingField = table.getColumnByName(mappingField.getName())).isMultilingual()) {
                String[] columnStr = this.getDefineColumnSql(mappingField);
                String sql = "";
                for (int j = 1; j <= columnStr.length; ++j) {
                    String sql1 = "If not exists ( select * from KSQL_USERCOLUMNS where KSQL_COL_NAME = '" + mappingField.getName() + "_L" + j + "' and KSQL_COL_TABNAME = '" + table.getName() + "') \n";
                    String sql2 = "alter table " + table.getName() + " add " + columnStr[j - 1] + ";\n\n";
                    sql = sql + sql1 + sql2;
                }
                this.outputSQL(sql, "\u5b57\u6bb5\u811a\u672c", table.getName() + "_" + mappingField.getName());
            } else {
                String sql1 = "If not exists ( select * from KSQL_USERCOLUMNS where KSQL_COL_NAME = '" + mappingField.getName() + "' and KSQL_COL_TABNAME = '" + table.getName() + "') \n";
                String[] columnStr = this.getDefineColumnSql(mappingField);
                String sql2 = "alter table " + table.getName() + " add " + columnStr[0] + ";\n";
                this.outputSQL(sql1 + sql2, "\u5b57\u6bb5\u811a\u672c", table.getName() + "_" + mappingField.getName());
            }
        }
    }

    private String getFieldSql(EntityObjectInfo info, PropertyInfo prop) {
        ColumnInfo mappingField = prop.getMappingField();
        DataTableInfo table = info.getTable();
        if (mappingField == null || StringUtils.isEmpty((String)mappingField.getName())) {
            return null;
        }
        if ((mappingField = table.getColumnByName(mappingField.getName())) != null && mappingField.isMultilingual()) {
            String[] columnStr = this.getDefineColumnSql(mappingField);
            String sql = "";
            for (int j = 1; j <= columnStr.length; ++j) {
                String sql1 = "If not exists ( select * from KSQL_USERCOLUMNS where KSQL_COL_NAME = '" + mappingField.getName() + "_L" + j + "' and KSQL_COL_TABNAME = '" + table.getName() + "') \n";
                String sql2 = "alter table " + table.getName() + " add " + columnStr[j - 1] + ";\n\n";
                sql = sql + sql1 + sql2;
            }
            return sql;
        }
        String sql1 = "If not exists ( select * from KSQL_USERCOLUMNS where KSQL_COL_NAME = '" + mappingField.getName() + "' and KSQL_COL_TABNAME = '" + table.getName() + "') \n";
        String[] columnStr = this.getDefineColumnSql(mappingField);
        String sql2 = "alter table " + table.getName() + " add " + columnStr[0] + ";\n";
        return sql1 + sql2;
    }

    private void outputSQL(String sql, String caption, String fileName) {
        String filePath = "c:\\tmp";
        String insertFileName = filePath + "\\" + caption + "-" + fileName + ".txt";
        try {
            File f = new File(filePath);
            File f1 = new File(insertFileName);
            if (!f.exists()) {
                f.mkdirs();
            }
            if (!f1.exists()) {
                f1.createNewFile();
            }
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f1), "utf-8"));
            PrintWriter fw = new PrintWriter((Writer)writer, false);
            fw.println("/** \u540d\u79f0 :" + caption + " **/");
            fw.println(sql);
            ((Writer)writer).close();
            fw.close();
            MsgBox.showInfo((Component)ComponentUtil.getCurrentActiveWindow(), (String)("\u811a\u672c\u5df2\u5bfc\u51fa\u5230" + insertFileName + "\uff01"));
        }
        catch (Exception e1) {
            logger.error((Object)("dyn bill designer\uff1a" + e1));
            IdeUtil.showErrorMsg((Component)ComponentUtil.getCurrentActiveWindow(), (Exception)e1, (String)"\u5bfc\u51fa\u811a\u672c\u5931\u8d25\uff01");
        }
    }

    private String[] getDefineColumnSql(ColumnInfo mappingField) {
        SQLType type = mappingField.getTypeName();
        String typeStr = null;
        typeStr = type.getName().equals(SQLType.CHAR.getName()) || type.getName().equals(SQLType.NCHAR.getName()) || type.getName().equals(SQLType.VARCHAR.getName()) || type.getName().equals(SQLType.NVARCHAR.getName()) || type.getName().equals(SQLType.BLOB.getName()) || type.getName().equals(SQLType.CLOB.getName()) || type.getName().equals(SQLType.NCLOB.getName()) ? (mappingField.isMultilingual() ? type.getName() + "(" + mappingField.getLength() * 3 + ")" : type.getName() + "(" + mappingField.getLength() + ")") : (type.getName().equals(SQLType.NUMERIC.getName()) ? type.getName() + "(" + mappingField.getPrecision() + "," + mappingField.getScale() + ")" : type.getName());
        String nullableStr = mappingField.isNullable() ? " " : " not null ";
        String defaultValueStr = " default ";
        String defaultValue = mappingField.getDefaultValue();
        defaultValueStr = StringUtils.isEmpty((String)defaultValue) || defaultValue.equals("''") ? (type.getName().equals(SQLType.CHAR.getName()) || type.getName().equals(SQLType.NCHAR.getName()) || type.getName().equals(SQLType.VARCHAR.getName()) || type.getName().equals(SQLType.NVARCHAR.getName()) ? "default ' ' " : (type.getName().equals(SQLType.NUMERIC.getName()) || type.getName().equals(SQLType.INT.getName()) ? defaultValueStr + " 0 " : " ")) : (type.getName().equals(SQLType.CHAR.getName()) || type.getName().equals(SQLType.NCHAR.getName()) || type.getName().equals(SQLType.VARCHAR.getName()) || type.getName().equals(SQLType.NVARCHAR.getName()) ? defaultValueStr + defaultValue : (type.getName().equals(SQLType.NUMERIC.getName()) || type.getName().equals(SQLType.INT.getName()) ? defaultValueStr + " " + defaultValue : " "));
        String[] columnStr = new String[]{mappingField.getName() + " " + typeStr + " " + nullableStr + " " + defaultValueStr};
        if (mappingField.isMultilingual()) {
            columnStr = new String[]{mappingField.getName() + "_L1 " + typeStr + " " + nullableStr + " " + defaultValueStr, mappingField.getName() + "_L2 " + typeStr + " " + nullableStr + " " + defaultValueStr, mappingField.getName() + "_L3 " + typeStr + " " + nullableStr + " " + defaultValueStr};
        }
        return columnStr;
    }

    private PropertyNodeObject showPropertyEditUI(String operation, PropertyNodeObject nodeObject, EntityObjectInfo entity) {
        String className = "com.kingdee.eas.base.form.ide.client.FormPropertyEditUI";
        UIContext uiContext = new UIContext();
        uiContext.put((Object)"ENTITY", (Object)entity);
        uiContext.put((Object)"Owner", (Object)ComponentUtil.getCurrentActiveWindow());
        if (!operation.equals(OprtState.ADDNEW)) {
            uiContext.put((Object)"NODEOBJ", (Object)nodeObject);
        }
        IUIWindow uiWindow = null;
        try {
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(className, (Map)uiContext, null, operation);
            String state = "\u67e5\u770b";
            if (operation.equals(OprtState.ADDNEW)) {
                state = "\u65b0\u589e";
            } else if (operation.equals(OprtState.EDIT)) {
                state = "\u4fee\u6539";
            }
            uiWindow.getUIObject().setUITitle("\u5c5e\u6027" + state);
            uiWindow.show();
            FormPropertyEditUI dialog = (FormPropertyEditUI)uiWindow.getUIObject();
            if (dialog.isCancel()) {
                return nodeObject;
            }
            nodeObject = dialog.getNodeObject();
            if (!nodeObject.isChanged) {
                return nodeObject;
            }
        }
        catch (UIException e1) {
            e1.printStackTrace();
        }
        return nodeObject;
    }

    @Override
    public Object getSelectionData() {
        TreePath[] paths = this.kDTree.getSelectionPaths();
        if (paths != null && paths.length > 0) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)paths[0].getLastPathComponent();
            return node.getUserObject();
        }
        return null;
    }

    public String[] getIssueSqls() {
        ArrayList sqlList = new ArrayList();
        TreePath treePath = this.kDTree.getPathForRow(0);
        if (treePath != null) {
            this.selectedNode = (DefaultKingdeeTreeNode)treePath.getLastPathComponent();
            this.subDealNode(this.selectedNode, sqlList);
        }
        String[] sqls = new String[sqlList.size()];
        sqlList.toArray(sqls);
        return sqls;
    }

    private void subDealNode(DefaultKingdeeTreeNode node, List sqlList) {
        if (node.getChildCount() > 0) {
            this.fillSqls(node, sqlList);
            for (int i = 0; i < node.getChildCount(); ++i) {
                DefaultKingdeeTreeNode subnode = (DefaultKingdeeTreeNode)node.getChildAt(i);
                this.subDealNode(subnode, sqlList);
            }
        }
    }

    private void fillSqls(DefaultKingdeeTreeNode node, List sqlList) {
        if (node != null && node.getChildCount() > 0) {
            PropertyNodeObject nodeObject = (PropertyNodeObject)node.getUserObject();
            EntityObjectInfo entity = nodeObject.entity;
            DataTableInfo table = entity.getTable();
            if (table == null) {
                MsgBox.showError((Component)ComponentUtil.getCurrentActiveWindow(), (String)("\u8be5\u5b9e\u4f53\u2014\u2014" + entity.getAlias() + "\u6ca1\u6709\u5b9a\u4e49\u8868\uff01"));
                SysUtil.abort();
            }
            String sql1 = "If not exists ( select * from KSQL_USERCOLUMNS where KSQL_COL_TABNAME = '" + table.getName() + "') \n";
            String sql2 = "Create Table " + table.getName() + "( FID varchar(44) not null, ";
            String sql3 = "";
            PrimaryKeyInfo primaryKey = table.getPrimaryKey();
            String tmp = "";
            for (int i = 0; i < primaryKey.getPKColumns().size(); ++i) {
                tmp = tmp + primaryKey.getPKColumns().get(i).getColumn().getName() + ",";
            }
            if (tmp.length() > 0) {
                tmp = tmp.substring(0, tmp.length() - 1);
                sql3 = " CONSTRAINT " + primaryKey.getName() + " PRIMARY KEY (" + tmp + ")); \n";
            } else {
                sql2 = sql2.substring(0, sql2.length() - 2);
                sql3 = " ); \n";
            }
            sqlList.add(sql1 + sql2 + sql3);
            PropertyCollection properties = Util.getAllEntityProperties((EntityObjectInfo)entity);
            for (int i = 0; i < properties.size(); ++i) {
                String tmpSql;
                PropertyInfo prop = properties.get(i);
                if (prop == null || prop.getName().equalsIgnoreCase("id") || StringUtils.isEmpty((String)(tmpSql = this.getFieldSql(entity, prop)))) continue;
                sqlList.add(tmpSql);
            }
        }
    }

    class ShowPropertyAdapter
    extends MouseAdapter {
        ShowPropertyAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.isMetaDown()) {
                TreePath tp = EntityView.this.kDTree.getPathForLocation(e.getX(), e.getY());
                if (tp != null) {
                    boolean isEditable;
                    EntityView.this.kDTree.setSelectionPath(tp);
                    DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)tp.getLastPathComponent();
                    EntityView.this.selectedNode = node;
                    PropertyNodeObject nodeObject = (PropertyNodeObject)node.getUserObject();
                    boolean bl = isEditable = nodeObject.property != null && nodeObject.property.isConfigured();
                    if (node.getParent() == null) {
                        EntityView.this.miNew.setEnabled(false);
                        EntityView.this.miEdit.setEnabled(true);
                        EntityView.this.miDelete.setEnabled(false);
                        EntityView.this.miView.setEnabled(true);
                        EntityView.this.miCreateTableSQL.setEnabled(true);
                        EntityView.this.miCreateFieldSQL.setEnabled(false);
                    } else if (node.getChildCount() > 0) {
                        EntityView.this.miNew.setEnabled(false);
                        EntityView.this.miEdit.setEnabled(true);
                        EntityView.this.miDelete.setEnabled(true);
                        EntityView.this.miView.setEnabled(true);
                        EntityView.this.miCreateTableSQL.setEnabled(true);
                        EntityView.this.miCreateFieldSQL.setEnabled(false);
                    } else {
                        EntityView.this.miNew.setEnabled(false);
                        EntityView.this.miEdit.setEnabled(true);
                        EntityView.this.miDelete.setEnabled(true);
                        EntityView.this.miView.setEnabled(true);
                        EntityView.this.miCreateTableSQL.setEnabled(false);
                        EntityView.this.miCreateFieldSQL.setEnabled(true);
                    }
                    this.showPopup(e);
                }
            } else if (e.getClickCount() == 2) {
                TreePath tp = EntityView.this.kDTree.getSelectionPath();
                if (tp == null) {
                    return;
                }
                DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)tp.getLastPathComponent();
                if (!node.isLeaf()) {
                    return;
                }
            }
        }

        private void showPopup(MouseEvent e) {
            EntityView.this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    class CreateSQLActionListner
    implements ActionListener {
        String operation;

        public CreateSQLActionListner(String operation) {
            this.operation = operation;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (EntityView.this.selectedNode == null) {
                MsgBox.showWarning((Component)ComponentUtil.getCurrentActiveWindow(), (String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u8282\u70b9\uff01");
                return;
            }
            PropertyNodeObject nodeObject = (PropertyNodeObject)EntityView.this.selectedNode.getUserObject();
            EntityObjectInfo entity = nodeObject.entity;
            DefaultKingdeeTreeNode parentNode = EntityView.this.selectedNode;
            if (entity == null) {
                parentNode = (DefaultKingdeeTreeNode)EntityView.this.selectedNode.getParent();
                PropertyNodeObject parentNO = (PropertyNodeObject)parentNode.getUserObject();
                entity = parentNO.entity;
            }
            EntityView.this.createSQL(entity, nodeObject.property, this.operation);
        }
    }

    class EditPropertyActionListner
    implements ActionListener {
        String operation;

        @Override
        public void actionPerformed(ActionEvent e) {
            if (EntityView.this.selectedNode == null) {
                return;
            }
            EntityView.this.handlePropertyEdit(EntityView.this.selectedNode, this.operation);
        }

        public EditPropertyActionListner(String operation) {
            this.operation = operation;
        }
    }

    class BindEntityActionListner
    implements ActionListener {
        EntityView view;
        EntityDataSelector dialog;

        public BindEntityActionListner(EntityView view) {
            this.view = view;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.view.openEntityDesigner();
        }
    }
}

