/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.ide.view;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.KDTreeView;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeCellRenderer;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.form.core.MetaDataFactory;
import com.kingdee.eas.base.form.core.UserDefinedData.client.UserDefinedDataMainUI;
import com.kingdee.eas.base.form.ide.FormPermission;
import com.kingdee.eas.base.form.ide.client.FormPermissionUI;
import com.kingdee.eas.base.form.ide.workbench.ui.ITrimView;
import com.kingdee.eas.base.form.metadata.FormAppearance;
import com.kingdee.eas.base.form.metadata.LayoutInfo;
import com.kingdee.eas.base.form.metadata.SubSystem;
import com.kingdee.eas.basedata.org.IPositionMember;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.util.client.ComponentUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Observer;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class SolutionView
extends KDPanel
implements ITrimView {
    private final Icon formIcon = EASResource.getIcon((String)"imgTbtn_bill");
    private final Icon layoutIcon = EASResource.getIcon((String)"imgTbtn_overallsortaccount");
    private final Icon subsysIcon = EASResource.getIcon((String)"imgTbtn_organiselist");
    private final Icon dynTypeIcon = EASResource.getIcon((String)"imgTbtn_templatetype");
    private final Icon freezeIcon = EASResource.getIcon((String)"imgTbtn_freeze");
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.form.ide.view.SolutionView");
    protected KDTreeView kDTreeView;
    protected KDTree kDTree;
    public static final String FORM_ID = "form_id";
    public static final String SOLUTION_ID = "solution_id";
    public static final String LAYOUT_KEY = "layout_key";
    public static final String SUBSYSTEM_ID = "subsystem_id";
    public static final int CREATE_NEW_FORM = 1;
    public static final int CREATE_NEW_FORMLAYOUT = 2;
    public static final int DELETE_SINGLE_FORM = 3;
    public static final int DELETE_SINGLE_FORMLAYOUT = 4;
    public static final int ISHIDE_DISPLAY_FORM = 0;
    public static final int ISHIDE_HIDE_FORM = 1;
    public static final int ISHIDE_FORM_READONLY = 2;
    public static final String OPERATION_TYPE = "operation_type";
    private List elementTypeList = new ArrayList();
    private Vector obs = new Vector();
    private KDWorkButton btnRefresh;
    private KDWorkButton btnDelete;
    private KDWorkButton btnAddNewLayout;
    private KDWorkButton btnFormPermission;
    private List layoutList;
    private List subsysList;

    public void addObserver(Observer o) {
        this.obs.add(o);
    }

    public SolutionView() {
        super((LayoutManager)new BorderLayout(), true);
        this.initComp();
        this.addCustomButton();
        this.kDTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                if (e.getNewLeadSelectionPath() != null && e.getNewLeadSelectionPath().getLastPathComponent() != null) {
                    DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)e.getNewLeadSelectionPath().getLastPathComponent();
                    if (node.getUserObject() instanceof FormAppearance || node.getUserObject() instanceof LayoutInfo) {
                        SolutionView.this.btnDelete.setEnabled(true);
                    } else {
                        SolutionView.this.btnDelete.setEnabled(false);
                    }
                    if (node.getUserObject() instanceof FormAppearance) {
                        SolutionView.this.btnFormPermission.setEnabled(true);
                    } else {
                        SolutionView.this.btnFormPermission.setEnabled(false);
                    }
                    if (node.getUserObject() instanceof FormAppearance && ((FormAppearance)node.getUserObject()).getElementType() == 100) {
                        SolutionView.this.btnAddNewLayout.setEnabled(true);
                    } else {
                        SolutionView.this.btnAddNewLayout.setEnabled(false);
                    }
                }
            }
        });
        this.kDTree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
            }

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                if (event.getPath() == null || ((DefaultKingdeeTreeNode)event.getPath().getLastPathComponent()).getUserObject() instanceof FormAppearance) {
                    // empty if block
                }
            }
        });
        this.kDTree.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    SolutionView.this.selectedForm(e.getSource());
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode((Object)"\u5b50\u7cfb\u7edf\u5217\u8868");
        this.kDTree.setModel((TreeModel)new KingdeeTreeModel((TreeNode)root));
        this.kDTree.setRootVisible(false);
        this.kDTree.updateUI();
    }

    public void refreshTree(List subsysList) {
        this.subsysList = subsysList;
        this.refreshTree();
    }

    public void refreshTree() {
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode((Object)"\u5b50\u7cfb\u7edf\u5217\u8868");
        try {
            if (this.subsysList == null || this.subsysList.isEmpty()) {
                return;
            }
            ArrayList<String> subsysIds = new ArrayList<String>();
            for (int i = 0; i < this.subsysList.size(); ++i) {
                String id = ((SubSystem)this.subsysList.get(i)).getId();
                subsysIds.add(id);
            }
            this.elementTypeList.clear();
            this.elementTypeList.add(new Integer(100));
            this.elementTypeList.add(new Integer(210));
            this.elementTypeList.add(new Integer(200));
            Map subsysFormsMap = MetaDataFactory.getForms(null, subsysIds, (List)this.elementTypeList);
            ArrayList<String> formIdList = new ArrayList<String>();
            Iterator it = subsysFormsMap.keySet().iterator();
            while (it.hasNext()) {
                List formList = (List)subsysFormsMap.get(it.next());
                for (int j = 0; j < formList.size(); ++j) {
                    FormAppearance formap = (FormAppearance)formList.get(j);
                    if (!this.filterForm(formap.getId())) continue;
                    formIdList.add(formap.getId());
                }
            }
            this.layoutList = MetaDataFactory.getAllBillLayout(null, formIdList);
            this.buildSubsysNode(root, this.subsysList, subsysFormsMap);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        this.kDTree.setModel((TreeModel)new KingdeeTreeModel((TreeNode)root));
        this.kDTree.setRootVisible(false);
        this.kDTree.expandAllNodes(true, (TreeNode)root);
        this.kDTree.updateUI();
        this.kDTree.setSelectionRow(0);
    }

    private boolean filterForm(String form_id) {
        FormPermission.FormPermisoionType type = FormPermission.newInstance().getCurrentUserFormPermission(form_id);
        return type.canRead();
    }

    private DefaultKingdeeTreeNode buildFormsLayoutTreeNode(DefaultKingdeeTreeNode rootNode, String currentFormId, List formList, boolean isCreateMainLayout) throws BOSException {
        for (int i = 0; this.layoutList != null && i < this.layoutList.size(); ++i) {
            LayoutInfo layout = (LayoutInfo)this.layoutList.get(i);
            if (isCreateMainLayout && !layout.getKey().equalsIgnoreCase("_Default") || !isCreateMainLayout && layout.getKey().equalsIgnoreCase("_Default")) continue;
            DefaultKingdeeTreeNode layoutNode = new DefaultKingdeeTreeNode((Object)layout);
            layoutNode.setCustomIcon(this.layoutIcon);
            String formId = layout.getFormId();
            if (!formId.equals(currentFormId)) continue;
            rootNode.add((MutableTreeNode)layoutNode);
            if (!isCreateMainLayout) continue;
            return layoutNode;
        }
        return null;
    }

    private void addCustomButton() {
        this.kDTreeView.setShowButton(false);
        this.btnFormPermission = new KDWorkButton(EASResource.getIcon((String)"imgTbtn_popedomsetting"));
        this.btnFormPermission.setEnabled(false);
        this.btnFormPermission.setActionCommand("FormPermission");
        this.btnFormPermission.setToolTipText("\u5355\u636e\u6388\u6743");
        this.btnFormPermission.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    SolutionView.this.formPermission();
                }
                catch (BOSException e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.kDTreeView.getControlPane().add((Component)this.btnFormPermission);
        this.btnAddNewLayout = new KDWorkButton(EASResource.getIcon((String)"imgTbtn_new"));
        this.btnAddNewLayout.setEnabled(false);
        this.btnAddNewLayout.setActionCommand("addNewLayout");
        this.btnAddNewLayout.setToolTipText("\u65b0\u589e\u5e03\u5c40");
        this.btnAddNewLayout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    SolutionView.this.addNewFormLayout();
                }
                catch (BOSException e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.kDTreeView.getControlPane().add((Component)this.btnAddNewLayout);
        this.btnRefresh = new KDWorkButton((Icon)new ImageIcon(EASResource.getImage((String)"imgTbtn_refresh"), "\u5237\u65b0"));
        this.btnRefresh.setActionCommand("refresh");
        this.btnRefresh.setToolTipText("\u5237\u65b0");
        this.btnRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SolutionView.this.refreshTree();
            }
        });
        this.kDTreeView.getControlPane().add((Component)this.btnRefresh);
        this.btnDelete = new KDWorkButton(EASResource.getIcon((String)"imgTbtn_delete"));
        this.btnDelete.setEnabled(false);
        this.btnDelete.setActionCommand("delete");
        this.btnDelete.setToolTipText("\u5220\u9664");
        this.btnDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    SolutionView.this.deleteSelectedForm();
                }
                catch (BOSException e1) {
                    MsgBox.showError((Component)ComponentUtil.getOwnerWindow(null), (String)e1.getMessage());
                    e1.printStackTrace();
                }
                catch (EASBizException e1) {
                    MsgBox.showError((Component)ComponentUtil.getOwnerWindow(null), (String)e1.getMessage());
                    e1.printStackTrace();
                }
            }
        });
        this.kDTreeView.getControlPane().add((Component)this.btnDelete);
    }

    public void selectedForm(Object obj) {
        if (obj != null) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.kDTree.getLastSelectedPathComponent();
            if (node == null) {
                return;
            }
            if (node.getUserObject() != null && node.getUserObject() instanceof SolutionDirect && ((SolutionDirect)node.getUserObject()).getId() == 6) {
                DefaultKingdeeTreeNode subSystemNode = (DefaultKingdeeTreeNode)node.getParent();
                if (subSystemNode == null) {
                    return;
                }
                SubSystem subSys = (SubSystem)subSystemNode.getUserObject();
                if (subSys == null) {
                    return;
                }
                String subSystemID = subSys.getId();
                UIContext uiContext = new UIContext((Object)this);
                this.getLocale();
                uiContext.put((Object)"locale", (Object)Locale.getDefault());
                uiContext.put((Object)"SubSystem", (Object)subSystemID);
                UserDefinedDataMainUI userDefinedData = null;
                Window win = ComponentUtil.getCurrentActiveWindow();
                userDefinedData = win instanceof Frame ? new UserDefinedDataMainUI((Frame)win, uiContext) : new UserDefinedDataMainUI(null, uiContext);
                userDefinedData.setModal(true);
                userDefinedData.show();
                userDefinedData.dispose();
                return;
            }
            if (!(node.getUserObject() instanceof FormAppearance) && !(node.getUserObject() instanceof LayoutInfo)) {
                return;
            }
            this.setCursor(new Cursor(3));
            Object userObject = node.getUserObject();
            HashMap objectMap = new HashMap();
            if (userObject instanceof FormAppearance) {
                String formId = ((FormAppearance)userObject).getId();
                try {
                    int formEditable = MetaDataFactory.getFormEditOrHide(null, (String)formId);
                    if (2 == formEditable) {
                        MsgBox.showWarning((String)"\u6b64\u5355\u636e\u662f\u7cfb\u7edf\u5185\u7f6e\u5355\u636e\uff0c\u6240\u6709\u7684\u4fee\u6539\u5c06\u4e0d\u80fd\u4fdd\u5b58\uff01");
                        return;
                    }
                }
                catch (BOSException e) {
                    e.printStackTrace();
                    return;
                }
                this.initFormToMap(node, objectMap);
            } else if (userObject instanceof LayoutInfo) {
                this.initLayoutToMap(node, objectMap);
            }
            for (int i = 0; i < this.obs.size(); ++i) {
                ((Observer)this.obs.get(i)).update(null, objectMap);
            }
            this.setCursor(new Cursor(0));
        }
    }

    private void initLayoutToMap(DefaultKingdeeTreeNode node, Map objectMap) {
        Object userObject = node.getUserObject();
        LayoutInfo layout = (LayoutInfo)userObject;
        DefaultKingdeeTreeNode parentNode = (DefaultKingdeeTreeNode)node.getParent();
        SolutionDirect sd = null;
        sd = parentNode.getUserObject() instanceof SolutionDirect ? (SolutionDirect)parentNode.getUserObject() : (SolutionDirect)((DefaultKingdeeTreeNode)parentNode.getParent()).getUserObject();
        int soluID = sd.getId();
        objectMap.put(FORM_ID, layout.getFormId());
        objectMap.put(SOLUTION_ID, new Integer(soluID));
        objectMap.put(LAYOUT_KEY, layout.getKey());
    }

    private void initFormToMap(DefaultKingdeeTreeNode node, Map objectMap) {
        FormAppearance form = (FormAppearance)node.getUserObject();
        DefaultKingdeeTreeNode parentNode = (DefaultKingdeeTreeNode)node.getParent();
        SolutionDirect sd = (SolutionDirect)parentNode.getUserObject();
        int soluID = sd.getId();
        objectMap.put(FORM_ID, form.getId());
        objectMap.put(SOLUTION_ID, new Integer(soluID));
        objectMap.put(LAYOUT_KEY, "_Default");
    }

    private void deleteSelectedForm() throws BOSException, EASBizException {
        FormPermission.FormPermisoionType perm_type;
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.kDTree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        Object userObject = node.getUserObject();
        if (userObject == null) {
            return;
        }
        String form_id = null;
        if (userObject instanceof FormAppearance) {
            form_id = ((FormAppearance)userObject).getId();
        } else if (userObject instanceof LayoutInfo) {
            form_id = ((LayoutInfo)userObject).getFormId();
        }
        if (!StringUtils.isEmpty((String)form_id) && !(perm_type = FormPermission.newInstance().getCurrentUserFormPermission(form_id)).canDelete()) {
            MsgBox.showError((String)"\u60a8\u6ca1\u6709\u5220\u9664\u8be5\u5355\u636e\u7684\u6743\u9650\uff01");
            return;
        }
        int result = MsgBox.showConfirm2((Component)((Object)this), (String)"\u786e\u8ba4\u8981\u5220\u9664\u5417\uff1f");
        if (result == 2) {
            return;
        }
        this.setCursor(new Cursor(3));
        HashMap<String, Integer> dataMap = new HashMap<String, Integer>();
        if (userObject != null && userObject instanceof FormAppearance) {
            this.initFormToMap(node, dataMap);
            dataMap.put(OPERATION_TYPE, new Integer(3));
            FormAppearance form = (FormAppearance)node.getUserObject();
            String id = form.getId();
            MetaDataFactory.deleteForm(null, (String)id);
            ((DefaultKingdeeTreeNode)node.getParent()).remove((MutableTreeNode)node);
        } else if (userObject instanceof LayoutInfo) {
            this.initLayoutToMap(node, dataMap);
            dataMap.put(OPERATION_TYPE, new Integer(4));
            LayoutInfo layout = (LayoutInfo)userObject;
            String formId = layout.getFormId();
            String layoutId = layout.getId();
            MetaDataFactory.deleteFormLayout(null, (String)formId, (String)layoutId);
            DefaultKingdeeTreeNode parent = (DefaultKingdeeTreeNode)node.getParent();
            parent.remove((MutableTreeNode)node);
            if (parent.getChildCount() == 0) {
                ((DefaultKingdeeTreeNode)parent.getParent()).remove((MutableTreeNode)parent);
            }
        }
        for (int i = 0; i < this.obs.size(); ++i) {
            ((Observer)this.obs.get(i)).update(null, dataMap);
        }
        this.kDTree.updateUI();
        this.setCursor(new Cursor(0));
        MsgBox.showInfo((String)"\u5220\u9664\u6210\u529f\uff01");
        this.kDTree.setSelectionRow(0);
    }

    private void formPermission() throws BOSException {
        String current_person_id;
        String creator;
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.kDTree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        Object userObject = node.getUserObject();
        if (userObject == null) {
            return;
        }
        String form_id = ((FormAppearance)userObject).getId();
        FormPermission.FormPermisoionType type = FormPermission.newInstance().getCurrentUserFormPermission(form_id);
        if (FormPermission.FormPermisoionType.NoLimit != type && !"".equals(creator = FormPermission.newInstance().getFormPermissionCreator(form_id)) && !creator.equals(current_person_id = FormPermission.newInstance().getPerson().getId().toString())) {
            MsgBox.showWarning((String)"\u60a8\u6ca1\u6709\u5355\u636e\u6388\u6743\u7684\u6743\u9650");
            return;
        }
        String old_creator = FormPermission.newInstance().getFormPermissionCreator(form_id);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)FORM_ID, (Object)form_id);
        uiContext.put((Object)"form_name", (Object)((FormAppearance)userObject).getCaption());
        uiContext.put((Object)"perm_info_map", (Object)FormPermission.newInstance().getUserPermission(form_id));
        uiContext.put((Object)"form_permission_notes", (Object)FormPermission.newInstance().getUserPermissionNotes(form_id));
        String className = "com.kingdee.eas.base.form.ide.client.FormPermissionUI";
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(className, (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
        FormPermissionUI form_perm_ui = (FormPermissionUI)uiWindow.getUIObject();
        if (!form_perm_ui.isCancel() && "".equals(old_creator)) {
            this.refreshTree();
        }
    }

    private void addNewFormLayout() throws BOSException {
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.kDTree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        this.setCursor(new Cursor(3));
        Object userObject = node.getUserObject();
        HashMap<String, Integer> dataMap = new HashMap<String, Integer>();
        if (userObject != null && userObject instanceof FormAppearance) {
            this.initFormToMap(node, dataMap);
        } else if (userObject instanceof LayoutInfo) {
            this.initLayoutToMap(node, dataMap);
        }
        dataMap.put(OPERATION_TYPE, new Integer(2));
        for (int i = 0; i < this.obs.size(); ++i) {
            ((Observer)this.obs.get(i)).update(null, dataMap);
        }
        this.refreshTree();
        this.setCursor(new Cursor(0));
        MsgBox.showInfo((String)"\u6210\u529f\uff01");
    }

    private void initComp() {
        this.kDTreeView = new KDTreeView();
        this.kDTreeView.setName("kDTreeView");
        this.kDTree = new KDTree();
        this.kDTree.setName("kDTree");
        this.kDTree.setCellRenderer((TreeCellRenderer)((Object)new TooltipRender()));
        this.kDTreeView.setBounds(new Rectangle(51, 55, 170, 267));
        this.kDTreeView.setShowButton(true);
        this.add((Component)this.kDTreeView, null);
        this.kDTreeView.setTree(this.kDTree);
    }

    public void buildDynTypeNode(DefaultKingdeeTreeNode node, int dynTypeKey) throws BOSException {
        DefaultKingdeeTreeNode tmpNode = null;
        int elementType = -1;
        switch (dynTypeKey) {
            case 3: {
                elementType = 100;
                tmpNode = new DefaultKingdeeTreeNode((Object)new SolutionDirect(3, "\u5355\u636e", elementType));
                node.add((MutableTreeNode)tmpNode);
                break;
            }
            case 4: {
                elementType = 210;
                tmpNode = new DefaultKingdeeTreeNode((Object)new SolutionDirect(4, "\u7ec4\u5408\u754c\u9762", elementType));
                node.add((MutableTreeNode)tmpNode);
                break;
            }
            case 5: {
                elementType = 200;
                tmpNode = new DefaultKingdeeTreeNode((Object)new SolutionDirect(5, "\u8fc7\u6ee4\u6761\u4ef6\u5bf9\u8bdd\u6846", elementType));
                node.add((MutableTreeNode)tmpNode);
            }
        }
    }

    public void buildDynTypeNode(DefaultKingdeeTreeNode node, int dynTypeKey, List formList) throws BOSException {
        DefaultKingdeeTreeNode tmpNode = null;
        int elementType = -1;
        switch (dynTypeKey) {
            case 3: {
                elementType = 100;
                tmpNode = new DefaultKingdeeTreeNode((Object)new SolutionDirect(3, "\u5355\u636e", elementType));
                this.buildFormsTreeNode(tmpNode, formList, 100);
                node.add((MutableTreeNode)tmpNode);
                break;
            }
            case 4: {
                elementType = 210;
                tmpNode = new DefaultKingdeeTreeNode((Object)new SolutionDirect(4, "\u7ec4\u5408\u754c\u9762", elementType));
                this.buildFormsTreeNode(tmpNode, formList, 210);
                node.add((MutableTreeNode)tmpNode);
                break;
            }
            case 5: {
                elementType = 200;
                tmpNode = new DefaultKingdeeTreeNode((Object)new SolutionDirect(5, "\u8fc7\u6ee4\u6761\u4ef6\u5bf9\u8bdd\u6846", elementType));
                this.buildFormsTreeNode(tmpNode, formList, 200);
                node.add((MutableTreeNode)tmpNode);
                break;
            }
            case 6: {
                elementType = -1;
                tmpNode = new DefaultKingdeeTreeNode((Object)new SolutionDirect(6, "\u8f85\u52a9\u8d44\u6599", elementType));
                node.add((MutableTreeNode)tmpNode);
            }
        }
        if (tmpNode != null) {
            tmpNode.setCustomIcon(this.dynTypeIcon);
        }
    }

    public void buildSubsysNode(DefaultKingdeeTreeNode node, List subsysList, Map subsysFormsMap) throws BOSException {
        for (int i = 0; i < subsysList.size(); ++i) {
            String id = ((SubSystem)subsysList.get(i)).getId();
            List formList = (List)subsysFormsMap.get(id);
            DefaultKingdeeTreeNode tmpNode = new DefaultKingdeeTreeNode(subsysList.get(i));
            tmpNode.setCustomIcon(this.subsysIcon);
            this.buildDynTypeNode(tmpNode, 1, formList);
            this.buildDynTypeNode(tmpNode, 2, formList);
            this.buildDynTypeNode(tmpNode, 3, formList);
            this.buildDynTypeNode(tmpNode, 6, formList);
            this.buildDynTypeNode(tmpNode, 4, formList);
            this.buildDynTypeNode(tmpNode, 5, formList);
            node.add((MutableTreeNode)tmpNode);
        }
    }

    public void buildFormsTreeNode(DefaultKingdeeTreeNode rootNode, List formList, int elementType) throws BOSException {
        for (int i = 0; formList != null && i < formList.size(); ++i) {
            FormAppearance form = (FormAppearance)formList.get(i);
            FormPermission.FormPermisoionType type = FormPermission.newInstance().getCurrentUserFormPermission(form.getId());
            if (!type.canRead() || form.getElementType() != elementType) continue;
            DefaultKingdeeTreeNode formNode = new DefaultKingdeeTreeNode((Object)form);
            formNode.setCheckBoxVisible(true);
            formNode.setCheckBoxEnabled(true);
            if (type.canEditable()) {
                formNode.setCustomIcon(this.formIcon);
            } else {
                formNode.setCustomIcon(this.freezeIcon);
            }
            String creator = FormPermission.newInstance().getFormPermissionCreator(form.getId());
            if (!StringUtils.isEmpty((String)creator)) {
                ObjectUuidPK person_pk = new ObjectUuidPK(BOSUuid.read((String)creator));
                IPerson iPerson = PersonFactory.getRemoteInstance();
                try {
                    if (iPerson.exists((IObjectPK)person_pk)) {
                        String person_name = iPerson.getPersonInfo((IObjectPK)person_pk).getName();
                        formNode.setText(formNode.getText() + "(" + person_name + ")");
                    }
                }
                catch (EASBizException eASBizException) {
                    // empty catch block
                }
            }
            if (elementType == 100) {
                this.buildFormsLayoutTreeNode(formNode, form.getId(), formList, false);
            }
            rootNode.add((MutableTreeNode)formNode);
        }
    }

    @Override
    public void onViewHide() {
    }

    @Override
    public void onViewShow() {
    }

    @Override
    public void onExclusive(boolean isExclusive) {
    }

    public SubSystem getCurrentSubsys() {
        DefaultKingdeeTreeNode node = this.getSelectTreeNode();
        if (node == null) {
            return null;
        }
        if (node.getUserObject() instanceof SubSystem) {
            return (SubSystem)node.getUserObject();
        }
        if (node.getUserObject() instanceof SolutionDirect) {
            return (SubSystem)((DefaultKingdeeTreeNode)node.getParent()).getUserObject();
        }
        if (node.getUserObject() instanceof FormAppearance) {
            return (SubSystem)((DefaultKingdeeTreeNode)node.getParent().getParent()).getUserObject();
        }
        if (node.getUserObject() instanceof LayoutInfo) {
            return (SubSystem)((DefaultKingdeeTreeNode)node.getParent().getParent().getParent()).getUserObject();
        }
        return null;
    }

    public DefaultKingdeeTreeNode getSelectTreeNode() {
        TreePath selectionPath = this.kDTree.getSelectionPath();
        if (selectionPath == null) {
            return null;
        }
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)selectionPath.getLastPathComponent();
        return node;
    }

    public List getBills() {
        ArrayList<String> result = new ArrayList<String>();
        TreePath[] paths = this.kDTree.getSelectionPaths();
        if (paths != null) {
            for (int i = 0; i < paths.length; ++i) {
                DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)paths[i].getLastPathComponent();
                if (node == null || !(node.getUserObject() instanceof FormAppearance)) continue;
                result.add(((FormAppearance)node.getUserObject()).getId());
            }
        }
        return result;
    }

    public static String getAllOrgName(Context ctx, String userId) throws Exception {
        Object info = null;
        StringBuffer sbuf = new StringBuffer();
        int depLevel = 10000;
        try {
            StringBuffer sb = new StringBuffer();
            sb.append("select position.* ,position.adminOrgUnit.displayName ,*");
            sb.append(" where person.id = '");
            sb.append(userId);
            sb.append("'");
            IPositionMember ipm = PositionMemberFactory.getRemoteInstance();
            PositionMemberCollection pmColl = ipm.getPositionMemberCollection(sb.toString());
            int size = pmColl.size();
            for (int i = 0; i < size; ++i) {
                String displayName;
                if (pmColl.get(i).getPosition().getAdminOrgUnit() == null || (displayName = pmColl.get(i).getPosition().getAdminOrgUnit().getDisplayName()) == null || "".equals(displayName)) continue;
                String[] spDisplayName = StringUtils.split((String)displayName, (String)"_");
                for (int j = 0; j < spDisplayName.length; ++j) {
                    sbuf.append(spDisplayName[j]);
                    if (j >= spDisplayName.length - 1) continue;
                    sbuf.append("/");
                }
                if (i >= pmColl.size() - 1) continue;
                sbuf.append(";");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new Exception("don't find Positioninfo!");
        }
        return sbuf.toString();
    }

    class TooltipRender
    extends DefaultKingdeeTreeCellRenderer {
        TooltipRender() {
        }

        public Component getTreeCellRendererComponent(JTree jtree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Object user_obj;
            Component cmp = super.getTreeCellRendererComponent(jtree, value, selected, expanded, leaf, row, hasFocus);
            if (value instanceof DefaultKingdeeTreeNode && (user_obj = ((DefaultKingdeeTreeNode)value).getUserObject()) != null && user_obj instanceof FormAppearance) {
                String form_id = ((FormAppearance)user_obj).getId();
                String creator = FormPermission.newInstance().getFormPermissionCreator(form_id);
                if (StringUtils.isEmpty((String)creator)) {
                    this.setToolTipText("");
                } else {
                    try {
                        String text = SolutionView.getAllOrgName(null, creator);
                        this.setToolTipText(text);
                    }
                    catch (Exception e) {
                        logger.error((Object)e);
                    }
                }
            }
            return cmp;
        }
    }

    public class SolutionDirect {
        private int id;
        private String name;
        private int elementType;

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        public int getElementType() {
            return this.elementType;
        }

        public void setElementType(int elementType) {
            this.elementType = elementType;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public SolutionDirect(int id, String name, int elementType) {
            this.elementType = elementType;
            this.id = id;
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

