/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.ide.workbench.logic;

import com.kingdee.eas.base.form.ide.workbench.ui.ITrimWidget;
import com.kingdee.eas.base.form.ide.workbench.ui.Perspective;
import com.kingdee.eas.base.form.ide.workbench.ui.TrimWidgetPlaceholder;
import java.awt.Component;
import java.awt.Container;

public class TrimWidgetManager {
    public static final int TOP = 1;
    public static final int BOTTOM = 2;
    public static final int LEFT = 3;
    public static final int RIGHT = 4;
    public static final int DEFAULT_HINT = -1;
    private Perspective perspective;

    public TrimWidgetManager(Perspective perspective) {
        this.perspective = perspective;
    }

    public void addTrim(ITrimWidget trim) {
        this.addTrim(4, trim, null, 0.0);
    }

    public void addTrim(int areaId, ITrimWidget trim) {
        this.addTrim(areaId, trim, null, 0.0);
    }

    public void addTrim(int areaId, ITrimWidget trim, ITrimWidget beforeMe) {
        this.addTrim(areaId, trim, beforeMe, 0.0);
    }

    public void addTrim(int areaId, ITrimWidget trim, ITrimWidget beforeMe, double dividerLocation) {
        Component beforeMeComp;
        Perspective former;
        if (beforeMe != null && beforeMe.getPerspective() != this.perspective) {
            return;
        }
        if (this.perspective.isExclusiveView()) {
            this.perspective.showAllInclusions();
        }
        if ((former = trim.getPerspective()) != null) {
            former.getTrimWidgetManager().removeTrim(trim);
        }
        trim.setPerspective(this.perspective);
        TrimWidgetPlaceholder placeholder = new TrimWidgetPlaceholder();
        if (beforeMe == null) {
            Component rootEle = this.perspective.getPerspectiveRootElement();
            if (rootEle == null) {
                this.perspective.add((Component)((Object)trim));
                return;
            }
            this.perspective.add(placeholder);
            beforeMeComp = rootEle;
        } else {
            this.cleavagePlaceholder(beforeMe, placeholder);
            beforeMeComp = (Component)((Object)beforeMe);
        }
        switch (areaId) {
            case 1: {
                placeholder.setOrientation(1);
                placeholder.setLeftComponent((Component)((Object)trim));
                placeholder.setRightComponent(beforeMeComp);
                if (dividerLocation > 0.0) {
                    placeholder.setDividerLocation(dividerLocation);
                    break;
                }
                placeholder.setDividerLocation(0.2);
                break;
            }
            case 2: {
                placeholder.setOrientation(1);
                placeholder.setLeftComponent(beforeMeComp);
                placeholder.setRightComponent((Component)((Object)trim));
                if (dividerLocation > 0.0) {
                    placeholder.setDividerLocation(1.0 - dividerLocation);
                    break;
                }
                placeholder.setDividerLocation(0.8);
                break;
            }
            case 3: {
                placeholder.setOrientation(0);
                placeholder.setLeftComponent((Component)((Object)trim));
                placeholder.setRightComponent(beforeMeComp);
                if (dividerLocation > 0.0) {
                    placeholder.setDividerLocation(dividerLocation);
                    break;
                }
                placeholder.setDividerLocation(0.2);
                break;
            }
            case 4: {
                placeholder.setOrientation(0);
                placeholder.setLeftComponent(beforeMeComp);
                placeholder.setRightComponent((Component)((Object)trim));
                if (dividerLocation > 0.0) {
                    placeholder.setDividerLocation(1.0 - dividerLocation);
                    break;
                }
                placeholder.setDividerLocation(0.8);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    private void cleavagePlaceholder(ITrimWidget beforeMe, TrimWidgetPlaceholder placeholder) {
        Container context = ((Component)((Object)beforeMe)).getParent();
        if (context instanceof Perspective) {
            context.add(placeholder);
        } else if (context instanceof TrimWidgetPlaceholder) {
            TrimWidgetPlaceholder twp = (TrimWidgetPlaceholder)context;
            if (twp.getLeftComponent() == beforeMe) {
                twp.setLeftComponent(placeholder);
            } else {
                twp.setRightComponent(placeholder);
            }
        } else {
            throw new IllegalArgumentException("ITrimWidget's parent must be a Perspective or TrimWidgetPlaceholder");
        }
    }

    public void removeTrim(ITrimWidget toRemove) {
        if (toRemove.getPerspective() != this.perspective) {
            return;
        }
        if (this.perspective.isExclusiveView()) {
            this.perspective.showAllInclusions();
        }
        toRemove.setPerspective(null);
        Container parent = ((Component)((Object)toRemove)).getParent();
        if (parent instanceof Perspective) {
            parent.remove((Component)((Object)toRemove));
            parent.validate();
            parent.repaint();
            return;
        }
        TrimWidgetPlaceholder senior = (TrimWidgetPlaceholder)parent;
        Component peer = senior.getLeftComponent() == toRemove ? senior.getRightComponent() : senior.getLeftComponent();
        parent = senior.getParent();
        if (parent instanceof Perspective) {
            parent.remove(senior);
            parent.add(peer);
            parent.validate();
            parent.repaint();
            return;
        }
        TrimWidgetPlaceholder supervisor = (TrimWidgetPlaceholder)parent;
        if (supervisor.getLeftComponent() == senior) {
            supervisor.setLeftComponent(peer);
        } else {
            supervisor.setRightComponent(peer);
        }
    }
}

