/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.ide.workbench.persist;

import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.swing.MessageDialog;
import com.kingdee.bos.util.backport.LinkedList;
import com.kingdee.eas.base.form.ide.workbench.logic.TrimWidgetManager;
import com.kingdee.eas.base.form.ide.workbench.persist.IIOProvider;
import com.kingdee.eas.base.form.ide.workbench.persist.WorkbenchPersistence;
import com.kingdee.eas.base.form.ide.workbench.ui.ITrimWidget;
import com.kingdee.eas.base.form.ide.workbench.ui.Perspective;
import com.kingdee.eas.base.form.ide.workbench.ui.TrimWidgetPlaceholder;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class PerspectivePersistence {
    public static final String KEY_TITLE = "title";
    public static final String KEY_MSG1 = "msg1";
    public static final String KEY_MSG2 = "msg2";
    private static PerspectivePersistence pp = new PerspectivePersistence();
    private Set perspectives = new HashSet();
    private Map ioCache = new HashMap();
    private static final boolean DEBUG = false;

    public static String getLocalText(String key, String defaultStr) {
        return LanguageManager.getLangMessage((String)key, PerspectivePersistence.class, (String)defaultStr);
    }

    private PerspectivePersistence() {
    }

    public static PerspectivePersistence getSharedInstance() {
        return pp;
    }

    public void persistAllPerspectives() {
        for (Perspective perspective : this.ioCache.keySet()) {
            String cache;
            if (perspective.isDisplayable()) {
                this.persistToCache(perspective);
            }
            if ((cache = (String)this.ioCache.get(perspective)) == null) continue;
            try {
                IIOProvider ioProvider = perspective.getIOProvider();
                OutputStream os = ioProvider != null ? ioProvider.getPersistenceOutputStream() : new FileOutputStream(new File(WorkbenchPersistence.CONFIG_DIR + "/" + perspective.getPerspectiveName() + ".conf"));
                PrintStream ps = new PrintStream(os);
                ps.print(cache);
                ps.flush();
                ps.close();
            }
            catch (Exception exception) {}
        }
    }

    public void persistToCache(Perspective perspective) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ITrimWidget exclusiveTrim = perspective.getExclusiveView();
        perspective.showAllInclusions();
        long t1 = System.currentTimeMillis();
        PrintStream ps = new PrintStream(bos);
        ps.println(perspective.getVersion());
        Object node = perspective.getPerspectiveRootElement();
        if (node == null) {
            ps.print("");
            ps.flush();
            ps.close();
            this.ioCache.put(perspective, new String(bos.toByteArray()));
            return;
        }
        if (node instanceof ITrimWidget) {
            if (exclusiveTrim == null) {
                ps.println(((ITrimWidget)node).getId());
            } else {
                ps.println(((ITrimWidget)node).getId() + this.getGap() + exclusiveTrim.getId());
            }
            ps.flush();
            ps.close();
            this.ioCache.put(perspective, new String(bos.toByteArray()));
            return;
        }
        LinkedList queue = new LinkedList();
        queue.offer(node);
        Component firstTw = node;
        while (!(firstTw instanceof ITrimWidget)) {
            firstTw = ((TrimWidgetPlaceholder)firstTw).getLeftComponent();
        }
        if (exclusiveTrim == null) {
            ps.println(((ITrimWidget)((Object)firstTw)).getId());
        } else {
            ps.println(((ITrimWidget)((Object)firstTw)).getId() + this.getGap() + exclusiveTrim.getId());
        }
        while (!queue.isEmpty()) {
            node = queue.poll();
            if (!(node instanceof TrimWidgetPlaceholder)) continue;
            TrimWidgetPlaceholder twp = (TrimWidgetPlaceholder)node;
            this.buildInformation4Composite(twp, ps);
            queue.offer((Object)twp.getLeftComponent());
            queue.offer((Object)twp.getRightComponent());
        }
        ps.flush();
        ps.close();
        this.ioCache.put(perspective, new String(bos.toByteArray()));
    }

    private void buildInformation4Composite(TrimWidgetPlaceholder twp, PrintStream ps) {
        Component llEst = twp.getLeftComponent();
        Component rlEst = twp.getRightComponent();
        while (!(llEst instanceof ITrimWidget)) {
            llEst = ((TrimWidgetPlaceholder)llEst).getLeftComponent();
        }
        while (!(rlEst instanceof ITrimWidget)) {
            rlEst = ((TrimWidgetPlaceholder)rlEst).getLeftComponent();
        }
        ps.print(((ITrimWidget)((Object)llEst)).getId());
        ps.print(this.getGap());
        ps.print(((ITrimWidget)((Object)rlEst)).getId());
        ps.print(this.getGap());
        ps.print(this.getOrientation(twp));
        ps.print(this.getGap());
        ps.println(1.0 - twp.getDividerLocation());
    }

    private String getGap() {
        return "  ";
    }

    private String getOrientation(TrimWidgetPlaceholder twp) {
        return twp.getOrientation() == 0 ? "VERTICAL_SPLIT" : "HORIZONTAL_SPLIT";
    }

    public boolean instantiate(Perspective perspective) {
        return this.instantiate(perspective, false);
    }

    public boolean instantiate(Perspective perspective, boolean ignoreExclusive) {
        try {
            String cache;
            long t1 = System.currentTimeMillis();
            this.perspectives.add(perspective);
            if (perspective.getComponentCount() > 0) {
                perspective.removeAll();
            }
            if ((cache = (String)this.ioCache.get(perspective)) == null) {
                InputStream is;
                IIOProvider ioProvider = perspective.getIOProvider();
                if (ioProvider != null) {
                    is = ioProvider.getPersistenceInputStream();
                } else {
                    File configFile = new File(WorkbenchPersistence.CONFIG_DIR + "/" + perspective.getPerspectiveName() + ".conf");
                    if (!configFile.exists()) {
                        return false;
                    }
                    if (configFile.length() == 0L) {
                        return true;
                    }
                    is = new FileInputStream(configFile);
                }
                BufferedReader br = new BufferedReader(new InputStreamReader(is));
                WorkbenchPersistence wp = WorkbenchPersistence.getSharedInstance();
                TrimWidgetManager manager = perspective.getTrimWidgetManager();
                StringBuffer sb = new StringBuffer();
                String line = br.readLine();
                if (!perspective.getVersion().equals(line)) {
                    return false;
                }
                sb.append(line + "\n");
                line = br.readLine();
                sb.append(line + "\n");
                String[] breakUps = line.split("  ");
                ITrimWidget testPaper = wp.getTrimWidget(breakUps[0]);
                if (testPaper == null) {
                    return false;
                }
                manager.addTrim(testPaper);
                line = br.readLine();
                while (line != null) {
                    sb.append(line + "\n");
                    String[] codeSnippets = line.split("  ");
                    ITrimWidget target = wp.getTrimWidget(codeSnippets[0]);
                    ITrimWidget source = wp.getTrimWidget(codeSnippets[1]);
                    if (target == null || source == null) {
                        return false;
                    }
                    int orientation = 4;
                    if ("HORIZONTAL_SPLIT".equals(codeSnippets[2])) {
                        orientation = 2;
                    }
                    manager.addTrim(orientation, source, target, new Double(codeSnippets[3]));
                    line = br.readLine();
                }
                if (breakUps.length > 1 && !ignoreExclusive) {
                    testPaper = wp.getTrimWidget(breakUps[1]);
                    if (testPaper == null) {
                        return false;
                    }
                    perspective.setExclusiveTrim(testPaper);
                }
                br.close();
                this.ioCache.put(perspective, sb.toString());
                return true;
            }
            ByteArrayInputStream is = new ByteArrayInputStream(cache.getBytes());
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            WorkbenchPersistence wp = WorkbenchPersistence.getSharedInstance();
            TrimWidgetManager manager = perspective.getTrimWidgetManager();
            String line = br.readLine();
            line = br.readLine();
            String[] breakUps = line.split("  ");
            manager.addTrim(wp.getTrimWidget(breakUps[0]));
            line = br.readLine();
            while (line != null) {
                String[] codeSnippets = line.split("  ");
                ITrimWidget target = wp.getTrimWidget(codeSnippets[0]);
                ITrimWidget source = wp.getTrimWidget(codeSnippets[1]);
                int orientation = 4;
                if ("HORIZONTAL_SPLIT".equals(codeSnippets[2])) {
                    orientation = 2;
                }
                manager.addTrim(orientation, source, target, new Double(codeSnippets[3]));
                line = br.readLine();
            }
            if (breakUps.length > 1 && !ignoreExclusive) {
                perspective.setExclusiveTrim(wp.getTrimWidget(breakUps[1]));
            }
            br.close();
            return true;
        }
        catch (Exception e) {
            perspective.removeAll();
            MessageDialog.show((Component)perspective, (Object)(PerspectivePersistence.getLocalText(KEY_MSG1, "?????????{") + perspective.getPerspectiveName() + PerspectivePersistence.getLocalText(KEY_MSG2, "}???????<???-???????>??????\u5c7e???")), (String)PerspectivePersistence.getLocalText(KEY_TITLE, "????????"), (int)-1);
            return false;
        }
    }
}

