/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.ide.workbench.persist;

import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.KDTreeView;
import com.kingdee.bos.ctrl.swing.MessageDialog;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.eas.base.form.ide.workbench.persist.IIOProvider;
import com.kingdee.eas.base.form.ide.workbench.persist.PerspectivePersistence;
import com.kingdee.eas.base.form.ide.workbench.persist.TrimWidgetDescriptor;
import com.kingdee.eas.base.form.ide.workbench.persist.Trinity;
import com.kingdee.eas.base.form.ide.workbench.ui.ITrimWidget;
import com.kingdee.eas.base.form.ide.workbench.ui.Perspective;
import com.kingdee.eas.base.form.ide.workbench.ui.TrimWidgetViewport;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.output.XMLOutputter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class WorkbenchPersistence
extends HashMap {
    public static final String KEY_TITLE = "title";
    public static final String KEY_MSG = "msg1";
    public static final String KEY_GENERAL = "general";
    public static final String KEY_OK = "ok";
    public static final String KEY_CANCEL = "cancel";
    public static final String KEY_VIEW_MANAGE = "viewManage";
    private static final boolean DEBUG = false;
    public static final String VERSION = "1.0.0";
    public static String CONFIG_DIR = System.getProperty("user.dir");
    private static WorkbenchPersistence twr = new WorkbenchPersistence();
    private IIOProvider ioProvider;
    private HashMap descriptors = new HashMap();
    private HashMap instances = new HashMap();

    public static String getLocalText(String key, String defaultStr) {
        return LanguageManager.getLangMessage((String)key, WorkbenchPersistence.class, (String)defaultStr);
    }

    private WorkbenchPersistence() {
        this.parseXmlToDescriptors();
    }

    public static WorkbenchPersistence getSharedInstance() {
        return twr;
    }

    public void setIOProvider(IIOProvider ioProvider) {
        this.ioProvider = ioProvider;
    }

    public IIOProvider getIOProvider() {
        return this.ioProvider;
    }

    public void registerTrimWidget(ITrimWidget trim) {
        if (trim != null) {
            this.descriptors.put(trim.getId(), new TrimWidgetDescriptor(trim));
            this.instances.put(trim.getId(), trim);
        }
    }

    public ITrimWidget getTrimWidget(String id) {
        ITrimWidget trimWidget = (ITrimWidget)this.instances.get(id);
        if (trimWidget == null) {
            TrimWidgetDescriptor desc = (TrimWidgetDescriptor)this.descriptors.get(id);
            if (desc == null) {
                return null;
            }
            trimWidget = desc.toTrimWidget();
            this.instances.put(id, trimWidget);
        }
        return trimWidget;
    }

    public void persist() {
        long t1 = System.currentTimeMillis();
        Document doc = new Document();
        Element root = new Element("workspace");
        root.setAttribute("version", VERSION);
        doc.setRootElement(root);
        Iterator it = this.descriptors.values().iterator();
        while (it.hasNext()) {
            root.addContent((Content)((TrimWidgetDescriptor)it.next()).toXmlElement());
        }
        OutputStream os = null;
        try {
            os = this.ioProvider != null ? this.ioProvider.getPersistenceOutputStream() : new FileOutputStream(new File(CONFIG_DIR + "/workbench.xml"));
            new XMLOutputter().output(doc, os);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("unable to persist the workbench config file");
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseXmlToDescriptors() {
        InputStream is = null;
        if (this.ioProvider != null) {
            is = this.ioProvider.getPersistenceInputStream();
        } else {
            File file = new File(CONFIG_DIR + "/workbench.xml");
            try {
                is = new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                return;
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser saxParser = factory.newSAXParser();
            long t1 = System.currentTimeMillis();
            saxParser.parse(is, (DefaultHandler)new WorkbenchSAXHandler());
        }
        catch (Exception e) {
            this.descriptors.clear();
            this.instances.clear();
            MessageDialog.show(null, (Object)WorkbenchPersistence.getLocalText(KEY_MSG, "????????????????????????????????\u0427\n?????????\n1.???????????????\n2.????????????\u6c7e????"), (String)WorkbenchPersistence.getLocalText(KEY_TITLE, "????????"), (int)-1);
        }
    }

    private TreeModel getSortedTrimTreeModel() {
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode((Object)"root");
        root.add((MutableTreeNode)new DefaultKingdeeTreeNode((Object)WorkbenchPersistence.getLocalText(KEY_GENERAL, "???")));
        for (TrimWidgetDescriptor twd : this.descriptors.values()) {
            String category = twd.getCategory();
            boolean inserted = false;
            for (int i = 0; i < root.getChildCount(); ++i) {
                DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)root.getChildAt(i);
                if (!category.equals(node.getUserObject())) continue;
                node.add((MutableTreeNode)((Object)new TrimNodeItem(twd.getId(), twd.getTitle(), twd.getIconURL())));
                inserted = true;
                break;
            }
            if (inserted) continue;
            DefaultKingdeeTreeNode node = new DefaultKingdeeTreeNode((Object)category);
            node.add((MutableTreeNode)((Object)new TrimNodeItem(twd.getId(), twd.getTitle(), twd.getIconURL())));
            root.add((MutableTreeNode)node);
        }
        return new KingdeeTreeModel((TreeNode)root);
    }

    public void showTrimList(Perspective perspective) {
        Window w = SwingUtilities.getWindowAncestor(perspective);
        TrimWidgetListDialog trimListDialog = null;
        trimListDialog = w instanceof Frame ? new TrimWidgetListDialog((Frame)w, perspective) : new TrimWidgetListDialog((Dialog)w, perspective);
        trimListDialog.configTreeModel(this.getSortedTrimTreeModel());
        trimListDialog.setLocationRelativeTo(perspective);
        trimListDialog.setVisible(true);
    }

    private class TrimWidgetListDialog
    extends JDialog {
        private KDTree sortedTrimTree;
        private JButton submit;
        private JButton cancel;
        private Perspective perspective;
        private Icon leafIcon;

        TrimWidgetListDialog(Frame w, Perspective perspective) {
            super(w, true);
            this.sortedTrimTree = new KDTree();
            this.submit = new JButton(WorkbenchPersistence.getLocalText(WorkbenchPersistence.KEY_OK, "???"));
            this.cancel = new JButton(WorkbenchPersistence.getLocalText(WorkbenchPersistence.KEY_CANCEL, "???"));
            this.leafIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(TrimWidgetViewport.class.getResource("default_symbol.gif")));
            this.perspective = perspective;
            this.initUI();
            this.initListeners();
        }

        TrimWidgetListDialog(Dialog w, Perspective perspective) {
            super(w, true);
            this.sortedTrimTree = new KDTree();
            this.submit = new JButton(WorkbenchPersistence.getLocalText(WorkbenchPersistence.KEY_OK, "???"));
            this.cancel = new JButton(WorkbenchPersistence.getLocalText(WorkbenchPersistence.KEY_CANCEL, "???"));
            this.leafIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(TrimWidgetViewport.class.getResource("default_symbol.gif")));
            this.perspective = perspective;
            this.initUI();
            this.initListeners();
        }

        private void initUI() {
            this.setTitle(WorkbenchPersistence.getLocalText(WorkbenchPersistence.KEY_VIEW_MANAGE, "???????"));
            this.setSize(248, 400);
            this.setResizable(false);
            this.sortedTrimTree.setRootVisible(false);
            KDTreeView treeView = new KDTreeView(this.sortedTrimTree);
            treeView.setShowButton(false);
            Container c = this.getContentPane();
            c.setLayout(null);
            c.add((Component)treeView);
            c.add(this.submit);
            c.add(this.cancel);
            treeView.setBounds(5, 5, 230, 340);
            DefaultTreeCellRenderer render = new DefaultTreeCellRenderer(){

                @Override
                public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                    URL iconURL;
                    super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                    if (value instanceof TrimNodeItem && (iconURL = ((TrimNodeItem)((Object)value)).getIconURL()) != null) {
                        this.setIcon(new ImageIcon(Toolkit.getDefaultToolkit().getImage(iconURL)));
                    }
                    return this;
                }
            };
            render.setLeafIcon(this.leafIcon);
            this.sortedTrimTree.setCellRenderer((TreeCellRenderer)render);
            this.submit.setBounds(65, 350, 80, 20);
            this.submit.setEnabled(false);
            this.cancel.setBounds(155, 350, 80, 20);
            this.sortedTrimTree.requestFocusInWindow();
        }

        private void initListeners() {
            this.sortedTrimTree.addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    TreePath tp = e.getNewLeadSelectionPath();
                    if ("root".equals(((DefaultMutableTreeNode)((TreeNode)tp.getLastPathComponent()).getParent()).getUserObject())) {
                        TrimWidgetListDialog.this.submit.setEnabled(false);
                    } else {
                        TrimWidgetListDialog.this.submit.setEnabled(true);
                    }
                }
            });
            this.sortedTrimTree.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        TrimWidgetListDialog.this.submit.doClick();
                    }
                }
            });
            this.submit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TrimWidgetListDialog.this.perspective.getTrimWidgetManager().addTrim(WorkbenchPersistence.this.getTrimWidget(((TrimNodeItem)((Object)TrimWidgetListDialog.this.sortedTrimTree.getSelectionPath().getLastPathComponent())).getId()));
                    TrimWidgetListDialog.this.perspective.revalidate();
                    TrimWidgetListDialog.this.perspective.repaint();
                    PerspectivePersistence.getSharedInstance().persistToCache(TrimWidgetListDialog.this.perspective);
                    TrimWidgetListDialog.this.setVisible(false);
                    TrimWidgetListDialog.this.dispose();
                }
            });
            this.cancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TrimWidgetListDialog.this.setVisible(false);
                    TrimWidgetListDialog.this.dispose();
                }
            });
        }

        void configTreeModel(TreeModel treemodel) {
            this.sortedTrimTree.setModel(treemodel);
            TreePath treepath = new TreePath(new Object[]{treemodel.getRoot(), ((TreeNode)treemodel.getRoot()).getChildAt(0)});
            this.sortedTrimTree.setSelectionPath(treepath);
            this.sortedTrimTree.expandPath(treepath);
        }
    }

    private static class TrimNodeItem
    extends DefaultKingdeeTreeNode {
        private String id;
        private String title;
        private URL iconURL;

        TrimNodeItem(String id, String title, URL iconURL) {
            super((Object)title);
            this.id = id;
            this.title = title;
            this.iconURL = iconURL;
        }

        String getId() {
            return this.id;
        }

        String getTitle() {
            return this.title;
        }

        URL getIconURL() {
            return this.iconURL;
        }
    }

    class WorkbenchSAXHandler
    extends DefaultHandler {
        private TrimWidgetDescriptor trimDescriptor;
        private int cursor = 0;
        private int type;
        private String key;
        private String value;

        WorkbenchSAXHandler() {
        }

        @Override
        public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws SAXException {
            if ("workspace".equals(qName)) {
                String version = attrs.getValue("version");
                if (!WorkbenchPersistence.VERSION.equals(version)) {
                    throw new SAXException("workbench's persistent file isn't a current version.");
                }
            } else if ("trim".equals(qName)) {
                String id = attrs.getValue("id");
                this.trimDescriptor = new TrimWidgetDescriptor(id, attrs.getValue("clsName"));
                WorkbenchPersistence.this.descriptors.put(id, this.trimDescriptor);
            } else if ("type".equals(qName)) {
                this.cursor = 1;
            } else if ("key".equals(qName)) {
                this.cursor = 2;
            } else if ("value".equals(qName)) {
                this.cursor = 3;
            }
        }

        @Override
        public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
            if ("trinity".equals(qName)) {
                this.trimDescriptor.addTrinity(new Trinity(this.type, this.key, this.value));
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            switch (this.cursor) {
                case 1: {
                    this.type = new Integer(new String(ch, start, length));
                    break;
                }
                case 2: {
                    this.key = new String(ch, start, length);
                    break;
                }
                case 3: {
                    this.value = new String(ch, start, length);
                    break;
                }
            }
        }
    }
}

