/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.ide.workbench.ui;

import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.eas.base.form.ide.workbench.logic.TrimWidgetManager;
import com.kingdee.eas.base.form.ide.workbench.persist.IIOProvider;
import com.kingdee.eas.base.form.ide.workbench.persist.PerspectivePersistence;
import com.kingdee.eas.base.form.ide.workbench.ui.IDockable;
import com.kingdee.eas.base.form.ide.workbench.ui.ITrimWidget;
import com.kingdee.eas.base.form.ide.workbench.ui.TrimWidgetPlaceholder;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class Perspective
extends JPanel
implements IDockable {
    public static final String KEY_MSG = "msg";
    private Rectangle dockRect;
    private TrimWidgetManager trimWidgetManager;
    private ITrimWidget exclusiveTrim;
    private String perspectiveName;
    private IIOProvider ioProvider;
    private boolean autoInstantiated = false;
    private String version;

    public static String getLocalText(String key, String defaultStr) {
        return LanguageManager.getLangMessage((String)key, Perspective.class, (String)defaultStr);
    }

    public Perspective(String perspectiveName, String version) {
        if (perspectiveName == null || version == null) {
            throw new NullPointerException(Perspective.getLocalText(KEY_MSG, "\u900f\u89c6\u56fe\u540d\u79f0\u548c\u7248\u672c\u53f7\u5747\u4e0d\u53ef\u4e3a\u7a7a"));
        }
        this.perspectiveName = perspectiveName;
        this.version = version;
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.autoInstantiated = PerspectivePersistence.getSharedInstance().instantiate(this);
    }

    public Perspective(String perspectiveName, String version, IIOProvider ioProvider) {
        this.ioProvider = ioProvider;
        this.perspectiveName = perspectiveName;
        this.version = version;
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.autoInstantiated = PerspectivePersistence.getSharedInstance().instantiate(this);
    }

    public IIOProvider getIOProvider() {
        return this.ioProvider;
    }

    public boolean isAutoInstantiated() {
        return this.autoInstantiated;
    }

    @Override
    public void removeNotify() {
        PerspectivePersistence.getSharedInstance().persistToCache(this);
        super.removeNotify();
    }

    public TrimWidgetManager getTrimWidgetManager() {
        if (this.trimWidgetManager == null) {
            this.trimWidgetManager = new TrimWidgetManager(this);
        }
        return this.trimWidgetManager;
    }

    public Component getPerspectiveRootElement() {
        return this.getComponentCount() == 0 ? null : this.getComponent(0);
    }

    @Override
    protected void paintChildren(Graphics g) {
        super.paintChildren(g);
        if (this.dockRect != null) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setColor(Color.blue.brighter());
            g2d.setStroke(new BasicStroke(3.0f));
            g2d.drawRect(this.dockRect.x, this.dockRect.y, this.dockRect.width, this.dockRect.height);
        }
    }

    @Override
    public void dockingTo(int areaId) {
        int w = this.getWidth();
        int h = this.getHeight();
        int dockx = (int)((double)w * 0.2);
        int docky = (int)((double)h * 0.2);
        switch (areaId) {
            case 3: {
                this.dockRect = new Rectangle(1, 1, dockx - 3, h - 3);
                this.repaint();
                break;
            }
            case 4: {
                this.dockRect = new Rectangle(w - dockx + 1, 1, dockx - 3, h - 3);
                this.repaint();
                break;
            }
            case 1: {
                this.dockRect = new Rectangle(1, 1, w - 3, docky - 3);
                this.repaint();
                break;
            }
            case 2: {
                this.dockRect = new Rectangle(1, h - docky + 1, w - 3, docky - 3);
                this.repaint();
                break;
            }
            default: {
                this.dockRect = null;
                this.repaint();
            }
        }
    }

    public void setExclusiveTrim(ITrimWidget exclusiveTrim) {
        if (exclusiveTrim.getPerspective() == null) {
            return;
        }
        PerspectivePersistence.getSharedInstance().persistToCache(this);
        this.dissociateDescendantTrims();
        this.removeAll();
        exclusiveTrim.setPerspective(this);
        this.exclusiveTrim = exclusiveTrim;
        exclusiveTrim.exclusiveNotify(true);
        this.add((Component)((Object)exclusiveTrim));
        this.revalidate();
        this.repaint();
    }

    private void dissociateDescendantTrims() {
        Component c = this.getPerspectiveRootElement();
        if (c == null) {
            return;
        }
        if (c instanceof TrimWidgetPlaceholder) {
            this.dissociateDescendantTrims((TrimWidgetPlaceholder)c);
        } else {
            ((ITrimWidget)((Object)c)).setPerspective(null);
        }
    }

    private void dissociateDescendantTrims(TrimWidgetPlaceholder pher) {
        Component left = pher.getLeftComponent();
        if (left instanceof TrimWidgetPlaceholder) {
            this.dissociateDescendantTrims((TrimWidgetPlaceholder)left);
        } else {
            ((ITrimWidget)((Object)left)).setPerspective(null);
        }
        Component right = pher.getRightComponent();
        if (right instanceof TrimWidgetPlaceholder) {
            this.dissociateDescendantTrims((TrimWidgetPlaceholder)right);
        } else {
            ((ITrimWidget)((Object)right)).setPerspective(null);
        }
    }

    public void showAllInclusions() {
        if (!this.isExclusiveView()) {
            return;
        }
        this.exclusiveTrim.setPerspective(null);
        this.exclusiveTrim.exclusiveNotify(false);
        this.exclusiveTrim = null;
        this.rebuild();
        this.revalidate();
        this.repaint();
    }

    private void rebuild() {
        this.removeAll();
        this.autoInstantiated = PerspectivePersistence.getSharedInstance().instantiate(this, true);
    }

    public boolean isExclusiveView() {
        return this.exclusiveTrim != null;
    }

    public ITrimWidget getExclusiveView() {
        return this.exclusiveTrim;
    }

    public String getPerspectiveName() {
        return this.perspectiveName;
    }

    public String getVersion() {
        return this.version;
    }
}

