/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.ide.workbench.ui;

import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.eas.base.form.ide.workbench.logic.TrimWidgetDnD;
import com.kingdee.eas.base.form.ide.workbench.ui.ITrimView;
import com.kingdee.eas.base.form.ide.workbench.ui.ITrimWidget;
import com.kingdee.eas.base.form.ide.workbench.ui.ITrimWidgetDndDelegate;
import com.kingdee.eas.base.form.ide.workbench.ui.ImageButton;
import com.kingdee.eas.base.form.ide.workbench.ui.Perspective;
import com.kingdee.eas.base.form.ide.workbench.ui.TrimWidgetViewLayout;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class TrimWidgetViewport
extends JPanel
implements ITrimWidget {
    public static final String KEY_GENERAL = "general";
    public static final String KEY_MSG = "msg";
    private static Image viewMaxImage;
    private static Image viewNormalImage;
    private static Image viewCloseImage;
    private Rectangle dockRect;
    private String id;
    private ViewDndBar viewDndArea = new ViewDndBar();
    private Icon icon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(TrimWidgetViewport.class.getResource("default_symbol.gif")));
    private ITrimView view;
    private boolean closeable = true;
    private String title;
    private Perspective perspective;
    private String category = TrimWidgetViewport.getLocalText("general", "???");
    private URL iconURL;

    public static String getLocalText(String key, String defaultStr) {
        return LanguageManager.getLangMessage((String)key, TrimWidgetViewport.class, (String)defaultStr);
    }

    public TrimWidgetViewport() {
        this.add(this.viewDndArea);
        this.setLayout(new TrimWidgetViewLayout());
        TrimWidgetDnD.installDndCapablilities(this);
    }

    public TrimWidgetViewport(String id, ITrimView comp) {
        this();
        this.setId(id);
        this.setView(comp);
    }

    @Override
    public void addNotify() {
        this.view.onViewShow();
        super.addNotify();
    }

    @Override
    public ITrimWidgetDndDelegate getDndDelegate() {
        return this.viewDndArea;
    }

    private void checkId(String id) {
        if (id == null || id.equals("")) {
            throw new IllegalArgumentException(TrimWidgetViewport.getLocalText(KEY_MSG, "View??ID??????????\u03bb????????????????????null????????????????????????"));
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        String oldId = this.id;
        this.checkId(id);
        this.id = id;
        this.firePropertyChange("id", oldId, id);
    }

    @Override
    public String getTitle() {
        if (this.title == null) {
            return this.id;
        }
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        String oldTitle = this.title;
        this.title = title;
        this.firePropertyChange("title", oldTitle, title);
    }

    @Override
    public URL getIconURL() {
        return this.iconURL;
    }

    @Override
    public void setIconURL(URL iconURL) {
        Icon oldIcon = this.icon;
        this.icon = new ImageIcon(iconURL);
        this.firePropertyChange("icon", oldIcon, this.icon);
        this.iconURL = iconURL;
    }

    @Override
    public boolean isCloseable() {
        return this.closeable;
    }

    @Override
    public void setCloseable(boolean closeable) {
        boolean oldCloseable = this.closeable;
        this.closeable = closeable;
        this.firePropertyChange("closeable", new Boolean(oldCloseable), new Boolean(closeable));
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    @Override
    public void setCategory(String category) {
        String oldCategory = this.category;
        this.category = category;
        this.firePropertyChange("category", oldCategory, category);
    }

    public ITrimView getView() {
        return this.view;
    }

    public void setView(ITrimView view) {
        ITrimView oldView = this.view;
        if (this.view != null) {
            this.remove((Component)((Object)view));
        }
        this.view = view;
        this.add((Component)((Object)view));
        this.firePropertyChange("view", oldView, view);
    }

    @Override
    public Perspective getPerspective() {
        return this.perspective;
    }

    @Override
    public void setPerspective(Perspective perspective) {
        Perspective oldPerspective = this.perspective;
        this.perspective = perspective;
        this.firePropertyChange("perspective", oldPerspective, perspective);
    }

    @Override
    protected void paintChildren(Graphics g) {
        super.paintChildren(g);
        if (this.dockRect != null) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setColor(Color.blue.brighter());
            g2d.setStroke(new BasicStroke(3.0f));
            g2d.drawRect(this.dockRect.x, this.dockRect.y, this.dockRect.width, this.dockRect.height);
        }
    }

    @Override
    public String toString() {
        return "[" + this.id + "] " + super.toString();
    }

    @Override
    public void exclusiveNotify(boolean isExclusive) {
        if (isExclusive) {
            this.viewDndArea.nmBtn.setImage(viewNormalImage);
        } else {
            this.viewDndArea.nmBtn.setImage(viewMaxImage);
        }
        this.view.onExclusive(isExclusive);
    }

    @Override
    public void dockingTo(int areaId) {
        int w = this.getWidth();
        int h = this.getHeight();
        int dockx = (int)((double)w * 0.2);
        int docky = (int)((double)h * 0.2);
        switch (areaId) {
            case 3: {
                this.dockRect = new Rectangle(1, 1, dockx - 3, h - 3);
                this.repaint();
                break;
            }
            case 4: {
                this.dockRect = new Rectangle(w - dockx + 1, 1, dockx - 3, h - 3);
                this.repaint();
                break;
            }
            case 1: {
                this.dockRect = new Rectangle(1, 1, w - 3, docky - 3);
                this.repaint();
                break;
            }
            case 2: {
                this.dockRect = new Rectangle(1, h - docky + 1, w - 3, docky - 3);
                this.repaint();
                break;
            }
            default: {
                this.dockRect = null;
                this.repaint();
            }
        }
    }

    static /* synthetic */ Image access$200() {
        return viewCloseImage;
    }

    static {
        try {
            viewMaxImage = ImageIO.read(TrimWidgetViewport.class.getResource("view_max.gif"));
            viewNormalImage = ImageIO.read(TrimWidgetViewport.class.getResource("view_normal.gif"));
            viewCloseImage = ImageIO.read(TrimWidgetViewport.class.getResource("view_close.gif"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private class ViewDndBar
    extends JComponent
    implements ITrimWidgetDndDelegate {
        private ImageButton nmBtn = new ImageButton(TrimWidgetViewport.access$100());
        private ImageButton closeBtn = new ImageButton(TrimWidgetViewport.access$200());

        private ViewDndBar() {
            this.setLayout(null);
            this.setCursor(Cursor.getPredefinedCursor(13));
            this.setLayout(new LayoutManager(){

                @Override
                public void addLayoutComponent(String name, Component comp) {
                }

                @Override
                public void layoutContainer(Container parent) {
                    int width = parent.getWidth();
                    if (TrimWidgetViewport.this.closeable) {
                        ViewDndBar.this.nmBtn.setBounds(width - 40, 2, 20, 20);
                        ViewDndBar.this.closeBtn.setBounds(width - 20, 2, 20, 20);
                    } else {
                        ViewDndBar.this.nmBtn.setBounds(width - 20, 2, 20, 20);
                    }
                }

                @Override
                public Dimension minimumLayoutSize(Container parent) {
                    return new Dimension(0, 0);
                }

                @Override
                public Dimension preferredLayoutSize(Container parent) {
                    return new Dimension(0, 0);
                }

                @Override
                public void removeLayoutComponent(Component comp) {
                }
            });
            TrimWidgetViewport.this.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    String pn = evt.getPropertyName();
                    if ("title".equals(pn) || "icon".equals(pn)) {
                        ViewDndBar.this.repaint();
                    } else if ("closeable".equals(pn) || "view".equals(pn)) {
                        ViewDndBar.this.invalidate();
                        ViewDndBar.this.revalidate();
                        ViewDndBar.this.repaint();
                    }
                }
            });
            this.add(this.nmBtn);
            this.add(this.closeBtn);
            this.initButtonListeners();
        }

        private void initButtonListeners() {
            this.nmBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ViewDndBar.this.nmBtn.getImage() == viewMaxImage) {
                        TrimWidgetViewport.this.perspective.setExclusiveTrim(TrimWidgetViewport.this);
                    } else if (ViewDndBar.this.nmBtn.getImage() == viewNormalImage) {
                        TrimWidgetViewport.this.perspective.showAllInclusions();
                    }
                }
            });
            this.closeBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TrimWidgetViewport.this.perspective.getTrimWidgetManager().removeTrim(TrimWidgetViewport.this);
                }
            });
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2d = (Graphics2D)g;
            GradientPaint gp = new GradientPaint(0.0f, 0.0f, UIManager.getColor("MenuBar.fourthShadowColor"), this.getWidth(), 0.0f, UIManager.getColor("MenuBar.firstShadowColor"));
            g2d.setPaint(gp);
            g2d.fillRect(1, 1, this.getWidth() - 2, this.getHeight() - 2);
            g2d.setPaint(Color.white);
            g2d.setFont(new Font("simsun", 1, 12));
            g2d.drawString(TrimWidgetViewport.this.getTitle(), 25, 15 - g2d.getFontMetrics().getDescent() + g2d.getFontMetrics().getLeading());
            TrimWidgetViewport.this.icon.paintIcon(this, g2d, 3, 3);
        }

        @Override
        public ITrimWidget getTrimWidget() {
            return TrimWidgetViewport.this;
        }
    }
}

