/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.messageCenter;

import java.io.Serializable;
import java.sql.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import nl.justobjects.pushlet.core.Event;
import nl.justobjects.pushlet.core.Protocol;

public class Message
implements Protocol,
Serializable {
    private static final long serialVersionUID = 8789832328072109038L;
    public static final int ADDNEW = 0;
    public static final int SAVED = 10;
    public static final int SENDED = 90;
    public static final int RECEIVED = 0;
    public static final int PUBLISHED = 10;
    public static final String SOURCEID = "SOURCEID";
    private String id = null;
    private String enterpriseId = null;
    private String subject = null;
    private Map<String, String> body = new HashMap<String, String>(10);
    private int director = 0;
    private Date lastUpdatetime = null;
    private int status = 0;

    public Message() {
        this.id = UUID.randomUUID().toString();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getEnterpriseId() {
        return this.enterpriseId;
    }

    public void setEnterpriseId(String enterpriseId) {
        this.enterpriseId = enterpriseId;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public Map<String, String> getBody() {
        return this.body;
    }

    public void setBody(Map<String, String> body) {
        this.body = body;
    }

    public void setField(String name, String value) {
        this.body.put(name, value);
    }

    public String getField(String name) {
        return this.body.get(name);
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public int getDirector() {
        return this.director;
    }

    public void setDirector(int director) {
        this.director = director;
    }

    public Date getLastUpdatetime() {
        return this.lastUpdatetime;
    }

    public void setLastUpdatetime(Date lastUpdatetime) {
        this.lastUpdatetime = lastUpdatetime;
    }

    public String getEventSubject() {
        String eId = this.getEnterpriseId();
        String s1 = this.getSubject();
        if (eId != null && !s1.startsWith("/" + eId)) {
            s1 = "/" + eId + s1;
        }
        return s1;
    }

    public Event toServerEvent() {
        Event event = Event.createDataEvent(this.getSubject(), this.getBody());
        event.setField("MESSAGEID", this.getId());
        event.setField("ENTERPRISEID", this.getEnterpriseId());
        return event;
    }

    public Event toEvent() {
        Event event = Event.createDataEvent(this.getEventSubject(), this.getBody());
        event.setField("MESSAGEID", this.getId());
        event.setField("ENTERPRISEID", this.getEnterpriseId());
        return event;
    }

    public static Message fromEvent(Event event) {
        Message m = new Message();
        m.setId(event.getField("MESSAGEID"));
        String enterpriseId = event.getField("ENTERPRISEID");
        m.setEnterpriseId(enterpriseId);
        String s1 = event.getField("p_subject");
        m.setSubject(s1);
        m.setBody(event.getAttrs());
        return m;
    }
}

