/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.messageCenter.common;

import com.kingdee.messageCenter.IMessageDAO;
import com.kingdee.messageCenter.IMessagePool;
import com.kingdee.messageCenter.Message;
import com.kingdee.messageCenter.MessageException;
import com.kingdee.messageCenter.common.ObjectFactory;
import java.sql.Date;
import java.util.List;

public class MessagePool
implements IMessagePool {
    private IMessageDAO getDao() {
        return ObjectFactory.getInstance().getMessageDAO();
    }

    @Override
    public void saveMessage(Message message) throws MessageException {
        message.setLastUpdatetime(new Date(System.currentTimeMillis()));
        this.getDao().save(true, message);
    }

    @Override
    public void saveMessage2Old(Message message) throws MessageException {
        message.setLastUpdatetime(new Date(System.currentTimeMillis()));
        this.getDao().save(false, message);
    }

    @Override
    public void moveMessage2Old(String messageID) throws MessageException {
        Message message = this.getDao().getValue(true, messageID);
        if (message != null) {
            this.getDao().delete(true, messageID);
            message.setLastUpdatetime(new Date(System.currentTimeMillis()));
            this.getDao().save(false, message);
        }
    }

    @Override
    public List<Message> getUnPushedMessage(String enterpriseId) throws MessageException {
        return this.getDao().getUnPushedMessage(enterpriseId);
    }

    @Override
    public List<Message> getUnProcessedMessage() throws MessageException {
        return this.getDao().getUnProcessedMessage();
    }
}

